/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import com.google.common.collect.Lists;
import io.papermc.paper.event.player.PlayerPurchaseEvent;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.NPC;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.IMerchant;
import net.minecraft.world.item.trading.MerchantRecipe;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftAbstractVillager;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftMerchant;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftMerchantRecipe;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.event.Event;
import org.bukkit.event.entity.VillagerAcquireTradeEvent;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.protocol.PcaSyncProtocol;

public abstract class EntityVillagerAbstract
extends EntityAgeable
implements InventoryCarrier,
NPC,
IMerchant {
    private CraftMerchant craftMerchant;
    private static final DataWatcherObject<Integer> bV = DataWatcher.a(EntityVillagerAbstract.class, DataWatcherRegistry.b);
    public static final int bT = 300;
    private static final int bW = 8;
    @Nullable
    private EntityHuman bX;
    @Nullable
    protected MerchantRecipeList bU;
    private final InventorySubcontainer bY = new InventorySubcontainer(8, (CraftAbstractVillager)this.getBukkitEntity());
    protected boolean voidTrade = false;

    @Override
    public CraftMerchant getCraftMerchant() {
        return this.craftMerchant == null ? (this.craftMerchant = new CraftMerchant(this)) : this.craftMerchant;
    }

    public EntityVillagerAbstract(EntityTypes<? extends EntityVillagerAbstract> type, World world) {
        super((EntityTypes<? extends EntityAgeable>)type, world);
        this.a(PathType.n, 16.0f);
        this.a(PathType.o, -1.0f);
        if (!this.dM().y_()) {
            this.bY.a((IInventory inventory) -> {
                if (LeavesConfig.pcaSyncProtocol) {
                    PcaSyncProtocol.syncEntityToClient(this);
                }
            });
        }
    }

    @Override
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        if (entityData == null) {
            entityData = new EntityAgeable.a(false);
        }
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public int u() {
        return this.an.b(bV);
    }

    public void s(int ticks) {
        this.an.b(bV, ticks);
    }

    @Override
    public int w() {
        return 0;
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return this.o_() ? 0.81f : 1.62f;
    }

    @Override
    protected void c_() {
        super.c_();
        this.an.a(bV, 0);
    }

    @Override
    public void f(@Nullable EntityHuman customer) {
        this.bX = customer;
    }

    @Override
    @Nullable
    public EntityHuman ge() {
        return this.bX;
    }

    public boolean gf() {
        return this.bX != null;
    }

    public void resetOffers() {
        this.bU = new MerchantRecipeList();
        this.gl();
    }

    @Override
    public MerchantRecipeList gg() {
        if (this.bU == null) {
            this.bU = new MerchantRecipeList();
            this.gl();
        }
        return this.bU;
    }

    @Override
    public void a(@Nullable MerchantRecipeList offers) {
    }

    @Override
    public void t(int experience) {
    }

    @Override
    public void processTrade(MerchantRecipe recipe, @Nullable PlayerPurchaseEvent event) {
        if (event == null || event.willIncreaseTradeUses()) {
            if (this.voidTrade) {
                recipe.increaseVoidUses();
            } else {
                recipe.j();
            }
        }
        if (event == null || event.isRewardingExp()) {
            this.b(recipe);
        }
        this.a(recipe);
    }

    @Override
    public void a(MerchantRecipe offer) {
        if (!this.voidTrade) {
            this.bI = -this.Q();
        }
        if (this.bX instanceof EntityPlayer) {
            CriterionTriggers.t.a((EntityPlayer)this.bX, this, offer.d());
        }
    }

    protected abstract void b(MerchantRecipe var1);

    @Override
    public boolean gh() {
        return true;
    }

    @Override
    public void l(ItemStack stack) {
        if (!this.dM().B && this.bI > -this.Q() + 20) {
            if (!this.voidTrade) {
                this.bI = -this.Q();
            }
            this.a(this.w(!stack.b()), this.eW(), this.eX());
        }
    }

    @Override
    public SoundEffect gi() {
        return SoundEffects.zN;
    }

    protected SoundEffect w(boolean sold) {
        return sold ? SoundEffects.zN : SoundEffects.zL;
    }

    public void gj() {
        this.a(SoundEffects.zI, this.eW(), this.eX());
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        MerchantRecipeList merchantrecipelist = this.gg();
        if (!merchantrecipelist.isEmpty()) {
            nbt.a("Offers", merchantrecipelist.a());
        }
        this.a_(nbt);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        if (nbt.b("Offers", 10)) {
            this.bU = new MerchantRecipeList(nbt.p("Offers"));
        }
        this.c(nbt);
    }

    @Override
    @Nullable
    public Entity b(WorldServer destination) {
        this.gk();
        return super.b(destination);
    }

    protected void gk() {
        this.voidTrade = false;
        if (this.bU != null) {
            this.bU.forEach(MerchantRecipe::resetVoidUses);
        }
        this.f((EntityHuman)null);
    }

    @Override
    public void a(DamageSource damageSource) {
        super.a(damageSource);
        this.gk();
    }

    protected void a(ParticleParam parameters) {
        for (int i2 = 0; i2 < 5; ++i2) {
            double d0 = this.ag.k() * 0.02;
            double d1 = this.ag.k() * 0.02;
            double d2 = this.ag.k() * 0.02;
            this.dM().a(parameters, this.d(1.0), this.du() + 1.0, this.g(1.0), d0, d1, d2);
        }
    }

    @Override
    public boolean a(EntityHuman player) {
        return false;
    }

    @Override
    public InventorySubcontainer A() {
        return this.bY;
    }

    @Override
    public SlotAccess a_(int mappedIndex) {
        int j2 = mappedIndex - 300;
        return j2 >= 0 && j2 < this.bY.b() ? SlotAccess.a(this.bY, j2) : super.a_(mappedIndex);
    }

    protected abstract void gl();

    protected void a(MerchantRecipeList recipeList, VillagerTrades.IMerchantRecipeOption[] pool, int count) {
        ArrayList arraylist = Lists.newArrayList((Object[])pool);
        int j2 = 0;
        while (j2 < count && !arraylist.isEmpty()) {
            MerchantRecipe merchantrecipe = ((VillagerTrades.IMerchantRecipeOption)arraylist.remove(this.ag.a(arraylist.size()))).a(this, this.ag);
            if (merchantrecipe == null) continue;
            VillagerAcquireTradeEvent event = new VillagerAcquireTradeEvent((AbstractVillager)this.getBukkitEntity(), (org.bukkit.inventory.MerchantRecipe)merchantrecipe.asBukkit());
            if (this.valid) {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            if (!event.isCancelled()) {
                CraftMerchantRecipe craftMerchantRecipe = CraftMerchantRecipe.fromBukkit(event.getRecipe());
                if (craftMerchantRecipe.getIngredients().isEmpty()) {
                    return;
                }
                recipeList.add(craftMerchantRecipe.toMinecraft());
            }
            ++j2;
        }
    }

    @Override
    public Vec3D q(float delta) {
        float f1 = MathHelper.i(delta, this.aV, this.aU) * ((float)Math.PI / 180);
        Vec3D vec3d = new Vec3D(0.0, this.cH().c() - 1.0, 0.2);
        return this.l(delta).e(vec3d.b(-f1));
    }

    @Override
    public boolean gm() {
        return this.dM().B;
    }

    public void setVoidTrade() {
        this.voidTrade = true;
    }
}

