/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import com.destroystokyo.paper.event.player.PlayerReadyArrowEvent;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.event.player.PlayerDeepSleepEvent;
import io.papermc.paper.event.player.PlayerShieldDisableEvent;
import io.papermc.paper.event.player.PrePlayerAttackEntityEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.kyori.adventure.util.TriState;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Unit;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityParrot;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.PlayerAbilities;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.food.FoodMetaData;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerPlayer;
import net.minecraft.world.inventory.InventoryEnderChest;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.ItemElytra;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemSword;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.CommandBlockListenerAbstract;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockRespawnAnchor;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftVector;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityKnockbackEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;
import org.slf4j.Logger;
import top.leavesmc.leaves.LeavesConfig;

public abstract class EntityHuman
extends EntityLiving {
    private static final Logger b = LogUtils.getLogger();
    public static final int bA = 16;
    public static final EnumMainHand bB = EnumMainHand.b;
    public static final int bC = 0;
    public static final int bD = 20;
    public static final int bE = 100;
    public static final int bF = 10;
    public static final int bG = 200;
    public static final float bH = 1.5f;
    public static final float bI = 0.6f;
    public static final float bJ = 0.6f;
    public static final float bK = 1.62f;
    public static final EntitySize bL = EntitySize.b(0.6f, 1.8f);
    private static final Map<EntityPose, EntitySize> c = ImmutableMap.builder().put((Object)EntityPose.a, (Object)bL).put((Object)EntityPose.c, (Object)EntityLiving.v).put((Object)EntityPose.b, (Object)EntitySize.b(0.6f, 0.6f)).put((Object)EntityPose.d, (Object)EntitySize.b(0.6f, 0.6f)).put((Object)EntityPose.e, (Object)EntitySize.b(0.6f, 0.6f)).put((Object)EntityPose.f, (Object)EntitySize.b(0.6f, 1.5f)).put((Object)EntityPose.h, (Object)EntitySize.c(0.2f, 0.2f)).build();
    private static final DataWatcherObject<Float> d = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Integer> e = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.b);
    public static final DataWatcherObject<Byte> bM = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.a);
    protected static final DataWatcherObject<Byte> bN = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.a);
    protected static final DataWatcherObject<NBTTagCompound> bO = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.s);
    protected static final DataWatcherObject<NBTTagCompound> bP = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.s);
    private long f;
    private final PlayerInventory cm = new PlayerInventory(this);
    protected InventoryEnderChest bQ = new InventoryEnderChest(this);
    public final ContainerPlayer bR;
    public Container bS;
    protected FoodMetaData bT = new FoodMetaData(this);
    protected int bU;
    public float bV;
    public float bW;
    public int bX;
    public double bY;
    public double bZ;
    public double ca;
    public double cb;
    public double cc;
    public double cd;
    public int cn;
    protected boolean ce;
    private final PlayerAbilities co = new PlayerAbilities();
    public int cf;
    public int cg;
    public float ch;
    public int ci;
    protected final float cj = 0.02f;
    private int cp;
    public GameProfile cq;
    private boolean cr;
    private net.minecraft.world.item.ItemStack cs;
    private final ItemCooldown ct;
    private Optional<GlobalPos> cu;
    @Nullable
    public EntityFishingHook ck;
    public float cl;
    public boolean affectsSpawning = true;
    public TriState flyingFallDamage = TriState.NOT_SET;
    public boolean elytraAeronauticsNoChunk = false;
    public boolean fauxSleeping;
    public int oldLevel = -1;

    @Override
    public CraftHumanEntity getBukkitEntity() {
        return (CraftHumanEntity)super.getBukkitEntity();
    }

    public EntityHuman(World world, BlockPosition pos, float yaw, GameProfile gameProfile) {
        super((EntityTypes<? extends EntityLiving>)EntityTypes.bv, world);
        this.cs = net.minecraft.world.item.ItemStack.f;
        this.ct = this.k();
        this.cu = Optional.empty();
        this.a_(gameProfile.getId());
        this.cq = gameProfile;
        this.bR = new ContainerPlayer(this.cm, !world.B, this);
        this.bS = this.bR;
        this.b((double)pos.u() + 0.5, pos.v() + 1, (double)pos.w() + 0.5, yaw, 0.0f);
        this.bg = 180.0f;
    }

    public boolean a(World world, BlockPosition pos, EnumGamemode gameMode) {
        if (!gameMode.f()) {
            return false;
        }
        if (gameMode == EnumGamemode.d) {
            return true;
        }
        if (this.ge()) {
            return false;
        }
        net.minecraft.world.item.ItemStack itemstack = this.eT();
        return itemstack.b() || !itemstack.b(world.I_().d(Registries.f), new ShapeDetectorBlock(world, pos, false));
    }

    public static AttributeProvider.Builder fH() {
        return EntityLiving.dQ().a(GenericAttributes.c, 1.0).a(GenericAttributes.m, 0.1f).a(GenericAttributes.e).a(GenericAttributes.j);
    }

    @Override
    protected void c_() {
        super.c_();
        this.an.a(d, Float.valueOf(0.0f));
        this.an.a(e, 0);
        this.an.a(bM, (byte)0);
        this.an.a(bN, (byte)bB.a());
        this.an.a(bO, new NBTTagCompound());
        this.an.a(bP, new NBTTagCompound());
    }

    @Override
    public void l() {
        this.af = this.isCreativeFlyOrSpectator();
        if (this.isCreativeFlyOrSpectator()) {
            this.c(false);
        }
        if (this.bX > 0) {
            --this.bX;
        }
        if (this.fD()) {
            ++this.cn;
            if (this.cn == 100 && !new PlayerDeepSleepEvent((Player)this.getBukkitEntity()).callEvent()) {
                this.cn = Integer.MIN_VALUE;
            }
            if (this.cn > 100) {
                this.cn = 100;
            }
            if (!this.dM().B && this.dM().P()) {
                this.a(false, true);
            }
        } else if (this.cn > 0) {
            ++this.cn;
            if (this.cn >= 110) {
                this.cn = 0;
            }
        }
        this.fL();
        super.l();
        if (!this.dM().B && this.bS != null && !this.bS.a(this)) {
            this.closeContainer(InventoryCloseEvent.Reason.CANT_USE);
            this.bS = this.bR;
        }
        this.w();
        if (!this.dM().B) {
            this.bT.a(this);
            this.a(StatisticList.k);
            this.a(StatisticList.l);
            if (this.bx()) {
                this.a(StatisticList.m);
            }
            if (this.bV()) {
                this.a(StatisticList.o);
            }
            if (!this.fD()) {
                this.a(StatisticList.n);
            }
        }
        int i2 = 29999999;
        double d0 = MathHelper.a(this.dr(), -2.9999999E7, 2.9999999E7);
        double d1 = MathHelper.a(this.dx(), -2.9999999E7, 2.9999999E7);
        if (d0 != this.dr() || d1 != this.dx()) {
            this.a_(d0, this.dt(), d1);
        }
        ++this.aP;
        net.minecraft.world.item.ItemStack itemstack = this.eT();
        if (!net.minecraft.world.item.ItemStack.a(this.cs, itemstack)) {
            if (!net.minecraft.world.item.ItemStack.b(this.cs, itemstack)) {
                this.gm();
            }
            this.cs = itemstack.p();
        }
        this.u();
        this.ct.a();
        this.fM();
    }

    @Override
    protected float fg() {
        return this.fu() ? 15.0f : super.fg();
    }

    public boolean fI() {
        return this.bS();
    }

    protected boolean fJ() {
        return this.bS();
    }

    protected boolean fK() {
        return this.bS();
    }

    protected boolean fL() {
        this.ce = ((Entity)this).a(TagsFluid.a);
        return this.ce;
    }

    private void u() {
        net.minecraft.world.item.ItemStack itemstack = this.c(EnumItemSlot.f);
        if (itemstack.a(Items.on) && !((Entity)this).a(TagsFluid.a)) {
            this.addEffect(new MobEffect(MobEffects.m, 200, 0, false, false, true), EntityPotionEffectEvent.Cause.TURTLE_HELMET);
        }
    }

    protected ItemCooldown k() {
        return new ItemCooldown();
    }

    private void w() {
        this.bY = this.cb;
        this.bZ = this.cc;
        this.ca = this.cd;
        double d0 = this.dr() - this.cb;
        double d1 = this.dt() - this.cc;
        double d2 = this.dx() - this.cd;
        double d3 = 10.0;
        if (d0 > 10.0) {
            this.bY = this.cb = this.dr();
        }
        if (d2 > 10.0) {
            this.ca = this.cd = this.dx();
        }
        if (d1 > 10.0) {
            this.bZ = this.cc = this.dt();
        }
        if (d0 < -10.0) {
            this.bY = this.cb = this.dr();
        }
        if (d2 < -10.0) {
            this.ca = this.cd = this.dx();
        }
        if (d1 < -10.0) {
            this.bZ = this.cc = this.dt();
        }
        this.cb += d0 * 0.25;
        this.cd += d2 * 0.25;
        this.cc += d1 * 0.25;
    }

    protected void fM() {
        if (this.g(EntityPose.d)) {
            EntityPose entitypose = this.fw() ? EntityPose.b : (this.fD() ? EntityPose.c : (this.bZ() ? EntityPose.d : (this.fj() ? EntityPose.e : (this.bS() && !this.co.b ? EntityPose.f : EntityPose.a))));
            EntityPose entitypose1 = !(this.isCreativeFlyOrSpectator() || this.bO() || this.g(entitypose)) ? (this.g(EntityPose.f) ? EntityPose.f : EntityPose.d) : entitypose;
            this.b(entitypose1);
        }
    }

    protected boolean g(EntityPose pose) {
        return this.dM().a((Entity)this, this.a(pose).a(this.dk()).h(1.0E-7));
    }

    @Override
    public int ax() {
        return Math.max(1, this.dM().Z().c(this.co.a ? GameRules.F : GameRules.E));
    }

    @Override
    protected SoundEffect aN() {
        return SoundEffects.tx;
    }

    @Override
    protected SoundEffect aO() {
        return SoundEffects.tv;
    }

    @Override
    protected SoundEffect aP() {
        return SoundEffects.tw;
    }

    @Override
    public int bJ() {
        return 10;
    }

    @Override
    public void a(SoundEffect sound, float volume, float pitch) {
        this.dM().a(this, this.dr(), this.dt(), this.dx(), sound, this.db(), volume, pitch);
    }

    public void a(SoundEffect event, SoundCategory category, float volume, float pitch) {
    }

    @Override
    public SoundCategory db() {
        return SoundCategory.h;
    }

    @Override
    public int dc() {
        return 20;
    }

    @Override
    public void b(byte status) {
        if (status == 9) {
            this.x();
        } else if (status == 23) {
            this.cr = false;
        } else if (status == 22) {
            this.cr = true;
        } else if (status == 43) {
            this.a(Particles.f);
        } else {
            super.b(status);
        }
    }

    private void a(ParticleParam parameters) {
        for (int i2 = 0; i2 < 5; ++i2) {
            double d0 = this.ag.k() * 0.02;
            double d1 = this.ag.k() * 0.02;
            double d2 = this.ag.k() * 0.02;
            this.dM().a(parameters, this.d(1.0), this.du() + 1.0, this.g(1.0), d0, d1, d2);
        }
    }

    public void closeContainer(InventoryCloseEvent.Reason reason) {
        this.r();
        this.bS = this.bR;
    }

    public void closeUnloadedInventory(InventoryCloseEvent.Reason reason) {
        this.bS = this.bR;
    }

    public void r() {
        this.bS = this.bR;
    }

    protected void s() {
    }

    @Override
    public void t() {
        if (!this.dM().B && this.fJ() && this.bO()) {
            this.ac();
            if (!this.bO()) {
                this.f(false);
                return;
            }
        }
        super.t();
        this.bV = this.bW;
        this.bW = 0.0f;
    }

    @Override
    protected void fi() {
        super.fi();
        this.eQ();
        this.aW = this.dC();
    }

    @Override
    public void d_() {
        if (this.bU > 0) {
            --this.bU;
        }
        if (this.dM().ak() == EnumDifficulty.a && this.dM().Z().b(GameRules.k)) {
            if (this.ev() < this.eM() && this.ah % 20 == 0) {
                this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
            }
            if (this.bT.c() && this.ah % 10 == 0) {
                this.bT.a(this.bT.a() + 1);
            }
        }
        this.cm.j();
        this.bV = this.bW;
        super.d_();
        this.w((float)this.b(GenericAttributes.m));
        float f2 = this.aC() && !this.ew() && !this.bZ() ? Math.min(0.1f, (float)this.dp().h()) : 0.0f;
        this.bW += (f2 - this.bW) * 0.4f;
        if (this.ev() > 0.0f && !this.isCreativeFlyOrSpectator()) {
            AxisAlignedBB axisalignedbb = this.bO() && !this.cZ().dH() ? this.cH().b(this.cZ().cH()).c(1.0, 0.0, 1.0) : this.cH().c(1.0, 0.5, 1.0);
            List<Entity> list = this.dM().a_(this, axisalignedbb);
            ArrayList list1 = Lists.newArrayList();
            for (Entity entity : list) {
                if (entity.ai() == EntityTypes.K) {
                    list1.add(entity);
                    continue;
                }
                if (entity.dH()) continue;
                this.c(entity);
            }
            if (!list1.isEmpty()) {
                this.c((Entity)SystemUtils.a(list1, this.ag));
            }
        }
        this.c(this.gj());
        this.c(this.gk());
        if ((!this.dM().B && (this.ab > 0.5f || this.aZ()) || this.co.b || this.fD() || this.aA) && !this.dM().paperConfig().entities.behavior.parrotsAreUnaffectedByPlayerMovement) {
            this.gg();
        }
    }

    private void c(@Nullable NBTTagCompound entityNbt) {
        if (!(entityNbt == null || entityNbt.e("Silent") && entityNbt.q("Silent") || this.dM().z.a(200) != 0)) {
            String s2 = entityNbt.l("id");
            EntityTypes.a(s2).filter(entitytypes -> entitytypes == EntityTypes.au).ifPresent(entitytypes -> {
                if (!EntityParrot.a(this.dM(), this)) {
                    this.dM().a((EntityHuman)null, this.dr(), this.dt(), this.dx(), EntityParrot.a(this.dM(), this.dM().z), this.db(), 1.0f, EntityParrot.a(this.dM().z));
                }
            });
        }
    }

    private void c(Entity entity) {
        entity.b_(this);
    }

    public int fN() {
        return this.an.b(e);
    }

    public void r(int score) {
        this.an.b(e, score);
    }

    public void s(int score) {
        int j2 = this.fN();
        this.an.b(e, j2 + score);
    }

    public void t(int riptideTicks) {
        this.by = riptideTicks;
        if (!this.dM().B) {
            this.gg();
            this.c(4, true);
        }
    }

    @Override
    public void a(DamageSource damageSource) {
        super.a(damageSource);
        this.ar();
        if (!this.P_()) {
            this.dropAllDeathLoot(damageSource);
        }
        if (damageSource != null) {
            this.o(-MathHelper.b((this.eE() + this.dC()) * ((float)Math.PI / 180)) * 0.1f, 0.1f, -MathHelper.a((this.eE() + this.dC()) * ((float)Math.PI / 180)) * 0.1f);
        } else {
            this.o(0.0, 0.1, 0.0);
        }
        this.a(StatisticList.N);
        this.a(StatisticList.i.b(StatisticList.m));
        this.a(StatisticList.i.b(StatisticList.n));
        this.aA();
        this.a_(false);
        this.a(Optional.of(GlobalPos.a(this.dM().ae(), this.dm())));
    }

    @Override
    protected void ey() {
        super.ey();
        if (!this.dM().Z().b(GameRules.d)) {
            this.fO();
            this.cm.k();
        }
    }

    protected void fO() {
        for (int i2 = 0; i2 < this.cm.b(); ++i2) {
            net.minecraft.world.item.ItemStack itemstack = this.cm.a(i2);
            if (itemstack.b() || !EnchantmentManager.e(itemstack)) continue;
            this.cm.b(i2);
        }
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return source.j().d().a();
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.tn;
    }

    @Nullable
    public EntityItem a(net.minecraft.world.item.ItemStack stack, boolean retainOwnership) {
        return this.a(stack, false, retainOwnership);
    }

    @Nullable
    public EntityItem a(net.minecraft.world.item.ItemStack stack, boolean throwRandomly, boolean retainOwnership) {
        return this.drop(stack, throwRandomly, retainOwnership, true);
    }

    @Nullable
    public EntityItem drop(net.minecraft.world.item.ItemStack itemstack, boolean flag, boolean flag1, boolean callEvent) {
        WorldMap worldmap;
        if (itemstack.b()) {
            return null;
        }
        if (this.dM().B) {
            this.a(EnumHand.a);
        }
        double d0 = this.dv() - (double)0.3f;
        net.minecraft.world.item.ItemStack tmp = itemstack.p();
        itemstack.f(0);
        itemstack = tmp;
        EntityItem entityitem = new EntityItem(this.dM(), this.dr(), d0, this.dx(), itemstack);
        entityitem.b(40);
        if (flag1) {
            entityitem.a(this);
        }
        if (flag) {
            float f2 = this.ag.i() * 0.5f;
            float f1 = this.ag.i() * ((float)Math.PI * 2);
            entityitem.o(-MathHelper.a(f1) * f2, 0.2f, MathHelper.b(f1) * f2);
        } else {
            float f3 = 0.3f;
            float f1 = MathHelper.a(this.dE() * ((float)Math.PI / 180));
            float f2 = MathHelper.b(this.dE() * ((float)Math.PI / 180));
            float f32 = MathHelper.a(this.dC() * ((float)Math.PI / 180));
            float f4 = MathHelper.b(this.dC() * ((float)Math.PI / 180));
            float f5 = this.ag.i() * ((float)Math.PI * 2);
            float f6 = 0.02f * this.ag.i();
            entityitem.o((double)(-f32 * f2 * 0.3f) + Math.cos(f5) * (double)f6, -f1 * 0.3f + 0.1f + (this.ag.i() - this.ag.i()) * 0.1f, (double)(f4 * f2 * 0.3f) + Math.sin(f5) * (double)f6);
        }
        if (!callEvent) {
            return entityitem;
        }
        Player player = (Player)this.getBukkitEntity();
        Item drop = (Item)entityitem.getBukkitEntity();
        PlayerDropItemEvent event = new PlayerDropItemEvent(player, drop);
        this.dM().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            ItemStack cur = player.getInventory().getItemInHand();
            if (flag1 && (cur == null || cur.getAmount() == 0)) {
                player.getInventory().setItemInHand(drop.getItemStack());
            } else if (flag1 && cur.isSimilar(drop.getItemStack()) && cur.getAmount() < cur.getMaxStackSize() && drop.getItemStack().getAmount() == 1) {
                cur.setAmount(cur.getAmount() + 1);
                player.getInventory().setItemInHand(cur);
            } else {
                player.getInventory().addItem(new ItemStack[]{drop.getItemStack()});
            }
            return null;
        }
        if (itemstack.d() == Items.rR && (worldmap = ItemWorldMap.b(itemstack, this.dM())) != null) {
            worldmap.a(this, itemstack);
        }
        return entityitem;
    }

    public float d(IBlockData block) {
        float f2 = this.cm.a(block);
        if (f2 > 1.0f) {
            int i2 = EnchantmentManager.g(this);
            net.minecraft.world.item.ItemStack itemstack = this.eT();
            if (i2 > 0 && !itemstack.b()) {
                f2 += (float)(i2 * i2 + 1);
            }
        }
        if (MobEffectUtil.a(this)) {
            f2 *= 1.0f + (float)(MobEffectUtil.b(this) + 1) * 0.2f;
        }
        if (this.a(MobEffects.d)) {
            f2 *= (switch (this.b(MobEffects.d).e()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            });
        }
        if (((Entity)this).a(TagsFluid.a) && !EnchantmentManager.i(this)) {
            f2 /= 5.0f;
        }
        if (!this.aC()) {
            f2 /= 5.0f;
        }
        return f2;
    }

    public boolean e(IBlockData state) {
        return !state.y() || this.cm.f().b(state);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.a_(this.cq.getId());
        NBTTagList nbttaglist = nbt.c("Inventory", 10);
        this.cm.b(nbttaglist);
        this.cm.l = nbt.h("SelectedItemSlot");
        this.cn = nbt.g("SleepTimer");
        this.ch = nbt.j("XpP");
        this.cf = nbt.h("XpLevel");
        this.cg = nbt.h("XpTotal");
        this.ci = nbt.h("XpSeed");
        if (this.ci == 0) {
            this.ci = this.ag.f();
        }
        this.r(nbt.h("Score"));
        this.bT.a(nbt);
        this.co.b(nbt);
        this.a(GenericAttributes.m).a(this.co.b());
        if (nbt.b("EnderItems", 9)) {
            this.bQ.a(nbt.c("EnderItems", 10));
        }
        if (nbt.b("ShoulderEntityLeft", 10)) {
            this.i(nbt.p("ShoulderEntityLeft"));
        }
        if (nbt.b("ShoulderEntityRight", 10)) {
            this.j(nbt.p("ShoulderEntityRight"));
        }
        if (nbt.b("LastDeathLocation", 10)) {
            DataResult dataresult = GlobalPos.a.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c("LastDeathLocation"));
            Logger logger = b;
            Objects.requireNonNull(logger);
            this.a(dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)));
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        GameProfileSerializer.g(nbt);
        nbt.a("Inventory", this.cm.a(new NBTTagList()));
        nbt.a("SelectedItemSlot", this.cm.l);
        nbt.a("SleepTimer", (short)this.cn);
        nbt.a("XpP", this.ch);
        nbt.a("XpLevel", this.cf);
        nbt.a("XpTotal", this.cg);
        nbt.a("XpSeed", this.ci);
        nbt.a("Score", this.fN());
        this.bT.b(nbt);
        this.co.a(nbt);
        nbt.a("EnderItems", this.bQ.g());
        if (!this.gj().g()) {
            nbt.a("ShoulderEntityLeft", this.gj());
        }
        if (!this.gk().g()) {
            nbt.a("ShoulderEntityRight", this.gk());
        }
        this.gr().flatMap(globalpos -> {
            DataResult dataresult = GlobalPos.a.encodeStart((DynamicOps)DynamicOpsNBT.a, globalpos);
            Logger logger = b;
            Objects.requireNonNull(logger);
            return dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0));
        }).ifPresent(nbtbase -> nbt.a("LastDeathLocation", (NBTBase)nbtbase));
    }

    @Override
    public boolean b(DamageSource damageSource) {
        return super.b(damageSource) ? true : (damageSource.a(DamageTypeTags.o) ? !this.dM().Z().b(GameRules.G) : (damageSource.a(DamageTypeTags.n) ? !this.dM().Z().b(GameRules.H) : (damageSource.a(DamageTypeTags.j) ? !this.dM().Z().b(GameRules.I) : (damageSource.a(DamageTypeTags.p) ? !this.dM().Z().b(GameRules.J) : false))));
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        boolean damaged;
        if (this.b(source)) {
            return false;
        }
        if (this.co.a && !source.a(DamageTypeTags.e)) {
            return false;
        }
        this.bb = 0;
        if (this.ew()) {
            return false;
        }
        if (!this.dM().B) {
            // empty if block
        }
        if (source.f()) {
            if (this.dM().ak() == EnumDifficulty.a) {
                return false;
            }
            if (this.dM().ak() == EnumDifficulty.b) {
                amount = Math.min(amount / 2.0f + 1.0f, amount);
            }
            if (this.dM().ak() == EnumDifficulty.d) {
                amount = amount * 3.0f / 2.0f;
            }
        }
        if (damaged = super.a(source, amount)) {
            this.gg();
        }
        return damaged;
    }

    @Override
    protected void d(EntityLiving attacker) {
        super.d(attacker);
        if (attacker.fG()) {
            this.disableShield(true, attacker);
        }
    }

    @Override
    public boolean eo() {
        return !this.fT().a && super.eo();
    }

    public boolean a(EntityHuman player) {
        Team team;
        if (player instanceof EntityPlayer) {
            EntityPlayer thatPlayer = (EntityPlayer)player;
            team = thatPlayer.getBukkitEntity().getScoreboard().getPlayerTeam((OfflinePlayer)thatPlayer.getBukkitEntity());
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        } else {
            OfflinePlayer thisPlayer = player.dM().getCraftServer().getOfflinePlayer(player.cy());
            team = player.dM().getCraftServer().getScoreboardManager().getMainScoreboard().getPlayerTeam(thisPlayer);
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        }
        if (this instanceof EntityPlayer) {
            return !team.hasPlayer((OfflinePlayer)((EntityPlayer)this).getBukkitEntity());
        }
        return !team.hasPlayer(this.dM().getCraftServer().getOfflinePlayer(this.cy()));
    }

    @Override
    protected void b(DamageSource source, float amount) {
        this.cm.a(source, amount, PlayerInventory.g);
    }

    @Override
    protected void c(DamageSource source, float amount) {
        this.cm.a(source, amount, PlayerInventory.h);
    }

    @Override
    protected void u(float amount) {
        if (this.bv.a(Items.vl)) {
            if (!this.dM().B) {
                this.b(StatisticList.c.b(this.bv.d()));
            }
            if (amount >= 3.0f) {
                int i2 = 1 + MathHelper.d(amount);
                EnumHand enumhand = this.fo();
                this.bv.a(i2, this, (T entityhuman) -> entityhuman.d(enumhand));
                if (this.bv.b()) {
                    if (enumhand == EnumHand.a) {
                        this.a(EnumItemSlot.a, net.minecraft.world.item.ItemStack.f);
                    } else {
                        this.a(EnumItemSlot.b, net.minecraft.world.item.ItemStack.f);
                    }
                    this.bv = net.minecraft.world.item.ItemStack.f;
                    this.a(SoundEffects.vH, 0.8f, 0.8f + this.dM().z.i() * 0.4f);
                }
            }
        }
    }

    @Override
    protected boolean actuallyHurt(DamageSource damagesource, float f2) {
        return super.actuallyHurt(damagesource, f2);
    }

    @Override
    protected boolean dU() {
        return !this.co.b && super.dU();
    }

    public boolean Y() {
        return false;
    }

    public void a(TileEntitySign sign, boolean front) {
    }

    public void a(CommandBlockListenerAbstract commandBlockExecutor) {
    }

    public void a(TileEntityCommand commandBlock) {
    }

    public void a(TileEntityStructure structureBlock) {
    }

    public void a(TileEntityJigsaw jigsaw) {
    }

    public void a(EntityHorseAbstract horse, IInventory inventory) {
    }

    public OptionalInt a(@Nullable ITileInventory factory) {
        return OptionalInt.empty();
    }

    public void a(int syncId, MerchantRecipeList offers, int levelProgress, int experience, boolean leveled, boolean refreshable) {
    }

    public void a(net.minecraft.world.item.ItemStack book, EnumHand hand) {
    }

    public EnumInteractionResult a(Entity entity, EnumHand hand) {
        if (this.P_()) {
            if (entity instanceof ITileInventory) {
                this.a((ITileInventory)((Object)entity));
            }
            return EnumInteractionResult.d;
        }
        net.minecraft.world.item.ItemStack itemstack = this.b(hand);
        net.minecraft.world.item.ItemStack itemstack1 = itemstack.p();
        EnumInteractionResult enuminteractionresult = entity.a(this, hand);
        if (enuminteractionresult.a()) {
            if (this.co.d && itemstack == this.b(hand) && itemstack.L() < itemstack1.L()) {
                itemstack.f(itemstack1.L());
            }
            return enuminteractionresult;
        }
        if (!itemstack.b() && entity instanceof EntityLiving) {
            EnumInteractionResult enuminteractionresult1;
            if (this.co.d) {
                itemstack = itemstack1;
            }
            if ((enuminteractionresult1 = itemstack.a(this, (EntityLiving)entity, hand)).a()) {
                this.dM().a(GameEvent.r, entity.dk(), GameEvent.a.a(this));
                if (itemstack.b() && !this.co.d) {
                    this.a(hand, net.minecraft.world.item.ItemStack.f);
                }
                return enuminteractionresult1;
            }
        }
        return EnumInteractionResult.d;
    }

    @Override
    protected float l(Entity vehicle) {
        return -0.6f;
    }

    @Override
    public void bC() {
        this.stopRiding(false);
    }

    @Override
    public void stopRiding(boolean suppressCancellation) {
        super.stopRiding(suppressCancellation);
        this.J = 0;
    }

    @Override
    protected boolean eY() {
        return super.eY() || this.fD() || this.dH() || !this.valid;
    }

    @Override
    public boolean ea() {
        return !this.co.b;
    }

    @Override
    protected Vec3D a(Vec3D movement, EnumMoveType type) {
        if (!this.co.b && movement.d <= 0.0 && (type == EnumMoveType.a || type == EnumMoveType.b) && this.fK() && this.A()) {
            double d0 = movement.c;
            double d1 = movement.e;
            double d2 = 0.05;
            while (d0 != 0.0 && this.dM().a((Entity)this, this.cH().d(d0, -this.dG(), 0.0))) {
                if (d0 < 0.05 && d0 >= -0.05) {
                    d0 = 0.0;
                    continue;
                }
                if (d0 > 0.0) {
                    d0 -= 0.05;
                    continue;
                }
                d0 += 0.05;
            }
            while (d1 != 0.0 && this.dM().a((Entity)this, this.cH().d(0.0, -this.dG(), d1))) {
                if (d1 < 0.05 && d1 >= -0.05) {
                    d1 = 0.0;
                    continue;
                }
                if (d1 > 0.0) {
                    d1 -= 0.05;
                    continue;
                }
                d1 += 0.05;
            }
            while (d0 != 0.0 && d1 != 0.0 && this.dM().a((Entity)this, this.cH().d(d0, -this.dG(), d1))) {
                d0 = d0 < 0.05 && d0 >= -0.05 ? 0.0 : (d0 > 0.0 ? (d0 -= 0.05) : (d0 += 0.05));
                if (d1 < 0.05 && d1 >= -0.05) {
                    d1 = 0.0;
                    continue;
                }
                if (d1 > 0.0) {
                    d1 -= 0.05;
                    continue;
                }
                d1 += 0.05;
            }
            movement = new Vec3D(d0, movement.d, d1);
        }
        return movement;
    }

    private boolean A() {
        return this.aC() || this.ab < this.dG() && !this.dM().a((Entity)this, this.cH().d(0.0, this.ab - this.dG(), 0.0));
    }

    public void d(Entity target) {
        boolean willAttack = target.cq() && !target.u(this);
        PrePlayerAttackEntityEvent playerAttackEntityEvent = new PrePlayerAttackEntityEvent((Player)this.getBukkitEntity(), (org.bukkit.entity.Entity)target.getBukkitEntity(), willAttack);
        if (playerAttackEntityEvent.callEvent() && willAttack) {
            float f2 = (float)this.b(GenericAttributes.c);
            float f1 = target instanceof EntityLiving ? EnchantmentManager.a(this.eT(), ((EntityLiving)target).eS()) : EnchantmentManager.a(this.eT(), EnumMonsterType.a);
            float f22 = this.B(0.5f);
            f1 *= f22;
            if ((f2 *= 0.2f + f22 * f22 * 0.8f) > 0.0f || f1 > 0.0f) {
                net.minecraft.world.item.ItemStack itemstack;
                boolean flag = f22 > 0.9f;
                boolean flag1 = false;
                int b0 = 0;
                int i2 = b0 + EnchantmentManager.c(this);
                if (this.bY() && flag) {
                    EntityHuman.sendSoundEffect(this, this.dr(), this.dt(), this.dx(), SoundEffects.tf, this.db(), 1.0f, 1.0f);
                    ++i2;
                    flag1 = true;
                }
                boolean flag2 = flag && this.ab > 0.0f && !this.aC() && !this.e_() && !this.aZ() && !this.a(MobEffects.o) && !this.bO() && target instanceof EntityLiving;
                flag2 = flag2 && !this.dM().paperConfig().entities.behavior.disablePlayerCrits;
                boolean bl = flag2 = flag2 && !this.bY();
                if (flag2) {
                    f2 *= 1.5f;
                }
                f2 += f1;
                boolean flag3 = false;
                double d0 = this.Y - this.X;
                if (flag && !flag2 && !flag1 && this.aC() && d0 < (double)this.ff() && (itemstack = this.b(EnumHand.a)).d() instanceof ItemSword) {
                    flag3 = true;
                }
                float f3 = 0.0f;
                boolean flag4 = false;
                int j2 = EnchantmentManager.d(this);
                if (target instanceof EntityLiving) {
                    f3 = ((EntityLiving)target).ev();
                    if (j2 > 0 && !target.bN()) {
                        EntityCombustByEntityEvent combustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)target.getBukkitEntity(), 1);
                        Bukkit.getPluginManager().callEvent((Event)combustEvent);
                        if (!combustEvent.isCancelled()) {
                            flag4 = true;
                            target.setSecondsOnFire(combustEvent.getDuration(), false);
                        }
                    }
                }
                Vec3D vec3d = target.dp();
                boolean flag5 = target.a(this.dN().a(this).critical(flag2), f2);
                if (flag5) {
                    if (i2 > 0) {
                        if (target instanceof EntityLiving) {
                            ((EntityLiving)target).knockback((float)i2 * 0.5f, MathHelper.a(this.dC() * ((float)Math.PI / 180)), -MathHelper.b(this.dC() * ((float)Math.PI / 180)), this, EntityKnockbackEvent.KnockbackCause.ENTITY_ATTACK);
                        } else {
                            target.push(-MathHelper.a(this.dC() * ((float)Math.PI / 180)) * (float)i2 * 0.5f, 0.1, MathHelper.b(this.dC() * ((float)Math.PI / 180)) * (float)i2 * 0.5f, this);
                        }
                        this.g(this.dp().d(0.6, 1.0, 0.6));
                        if (!this.dM().paperConfig().misc.disableSprintInterruptionOnAttack) {
                            this.g(false);
                        }
                    }
                    if (flag3) {
                        float f4 = 1.0f + EnchantmentManager.a(this) * f2;
                        List<EntityLiving> list = this.dM().a(EntityLiving.class, target.cH().c(1.0, 0.25, 1.0));
                        for (EntityLiving entityliving : list) {
                            if (entityliving == this || entityliving == target || this.s(entityliving) || entityliving instanceof EntityArmorStand && ((EntityArmorStand)entityliving).A() || !(this.f((Entity)entityliving) < 9.0) || !entityliving.a(this.dN().a(this).sweep().critical(flag2), f4)) continue;
                            entityliving.knockback(0.4f, MathHelper.a(this.dC() * ((float)Math.PI / 180)), -MathHelper.b(this.dC() * ((float)Math.PI / 180)), this, EntityKnockbackEvent.KnockbackCause.SWEEP_ATTACK);
                        }
                        EntityHuman.sendSoundEffect(this, this.dr(), this.dt(), this.dx(), SoundEffects.ti, this.db(), 1.0f, 1.0f);
                        this.fP();
                    }
                    if (target instanceof EntityPlayer && target.T) {
                        boolean cancelled = false;
                        Player player = (Player)target.getBukkitEntity();
                        Vector velocity = CraftVector.toBukkit(vec3d);
                        PlayerVelocityEvent event = new PlayerVelocityEvent(player, velocity.clone());
                        this.dM().getCraftServer().getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) {
                            cancelled = true;
                        } else if (!velocity.equals((Object)event.getVelocity())) {
                            player.setVelocity(event.getVelocity());
                        }
                        if (!cancelled) {
                            ((EntityPlayer)target).c.b(new PacketPlayOutEntityVelocity(target));
                            target.T = false;
                            target.g(vec3d);
                        }
                    }
                    if (flag2) {
                        EntityHuman.sendSoundEffect(this, this.dr(), this.dt(), this.dx(), SoundEffects.te, this.db(), 1.0f, 1.0f);
                        this.a(target);
                    }
                    if (!flag2 && !flag3) {
                        if (flag) {
                            EntityHuman.sendSoundEffect(this, this.dr(), this.dt(), this.dx(), SoundEffects.th, this.db(), 1.0f, 1.0f);
                        } else {
                            EntityHuman.sendSoundEffect(this, this.dr(), this.dt(), this.dx(), SoundEffects.tj, this.db(), 1.0f, 1.0f);
                        }
                    }
                    if (f1 > 0.0f) {
                        this.b(target);
                    }
                    this.A(target);
                    if (target instanceof EntityLiving) {
                        EnchantmentManager.a((EntityLiving)target, (Entity)this);
                    }
                    EnchantmentManager.b(this, target);
                    net.minecraft.world.item.ItemStack itemstack1 = this.eT();
                    Entity object = target;
                    if (target instanceof EntityComplexPart) {
                        object = ((EntityComplexPart)target).b;
                    }
                    if (!this.dM().B && !itemstack1.b() && object instanceof EntityLiving) {
                        itemstack1.a((EntityLiving)object, this);
                        if (itemstack1.b()) {
                            this.a(EnumHand.a, net.minecraft.world.item.ItemStack.f);
                        }
                    }
                    if (target instanceof EntityLiving) {
                        float f5 = f3 - ((EntityLiving)target).ev();
                        this.a(StatisticList.G, Math.round(f5 * 10.0f));
                        if (j2 > 0) {
                            EntityCombustByEntityEvent combustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)target.getBukkitEntity(), j2 * 4);
                            Bukkit.getPluginManager().callEvent((Event)combustEvent);
                            if (!combustEvent.isCancelled()) {
                                target.setSecondsOnFire(combustEvent.getDuration(), false);
                            }
                        }
                        if (this.dM() instanceof WorldServer && f5 > 2.0f) {
                            int k2 = (int)((double)f5 * 0.5);
                            ((WorldServer)this.dM()).a(Particles.h, target.dr(), target.e(0.5), target.dx(), k2, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                    this.causeFoodExhaustion(this.dM().spigotConfig.combatExhaustion, EntityExhaustionEvent.ExhaustionReason.ATTACK);
                } else {
                    EntityHuman.sendSoundEffect(this, this.dr(), this.dt(), this.dx(), SoundEffects.tg, this.db(), 1.0f, 1.0f);
                    if (flag4) {
                        target.aA();
                    }
                    if (this instanceof EntityPlayer) {
                        ((EntityPlayer)this).getBukkitEntity().updateInventory();
                    }
                }
            }
        }
    }

    @Override
    protected void g(EntityLiving target) {
        this.d((Entity)target);
    }

    @DoNotUse
    @Deprecated
    public void s(boolean sprinting) {
        this.disableShield(sprinting, null);
    }

    public void disableShield(boolean sprinting, @Nullable EntityLiving attacker) {
        float f2 = 0.25f + (float)EnchantmentManager.g(this) * 0.05f;
        if (sprinting) {
            f2 += 0.75f;
        }
        if (this.ag.i() < f2) {
            CraftEntity finalAttacker;
            CraftEntity craftEntity = finalAttacker = attacker != null ? attacker.getBukkitEntity() : null;
            if (finalAttacker != null) {
                PlayerShieldDisableEvent shieldDisableEvent = new PlayerShieldDisableEvent((Player)this.getBukkitEntity(), (org.bukkit.entity.Entity)finalAttacker, 100);
                if (!shieldDisableEvent.callEvent()) {
                    return;
                }
                this.gn().a(Items.vl, shieldDisableEvent.getCooldown());
            } else {
                this.gn().a(Items.vl, 100);
            }
            this.ft();
            this.dM().a((Entity)this, (byte)30);
        }
    }

    public void a(Entity target) {
    }

    public void b(Entity target) {
    }

    public void fP() {
        double d0 = -MathHelper.a(this.dC() * ((float)Math.PI / 180));
        double d1 = MathHelper.b(this.dC() * ((float)Math.PI / 180));
        if (this.dM() instanceof WorldServer) {
            ((WorldServer)this.dM()).a(Particles.ag, this.dr() + d0, this.e(0.5), this.dx() + d1, 0, d0, 0.0, d1, 0.0);
        }
    }

    public void fQ() {
    }

    @Override
    public void a(Entity.RemovalReason reason) {
        this.remove(reason, null);
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        super.remove(entity_removalreason, cause);
        this.bR.b(this);
        if (this.bS != null && this.fU()) {
            this.s();
        }
    }

    public boolean g() {
        return false;
    }

    public GameProfile fR() {
        return this.cq;
    }

    public PlayerInventory fS() {
        return this.cm;
    }

    public PlayerAbilities fT() {
        return this.co;
    }

    public void a(net.minecraft.world.item.ItemStack cursorStack, net.minecraft.world.item.ItemStack slotStack, ClickAction clickType) {
    }

    public boolean fU() {
        return this.bS != this.bR;
    }

    public Either<EnumBedResult, Unit> a(BlockPosition pos) {
        return this.startSleepInBed(pos, false);
    }

    public Either<EnumBedResult, Unit> startSleepInBed(BlockPosition blockposition, boolean force) {
        this.b(blockposition);
        this.cn = 0;
        return Either.right(Unit.a);
    }

    public void a(boolean skipSleepTimer, boolean updateSleepingPlayers) {
        super.fE();
        if (this.dM() instanceof WorldServer && updateSleepingPlayers) {
            ((WorldServer)this.dM()).e();
        }
        this.cn = skipSleepTimer ? 0 : 100;
    }

    @Override
    public void fE() {
        this.a(true, true);
    }

    public static Optional<Vec3D> a(WorldServer world, BlockPosition pos, float angle, boolean forced, boolean alive) {
        IBlockData iblockdata = world.a_(pos);
        Block block = iblockdata.b();
        if (block instanceof BlockRespawnAnchor && (forced || iblockdata.c(BlockRespawnAnchor.d) > 0) && BlockRespawnAnchor.a(world)) {
            Optional<Vec3D> optional = BlockRespawnAnchor.a(EntityTypes.bv, world, pos);
            if (!forced && !alive && optional.isPresent()) {
                world.a(pos, (IBlockData)iblockdata.a(BlockRespawnAnchor.d, iblockdata.c(BlockRespawnAnchor.d) - 1), 3);
            }
            return optional;
        }
        if (block instanceof BlockBed && BlockBed.a(world)) {
            return BlockBed.a(EntityTypes.bv, (ICollisionAccess)world, pos, iblockdata.c(BlockFacingHorizontal.aE), angle);
        }
        if (!forced) {
            return Optional.empty();
        }
        boolean flag2 = block.a(iblockdata);
        IBlockData iblockdata1 = world.a_(pos.c());
        boolean flag3 = iblockdata1.b().a(iblockdata1);
        return flag2 && flag3 ? Optional.of(new Vec3D((double)pos.u() + 0.5, (double)pos.v() + 0.1, (double)pos.w() + 0.5)) : Optional.empty();
    }

    public boolean fV() {
        return this.fD() && this.cn >= 100;
    }

    public int fW() {
        return this.cn;
    }

    public void a(IChatBaseComponent message, boolean overlay) {
    }

    public void a(MinecraftKey stat) {
        this.b(StatisticList.i.b(stat));
    }

    public void a(MinecraftKey stat, int amount) {
        this.a(StatisticList.i.b(stat), amount);
    }

    public void b(Statistic<?> stat) {
        this.a(stat, 1);
    }

    public void a(Statistic<?> stat, int amount) {
    }

    public void a(Statistic<?> stat) {
    }

    public int a(Collection<RecipeHolder<?>> recipes) {
        return 0;
    }

    public void a(RecipeHolder<?> recipe, List<net.minecraft.world.item.ItemStack> ingredients) {
    }

    public void a(List<MinecraftKey> recipes) {
    }

    public int b(Collection<RecipeHolder<?>> recipes) {
        return 0;
    }

    @Override
    public void fb() {
        super.fb();
        this.a(StatisticList.E);
        if (this.bY()) {
            this.causeFoodExhaustion(this.dM().spigotConfig.jumpSprintExhaustion, EntityExhaustionEvent.ExhaustionReason.JUMP_SPRINT);
        } else {
            this.causeFoodExhaustion(this.dM().spigotConfig.jumpWalkExhaustion, EntityExhaustionEvent.ExhaustionReason.JUMP);
        }
    }

    @Override
    public void a(Vec3D movementInput) {
        double d0;
        if (this.bZ() && !this.bO()) {
            double d1;
            d0 = this.bF().d;
            double d2 = d1 = d0 < -0.2 ? 0.085 : 0.06;
            if (d0 <= 0.0 || this.bj || !this.dM().a_(BlockPosition.a(this.dr(), this.dt() + 1.0 - 0.1, this.dx())).u().c()) {
                Vec3D vec3d1 = this.dp();
                this.g(vec3d1.b(0.0, (d0 - vec3d1.d) * d1, 0.0));
            }
        }
        if (this.co.b && !this.bO()) {
            d0 = this.dp().d;
            super.a(movementInput);
            Vec3D vec3d2 = this.dp();
            this.o(vec3d2.c, d0 * 0.6, vec3d2.e);
            this.n();
            if (this.i(7) && !CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
                this.b(7, false);
            }
        } else {
            super.a(movementInput);
        }
    }

    @Override
    public void bf() {
        if (this.co.b) {
            this.h(false);
        } else {
            super.bf();
        }
    }

    protected boolean h(BlockPosition pos) {
        return !this.dM().a_(pos).o(this.dM(), pos);
    }

    @Override
    public float ff() {
        return (float)this.b(GenericAttributes.m);
    }

    @Override
    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        if (this.co.c && !this.flyingFallDamage.toBooleanOrElse(false)) {
            return false;
        }
        if (fallDistance >= 2.0f) {
            this.a(StatisticList.t, (int)Math.round((double)fallDistance * 100.0));
        }
        return super.a(fallDistance, damageMultiplier, damageSource);
    }

    public boolean fX() {
        net.minecraft.world.item.ItemStack itemstack;
        if (!this.aC() && !this.fw() && !this.aZ() && !this.a(MobEffects.y) && (itemstack = this.c(EnumItemSlot.e)).a(Items.nS) && ItemElytra.d(itemstack)) {
            this.fY();
            return true;
        }
        return false;
    }

    public void fY() {
        if (!CraftEventFactory.callToggleGlideEvent(this, true).isCancelled()) {
            this.b(7, true);
        } else {
            this.b(7, true);
            this.b(7, false);
        }
    }

    public void fZ() {
        if (!CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
            this.b(7, true);
            this.b(7, false);
        }
    }

    @Override
    protected void bi() {
        if (!this.P_()) {
            super.bi();
        }
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        if (this.aZ()) {
            this.aR();
            this.b(state);
        } else {
            BlockPosition blockposition1 = this.e(pos);
            if (!pos.equals(blockposition1)) {
                IBlockData iblockdata1 = this.dM().a_(blockposition1);
                if (iblockdata1.a(TagsBlock.bn)) {
                    this.a(iblockdata1, state);
                } else {
                    super.b(blockposition1, iblockdata1);
                }
            } else {
                super.b(pos, state);
            }
        }
    }

    @Override
    public EntityLiving.a eG() {
        return new EntityLiving.a(SoundEffects.tu, SoundEffects.tk);
    }

    @Override
    public boolean a(WorldServer world, EntityLiving other) {
        this.b(StatisticList.g.b(other.ai()));
        return true;
    }

    @Override
    public void a(IBlockData state, Vec3D multiplier) {
        if (!this.co.b) {
            super.a(state, multiplier);
        }
    }

    public void d(int experience) {
        this.s(experience);
        this.ch += (float)experience / (float)this.gb();
        this.cg = MathHelper.a(this.cg + experience, 0, Integer.MAX_VALUE);
        while (this.ch < 0.0f) {
            float f2 = this.ch * (float)this.gb();
            if (this.cf > 0) {
                this.c(-1);
                this.ch = 1.0f + f2 / (float)this.gb();
                continue;
            }
            this.c(-1);
            this.ch = 0.0f;
        }
        while (this.ch >= 1.0f) {
            this.ch = (this.ch - 1.0f) * (float)this.gb();
            this.c(1);
            this.ch /= (float)this.gb();
        }
    }

    public int ga() {
        return this.ci;
    }

    public void a(net.minecraft.world.item.ItemStack enchantedItem, int experienceLevels) {
        this.cf -= experienceLevels;
        if (this.cf < 0) {
            this.cf = 0;
            this.ch = 0.0f;
            this.cg = 0;
        }
        this.ci = this.ag.f();
    }

    public void c(int levels) {
        this.cf += levels;
        if (this.cf < 0) {
            this.cf = 0;
            this.ch = 0.0f;
            this.cg = 0;
        }
        if (levels > 0 && this.cf % 5 == 0 && (float)this.cp < (float)this.ah - 100.0f) {
            float f2 = this.cf > 30 ? 1.0f : (float)this.cf / 30.0f;
            this.dM().a((EntityHuman)null, this.dr(), this.dt(), this.dx(), SoundEffects.tt, this.db(), f2 * 0.75f, 1.0f);
            this.cp = this.ah;
        }
    }

    public int gb() {
        return this.cf >= 30 ? 112 + (this.cf - 30) * 9 : (this.cf >= 15 ? 37 + (this.cf - 15) * 5 : 7 + this.cf * 2);
    }

    private static void sendSoundEffect(EntityHuman fromEntity, double x2, double y2, double z2, SoundEffect soundEffect, SoundCategory soundCategory, float volume, float pitch) {
        fromEntity.dM().a(fromEntity, x2, y2, z2, soundEffect, soundCategory, volume, pitch);
        if (fromEntity instanceof EntityPlayer) {
            ((EntityPlayer)fromEntity).c.b(new PacketPlayOutNamedSoundEffect(BuiltInRegistries.b.d(soundEffect), soundCategory, x2, y2, z2, volume, pitch, fromEntity.ag.g()));
        }
    }

    public void A(float exhaustion) {
        this.causeFoodExhaustion(exhaustion, EntityExhaustionEvent.ExhaustionReason.UNKNOWN);
    }

    public void causeFoodExhaustion(float f2, EntityExhaustionEvent.ExhaustionReason reason) {
        EntityExhaustionEvent event;
        if (!(this.co.a || this.dM().B || (event = CraftEventFactory.callPlayerExhaustionEvent(this, reason, f2)).isCancelled())) {
            this.bT.a(event.getExhaustion());
        }
    }

    public Optional<WardenSpawnTracker> aa() {
        return Optional.empty();
    }

    public FoodMetaData gc() {
        return this.bT;
    }

    public boolean t(boolean ignoreHunger) {
        return this.co.a || ignoreHunger || this.bT.c();
    }

    public boolean gd() {
        return this.ev() > 0.0f && this.ev() < this.eM();
    }

    public boolean ge() {
        return this.co.e;
    }

    public boolean a(BlockPosition pos, EnumDirection facing, net.minecraft.world.item.ItemStack stack) {
        if (this.co.e) {
            return true;
        }
        BlockPosition blockposition1 = pos.a(facing.g());
        ShapeDetectorBlock shapedetectorblock = new ShapeDetectorBlock(this.dM(), blockposition1, false);
        return stack.a(this.dM().I_().d(Registries.f), shapedetectorblock);
    }

    @Override
    public int ee() {
        if (!this.dM().Z().b(GameRules.d) && !this.P_()) {
            int i2 = this.cf * 7;
            return i2 > 100 ? 100 : i2;
        }
        return 0;
    }

    @Override
    protected boolean ef() {
        return true;
    }

    @Override
    public boolean cC() {
        return true;
    }

    @Override
    protected Entity.MovementEmission aW() {
        return !this.co.b && (!this.aC() || !this.bV()) ? Entity.MovementEmission.d : Entity.MovementEmission.a;
    }

    public void y() {
    }

    @Override
    public IChatBaseComponent ad() {
        return IChatBaseComponent.b(this.cq.getName());
    }

    public InventoryEnderChest gf() {
        return this.bQ;
    }

    @Override
    public net.minecraft.world.item.ItemStack c(EnumItemSlot slot) {
        return slot == EnumItemSlot.a ? this.cm.f() : (slot == EnumItemSlot.b ? this.cm.k.get(0) : (slot.a() == EnumItemSlot.Function.b ? this.cm.j.get(slot.b()) : net.minecraft.world.item.ItemStack.f));
    }

    @Override
    protected boolean a(EnumItemSlot slot) {
        return slot.a() == EnumItemSlot.Function.b;
    }

    @Override
    public void a(EnumItemSlot slot, net.minecraft.world.item.ItemStack stack) {
        this.setItemSlot(slot, stack, false);
    }

    @Override
    public void setItemSlot(EnumItemSlot enumitemslot, net.minecraft.world.item.ItemStack itemstack, boolean silent) {
        this.e(itemstack);
        if (enumitemslot == EnumItemSlot.a) {
            this.onEquipItem(enumitemslot, this.cm.i.set(this.cm.l, itemstack), itemstack, silent);
        } else if (enumitemslot == EnumItemSlot.b) {
            this.onEquipItem(enumitemslot, this.cm.k.set(0, itemstack), itemstack, silent);
        } else if (enumitemslot.a() == EnumItemSlot.Function.b) {
            this.onEquipItem(enumitemslot, this.cm.j.set(enumitemslot.b(), itemstack), itemstack, silent);
        }
    }

    public boolean i(net.minecraft.world.item.ItemStack stack) {
        return this.cm.e(stack);
    }

    @Override
    public Iterable<net.minecraft.world.item.ItemStack> bK() {
        return Lists.newArrayList((Object[])new net.minecraft.world.item.ItemStack[]{this.eT(), this.eU()});
    }

    @Override
    public Iterable<net.minecraft.world.item.ItemStack> bL() {
        return this.cm.j;
    }

    public boolean h(NBTTagCompound entityNbt) {
        if (!this.bO() && this.aC() && !this.aZ() && !this.aA) {
            if (this.gj().g()) {
                this.i(entityNbt);
                this.f = this.dM().X();
                return true;
            }
            if (this.gk().g()) {
                this.j(entityNbt);
                this.f = this.dM().X();
                return true;
            }
            return false;
        }
        return false;
    }

    public void gg() {
        if (this.f + 20L < this.dM().X()) {
            if (this.respawnEntityOnShoulder(this.gj())) {
                this.i(new NBTTagCompound());
            }
            if (this.respawnEntityOnShoulder(this.gk())) {
                this.j(new NBTTagCompound());
            }
        }
    }

    public Entity releaseLeftShoulderEntity() {
        Entity entity = this.respawnEntityOnShoulder0(this.gj());
        if (entity != null) {
            this.i(new NBTTagCompound());
        }
        return entity;
    }

    public Entity releaseRightShoulderEntity() {
        Entity entity = this.respawnEntityOnShoulder0(this.gk());
        if (entity != null) {
            this.j(new NBTTagCompound());
        }
        return entity;
    }

    private boolean respawnEntityOnShoulder(NBTTagCompound nbttagcompound) {
        return this.respawnEntityOnShoulder0(nbttagcompound) != null;
    }

    private Entity respawnEntityOnShoulder0(NBTTagCompound nbttagcompound) {
        if (!this.dM().B && nbttagcompound != null && !nbttagcompound.g()) {
            return EntityTypes.a(nbttagcompound, this.dM()).map(entity -> {
                if (entity instanceof EntityTameableAnimal) {
                    ((EntityTameableAnimal)entity).b(this.ay);
                }
                entity.a_(this.dr(), this.dt() + (double)0.7f, this.dx());
                boolean addedToWorld = ((WorldServer)this.dM()).addWithUUID((Entity)entity, CreatureSpawnEvent.SpawnReason.SHOULDER_ENTITY);
                return addedToWorld ? entity : null;
            }).orElse(null);
        }
        return null;
    }

    @Override
    public abstract boolean P_();

    public boolean isCreativeFlyOrSpectator() {
        return this.P_() || LeavesConfig.creativeNoClip && this.f() && this.fT().b;
    }

    public boolean canSpectatingPlace(World world, IBlockData state, BlockPosition pos, VoxelShapeCollision context) {
        if (this.isCreativeFlyOrSpectator()) {
            VoxelShape voxelShape = state.b((IBlockAccess)world, pos, context);
            return voxelShape.c() || world.a((Entity)this, voxelShape.a(pos.u(), (double)pos.v(), (double)pos.w()));
        }
        return world.a(state, pos, context);
    }

    @Override
    public boolean bs() {
        return !this.P_() && super.bs();
    }

    @Override
    public boolean bZ() {
        return !this.co.b && !this.P_() && super.bZ();
    }

    public abstract boolean f();

    @Override
    public boolean cz() {
        return !this.co.b;
    }

    public Scoreboard gh() {
        return this.dM().K();
    }

    @Override
    public IChatBaseComponent Q_() {
        IChatMutableComponent ichatmutablecomponent = ScoreboardTeam.a(this.cg(), this.ad());
        return this.a(ichatmutablecomponent);
    }

    private IChatMutableComponent a(IChatMutableComponent component) {
        String s2 = this.fR().getName();
        return component.a(chatmodifier -> chatmodifier.a(new ChatClickable(ChatClickable.EnumClickAction.d, "/tell " + s2 + " ")).a(this.cG()).a(s2));
    }

    @Override
    public String cy() {
        return this.fR().getName();
    }

    @Override
    public float b(EntityPose pose, EntitySize dimensions) {
        switch (pose) {
            case d: 
            case b: 
            case e: {
                return 0.4f;
            }
            case f: {
                return 1.27f;
            }
        }
        return 1.62f;
    }

    @Override
    protected void z(float absorptionAmount) {
        this.an().b(d, Float.valueOf(absorptionAmount));
    }

    @Override
    public float fk() {
        return this.an().b(d).floatValue();
    }

    public boolean a(PlayerModelPart modelPart) {
        return (this.an().b(bM) & modelPart.a()) == modelPart.a();
    }

    @Override
    public SlotAccess a_(int mappedIndex) {
        if (mappedIndex >= 0 && mappedIndex < this.cm.i.size()) {
            return SlotAccess.a(this.cm, mappedIndex);
        }
        int j2 = mappedIndex - 200;
        return j2 >= 0 && j2 < this.bQ.b() ? SlotAccess.a(this.bQ, j2) : super.a_(mappedIndex);
    }

    public boolean gi() {
        return this.cr;
    }

    public void u(boolean reducedDebugInfo) {
        this.cr = reducedDebugInfo;
    }

    @Override
    public void h(int fireTicks) {
        super.h(this.co.a ? Math.min(fireTicks, 1) : fireTicks);
    }

    @Override
    public EnumMainHand fm() {
        return this.an.b(bN) == 0 ? EnumMainHand.a : EnumMainHand.b;
    }

    public void a(EnumMainHand arm) {
        this.an.b(bN, (byte)(arm != EnumMainHand.a ? 1 : 0));
    }

    public NBTTagCompound gj() {
        return this.an.b(bO);
    }

    public void i(NBTTagCompound entityNbt) {
        this.an.b(bO, entityNbt);
    }

    public NBTTagCompound gk() {
        return this.an.b(bP);
    }

    public void j(NBTTagCompound entityNbt) {
        this.an.b(bP, entityNbt);
    }

    public float gl() {
        return (float)(1.0 / this.b(GenericAttributes.e) * 20.0);
    }

    public float B(float baseTime) {
        return MathHelper.a(((float)this.aP + baseTime) / this.gl(), 0.0f, 1.0f);
    }

    public void gm() {
        this.aP = 0;
    }

    public ItemCooldown gn() {
        return this.ct;
    }

    @Override
    protected float aL() {
        return !this.co.b && !this.fw() ? super.aL() : 1.0f;
    }

    public float go() {
        return (float)this.b(GenericAttributes.j);
    }

    public boolean gp() {
        return this.co.d && this.F() >= 2;
    }

    @Override
    public boolean f(net.minecraft.world.item.ItemStack stack) {
        EnumItemSlot enumitemslot = EntityInsentient.h(stack);
        return this.c(enumitemslot).b();
    }

    @Override
    public EntitySize a(EntityPose pose) {
        return c.getOrDefault((Object)pose, bL);
    }

    @Override
    public ImmutableList<EntityPose> fA() {
        return ImmutableList.of((Object)((Object)EntityPose.a), (Object)((Object)EntityPose.f), (Object)((Object)EntityPose.d));
    }

    protected boolean tryReadyArrow(net.minecraft.world.item.ItemStack bow, net.minecraft.world.item.ItemStack itemstack) {
        return !(this instanceof EntityPlayer) || new PlayerReadyArrowEvent((Player)((EntityPlayer)this).getBukkitEntity(), (ItemStack)CraftItemStack.asCraftMirror(bow), (ItemStack)CraftItemStack.asCraftMirror(itemstack)).callEvent();
    }

    @Override
    public net.minecraft.world.item.ItemStack g(net.minecraft.world.item.ItemStack stack) {
        if (!(stack.d() instanceof ItemProjectileWeapon)) {
            return net.minecraft.world.item.ItemStack.f;
        }
        Predicate<net.minecraft.world.item.ItemStack> predicate = ((ItemProjectileWeapon)stack.d()).e().and(item -> this.tryReadyArrow(stack, (net.minecraft.world.item.ItemStack)item));
        net.minecraft.world.item.ItemStack itemstack1 = ItemProjectileWeapon.a(this, predicate);
        if (!itemstack1.b()) {
            return itemstack1;
        }
        predicate = ((ItemProjectileWeapon)stack.d()).b().and(item -> this.tryReadyArrow(stack, (net.minecraft.world.item.ItemStack)item));
        for (int i2 = 0; i2 < this.cm.b(); ++i2) {
            net.minecraft.world.item.ItemStack itemstack2 = this.cm.a(i2);
            if (!predicate.test(itemstack2)) continue;
            return itemstack2;
        }
        return this.co.d ? new net.minecraft.world.item.ItemStack(Items.os) : net.minecraft.world.item.ItemStack.f;
    }

    @Override
    public net.minecraft.world.item.ItemStack a(World world, net.minecraft.world.item.ItemStack stack) {
        this.gc().a(stack.d(), stack);
        this.b(StatisticList.c.b(stack.d()));
        world.a((EntityHuman)null, this.dr(), this.dt(), this.dx(), SoundEffects.tm, SoundCategory.h, 0.5f, world.z.i() * 0.1f + 0.9f);
        if (this instanceof EntityPlayer) {
            CriterionTriggers.A.a((EntityPlayer)this, stack);
        }
        return super.a(world, stack);
    }

    @Override
    protected boolean c(IBlockData landingState) {
        return this.co.b || super.c(landingState);
    }

    @Override
    public Vec3D q(float delta) {
        float f3;
        double d0 = 0.22 * (this.fm() == EnumMainHand.b ? -1.0 : 1.0);
        float f1 = MathHelper.i(delta * 0.5f, this.dE(), this.O) * ((float)Math.PI / 180);
        float f2 = MathHelper.i(delta, this.aV, this.aU) * ((float)Math.PI / 180);
        if (!this.fw() && !this.fj()) {
            if (this.ca()) {
                return this.l(delta).e(new Vec3D(d0, 0.2, -0.15).a(-f1).b(-f2));
            }
            double d2 = this.cH().c() - 1.0;
            double d1 = this.bX() ? -0.2 : 0.07;
            return this.l(delta).e(new Vec3D(d0, d2, d1).b(-f2));
        }
        Vec3D vec3d = this.f(delta);
        Vec3D vec3d1 = this.dp();
        double d1 = vec3d1.i();
        double d3 = vec3d.i();
        if (d1 > 0.0 && d3 > 0.0) {
            double d4 = (vec3d1.c * vec3d.c + vec3d1.e * vec3d.e) / Math.sqrt(d1 * d3);
            double d5 = vec3d1.c * vec3d.e - vec3d1.e * vec3d.c;
            f3 = (float)(Math.signum(d5) * Math.acos(d4));
        } else {
            f3 = 0.0f;
        }
        return this.l(delta).e(new Vec3D(d0, -0.11, 0.85).c(-f3).a(-f1).b(-f2));
    }

    @Override
    public boolean dL() {
        return true;
    }

    public boolean gq() {
        return this.fn() && this.fp().a(Items.qU);
    }

    @Override
    public boolean dK() {
        return false;
    }

    public Optional<GlobalPos> gr() {
        return this.cu;
    }

    public void a(Optional<GlobalPos> lastDeathPos) {
        this.cu = lastDeathPos;
    }

    @Override
    public float eE() {
        return this.cl;
    }

    @Override
    public void m(float yaw) {
        super.m(yaw);
        this.cl = yaw;
    }

    @Override
    public boolean dF() {
        return true;
    }

    @Override
    protected float fe() {
        return this.co.b && !this.bO() ? (this.bY() ? this.co.a() * 2.0f : this.co.a()) : (this.bY() ? 0.025999999f : 0.02f);
    }

    public static boolean c(String name) {
        if (name == null || name.isEmpty() || name.length() > 16) {
            return false;
        }
        int len = name.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = name.charAt(i2);
            if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || c2 == '_' || c2 == '.') continue;
            return false;
        }
        return true;
    }

    public static float v(boolean creative) {
        return creative ? 5.0f : 4.5f;
    }

    public static enum EnumBedResult {
        a,
        b(IChatBaseComponent.c("block.minecraft.bed.no_sleep")),
        c(IChatBaseComponent.c("block.minecraft.bed.too_far_away")),
        d(IChatBaseComponent.c("block.minecraft.bed.obstructed")),
        e,
        f(IChatBaseComponent.c("block.minecraft.bed.not_safe"));

        @Nullable
        private final IChatBaseComponent g;

        private EnumBedResult() {
            this.g = null;
        }

        private EnumBedResult(IChatBaseComponent ichatbasecomponent) {
            this.g = ichatbasecomponent;
        }

        @Nullable
        public IChatBaseComponent a() {
            return this.g;
        }
    }
}

