/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftItem;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerPickupArrowEvent;

public abstract class EntityArrow
extends IProjectile {
    private static final double f = 2.0;
    private static final DataWatcherObject<Byte> g = DataWatcher.a(EntityArrow.class, DataWatcherRegistry.a);
    private static final DataWatcherObject<Byte> h = DataWatcher.a(EntityArrow.class, DataWatcherRegistry.a);
    private static final int i = 1;
    private static final int j = 2;
    private static final int k = 4;
    @Nullable
    private IBlockData l;
    public boolean b;
    protected int c;
    public PickupStatus d = PickupStatus.a;
    public int e;
    public int m;
    private double n = 2.0;
    public int o;
    public SoundEffect p = this.u();
    @Nullable
    private IntOpenHashSet q;
    @Nullable
    private List<Entity> r;
    public ItemStack s;

    @Override
    public void inactiveTick() {
        if (this.b) {
            ++this.m;
        }
        super.inactiveTick();
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> type, World world, ItemStack stack) {
        super((EntityTypes<? extends IProjectile>)type, world);
        this.s = stack.p();
        if (stack.A()) {
            this.b(stack.y());
        }
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> type, double x2, double y2, double z2, World world, ItemStack stack) {
        this(type, world, stack);
        this.a_(x2, y2, z2);
    }

    protected EntityArrow(EntityTypes<? extends EntityArrow> type, EntityLiving owner, World world, ItemStack stack) {
        this(type, owner.dr(), owner.dv() - (double)0.1f, owner.dx(), world, stack);
        this.b((Entity)owner);
        if (owner instanceof EntityHuman) {
            this.d = PickupStatus.b;
        }
    }

    public void b(SoundEffect sound) {
        this.p = sound;
    }

    @Override
    public boolean a(double distance) {
        double d1 = this.cH().a() * 10.0;
        if (Double.isNaN(d1)) {
            d1 = 1.0;
        }
        return distance < (d1 *= 64.0 * EntityArrow.cA()) * d1;
    }

    @Override
    protected void c_() {
        this.an.a(g, (byte)0);
        this.an.a(h, (byte)0);
    }

    @Override
    public void c(double x2, double y2, double z2, float speed, float divergence) {
        super.c(x2, y2, z2, speed, divergence);
        this.m = 0;
    }

    @Override
    public void a(double x2, double y2, double z2, float yaw, float pitch, int interpolationSteps) {
        this.a_(x2, y2, z2);
        this.a(yaw, pitch);
    }

    @Override
    public void l(double x2, double y2, double z2) {
        super.l(x2, y2, z2);
        this.m = 0;
    }

    @Override
    public void l() {
        Vec3D vec3d1;
        VoxelShape voxelshape;
        super.l();
        boolean flag = this.H();
        Vec3D vec3d = this.dp();
        if (this.O == 0.0f && this.N == 0.0f) {
            double d0 = vec3d.h();
            this.r((float)(MathHelper.d(vec3d.c, vec3d.e) * 57.2957763671875));
            this.s((float)(MathHelper.d(vec3d.d, d0) * 57.2957763671875));
            this.N = this.dC();
            this.O = this.dE();
        }
        BlockPosition blockposition = this.dm();
        IBlockData iblockdata = this.dM().a_(blockposition);
        if (!(iblockdata.i() || flag || (voxelshape = iblockdata.k(this.dM(), blockposition)).c())) {
            vec3d1 = this.dk();
            for (AxisAlignedBB axisalignedbb : voxelshape.e()) {
                if (!axisalignedbb.a(blockposition).d(vec3d1)) continue;
                this.b = true;
                break;
            }
        }
        if (this.e > 0) {
            --this.e;
        }
        if (this.ba() || iblockdata.a(Blocks.qP)) {
            this.aA();
        }
        if (this.b && !flag) {
            if (this.l != iblockdata && this.I()) {
                this.M();
            } else if (!this.dM().B) {
                this.q();
            }
            ++this.c;
        } else {
            if (this.ah > 200) {
                this.q();
            }
            this.c = 0;
            Vec3D vec3d2 = this.dk();
            vec3d1 = vec3d2.e(vec3d);
            MovingObjectPosition object = this.dM().a(new RayTrace(vec3d2, vec3d1, RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, this));
            if (((MovingObjectPosition)object).c() != MovingObjectPosition.EnumMovingObjectType.a) {
                vec3d1 = ((MovingObjectPosition)object).e();
            }
            while (!this.dH()) {
                MovingObjectPositionEntity movingobjectpositionentity = this.a(vec3d2, vec3d1);
                if (movingobjectpositionentity != null) {
                    object = movingobjectpositionentity;
                }
                if (object != null && ((MovingObjectPosition)object).c() == MovingObjectPosition.EnumMovingObjectType.c) {
                    Entity entity = ((MovingObjectPositionEntity)object).a();
                    Entity entity1 = this.w();
                    if (entity instanceof EntityHuman && entity1 instanceof EntityHuman && !((EntityHuman)entity1).a((EntityHuman)entity)) {
                        object = null;
                        movingobjectpositionentity = null;
                    }
                }
                if (object != null && !flag) {
                    this.preOnHit(object);
                    this.au = true;
                }
                if (movingobjectpositionentity == null || this.E() <= 0) break;
                object = null;
            }
            vec3d = this.dp();
            double d1 = vec3d.c;
            double d2 = vec3d.d;
            double d3 = vec3d.e;
            if (this.C()) {
                for (int i2 = 0; i2 < 4; ++i2) {
                    this.dM().a(Particles.g, this.dr() + d1 * (double)i2 / 4.0, this.dt() + d2 * (double)i2 / 4.0, this.dx() + d3 * (double)i2 / 4.0, -d1, -d2 + 0.2, -d3);
                }
            }
            double d4 = this.dr() + d1;
            double d5 = this.dt() + d2;
            double d6 = this.dx() + d3;
            double d7 = vec3d.h();
            if (flag) {
                this.r((float)(MathHelper.d(-d1, -d3) * 57.2957763671875));
            } else {
                this.r((float)(MathHelper.d(d1, d3) * 57.2957763671875));
            }
            this.s((float)(MathHelper.d(d2, d7) * 57.2957763671875));
            this.s(EntityArrow.d(this.O, this.dE()));
            this.r(EntityArrow.d(this.N, this.dC()));
            float f2 = 0.99f;
            float f1 = 0.05f;
            if (this.aZ()) {
                for (int j2 = 0; j2 < 4; ++j2) {
                    float f22 = 0.25f;
                    this.dM().a(Particles.e, d4 - d1 * 0.25, d5 - d2 * 0.25, d6 - d3 * 0.25, d1, d2, d3);
                }
                f2 = this.G();
            }
            this.g(vec3d.a((double)f2));
            if (!this.aV() && !flag) {
                Vec3D vec3d3 = this.dp();
                this.o(vec3d3.c, vec3d3.d - (double)0.05f, vec3d3.e);
            }
            this.a_(d4, d5, d6);
            this.aQ();
        }
    }

    @Override
    public void preOnHit(MovingObjectPosition hitResult) {
        super.preOnHit(hitResult);
        if (hitResult instanceof MovingObjectPositionEntity) {
            MovingObjectPositionEntity entityHitResult = (MovingObjectPositionEntity)hitResult;
            if (this.hitCancelled && this.E() > 0) {
                if (this.q == null) {
                    this.q = new IntOpenHashSet(5);
                }
                this.q.add(entityHitResult.a().aj());
            }
        }
    }

    private boolean I() {
        return this.b && this.dM().b(new AxisAlignedBB(this.dk(), this.dk()).g(0.06));
    }

    private void M() {
        this.b = false;
        Vec3D vec3d = this.dp();
        this.g(vec3d.d(this.ag.i() * 0.2f, this.ag.i() * 0.2f, this.ag.i() * 0.2f));
        this.m = 0;
    }

    @Override
    public void a(EnumMoveType movementType, Vec3D movement) {
        super.a(movementType, movement);
        if (movementType != EnumMoveType.a && this.I()) {
            this.M();
        }
    }

    protected void q() {
        ++this.m;
        if (this.m >= (this.d == PickupStatus.c ? this.dM().paperConfig().entities.spawning.creativeArrowDespawnRate.value() : (this.d == PickupStatus.a ? this.dM().paperConfig().entities.spawning.nonPlayerArrowDespawnRate.value() : (this instanceof EntityThrownTrident ? this.dM().spigotConfig.tridentDespawnRate : this.dM().spigotConfig.arrowDespawnRate)))) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    private void N() {
        if (this.r != null) {
            this.r.clear();
        }
        if (this.q != null) {
            this.q.clear();
        }
    }

    @Override
    protected void a(MovingObjectPositionEntity entityHitResult) {
        DamageSource damagesource;
        Entity entity1;
        super.a(entityHitResult);
        Entity entity = entityHitResult.a();
        float f2 = (float)this.dp().f();
        int i2 = MathHelper.c(MathHelper.a((double)f2 * this.n, 0.0, 2.147483647E9));
        if (this.E() > 0) {
            if (this.q == null) {
                this.q = new IntOpenHashSet(5);
            }
            if (this.r == null) {
                this.r = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.q.size() >= this.E() + 1) {
                this.discard(EntityRemoveEvent.Cause.HIT);
                return;
            }
            this.q.add(entity.aj());
        }
        if (this.C()) {
            long j2 = this.ag.a(i2 / 2 + 2);
            i2 = (int)Math.min(j2 + (long)i2, Integer.MAX_VALUE);
        }
        if ((entity1 = this.w()) == null) {
            damagesource = this.dN().a(this, (Entity)this);
        } else {
            damagesource = this.dN().a(this, entity1);
            if (entity1 instanceof EntityLiving) {
                ((EntityLiving)entity1).A(entity);
            }
        }
        if (this.C()) {
            damagesource = damagesource.critical();
        }
        boolean flag = entity.ai() == EntityTypes.F;
        int k2 = entity.az();
        boolean flag1 = entity.ai().a(TagsEntity.r);
        if (this.bN() && !flag && !flag1) {
            EntityCombustByEntityEvent combustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity(), 5);
            Bukkit.getPluginManager().callEvent((Event)combustEvent);
            if (!combustEvent.isCancelled()) {
                entity.setSecondsOnFire(combustEvent.getDuration(), false);
            }
        }
        if (entity.a(damagesource, (float)i2)) {
            if (flag) {
                return;
            }
            if (entity instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity;
                if (!this.dM().B && this.E() <= 0) {
                    entityliving.p(entityliving.eO() + 1);
                }
                if (this.o > 0) {
                    double d0 = Math.max(0.0, 1.0 - entityliving.b(GenericAttributes.i));
                    Vec3D vec3d = this.dp().d(1.0, 0.0, 1.0).d().a((double)this.o * 0.6 * d0);
                    if (vec3d.g() > 0.0) {
                        entityliving.push(vec3d.c, 0.1, vec3d.e, this);
                    }
                }
                if (!this.dM().B && entity1 instanceof EntityLiving) {
                    EnchantmentManager.a(entityliving, entity1);
                    EnchantmentManager.b((EntityLiving)entity1, (Entity)entityliving);
                }
                this.a(entityliving);
                if (entity1 != null && entityliving != entity1 && entityliving instanceof EntityHuman && entity1 instanceof EntityPlayer && !this.aU()) {
                    ((EntityPlayer)entity1).c.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.g, 0.0f));
                }
                if (!entity.bx() && this.r != null) {
                    this.r.add(entityliving);
                }
                if (!this.dM().B && entity1 instanceof EntityPlayer) {
                    EntityPlayer entityplayer = (EntityPlayer)entity1;
                    if (this.r != null && this.D()) {
                        CriterionTriggers.H.a(entityplayer, this.r);
                    } else if (!entity.bx() && this.D()) {
                        CriterionTriggers.H.a(entityplayer, Arrays.asList(entity));
                    }
                }
            }
            this.a(this.p, 1.0f, 1.2f / (this.ag.i() * 0.2f + 0.9f));
            if (this.E() <= 0) {
                this.discard(EntityRemoveEvent.Cause.HIT);
            }
        } else if (flag1) {
            this.s();
        } else {
            entity.h(k2);
            this.g(this.dp().a(-0.1));
            this.r(this.dC() + 180.0f);
            this.N += 180.0f;
            if (!this.dM().B && this.dp().g() < 1.0E-7) {
                if (this.d == PickupStatus.b) {
                    this.a(this.y(), 0.1f);
                }
                this.discard(EntityRemoveEvent.Cause.HIT);
            }
        }
    }

    public void s() {
        float f2 = this.ag.i() * 360.0f;
        this.g(this.dp().b(f2 * ((float)Math.PI / 180)).a(0.5));
        this.r(this.dC() + f2);
        this.N += f2;
    }

    @Override
    protected void a(MovingObjectPositionBlock blockHitResult) {
        this.l = this.dM().a_(blockHitResult.a());
        super.a(blockHitResult);
        Vec3D vec3d = blockHitResult.e().a(this.dr(), this.dt(), this.dx());
        this.g(vec3d);
        Vec3D vec3d1 = vec3d.d().a((double)0.05f);
        this.p(this.dr() - vec3d1.c, this.dt() - vec3d1.d, this.dx() - vec3d1.e);
        this.a(this.x(), 1.0f, 1.2f / (this.ag.i() * 0.2f + 0.9f));
        this.b = true;
        this.e = 7;
        this.a(false);
        this.a((byte)0);
        this.b(SoundEffects.ap);
        this.q(false);
        this.N();
    }

    protected SoundEffect u() {
        return SoundEffects.ap;
    }

    protected final SoundEffect x() {
        return this.p;
    }

    protected void a(EntityLiving target) {
    }

    @Nullable
    protected MovingObjectPositionEntity a(Vec3D currentPosition, Vec3D nextPosition) {
        return ProjectileHelper.a(this.dM(), this, currentPosition, nextPosition, this.cH().b(this.dp()).g(1.0), this::a);
    }

    @Override
    public boolean a(Entity entity) {
        return super.a(entity) && (this.q == null || !this.q.contains(entity.aj()));
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("life", (short)this.m);
        if (this.l != null) {
            nbt.a("inBlockState", GameProfileSerializer.a(this.l));
        }
        nbt.a("shake", (byte)this.e);
        nbt.a("inGround", this.b);
        nbt.a("pickup", (byte)this.d.ordinal());
        nbt.a("damage", this.n);
        nbt.a("crit", this.C());
        nbt.a("PierceLevel", this.E());
        nbt.a("SoundEvent", BuiltInRegistries.b.b(this.p).toString());
        nbt.a("ShotFromCrossbow", this.D());
        nbt.a("item", this.s.b(new NBTTagCompound()));
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.m = nbt.g("life");
        if (nbt.b("inBlockState", 10)) {
            this.l = GameProfileSerializer.a(this.dM().a(Registries.f), nbt.p("inBlockState"));
        }
        this.e = nbt.f("shake") & 0xFF;
        this.b = nbt.q("inGround");
        if (nbt.b("damage", 99)) {
            this.n = nbt.k("damage");
        }
        this.d = PickupStatus.a(nbt.f("pickup"));
        this.a(nbt.q("crit"));
        this.a(nbt.f("PierceLevel"));
        if (nbt.b("SoundEvent", 8)) {
            this.p = BuiltInRegistries.b.b(MinecraftKey.a(nbt.l("SoundEvent"))).orElse(this.u());
        }
        this.q(nbt.q("ShotFromCrossbow"));
        if (nbt.b("item", 10)) {
            this.s = ItemStack.a(nbt.p("item"));
        }
    }

    @Override
    public void b(@Nullable Entity entity) {
        super.b(entity);
        if (entity instanceof EntityHuman) {
            this.d = ((EntityHuman)entity).fT().d ? PickupStatus.c : PickupStatus.b;
        }
    }

    @Override
    public void b_(EntityHuman player) {
        if (!this.dM().B && (this.b || this.H()) && this.e <= 0) {
            ItemStack itemstack = this.y();
            if (this.d == PickupStatus.b && !itemstack.b() && player.fS().canHold(itemstack) > 0) {
                EntityItem item = new EntityItem(this.dM(), this.dr(), this.dt(), this.dx(), itemstack);
                PlayerPickupArrowEvent event = new PlayerPickupArrowEvent((Player)player.getBukkitEntity(), (Item)new CraftItem(this.dM().getCraftServer(), item), (AbstractArrow)this.getBukkitEntity());
                this.dM().getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                itemstack = item.q();
            }
            if (this.d == PickupStatus.b && player.fS().e(itemstack) || this.d == PickupStatus.c && player.fT().d) {
                player.a((Entity)this, 1);
                this.discard(EntityRemoveEvent.Cause.PICKUP);
            }
        }
    }

    protected boolean a(EntityHuman player) {
        switch (this.d) {
            case b: {
                return player.fS().e(this.y());
            }
            case c: {
                return player.fT().d;
            }
        }
        return false;
    }

    public ItemStack y() {
        return this.s.p();
    }

    @Override
    protected Entity.MovementEmission aW() {
        return Entity.MovementEmission.a;
    }

    public ItemStack z() {
        return this.s;
    }

    public void h(double damage) {
        this.n = damage;
    }

    public double A() {
        return this.n;
    }

    public void b(int punch) {
        this.o = punch;
    }

    public int B() {
        return this.o;
    }

    @Override
    public boolean cq() {
        return false;
    }

    @Override
    protected float a(EntityPose pose, EntitySize dimensions) {
        return 0.13f;
    }

    public void a(boolean critical) {
        this.a(1, critical);
    }

    public void a(byte level) {
        this.an.b(h, level);
    }

    private void a(int index, boolean flag) {
        byte b0 = this.an.b(g);
        if (flag) {
            this.an.b(g, (byte)(b0 | index));
        } else {
            this.an.b(g, (byte)(b0 & ~index));
        }
    }

    public boolean C() {
        byte b0 = this.an.b(g);
        return (b0 & 1) != 0;
    }

    public boolean D() {
        byte b0 = this.an.b(g);
        return (b0 & 4) != 0;
    }

    public byte E() {
        return this.an.b(h);
    }

    public void a(EntityLiving entity, float damageModifier) {
        int i2 = EnchantmentManager.a(Enchantments.y, entity);
        int j2 = EnchantmentManager.a(Enchantments.z, entity);
        this.h((double)(damageModifier * 2.0f) + this.ag.a((double)this.dM().ak().a() * 0.11, 0.57425));
        if (i2 > 0) {
            this.h(this.A() + (double)i2 * 0.5 + 0.5);
        }
        if (j2 > 0) {
            this.b(j2);
        }
        if (EnchantmentManager.a(Enchantments.A, entity) > 0) {
            this.g(100);
        }
    }

    protected float G() {
        return 0.6f;
    }

    public void p(boolean noClip) {
        this.af = noClip;
        this.a(2, noClip);
    }

    public boolean H() {
        return !this.dM().B ? this.af : (this.an.b(g) & 2) != 0;
    }

    public void q(boolean shotFromCrossbow) {
        this.a(4, shotFromCrossbow);
    }

    public static enum PickupStatus {
        a,
        b,
        c;


        public static PickupStatus a(int ordinal) {
            if (ordinal < 0 || ordinal > PickupStatus.values().length) {
                ordinal = 0;
            }
            return PickupStatus.values()[ordinal];
        }
    }
}

