/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.destroystokyo.paper.event.entity.ThrownEggHatchEvent;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.EntityProjectileThrowable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import org.bukkit.Location;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityKnockbackEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerEggThrowEvent;
import top.leavesmc.leaves.LeavesConfig;

public class EntityEgg
extends EntityProjectileThrowable {
    public EntityEgg(EntityTypes<? extends EntityEgg> type, World world) {
        super((EntityTypes<? extends EntityProjectileThrowable>)type, world);
    }

    public EntityEgg(World world, EntityLiving owner) {
        super((EntityTypes<? extends EntityProjectileThrowable>)EntityTypes.A, owner, world);
    }

    public EntityEgg(World world, double x2, double y2, double z2) {
        super((EntityTypes<? extends EntityProjectileThrowable>)EntityTypes.A, x2, y2, z2, world);
    }

    @Override
    public void b(byte status) {
        if (status == 3) {
            double d0 = 0.08;
            for (int i2 = 0; i2 < 8; ++i2) {
                this.dM().a(new ParticleParamItem(Particles.Q, this.q()), this.dr(), this.dt(), this.dx(), ((double)this.ag.i() - 0.5) * 0.08, ((double)this.ag.i() - 0.5) * 0.08, ((double)this.ag.i() - 0.5) * 0.08);
            }
        }
    }

    @Override
    protected void a(MovingObjectPositionEntity entityHitResult) {
        super.a(entityHitResult);
        Entity entity = entityHitResult.a();
        entityHitResult.a().a(this.dN().b(this, this.w()), 0.0f);
        if (LeavesConfig.snowballAndEggCanKnockback && entity instanceof EntityPlayer) {
            entity.a(this.dN().b(this, this.w()), 1.0E-7f);
            ((EntityPlayer)entity).knockback(0.4f, this.dr() - entity.dr(), this.dx() - entity.dx(), this, EntityKnockbackEvent.KnockbackCause.DAMAGE);
        }
    }

    @Override
    protected void a(MovingObjectPosition hitResult) {
        super.a(hitResult);
        if (!this.dM().B) {
            ThrownEggHatchEvent event;
            boolean hatching = this.ag.a(8) == 0;
            int b0 = 1;
            if (this.ag.a(32) == 0) {
                b0 = 4;
            }
            EntityType hatchingType = EntityType.CHICKEN;
            Entity shooter = this.w();
            if (!hatching) {
                b0 = 0;
            }
            if (shooter instanceof EntityPlayer) {
                event = new PlayerEggThrowEvent((Player)shooter.getBukkitEntity(), (Egg)this.getBukkitEntity(), hatching, (byte)b0, hatchingType);
                this.dM().getCraftServer().getPluginManager().callEvent((Event)event);
                b0 = event.getNumHatches();
                hatching = event.isHatching();
                hatchingType = event.getHatchingType();
                if (!hatching) {
                    b0 = 0;
                }
            }
            event = new ThrownEggHatchEvent((Egg)this.getBukkitEntity(), hatching, (byte)b0, hatchingType);
            event.callEvent();
            hatching = event.isHatching();
            b0 = hatching ? event.getNumHatches() : (byte)0;
            hatchingType = event.getHatchingType();
            for (int i2 = 0; i2 < b0; ++i2) {
                Entity entitychicken = this.dM().getWorld().makeEntity(new Location((org.bukkit.World)this.dM().getWorld(), this.dr(), this.dt(), this.dx(), this.dC(), 0.0f), hatchingType.getEntityClass());
                if (entitychicken == null) continue;
                if (entitychicken.getBukkitEntity() instanceof Ageable) {
                    ((Ageable)entitychicken.getBukkitEntity()).setBaby();
                }
                this.dM().addFreshEntity(entitychicken, CreatureSpawnEvent.SpawnReason.EGG);
            }
            this.dM().a((Entity)this, (byte)3);
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }

    @Override
    protected Item s() {
        return Items.qO;
    }
}

