/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;

public abstract class EntityFireball
extends IProjectile {
    public double b;
    public double c;
    public double d;
    public float bukkitYield = 1.0f;
    public boolean isIncendiary = true;

    protected EntityFireball(EntityTypes<? extends EntityFireball> type, World world) {
        super((EntityTypes<? extends IProjectile>)type, world);
    }

    protected EntityFireball(EntityTypes<? extends EntityFireball> type, double x2, double y2, double z2, World world) {
        this(type, world);
        this.a_(x2, y2, z2);
    }

    public EntityFireball(EntityTypes<? extends EntityFireball> type, double x2, double y2, double z2, double directionX, double directionY, double directionZ, World world) {
        this(type, world);
        this.b(x2, y2, z2, this.dC(), this.dE());
        this.ar();
        this.setDirection(directionX, directionY, directionZ);
    }

    public void setDirection(double d3, double d4, double d5) {
        double d6 = Math.sqrt(d3 * d3 + d4 * d4 + d5 * d5);
        if (d6 != 0.0) {
            this.b = d3 / d6 * 0.1;
            this.c = d4 / d6 * 0.1;
            this.d = d5 / d6 * 0.1;
        }
    }

    public EntityFireball(EntityTypes<? extends EntityFireball> type, EntityLiving owner, double directionX, double directionY, double directionZ, World world) {
        this(type, owner.dr(), owner.dt(), owner.dx(), directionX, directionY, directionZ, world);
        this.b((Entity)owner);
        this.a(owner.dC(), owner.dE());
    }

    @Override
    protected void c_() {
    }

    @Override
    public boolean a(double distance) {
        double d1 = this.cH().a() * 4.0;
        if (Double.isNaN(d1)) {
            d1 = 4.0;
        }
        return distance < (d1 *= 64.0) * d1;
    }

    protected RayTrace.BlockCollisionOption ag_() {
        return RayTrace.BlockCollisionOption.a;
    }

    @Override
    public void l() {
        Entity entity = this.w();
        if (!this.dM().B && (entity != null && entity.dH() || !this.dM().B(this.dm()))) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            float f2;
            MovingObjectPosition movingobjectposition;
            super.l();
            if (this.s()) {
                this.g(1);
            }
            if ((movingobjectposition = ProjectileHelper.a((Entity)this, this::a, this.ag_())).c() != MovingObjectPosition.EnumMovingObjectType.a) {
                this.preOnHit(movingobjectposition);
                if (this.dH()) {
                    // empty if block
                }
            }
            this.aQ();
            Vec3D vec3d = this.dp();
            double d0 = this.dr() + vec3d.c;
            double d1 = this.dt() + vec3d.d;
            double d2 = this.dx() + vec3d.e;
            ProjectileHelper.a((Entity)this, 0.2f);
            if (this.aZ()) {
                for (int i2 = 0; i2 < 4; ++i2) {
                    float f1 = 0.25f;
                    this.dM().a(Particles.e, d0 - vec3d.c * 0.25, d1 - vec3d.d * 0.25, d2 - vec3d.e * 0.25, vec3d.c, vec3d.d, vec3d.e);
                }
                f2 = this.y();
            } else {
                f2 = this.x();
            }
            this.g(vec3d.b(this.b, this.c, this.d).a((double)f2));
            ParticleParam particleparam = this.u();
            if (particleparam != null) {
                this.dM().a(particleparam, d0, d1 + 0.5, d2, 0.0, 0.0, 0.0);
            }
            this.a_(d0, d1, d2);
        }
    }

    @Override
    public boolean a(Entity entity) {
        return super.a(entity) && !entity.af;
    }

    protected boolean s() {
        return true;
    }

    @Nullable
    protected ParticleParam u() {
        return Particles.ab;
    }

    protected float x() {
        return 0.95f;
    }

    protected float y() {
        return 0.8f;
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("power", this.a(new double[]{this.b, this.c, this.d}));
    }

    @Override
    public void a(NBTTagCompound nbt) {
        NBTTagList nbttaglist;
        super.a(nbt);
        if (nbt.b("power", 9) && (nbttaglist = nbt.c("power", 6)).size() == 3) {
            this.b = nbttaglist.h(0);
            this.c = nbttaglist.h(1);
            this.d = nbttaglist.h(2);
        }
    }

    @Override
    public boolean bt() {
        return true;
    }

    @Override
    public float bE() {
        return 1.0f;
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        this.bq();
        Entity entity = source.d();
        if (entity != null) {
            if (!this.dM().B) {
                if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, source, amount, false)) {
                    return false;
                }
                Vec3D vec3d = entity.bF();
                this.g(vec3d);
                this.b = vec3d.c * 0.1;
                this.c = vec3d.d * 0.1;
                this.d = vec3d.e * 0.1;
                this.b(entity);
            }
            return true;
        }
        return false;
    }

    @Override
    public float bo() {
        return 1.0f;
    }

    @Override
    public Packet<PacketListenerPlayOut> dj() {
        Entity entity = this.w();
        int i2 = entity == null ? 0 : entity.aj();
        return new PacketPlayOutSpawnEntity(this.aj(), this.cw(), this.dr(), this.dt(), this.dx(), this.dE(), this.dC(), this.ai(), i2, new Vec3D(this.b, this.c, this.d), 0.0);
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        double d0 = packet.i();
        double d1 = packet.j();
        double d2 = packet.k();
        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
        if (d3 != 0.0) {
            this.b = d0 / d3 * 0.1;
            this.c = d1 / d3 * 0.1;
            this.d = d2 / d3 * 0.1;
        }
    }
}

