/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.raid;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.server.level.BossBattleServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossBattle;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BannerPatterns;
import net.minecraft.world.level.block.entity.EnumBannerPatternType;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R3.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_20_R3.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.raid.RaidStopEvent;
import top.leavesmc.leaves.LeavesConfig;

public class Raid {
    private static final int h = 2;
    private static final int i = 0;
    private static final int j = 1;
    private static final int k = 2;
    private static final int l = 32;
    private static final int m = 48000;
    private static final int n = 3;
    private static final String o = "block.minecraft.ominous_banner";
    private static final String p = "event.minecraft.raid.raiders_remaining";
    public static final int a = 16;
    private static final int q = 40;
    private static final int r = 300;
    public static final int b = 2400;
    public static final int c = 600;
    private static final int s = 30;
    public static final int d = 24000;
    public static final int e = 5;
    private static final int t = 2;
    private static final IChatBaseComponent u = IChatBaseComponent.c("event.minecraft.raid");
    private static final IChatBaseComponent v = IChatBaseComponent.c("event.minecraft.raid.victory.full");
    private static final IChatBaseComponent w = IChatBaseComponent.c("event.minecraft.raid.defeat.full");
    private static final int x = 48000;
    public static final int f = 9216;
    public static final int g = 12544;
    private final Map<Integer, EntityRaider> y = Maps.newHashMap();
    private final Map<Integer, Set<EntityRaider>> z = Maps.newHashMap();
    public final Set<UUID> A = Sets.newHashSet();
    public long B;
    private BlockPosition C;
    private final WorldServer D;
    private boolean E;
    private final int F;
    public float G;
    public int H;
    private boolean I;
    private int J;
    public final BossBattleServer K;
    private int L;
    private int M;
    private final RandomSource N;
    public final int O;
    private Status P;
    private int Q;
    private Optional<BlockPosition> R;
    private static final String PDC_NBT_KEY = "BukkitValues";
    private static final CraftPersistentDataTypeRegistry PDC_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    public final CraftPersistentDataContainer persistentDataContainer = new CraftPersistentDataContainer(PDC_TYPE_REGISTRY);
    public static final ItemStack LEADER_BANNER = Raid.createLeaderBanner();

    public Raid(int id, WorldServer world, BlockPosition pos) {
        this.K = new BossBattleServer(u, BossBattle.BarColor.c, BossBattle.BarStyle.c);
        this.N = RandomSource.a();
        this.R = Optional.empty();
        this.F = id;
        this.D = world;
        this.I = true;
        this.M = 300;
        this.K.a(0.0f);
        this.C = pos;
        this.O = this.a(world.ak());
        this.P = Status.a;
    }

    public Raid(WorldServer world, NBTTagCompound nbt) {
        this.K = new BossBattleServer(u, BossBattle.BarColor.c, BossBattle.BarStyle.c);
        this.N = RandomSource.a();
        this.R = Optional.empty();
        this.D = world;
        this.F = nbt.h("Id");
        this.E = nbt.q("Started");
        this.I = nbt.q("Active");
        this.B = nbt.i("TicksActive");
        this.H = nbt.h("BadOmenLevel");
        this.J = nbt.h("GroupsSpawned");
        this.M = nbt.h("PreRaidTicks");
        this.L = nbt.h("PostRaidTicks");
        this.G = nbt.j("TotalHealth");
        this.C = new BlockPosition(nbt.h("CX"), nbt.h("CY"), nbt.h("CZ"));
        this.O = nbt.h("NumGroups");
        this.P = Status.a(nbt.l("Status"));
        this.A.clear();
        if (nbt.b("HeroesOfTheVillage", 9)) {
            NBTTagList nbttaglist = nbt.c("HeroesOfTheVillage", 11);
            for (NBTBase nbtbase : nbttaglist) {
                this.A.add(GameProfileSerializer.a(nbtbase));
            }
        }
        if (nbt.b(PDC_NBT_KEY, 10)) {
            this.persistentDataContainer.putAll(nbt.p(PDC_NBT_KEY));
        }
    }

    public boolean a() {
        return this.e() || this.f();
    }

    public boolean b() {
        return this.c() && this.r() == 0 && this.M > 0;
    }

    public boolean c() {
        return this.J > 0;
    }

    public boolean d() {
        return this.P == Status.d;
    }

    public boolean e() {
        return this.P == Status.b;
    }

    public boolean f() {
        return this.P == Status.c;
    }

    public boolean isInProgress() {
        return this.P == Status.a;
    }

    public float g() {
        return this.G;
    }

    public Set<EntityRaider> h() {
        HashSet set = Sets.newHashSet();
        for (Set<EntityRaider> set1 : this.z.values()) {
            set.addAll(set1);
        }
        return set;
    }

    public World i() {
        return this.D;
    }

    public boolean j() {
        return this.E;
    }

    public int k() {
        return this.J;
    }

    private Predicate<EntityPlayer> x() {
        return entityplayer -> {
            BlockPosition blockposition = entityplayer.dm();
            return entityplayer.bx() && this.D.d(blockposition) == this;
        };
    }

    private void y() {
        HashSet set = Sets.newHashSet(this.K.h());
        List<EntityPlayer> list = this.D.a(this.x());
        for (EntityPlayer entityplayer : list) {
            if (set.contains(entityplayer)) continue;
            this.K.a(entityplayer);
        }
        for (EntityPlayer entityplayer : set) {
            if (list.contains(entityplayer)) continue;
            this.K.b(entityplayer);
        }
    }

    public int l() {
        return 5;
    }

    public int m() {
        return this.H;
    }

    public void a(int badOmenLevel) {
        this.H = badOmenLevel;
    }

    public void a(EntityHuman player) {
        if (player.a(MobEffects.E)) {
            this.H += player.b(MobEffects.E).e() + 1;
            this.H = MathHelper.a(this.H, 0, this.l());
        }
        player.d(MobEffects.E);
    }

    public void n() {
        this.I = false;
        this.K.b();
        this.P = Status.d;
    }

    public void o() {
        if (!this.d()) {
            if (this.P == Status.a) {
                boolean flag1;
                boolean flag = this.I;
                this.I = this.D.B(this.C);
                if (this.D.ak() == EnumDifficulty.a) {
                    CraftEventFactory.callRaidStopEvent(this, RaidStopEvent.Reason.PEACE);
                    this.n();
                    return;
                }
                if (flag != this.I) {
                    this.K.d(this.I);
                }
                if (!this.I) {
                    return;
                }
                if (!this.D.c(this.C)) {
                    this.z();
                }
                if (!this.D.c(this.C)) {
                    if (this.J > 0) {
                        this.P = Status.c;
                        CraftEventFactory.callRaidFinishEvent(this, new ArrayList<Player>());
                    } else {
                        CraftEventFactory.callRaidStopEvent(this, RaidStopEvent.Reason.NOT_IN_VILLAGE);
                        this.n();
                    }
                }
                ++this.B;
                if (this.B >= 48000L) {
                    CraftEventFactory.callRaidStopEvent(this, RaidStopEvent.Reason.TIMEOUT);
                    this.n();
                    return;
                }
                int i2 = this.r();
                if (i2 == 0 && this.A()) {
                    if (this.M > 0) {
                        boolean flag2;
                        flag1 = this.R.isPresent();
                        boolean bl = flag2 = !flag1 && this.M % 5 == 0;
                        if (flag1 && !this.D.f(this.R.get())) {
                            flag2 = true;
                        }
                        if (flag2) {
                            int b0 = 0;
                            if (this.M < 100) {
                                b0 = 1;
                            } else if (this.M < 40) {
                                b0 = 2;
                            }
                            this.R = this.d(b0);
                        }
                        if (this.M == 300 || this.M % 20 == 0) {
                            this.y();
                        }
                        --this.M;
                        this.K.a(MathHelper.a((float)(300 - this.M) / 300.0f, 0.0f, 1.0f));
                    } else if (this.M == 0 && this.J > 0) {
                        this.M = 300;
                        this.K.a(u);
                        return;
                    }
                }
                if (this.B % 20L == 0L) {
                    this.y();
                    this.F();
                    if (i2 > 0) {
                        if (i2 <= 2) {
                            this.K.a(u.f().f(" - ").b(IChatBaseComponent.a(p, i2)));
                        } else {
                            this.K.a(u);
                        }
                    } else {
                        this.K.a(u);
                    }
                }
                flag1 = false;
                int j2 = 0;
                while (this.G()) {
                    BlockPosition blockposition;
                    BlockPosition blockPosition = blockposition = this.R.isPresent() ? this.R.get() : this.a(j2, 20);
                    if (blockposition != null) {
                        this.E = true;
                        this.b(blockposition);
                        if (!flag1) {
                            this.a(blockposition);
                            flag1 = true;
                        }
                    } else {
                        ++j2;
                    }
                    if (j2 <= 3) continue;
                    CraftEventFactory.callRaidStopEvent(this, RaidStopEvent.Reason.UNSPAWNABLE);
                    this.n();
                    break;
                }
                if (this.j() && !this.A() && i2 == 0) {
                    if (this.L < 40) {
                        ++this.L;
                    } else {
                        this.P = Status.b;
                        Iterator<UUID> iterator = this.A.iterator();
                        ArrayList<Player> winners = new ArrayList<Player>();
                        while (iterator.hasNext()) {
                            UUID uuid = iterator.next();
                            Entity entity = this.D.a(uuid);
                            if (!(entity instanceof EntityLiving)) continue;
                            EntityLiving entityliving = (EntityLiving)entity;
                            if (entity.P_()) continue;
                            entityliving.b(new MobEffect(MobEffects.F, 48000, this.H - 1, false, false, true));
                            if (!(entityliving instanceof EntityPlayer)) continue;
                            EntityPlayer entityplayer = (EntityPlayer)entityliving;
                            entityplayer.a(StatisticList.aB);
                            CriterionTriggers.I.a(entityplayer);
                            winners.add(entityplayer.getBukkitEntity());
                        }
                        CraftEventFactory.callRaidFinishEvent(this, winners);
                    }
                }
                this.H();
            } else if (this.a()) {
                ++this.Q;
                if (this.Q >= 600) {
                    CraftEventFactory.callRaidStopEvent(this, RaidStopEvent.Reason.FINISHED);
                    this.n();
                    return;
                }
                if (this.Q % 20 == 0) {
                    this.y();
                    this.K.d(true);
                    if (this.e()) {
                        this.K.a(0.0f);
                        this.K.a(v);
                    } else {
                        this.K.a(w);
                    }
                }
            }
        }
    }

    private void z() {
        Stream<SectionPosition> stream = SectionPosition.a(SectionPosition.a(this.C), 2);
        WorldServer worldserver = this.D;
        Objects.requireNonNull(this.D);
        stream.filter(worldserver::a).map(SectionPosition::q).min(Comparator.comparingDouble(blockposition -> blockposition.j(this.C))).ifPresent(this::c);
    }

    private Optional<BlockPosition> d(int proximity) {
        for (int j2 = 0; j2 < 3; ++j2) {
            BlockPosition blockposition = this.a(proximity, 1);
            if (blockposition == null) continue;
            return Optional.of(blockposition);
        }
        return Optional.empty();
    }

    private boolean A() {
        return this.C() ? !this.D() : !this.B();
    }

    private boolean B() {
        return this.k() == this.O;
    }

    private boolean C() {
        return this.H > 1;
    }

    private boolean D() {
        return this.k() > this.O;
    }

    private boolean E() {
        return this.B() && this.r() == 0 && this.C();
    }

    private void F() {
        Iterator<Set<EntityRaider>> iterator = this.z.values().iterator();
        HashSet hashset = Sets.newHashSet();
        while (iterator.hasNext()) {
            Set<EntityRaider> set = iterator.next();
            for (EntityRaider entityraider : set) {
                BlockPosition blockposition = entityraider.dm();
                if (!entityraider.dH() && entityraider.dM().ae() == this.D.ae() && this.C.j(blockposition) < 12544.0) {
                    if (entityraider.ah <= 600) continue;
                    if (this.D.a(entityraider.cw()) == null) {
                        hashset.add(entityraider);
                    }
                    if (!this.D.c(blockposition) && entityraider.el() > 2400) {
                        entityraider.c(entityraider.gw() + 1);
                    }
                    if (entityraider.gw() < 30) continue;
                    hashset.add(entityraider);
                    continue;
                }
                hashset.add(entityraider);
            }
        }
        for (EntityRaider entityraider1 : hashset) {
            this.a(entityraider1, true);
        }
    }

    private void a(BlockPosition pos) {
        float f2 = 13.0f;
        boolean flag = true;
        Collection<EntityPlayer> collection = this.K.h();
        long i2 = this.N.g();
        for (EntityPlayer entityplayer : this.D.x()) {
            Vec3D vec3d = entityplayer.dk();
            Vec3D vec3d1 = Vec3D.b(pos);
            double d0 = Math.sqrt((vec3d1.c - vec3d.c) * (vec3d1.c - vec3d.c) + (vec3d1.e - vec3d.e) * (vec3d1.e - vec3d.e));
            double d1 = vec3d.c + 13.0 / d0 * (vec3d1.c - vec3d.c);
            double d2 = vec3d.e + 13.0 / d0 * (vec3d1.e - vec3d.e);
            if (!(d0 <= 64.0) && !collection.contains(entityplayer)) continue;
            entityplayer.c.b(new PacketPlayOutNamedSoundEffect(SoundEffects.uf, SoundCategory.g, d1, entityplayer.dt(), d2, 64.0f, 1.0f, i2));
        }
    }

    private void b(BlockPosition pos) {
        boolean flag = false;
        int i2 = this.J + 1;
        this.G = 0.0f;
        DifficultyDamageScaler difficultydamagescaler = this.D.d_(pos);
        boolean flag1 = this.E();
        Wave[] araid_wave = Wave.f;
        int j2 = araid_wave.length;
        EntityRaider leader = null;
        ArrayList<EntityRaider> raiders = new ArrayList<EntityRaider>();
        for (int k2 = 0; k2 < j2; ++k2) {
            EntityRaider entityraider;
            Wave raid_wave = araid_wave[k2];
            int l2 = this.a(raid_wave, i2, flag1) + this.a(raid_wave, this.N, i2, difficultydamagescaler, flag1);
            int i1 = 0;
            for (int j1 = 0; j1 < l2 && (entityraider = raid_wave.g.a(this.D)) != null; ++j1) {
                if (!flag && entityraider.gf()) {
                    entityraider.w(true);
                    this.a(i2, entityraider);
                    flag = true;
                    leader = entityraider;
                }
                this.a(i2, entityraider, pos, false);
                raiders.add(entityraider);
                if (raid_wave.g != EntityTypes.aE) continue;
                EntityRaider entityraider1 = null;
                if (i2 == this.a(EnumDifficulty.c)) {
                    entityraider1 = EntityTypes.az.a(this.D);
                } else if (i2 >= this.a(EnumDifficulty.d)) {
                    entityraider1 = i1 == 0 ? (EntityRaider)EntityTypes.H.a(this.D) : (EntityRaider)EntityTypes.bh.a(this.D);
                }
                ++i1;
                if (entityraider1 == null) continue;
                this.a(i2, entityraider1, pos, false);
                entityraider1.a(pos, 0.0f, 0.0f);
                entityraider1.n(entityraider);
                raiders.add(entityraider);
            }
        }
        this.R = Optional.empty();
        ++this.J;
        this.p();
        this.H();
        CraftEventFactory.callRaidSpawnWaveEvent(this, leader, raiders);
    }

    public void a(int wave, EntityRaider raider, @Nullable BlockPosition pos, boolean existing) {
        boolean flag1 = this.b(wave, raider);
        if (flag1) {
            raider.a(this);
            raider.b(wave);
            raider.z(true);
            raider.c(0);
            if (!existing && pos != null) {
                raider.a_((double)pos.u() + 0.5, (double)pos.v() + 1.0, (double)pos.w() + 0.5);
                raider.a(this.D, this.D.d_(pos), EnumMobSpawn.h, (GroupDataEntity)null, null);
                raider.a(wave, false);
                raider.c(true);
                this.D.addFreshEntityWithPassengers(raider, CreatureSpawnEvent.SpawnReason.RAID);
            }
        }
    }

    public void p() {
        this.K.a(MathHelper.a(this.q() / this.G, 0.0f, 1.0f));
    }

    public float q() {
        float f2 = 0.0f;
        for (Set<EntityRaider> set : this.z.values()) {
            for (EntityRaider entityraider : set) {
                f2 += entityraider.ev();
            }
        }
        return f2;
    }

    private boolean G() {
        return this.M == 0 && (this.J < this.O || this.E()) && this.r() == 0;
    }

    public int r() {
        return this.z.values().stream().mapToInt(Set::size).sum();
    }

    public void a(EntityRaider entity, boolean countHealth) {
        boolean flag1;
        Set<EntityRaider> set = this.z.get(entity.gu());
        if (set != null && (flag1 = set.remove(entity))) {
            if (countHealth) {
                this.G -= entity.ev();
            }
            entity.a((Raid)null);
            this.p();
            this.H();
        }
    }

    private void H() {
        this.D.z().c();
    }

    public static ItemStack s() {
        return LeavesConfig.cacheOminousBannerItem ? LEADER_BANNER.p() : Raid.createLeaderBanner();
    }

    public static ItemStack createLeaderBanner() {
        ItemStack itemstack = new ItemStack(Items.uI);
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        NBTTagList nbttaglist = new EnumBannerPatternType.a().a(BannerPatterns.z, EnumColor.j).a(BannerPatterns.f, EnumColor.i).a(BannerPatterns.j, EnumColor.h).a(BannerPatterns.E, EnumColor.i).a(BannerPatterns.k, EnumColor.p).a(BannerPatterns.B, EnumColor.i).a(BannerPatterns.y, EnumColor.i).a(BannerPatterns.E, EnumColor.p).a();
        nbttagcompound.a("Patterns", nbttaglist);
        ItemBlock.a(itemstack, TileEntityTypes.t, nbttagcompound);
        itemstack.a(ItemStack.HideFlags.f);
        itemstack.a(IChatBaseComponent.c(o).a(EnumChatFormat.g));
        return itemstack;
    }

    @Nullable
    public EntityRaider b(int wave) {
        return this.y.get(wave);
    }

    @Nullable
    private BlockPosition a(int proximity, int tries) {
        int k2 = proximity == 0 ? 2 : 2 - proximity;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (int l2 = 0; l2 < tries; ++l2) {
            float f2 = this.D.z.i() * ((float)Math.PI * 2);
            int i1 = this.C.u() + MathHelper.d(MathHelper.b(f2) * 32.0f * (float)k2) + this.D.z.a(5);
            int j1 = this.C.w() + MathHelper.d(MathHelper.a(f2) * 32.0f * (float)k2) + this.D.z.a(5);
            int k1 = this.D.a(HeightMap.Type.b, i1, j1);
            blockposition_mutableblockposition.d(i1, k1, j1);
            if (this.D.c(blockposition_mutableblockposition) && proximity < 2) continue;
            boolean flag = true;
            if (!this.D.b(blockposition_mutableblockposition.u() - 10, blockposition_mutableblockposition.w() - 10, blockposition_mutableblockposition.u() + 10, blockposition_mutableblockposition.w() + 10) || !this.D.f(blockposition_mutableblockposition) || !SpawnerCreature.a(EntityPositionTypes.Surface.a, (IWorldReader)this.D, (BlockPosition)blockposition_mutableblockposition, EntityTypes.aE) && (!this.D.a_(blockposition_mutableblockposition.d()).a(Blocks.dN) || !this.D.a_(blockposition_mutableblockposition).i())) continue;
            return blockposition_mutableblockposition;
        }
        return null;
    }

    private boolean b(int wave, EntityRaider entity) {
        return this.a(wave, entity, true);
    }

    public boolean a(int wave, EntityRaider entity, boolean countHealth) {
        this.z.computeIfAbsent(wave, integer -> Sets.newHashSet());
        Set<EntityRaider> set = this.z.get(wave);
        EntityRaider entityraider1 = null;
        for (EntityRaider entityraider2 : set) {
            if (!entityraider2.cw().equals(entity.cw())) continue;
            entityraider1 = entityraider2;
            break;
        }
        if (entityraider1 != null) {
            set.remove(entityraider1);
            set.add(entity);
        }
        set.add(entity);
        if (countHealth) {
            this.G += entity.ev();
        }
        this.p();
        this.H();
        return true;
    }

    public void a(int wave, EntityRaider entity) {
        this.y.put(wave, entity);
        entity.a(EnumItemSlot.f, Raid.s());
        entity.a(EnumItemSlot.f, 2.0f);
    }

    public void c(int wave) {
        this.y.remove(wave);
    }

    public BlockPosition t() {
        return this.C;
    }

    private void c(BlockPosition center) {
        this.C = center;
    }

    public int u() {
        return this.F;
    }

    private int a(Wave member, int wave, boolean extra) {
        return extra ? member.h[this.O] : member.h[wave];
    }

    private int a(Wave member, RandomSource random, int wave, DifficultyDamageScaler localDifficulty, boolean extra) {
        int j2;
        EnumDifficulty enumdifficulty = localDifficulty.a();
        boolean flag1 = enumdifficulty == EnumDifficulty.b;
        boolean flag2 = enumdifficulty == EnumDifficulty.c;
        switch (member) {
            case d: {
                if (flag1 || wave <= 2 || wave == 4) {
                    return 0;
                }
                j2 = 1;
                break;
            }
            case c: 
            case a: {
                if (flag1) {
                    j2 = random.a(2);
                    break;
                }
                if (flag2) {
                    j2 = 1;
                    break;
                }
                j2 = 2;
                break;
            }
            case e: {
                j2 = !flag1 && extra ? 1 : 0;
                break;
            }
            default: {
                return 0;
            }
        }
        return j2 > 0 ? random.a(j2 + 1) : 0;
    }

    public boolean v() {
        return this.I;
    }

    public NBTTagCompound a(NBTTagCompound nbt) {
        nbt.a("Id", this.F);
        nbt.a("Started", this.E);
        nbt.a("Active", this.I);
        nbt.a("TicksActive", this.B);
        nbt.a("BadOmenLevel", this.H);
        nbt.a("GroupsSpawned", this.J);
        nbt.a("PreRaidTicks", this.M);
        nbt.a("PostRaidTicks", this.L);
        nbt.a("TotalHealth", this.G);
        nbt.a("NumGroups", this.O);
        nbt.a("Status", this.P.a());
        nbt.a("CX", this.C.u());
        nbt.a("CY", this.C.v());
        nbt.a("CZ", this.C.w());
        NBTTagList nbttaglist = new NBTTagList();
        for (UUID uuid : this.A) {
            nbttaglist.add(GameProfileSerializer.a(uuid));
        }
        nbt.a("HeroesOfTheVillage", nbttaglist);
        if (!this.persistentDataContainer.isEmpty()) {
            nbt.a(PDC_NBT_KEY, this.persistentDataContainer.toTagCompound());
        }
        return nbt;
    }

    public int a(EnumDifficulty difficulty) {
        switch (difficulty) {
            case b: {
                return 3;
            }
            case c: {
                return 5;
            }
            case d: {
                return 7;
            }
        }
        return 0;
    }

    public float w() {
        int i2 = this.m();
        return i2 == 2 ? 0.1f : (i2 == 3 ? 0.25f : (i2 == 4 ? 0.5f : (i2 == 5 ? 0.75f : 0.0f)));
    }

    public void a(Entity entity) {
        this.A.add(entity.cw());
    }

    public Collection<EntityRaider> getRaiders() {
        return this.z.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private static enum Status {
        a,
        b,
        c,
        d;

        private static final Status[] e;

        static Status a(String name) {
            for (Status raid_status : e) {
                if (!name.equalsIgnoreCase(raid_status.name())) continue;
                return raid_status;
            }
            return a;
        }

        public String a() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            e = Status.values();
        }
    }

    private static enum Wave {
        a(EntityTypes.bh, new int[]{0, 0, 2, 0, 1, 4, 2, 5}),
        b(EntityTypes.H, new int[]{0, 0, 0, 0, 0, 1, 1, 2}),
        c(EntityTypes.az, new int[]{0, 4, 3, 3, 4, 4, 4, 2}),
        d(EntityTypes.bl, new int[]{0, 0, 0, 0, 3, 0, 0, 1}),
        e(EntityTypes.aE, new int[]{0, 0, 0, 1, 0, 1, 0, 2});

        static final Wave[] f;
        final EntityTypes<? extends EntityRaider> g;
        final int[] h;

        private Wave(EntityTypes entitytypes, int[] aint) {
            this.g = entitytypes;
            this.h = aint;
        }

        static {
            f = Wave.values();
        }
    }
}

