/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;

public class EntityMinecartTNT
extends EntityMinecartAbstract {
    private static final byte c = 10;
    public int d = -1;

    public EntityMinecartTNT(EntityTypes<? extends EntityMinecartTNT> type, World world) {
        super(type, world);
    }

    public EntityMinecartTNT(World world, double x2, double y2, double z2) {
        super(EntityTypes.ba, world, x2, y2, z2);
    }

    @Override
    public EntityMinecartAbstract.EnumMinecartType w() {
        return EntityMinecartAbstract.EnumMinecartType.d;
    }

    @Override
    public IBlockData y() {
        return Blocks.ck.o();
    }

    @Override
    public void l() {
        double d0;
        super.l();
        if (this.d > 0) {
            if (this.dM().paperConfig().fixes.tntEntityHeightNerf.test(v2 -> this.dt() > (double)v2)) {
                this.discard(EntityRemoveEvent.Cause.OUT_OF_WORLD);
                return;
            }
            --this.d;
            this.dM().a(Particles.ab, this.dr(), this.dt() + 0.5, this.dx(), 0.0, 0.0, 0.0);
        } else if (this.d == 0) {
            this.h(this.dp().i());
        }
        if (this.P && (d0 = this.dp().i()) >= (double)0.01f) {
            this.h(d0);
        }
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        EntityArrow entityarrow;
        Entity entity = source.c();
        if (entity instanceof EntityArrow && (entityarrow = (EntityArrow)entity).bN()) {
            DamageSource damagesource1 = this.dN().d(this, source.d());
            this.a(damagesource1, entityarrow.dp().g());
        }
        return super.a(source, amount);
    }

    @Override
    public void a(DamageSource source) {
        double d0 = this.dp().i();
        if (!EntityMinecartTNT.e(source) && d0 < (double)0.01f) {
            this.b(this.ah_());
        } else if (this.d < 0) {
            this.C();
            this.d = this.ag.a(20) + this.ag.a(20);
        }
    }

    @Override
    protected Item ah_() {
        return Items.nO;
    }

    public void h(double power) {
        this.a((DamageSource)null, power);
    }

    protected void a(@Nullable DamageSource damageSource, double power) {
        if (!this.dM().B) {
            double d1 = Math.sqrt(power);
            if (d1 > 5.0) {
                d1 = 5.0;
            }
            ExplosionPrimeEvent event = new ExplosionPrimeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (float)(4.0 + this.ag.j() * 1.5 * d1), false);
            this.dM().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                this.d = -1;
                return;
            }
            this.dM().a(this, damageSource, null, this.dr(), this.dt(), this.dx(), event.getRadius(), event.getFire(), World.a.d);
            this.discard(EntityRemoveEvent.Cause.EXPLODE);
        }
    }

    @Override
    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        if (fallDistance >= 3.0f) {
            float f2 = fallDistance / 10.0f;
            this.h((double)(f2 * f2));
        }
        return super.a(fallDistance, damageMultiplier, damageSource);
    }

    @Override
    public void a(int x2, int y2, int z2, boolean powered) {
        if (powered && this.d < 0) {
            this.C();
        }
    }

    @Override
    public void b(byte status) {
        if (status == 10) {
            this.C();
        } else {
            super.b(status);
        }
    }

    public void C() {
        this.d = 80;
        if (!this.dM().B) {
            this.dM().a((Entity)this, (byte)10);
            if (!this.aU()) {
                this.dM().a((EntityHuman)null, this.dr(), this.dt(), this.dx(), SoundEffects.yB, SoundCategory.e, 1.0f, 1.0f);
            }
        }
    }

    public int D() {
        return this.d;
    }

    public boolean E() {
        return this.d > -1;
    }

    @Override
    public float a(Explosion explosion, IBlockAccess world, BlockPosition pos, IBlockData blockState, Fluid fluidState, float max) {
        return this.E() && (blockState.a(TagsBlock.N) || world.a_(pos.c()).a(TagsBlock.N)) ? 0.0f : super.a(explosion, world, pos, blockState, fluidState, max);
    }

    @Override
    public boolean a(Explosion explosion, IBlockAccess world, BlockPosition pos, IBlockData state, float explosionPower) {
        return this.E() && (state.a(TagsBlock.N) || world.a_(pos.c()).a(TagsBlock.N)) ? false : super.a(explosion, world, pos, state, explosionPower);
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        super.a(nbt);
        if (nbt.b("TNTFuse", 99)) {
            this.d = nbt.h("TNTFuse");
        }
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("TNTFuse", this.d);
    }

    @Override
    boolean d(DamageSource source) {
        return EntityMinecartTNT.e(source);
    }

    private static boolean e(DamageSource source) {
        return source.a(DamageTypeTags.j) || source.a(DamageTypeTags.m);
    }
}

