/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.level.World;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftBlockInventoryHolder;
import org.bukkit.inventory.BlockInventoryHolder;
import org.jetbrains.annotations.Nullable;

public interface ContainerAccess {
    public static final ContainerAccess a = new ContainerAccess(){

        @Override
        public <T> Optional<T> a(BiFunction<World, BlockPosition, T> getter) {
            return Optional.empty();
        }

        @Override
        public Location getLocation() {
            return null;
        }
    };

    default public World getWorld() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    default public BlockPosition getPosition() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    default public Location getLocation() {
        return new Location((org.bukkit.World)this.getWorld().getWorld(), (double)this.getPosition().u(), (double)this.getPosition().v(), (double)this.getPosition().w());
    }

    default public boolean isBlock() {
        return false;
    }

    default public @Nullable BlockInventoryHolder createBlockHolder(Container menu) {
        if (!this.isBlock()) {
            return null;
        }
        return new CraftBlockInventoryHolder(this, menu.getBukkitView().getTopInventory());
    }

    public static ContainerAccess a(final World world, final BlockPosition pos) {
        return new ContainerAccess(){

            @Override
            public World getWorld() {
                return world;
            }

            @Override
            public BlockPosition getPosition() {
                return pos;
            }

            @Override
            public boolean isBlock() {
                return true;
            }

            @Override
            public <T> Optional<T> a(BiFunction<World, BlockPosition, T> getter) {
                return Optional.of(getter.apply(world, pos));
            }
        };
    }

    public <T> Optional<T> a(BiFunction<World, BlockPosition, T> var1);

    default public <T> T a(BiFunction<World, BlockPosition, T> getter, T defaultValue) {
        return this.a(getter).orElse(defaultValue);
    }

    default public void a(BiConsumer<World, BlockPosition> function) {
        this.a((World world, BlockPosition blockposition) -> {
            function.accept((World)world, (BlockPosition)blockposition);
            return Optional.empty();
        });
    }
}

