/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.EnumAnimation;
import net.minecraft.world.item.EnumItemRarity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class Item
implements FeatureElement,
IMaterial {
    private static final Logger a = LogUtils.getLogger();
    public static final Map<Block, Item> l = Maps.newHashMap();
    protected static final UUID m = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    protected static final UUID n = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3");
    public static final int o = 64;
    public static final int p = 32;
    public static final int q = 13;
    private final Holder.c<Item> b = BuiltInRegistries.h.f(this);
    public final EnumItemRarity c;
    private final int d;
    private final int e;
    private final boolean f;
    @Nullable
    private final Item g;
    @Nullable
    private String h;
    @Nullable
    private final FoodInfo i;
    private final FeatureFlagSet j;

    public static int a(Item item) {
        return item == null ? 0 : BuiltInRegistries.h.a(item);
    }

    public static Item b(int id) {
        return BuiltInRegistries.h.a(id);
    }

    @Deprecated
    public static Item a(Block block) {
        return l.getOrDefault(block, Items.a);
    }

    public Item(Info settings) {
        String string;
        this.c = settings.d;
        this.g = settings.c;
        this.e = settings.b;
        this.d = settings.a;
        this.i = settings.e;
        this.f = settings.f;
        this.j = settings.g;
        if (SharedConstants.aW && !(string = this.getClass().getSimpleName()).endsWith("Item")) {
            a.error("Item classes should end with Item and {} doesn't.", (Object)string);
        }
    }

    @Deprecated
    public Holder.c<Item> j() {
        return this.b;
    }

    public void a(World world, EntityLiving user, ItemStack stack, int remainingUseTicks) {
    }

    public void a(EntityItem entity) {
    }

    public void b(NBTTagCompound nbt) {
    }

    public boolean a(IBlockData state, World world, BlockPosition pos, EntityHuman miner) {
        return true;
    }

    @Override
    @Override
    public Item k() {
        return this;
    }

    public EnumInteractionResult a(ItemActionContext context) {
        return EnumInteractionResult.d;
    }

    public float a(ItemStack stack, IBlockData state) {
        return 1.0f;
    }

    public InteractionResultWrapper<ItemStack> a(World world, EntityHuman user, EnumHand hand) {
        if (this.u()) {
            ItemStack itemStack = user.b(hand);
            if (user.t(this.v().d())) {
                user.c(hand);
                return InteractionResultWrapper.b(itemStack);
            }
            return InteractionResultWrapper.d(itemStack);
        }
        return InteractionResultWrapper.c(user.b(hand));
    }

    public ItemStack a(ItemStack stack, World world, EntityLiving user) {
        if (this.u()) {
            return user.a(world, stack);
        }
        return stack;
    }

    public final int l() {
        return this.d;
    }

    public final int n() {
        return this.e;
    }

    public boolean o() {
        return this.e > 0;
    }

    public boolean e(ItemStack stack) {
        return stack.j();
    }

    public int f(ItemStack stack) {
        return Math.round(13.0f - (float)stack.k() * 13.0f / (float)this.e);
    }

    public int g(ItemStack stack) {
        float f2 = Math.max(0.0f, ((float)this.e - (float)stack.k()) / (float)this.e);
        return MathHelper.h(f2 / 3.0f, 1.0f, 1.0f);
    }

    public boolean a(ItemStack stack, Slot slot, ClickAction clickType, EntityHuman player) {
        return false;
    }

    public boolean a(ItemStack stack, ItemStack otherStack, Slot slot, ClickAction clickType, EntityHuman player, SlotAccess cursorStackReference) {
        return false;
    }

    public boolean a(ItemStack stack, EntityLiving target, EntityLiving attacker) {
        return false;
    }

    public boolean a(ItemStack stack, World world, IBlockData state, BlockPosition pos, EntityLiving miner) {
        return false;
    }

    public boolean a_(IBlockData state) {
        return false;
    }

    public EnumInteractionResult a(ItemStack stack, EntityHuman user, EntityLiving entity, EnumHand hand) {
        return EnumInteractionResult.d;
    }

    public IChatBaseComponent p() {
        return IChatBaseComponent.c(this.a());
    }

    @Override
    public String toString() {
        return BuiltInRegistries.h.b(this).a();
    }

    protected String q() {
        if (this.h == null) {
            this.h = SystemUtils.a("item", BuiltInRegistries.h.b(this));
        }
        return this.h;
    }

    public String a() {
        return this.q();
    }

    public String j(ItemStack stack) {
        return this.a();
    }

    public boolean r() {
        return true;
    }

    @Nullable
    public final Item s() {
        return this.g;
    }

    public boolean t() {
        return this.g != null;
    }

    public void a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
    }

    public void b(ItemStack stack, World world, EntityHuman player) {
        this.a(stack, world);
    }

    public void a(ItemStack stack, World world) {
    }

    public boolean al_() {
        return false;
    }

    public EnumAnimation c(ItemStack stack) {
        return stack.d().u() ? EnumAnimation.b : EnumAnimation.a;
    }

    public int b(ItemStack stack) {
        if (stack.d().u()) {
            return this.v().e() ? 16 : 32;
        }
        return 0;
    }

    public void a(ItemStack stack, World world, EntityLiving user, int remainingUseTicks) {
    }

    public void a(ItemStack stack, @Nullable World world, List<IChatBaseComponent> tooltip, TooltipFlag context) {
    }

    public Optional<TooltipComponent> h(ItemStack stack) {
        return Optional.empty();
    }

    public IChatBaseComponent m(ItemStack stack) {
        return IChatBaseComponent.c(this.j(stack));
    }

    public boolean i(ItemStack stack) {
        return stack.E();
    }

    public EnumItemRarity n(ItemStack stack) {
        if (!stack.E()) {
            return this.c;
        }
        switch (this.c) {
            case a: 
            case b: {
                return EnumItemRarity.c;
            }
            case c: {
                return EnumItemRarity.d;
            }
        }
        return this.c;
    }

    public boolean d_(ItemStack stack) {
        return this.l() == 1 && this.o();
    }

    protected static MovingObjectPositionBlock a(World world, EntityHuman player, RayTrace.FluidCollisionOption fluidHandling) {
        float f2 = player.dE();
        float g2 = player.dC();
        Vec3D vec3 = player.br();
        float h2 = MathHelper.b(-g2 * ((float)Math.PI / 180) - (float)Math.PI);
        float i2 = MathHelper.a(-g2 * ((float)Math.PI / 180) - (float)Math.PI);
        float j2 = -MathHelper.b(-f2 * ((float)Math.PI / 180));
        float k2 = MathHelper.a(-f2 * ((float)Math.PI / 180));
        float l2 = i2 * j2;
        float m2 = k2;
        float n2 = h2 * j2;
        double d2 = 5.0;
        Vec3D vec32 = vec3.b((double)l2 * 5.0, (double)m2 * 5.0, (double)n2 * 5.0);
        return world.a(new RayTrace(vec3, vec32, RayTrace.BlockCollisionOption.b, fluidHandling, player));
    }

    public int c() {
        return 0;
    }

    public boolean a(ItemStack stack, ItemStack ingredient) {
        return false;
    }

    public Multimap<AttributeBase, AttributeModifier> a(EnumItemSlot slot) {
        return ImmutableMultimap.of();
    }

    public boolean l(ItemStack stack) {
        return false;
    }

    public ItemStack am_() {
        return new ItemStack(this);
    }

    public boolean u() {
        return this.i != null;
    }

    @Nullable
    public FoodInfo v() {
        return this.i;
    }

    public SoundEffect an_() {
        return SoundEffects.jy;
    }

    public SoundEffect ao_() {
        return SoundEffects.jz;
    }

    public boolean w() {
        return this.f;
    }

    public boolean a(DamageSource source) {
        return !this.f || !source.a(DamageTypeTags.j);
    }

    public boolean ap_() {
        return true;
    }

    @Override
    @Override
    public FeatureFlagSet m() {
        return this.j;
    }

    public static class Info {
        int a = 64;
        int b;
        @Nullable
        Item c;
        EnumItemRarity d = EnumItemRarity.a;
        @Nullable
        FoodInfo e;
        boolean f;
        FeatureFlagSet g = FeatureFlags.g;

        public Info a(FoodInfo foodComponent) {
            this.e = foodComponent;
            return this;
        }

        public Info a(int maxCount) {
            if (this.b > 0) {
                throw new RuntimeException("Unable to have damage AND stack.");
            }
            this.a = maxCount;
            return this;
        }

        public Info b(int maxDamage) {
            return this.b == 0 ? this.c(maxDamage) : this;
        }

        public Info c(int maxDamage) {
            this.b = maxDamage;
            this.a = 1;
            return this;
        }

        public Info a(Item recipeRemainder) {
            this.c = recipeRemainder;
            return this;
        }

        public Info a(EnumItemRarity rarity) {
            this.d = rarity;
            return this;
        }

        public Info a() {
            this.f = true;
            return this;
        }

        public Info a(FeatureFlag ... features) {
            this.g = FeatureFlags.e.a(features);
            return this;
        }
    }
}

