/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class ItemMonsterEgg
extends Item {
    private static final Map<EntityTypes<? extends EntityInsentient>, ItemMonsterEgg> a = Maps.newIdentityHashMap();
    private final int b;
    private final int c;
    private final EntityTypes<?> d;

    public ItemMonsterEgg(EntityTypes<? extends EntityInsentient> type, int primaryColor, int secondaryColor, Item.Info settings) {
        super(settings);
        this.d = type;
        this.b = primaryColor;
        this.c = secondaryColor;
        a.put(type, this);
    }

    @Override
    public EnumInteractionResult a(ItemActionContext context) {
        World world = context.q();
        if (!(world instanceof WorldServer)) {
            return EnumInteractionResult.a;
        }
        ItemStack itemstack = context.n();
        BlockPosition blockposition = context.a();
        EnumDirection enumdirection = context.k();
        IBlockData iblockdata = world.a_(blockposition);
        TileEntity tileentity = world.c_(blockposition);
        if (tileentity instanceof Spawner) {
            if (world.paperConfig().entities.spawning.disableMobSpawnerSpawnEggTransformation) {
                return EnumInteractionResult.e;
            }
            Spawner spawner = (Spawner)((Object)tileentity);
            EntityTypes<?> entitytypes = this.a(itemstack.v());
            spawner.a(entitytypes, world.F_());
            world.a(blockposition, iblockdata, iblockdata, 3);
            world.a((Entity)context.o(), GameEvent.c, blockposition);
            itemstack.h(1);
            return EnumInteractionResult.b;
        }
        BlockPosition blockposition1 = iblockdata.k(world, blockposition).c() ? blockposition : blockposition.a(enumdirection);
        EntityTypes<?> entitytypes = this.a(itemstack.v());
        if (entitytypes.a((WorldServer)world, itemstack, context.o(), blockposition1, EnumMobSpawn.m, true, !Objects.equals(blockposition, blockposition1) && enumdirection == EnumDirection.b) != null) {
            itemstack.h(1);
            world.a((Entity)context.o(), GameEvent.t, blockposition);
        }
        return EnumInteractionResult.b;
    }

    @Override
    public InteractionResultWrapper<ItemStack> a(World world, EntityHuman user, EnumHand hand) {
        ItemStack itemstack = user.b(hand);
        MovingObjectPositionBlock movingobjectpositionblock = ItemMonsterEgg.a(world, user, RayTrace.FluidCollisionOption.b);
        if (movingobjectpositionblock.c() != MovingObjectPosition.EnumMovingObjectType.b) {
            return InteractionResultWrapper.c(itemstack);
        }
        if (!(world instanceof WorldServer)) {
            return InteractionResultWrapper.a(itemstack);
        }
        BlockPosition blockposition = movingobjectpositionblock.a();
        if (!(world.a_(blockposition).b() instanceof BlockFluids)) {
            return InteractionResultWrapper.c(itemstack);
        }
        if (world.a(user, blockposition) && user.a(blockposition, movingobjectpositionblock.b(), itemstack)) {
            EntityTypes<?> entitytypes = this.a(itemstack.v());
            Object entity = entitytypes.a((WorldServer)world, itemstack, user, blockposition, EnumMobSpawn.m, false, false);
            if (entity == null) {
                return InteractionResultWrapper.c(itemstack);
            }
            if (!user.fT().d) {
                itemstack.h(1);
            }
            user.b(StatisticList.c.b(this));
            world.a((Entity)user, GameEvent.t, ((Entity)entity).dk());
            return InteractionResultWrapper.b(itemstack);
        }
        return InteractionResultWrapper.d(itemstack);
    }

    public boolean a(@Nullable NBTTagCompound nbt, EntityTypes<?> type) {
        return Objects.equals(this.a(nbt), type);
    }

    public int a(int tintIndex) {
        return tintIndex == 0 ? this.b : this.c;
    }

    @Nullable
    public static ItemMonsterEgg a(@Nullable EntityTypes<?> type) {
        return a.get(type);
    }

    public static Iterable<ItemMonsterEgg> h() {
        return Iterables.unmodifiableIterable(a.values());
    }

    public EntityTypes<?> a(@Nullable NBTTagCompound nbt) {
        NBTTagCompound nbttagcompound1;
        if (nbt != null && nbt.b("EntityTag", 10) && (nbttagcompound1 = nbt.p("EntityTag")).b("id", 8)) {
            return EntityTypes.a(nbttagcompound1.l("id")).orElse(this.d);
        }
        return this.d;
    }

    @Override
    public FeatureFlagSet m() {
        return this.d.m();
    }

    public Optional<EntityInsentient> a(EntityHuman user, EntityInsentient entity, EntityTypes<? extends EntityInsentient> entityType, WorldServer world, Vec3D pos, ItemStack stack) {
        if (!this.a(stack.v(), entityType)) {
            return Optional.empty();
        }
        EntityInsentient object = entity instanceof EntityAgeable ? ((EntityAgeable)entity).a(world, (EntityAgeable)entity) : entityType.a(world);
        if (object == null) {
            return Optional.empty();
        }
        object.a(true);
        if (!object.o_()) {
            return Optional.empty();
        }
        object.b(pos.a(), pos.b(), pos.c(), 0.0f, 0.0f);
        world.addFreshEntityWithPassengers(object, CreatureSpawnEvent.SpawnReason.SPAWNER_EGG);
        if (stack.A()) {
            object.b(stack.y());
        }
        if (!user.fT().d) {
            stack.h(1);
        }
        return Optional.of(object);
    }
}

