/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.level.block.BlockGrowingTop;
import net.minecraft.world.level.block.BlockHopper;
import net.minecraft.world.level.block.BlockObserver;
import net.minecraft.world.level.block.BlockRedstoneComparator;
import net.minecraft.world.level.block.BlockRepeater;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.piston.BlockPiston;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import top.leavesmc.leaves.LeavesConfig;

public class ItemShears
extends Item {
    public ItemShears(Item.Info settings) {
        super(settings);
    }

    @Override
    public boolean a(ItemStack stack, World world, IBlockData state, BlockPosition pos, EntityLiving miner) {
        if (!world.B && !state.a(TagsBlock.aJ)) {
            stack.a(1, miner, (T e2) -> e2.d(EnumItemSlot.a));
        }
        return state.a(TagsBlock.O) || state.a(Blocks.bs) || state.a(Blocks.bt) || state.a(Blocks.bu) || state.a(Blocks.bv) || state.a(Blocks.sG) || state.a(Blocks.ff) || state.a(Blocks.fI) || state.a(TagsBlock.a) || super.a(stack, world, state, pos, miner);
    }

    @Override
    public boolean a_(IBlockData state) {
        return state.a(Blocks.bs) || state.a(Blocks.cw) || state.a(Blocks.fI);
    }

    @Override
    public float a(ItemStack stack, IBlockData state) {
        if (state.a(Blocks.bs) || state.a(TagsBlock.O)) {
            return 15.0f;
        }
        if (state.a(TagsBlock.a)) {
            return 5.0f;
        }
        return !state.a(Blocks.ff) && !state.a(Blocks.fg) ? super.a(stack, state) : 2.0f;
    }

    @Override
    public EnumInteractionResult a(ItemActionContext context) {
        BlockGrowingTop growingPlantHeadBlock;
        BlockPosition blockPos;
        World level = context.q();
        IBlockData blockState = level.a_(blockPos = context.a());
        Block block = blockState.b();
        if (block instanceof BlockGrowingTop && !(growingPlantHeadBlock = (BlockGrowingTop)block).o(blockState)) {
            EntityHuman player = context.o();
            ItemStack itemStack = context.n();
            if (player instanceof EntityPlayer) {
                CriterionTriggers.N.a((EntityPlayer)player, blockPos, itemStack);
            }
            level.a(player, blockPos, SoundEffects.kL, SoundCategory.e, 1.0f, 1.0f);
            IBlockData blockState2 = growingPlantHeadBlock.n(blockState);
            level.b(blockPos, blockState2);
            level.a(GameEvent.c, blockPos, GameEvent.a.a(context.o(), blockState2));
            if (player != null) {
                itemStack.a(1, player, (T playerx) -> playerx.d(context.p()));
            }
            return EnumInteractionResult.a(level.B);
        }
        Block block2 = blockState.b();
        if (LeavesConfig.redstoneShearsWrench && block2 instanceof BlockObserver || block2 instanceof BlockDispenser || block2 instanceof BlockPiston || block2 instanceof BlockHopper || block2 instanceof BlockRepeater || block2 instanceof BlockRedstoneComparator) {
            BlockStateList<Block, IBlockData> blockstatelist = block2.n();
            IBlockState<?> iblockstate = blockstatelist.a("facing");
            EntityHuman player = context.o();
            if (iblockstate == null || player == null) {
                return EnumInteractionResult.e;
            }
            if (block2 instanceof BlockPiston && ItemShears.getNameHelper(blockState, blockstatelist.a("extended")).equals("true")) {
                return EnumInteractionResult.e;
            }
            if (block2 instanceof BlockRepeater || block2 instanceof BlockRedstoneComparator) {
                if (ItemShears.getNameHelper(blockState, blockstatelist.a("powered")).equals("true")) {
                    return EnumInteractionResult.e;
                }
                if (block2 instanceof BlockRepeater && ItemShears.getNameHelper(blockState, blockstatelist.a("locked")).equals("true")) {
                    return EnumInteractionResult.e;
                }
            }
            IBlockData iblockdata1 = ItemShears.cycleState(blockState, iblockstate, player.fI());
            level.a(blockPos, iblockdata1, 18);
            ItemShears.message(player, IChatBaseComponent.a("item.minecraft.debug_stick.update", new Object[]{iblockstate.f(), ItemShears.getNameHelper(iblockdata1, iblockstate)}));
            return EnumInteractionResult.c;
        }
        return super.a(context);
    }

    private static <T extends Comparable<T>> IBlockData cycleState(IBlockData state, IBlockState<T> property, boolean inverse) {
        return (IBlockData)state.a(property, (Comparable)ItemShears.getRelative(property.a(), state.c(property), inverse));
    }

    private static <T> T getRelative(Iterable<T> elements, @Nullable T current, boolean inverse) {
        return inverse ? SystemUtils.b(elements, current) : SystemUtils.a(elements, current);
    }

    private static void message(EntityHuman player, IChatBaseComponent message) {
        ((EntityPlayer)player).b(message, true);
    }

    private static <T extends Comparable<T>> String getNameHelper(IBlockData state, IBlockState<T> property) {
        return property.a(state.c(property));
    }
}

