/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.event.entity.EntityDamageItemEvent;
import io.papermc.paper.event.player.PlayerOpenSignEvent;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.arguments.blocks.ArgumentBlock;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.AdventureModeCheck;
import net.minecraft.world.item.EnumAnimation;
import net.minecraft.world.item.EnumItemRarity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBed;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemBucket;
import net.minecraft.world.item.ItemRecord;
import net.minecraft.world.item.ItemSign;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentDurability;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockSapling;
import net.minecraft.world.level.block.BlockSign;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.BlockWitherSkull;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityJukeBox;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_20_R3.block.CapturedBlockState;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftLocation;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftMagicNumbers;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.slf4j.Logger;
import top.leavesmc.leaves.command.NoBlockUpdateCommand;

public final class ItemStack {
    public static final Codec<ItemStack> a = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.h.r().fieldOf("id").forGetter(ItemStack::e), (App)Codec.INT.fieldOf("Count").forGetter(ItemStack::L), (App)NBTTagCompound.a.optionalFieldOf("tag").forGetter(itemstack -> Optional.ofNullable(itemstack.v()))).apply((Applicative)instance, ItemStack::new));
    private static final Codec<Item> n = ExtraCodecs.a(BuiltInRegistries.h.q(), (T item) -> item == Items.a ? DataResult.error(() -> "Item must not be minecraft:air") : DataResult.success((Object)item));
    public static final Codec<ItemStack> b = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.h.r().fieldOf("item").forGetter(ItemStack::e), (App)ExtraCodecs.a(MojangsonParser.i, "nbt").forGetter(itemstack -> Optional.ofNullable(itemstack.v()))).apply((Applicative)instance, (holder, optional) -> new ItemStack((Holder<Item>)holder, 1, (Optional<NBTTagCompound>)optional)));
    public static final Codec<ItemStack> c = RecordCodecBuilder.create(instance -> instance.group((App)n.fieldOf("item").forGetter(ItemStack::d), (App)ExtraCodecs.a(ExtraCodecs.j, "count", Integer.valueOf(1)).forGetter(ItemStack::L)).apply((Applicative)instance, ItemStack::new));
    public static final Codec<ItemStack> d = n.xmap(ItemStack::new, ItemStack::d);
    public static final MapCodec<ItemStack> e = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.h.q().fieldOf("result").forGetter(ItemStack::d), (App)Codec.INT.fieldOf("count").forGetter(ItemStack::L)).apply((Applicative)instance, ItemStack::new));
    private static final Logger o = LogUtils.getLogger();
    public static final ItemStack f = new ItemStack((Void)null);
    public static final DecimalFormat g = SystemUtils.a(new DecimalFormat("#.##"), (? super T decimalformat) -> decimalformat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    public static final String h = "Enchantments";
    public static final String i = "display";
    public static final String j = "Name";
    public static final String k = "Lore";
    public static final String l = "Damage";
    public static final String m = "color";
    private static final String p = "Unbreakable";
    private static final String q = "RepairCost";
    private static final String r = "CanDestroy";
    private static final String s = "CanPlaceOn";
    private static final String t = "HideFlags";
    private static final IChatBaseComponent u = IChatBaseComponent.c("item.disabled").a(EnumChatFormat.m);
    private static final int v = 0;
    private static final ChatModifier w = ChatModifier.a.a(EnumChatFormat.f).b(true);
    private int x;
    private int y;
    @Deprecated
    @Nullable
    private Item z;
    @Nullable
    private NBTTagCompound A;
    @Nullable
    private net.minecraft.world.entity.Entity B;
    @Nullable
    private AdventureModeCheck C;
    @Nullable
    private AdventureModeCheck D;
    private static final Comparator<? super NBTTagCompound> enchantSorter = Comparator.comparing(o2 -> o2.l("id"));
    private CraftItemStack bukkitStack;

    public Optional<TooltipComponent> a() {
        return this.d().h(this);
    }

    private void processEnchantOrder(@Nullable NBTTagCompound tag) {
        if (tag == null || !tag.b(h, 9)) {
            return;
        }
        NBTTagList list = tag.c(h, 10);
        if (list.size() < 2) {
            return;
        }
        try {
            list.sort(enchantSorter);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void processText() {
        NBTTagCompound display = this.b(i);
        if (display != null) {
            String json;
            if (display.b(j, 8) && (json = display.l(j)) != null && json.contains("\u00a7")) {
                try {
                    display.a(j, this.convert(json));
                }
                catch (JsonParseException jsonparseexception) {
                    display.r(j);
                }
            }
            if (display.b(k, 9)) {
                NBTTagList list = display.c(k, 8);
                for (int index = 0; index < list.size(); ++index) {
                    String json2 = list.j(index);
                    if (json2 == null || !json2.contains("\u00a7")) continue;
                    try {
                        list.d(index, this.convert(json2));
                        continue;
                    }
                    catch (JsonParseException e2) {
                        list.d(index, NBTTagString.a(CraftChatMessage.toJSON(IChatBaseComponent.b(""))));
                    }
                }
            }
        }
    }

    private NBTTagString convert(String json) {
        LiteralContents plainTextContents;
        IChatBaseComponent component = IChatBaseComponent.ChatSerializer.a(json);
        ComponentContents componentContents = component.b();
        if (componentContents instanceof LiteralContents && (plainTextContents = (LiteralContents)componentContents).b().contains("\u00a7") && component.c().isEmpty()) {
            component = CraftChatMessage.fromString(plainTextContents.b())[0];
        }
        return NBTTagString.a(CraftChatMessage.toJSON(component));
    }

    public ItemStack(IMaterial item) {
        this(item, 1);
    }

    public ItemStack(Holder<Item> entry) {
        this(entry.a(), 1);
    }

    public ItemStack(Holder<Item> item, int count, Optional<NBTTagCompound> nbt) {
        this(item, count);
        nbt.ifPresent(this::c);
    }

    public ItemStack(Holder<Item> itemEntry, int count) {
        this(itemEntry.a(), count);
    }

    public ItemStack(IMaterial item, int count) {
        this.z = item.k();
        this.x = count;
        if (this.z.o()) {
            this.b(this.k());
        }
    }

    private ItemStack(@Nullable Void v2) {
        this.z = null;
    }

    public void convertStack(int version) {
        if (0 < version && version < CraftMagicNumbers.INSTANCE.getDataVersion() && MinecraftServer.getServer() != null) {
            NBTTagCompound savedStack = new NBTTagCompound();
            this.b(savedStack);
            savedStack = (NBTTagCompound)MinecraftServer.getServer().M.update(DataConverterTypes.t, new Dynamic<NBTTagCompound>(DynamicOpsNBT.a, savedStack), version, CraftMagicNumbers.INSTANCE.getDataVersion()).getValue();
            this.load(savedStack);
        }
    }

    private void load(NBTTagCompound nbttagcompound) {
        this.z = BuiltInRegistries.h.a(new MinecraftKey(nbttagcompound.l("id")));
        this.x = nbttagcompound.f("Count");
        if (nbttagcompound.b("tag", 10)) {
            this.A = nbttagcompound.p("tag").h();
            this.processEnchantOrder(this.A);
            this.processText();
            this.d().b(this.A);
        }
        if (this.d().o()) {
            this.b(this.k());
        }
    }

    private ItemStack(NBTTagCompound nbt) {
        this.load(nbt);
    }

    public static ItemStack a(NBTTagCompound nbt) {
        try {
            return new ItemStack(nbt);
        }
        catch (RuntimeException runtimeexception) {
            o.debug("Tried to load invalid item: {}", (Object)nbt, (Object)runtimeexception);
            return f;
        }
    }

    public boolean b() {
        return this == f || this.z == Items.a || this.x <= 0;
    }

    public boolean a(FeatureFlagSet enabledFeatures) {
        return this.b() || this.d().a(enabledFeatures);
    }

    public ItemStack a(int amount) {
        int j2 = Math.min(amount, this.L());
        ItemStack itemstack = this.c(j2);
        this.h(j2);
        return itemstack;
    }

    public ItemStack c() {
        if (this.b()) {
            return f;
        }
        ItemStack itemstack = this.p();
        this.f(0);
        return itemstack;
    }

    public Item d() {
        return this.b() ? Items.a : this.z;
    }

    public Holder<Item> e() {
        return this.d().j();
    }

    public boolean a(TagKey<Item> tag) {
        return this.d().j().a(tag);
    }

    public boolean a(Item item) {
        return this.d() == item;
    }

    public boolean a(Predicate<Holder<Item>> predicate) {
        return predicate.test(this.d().j());
    }

    public boolean a(Holder<Item> itemEntry) {
        return this.d().j() == itemEntry;
    }

    public boolean a(HolderSet<Item> registryEntryList) {
        return registryEntryList.a(this.e());
    }

    public Stream<TagKey<Item>> f() {
        return this.d().j().c();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnumInteractionResult a(ItemActionContext context) {
        EnumInteractionResult enuminteractionresult;
        EntityHuman entityhuman = context.o();
        BlockPosition blockposition = context.a();
        ShapeDetectorBlock shapedetectorblock = new ShapeDetectorBlock(context.q(), blockposition, false);
        if (entityhuman != null && !entityhuman.fT().e && !this.a(context.q().I_().d(Registries.f), shapedetectorblock)) {
            return EnumInteractionResult.d;
        }
        Item item = this.d();
        NBTTagCompound oldData = this.getTagClone();
        int oldCount = this.L();
        WorldServer world = (WorldServer)context.q();
        if (!(item instanceof ItemBucket)) {
            world.captureBlockStates = true;
            if (item == Items.rv) {
                world.captureTreeGeneration = true;
            }
        }
        try {
            enuminteractionresult = item.a(context);
        }
        finally {
            world.captureBlockStates = false;
        }
        NBTTagCompound newData = this.getTagClone();
        int newCount = this.L();
        this.f(oldCount);
        this.setTagClone(oldData);
        if (enuminteractionresult.a() && world.captureTreeGeneration && world.capturedBlockStates.size() > 0) {
            world.captureTreeGeneration = false;
            Location location = CraftLocation.toBukkit(blockposition, (World)world.getWorld());
            TreeType treeType = BlockSapling.treeType;
            BlockSapling.treeType = null;
            ArrayList<CraftBlockState> blocks = new ArrayList<CraftBlockState>(world.capturedBlockStates.values());
            world.capturedBlockStates.clear();
            StructureGrowEvent structureEvent = null;
            if (treeType != null) {
                boolean isBonemeal = this.d() == Items.rv;
                structureEvent = new StructureGrowEvent(location, treeType, isBonemeal, (Player)entityhuman.getBukkitEntity(), blocks);
                Bukkit.getPluginManager().callEvent((Event)structureEvent);
            }
            BlockFertilizeEvent fertilizeEvent = new BlockFertilizeEvent((org.bukkit.block.Block)CraftBlock.at(world, blockposition), (Player)entityhuman.getBukkitEntity(), blocks);
            fertilizeEvent.setCancelled(structureEvent != null && structureEvent.isCancelled());
            Bukkit.getPluginManager().callEvent((Event)fertilizeEvent);
            if (!fertilizeEvent.isCancelled()) {
                if (this.L() == oldCount && Objects.equals(this.A, oldData)) {
                    this.c(newData);
                    this.f(newCount);
                }
                for (CraftBlockState blockstate : blocks) {
                    CapturedBlockState.setBlockState(blockstate);
                    world.checkCapturedTreeStateForObserverNotify(blockposition, blockstate);
                }
                entityhuman.b(StatisticList.c.b(item));
            }
            ItemSign.openSign = null;
            return enuminteractionresult;
        }
        world.captureTreeGeneration = false;
        if (entityhuman != null && enuminteractionresult.c()) {
            EnumHand enumhand = context.p();
            BlockMultiPlaceEvent placeEvent = null;
            ArrayList<BlockState> blocks = new ArrayList<BlockState>(world.capturedBlockStates.values());
            world.capturedBlockStates.clear();
            if (blocks.size() > 1) {
                placeEvent = CraftEventFactory.callBlockMultiPlaceEvent(world, entityhuman, enumhand, blocks, blockposition.u(), blockposition.v(), blockposition.w());
            } else if (blocks.size() == 1 && item != Items.qy) {
                placeEvent = CraftEventFactory.callBlockPlaceEvent(world, entityhuman, enumhand, (BlockState)blocks.get(0), blockposition.u(), blockposition.v(), blockposition.w());
            }
            if (placeEvent != null && (placeEvent.isCancelled() || !placeEvent.canBuild())) {
                enuminteractionresult = EnumInteractionResult.e;
                placeEvent.getPlayer().updateInventory();
                world.capturedTileEntities.clear();
                world.preventPoiUpdated = true;
                for (BlockState blockstate : blocks) {
                    blockstate.update(true, false);
                }
                world.preventPoiUpdated = false;
                ItemSign.openSign = null;
            } else {
                BlockPosition position;
                IBlockData blockData;
                TileEntity te;
                if (this.L() == oldCount && Objects.equals(this.A, oldData)) {
                    this.c(newData);
                    this.f(newCount);
                }
                for (Map.Entry<BlockPosition, TileEntity> e2 : world.capturedTileEntities.entrySet()) {
                    world.a(e2.getValue());
                }
                for (BlockState blockstate : blocks) {
                    int updateFlag = ((CraftBlockState)blockstate).getFlag();
                    IBlockData oldBlock = ((CraftBlockState)blockstate).getHandle();
                    BlockPosition newblockposition = ((CraftBlockState)blockstate).getPosition();
                    IBlockData block = world.a_(newblockposition);
                    if (!(block.b() instanceof BlockTileEntity) && !NoBlockUpdateCommand.isNoBlockUpdate()) {
                        block.b().onPlace(block, world, newblockposition, oldBlock, true, context);
                    }
                    world.notifyAndUpdatePhysics(newblockposition, null, oldBlock, block, world.a_(newblockposition), updateFlag, 512);
                }
                if (this.z instanceof ItemRecord) {
                    TileEntity tileentity = world.c_(blockposition);
                    if (tileentity instanceof TileEntityJukeBox) {
                        TileEntityJukeBox tileentityjukebox = (TileEntityJukeBox)tileentity;
                        tileentityjukebox.b(this.p());
                        world.a(GameEvent.c, blockposition, GameEvent.a.a(entityhuman, world.a_(blockposition)));
                    }
                    this.h(1);
                    entityhuman.a(StatisticList.al);
                }
                if (this.z == Items.uf) {
                    BlockPosition bp = blockposition;
                    if (!world.a_(blockposition).r()) {
                        bp = !world.a_(blockposition).e() ? null : bp.a(context.k());
                    }
                    if (bp != null && (te = world.c_(bp)) instanceof TileEntitySkull) {
                        BlockWitherSkull.a((net.minecraft.world.level.World)world, bp, (TileEntitySkull)te);
                    }
                }
                if (this.z instanceof ItemSign && ItemSign.openSign != null) {
                    try {
                        te = world.c_(ItemSign.openSign);
                        if (te instanceof TileEntitySign) {
                            TileEntitySign tileentitysign = (TileEntitySign)te;
                            Block updateFlag = world.a_(ItemSign.openSign).b();
                            if (updateFlag instanceof BlockSign) {
                                BlockSign blocksign = (BlockSign)updateFlag;
                                blocksign.openTextEdit(entityhuman, tileentitysign, true, PlayerOpenSignEvent.Cause.PLACE);
                            }
                        }
                    }
                    finally {
                        ItemSign.openSign = null;
                    }
                }
                if (placeEvent != null && this.z instanceof ItemBed && (blockData = world.a_(position = ((CraftBlock)placeEvent.getBlock()).getPosition())).b() instanceof BlockBed) {
                    world.b(position, Blocks.a);
                    blockData.a((GeneratorAccess)world, position, 3);
                }
                if (this.z instanceof ItemBlock) {
                    position = new BlockActionContext(context).a();
                    blockData = world.a_(position);
                    SoundEffectType soundeffecttype = blockData.w();
                    world.a(entityhuman, blockposition, soundeffecttype.e(), SoundCategory.e, (soundeffecttype.a() + 1.0f) / 2.0f, soundeffecttype.b() * 0.8f);
                }
                entityhuman.b(StatisticList.c.b(item));
            }
        }
        world.capturedTileEntities.clear();
        world.capturedBlockStates.clear();
        return enuminteractionresult;
    }

    public float a(IBlockData state) {
        return this.d().a(this, state);
    }

    public InteractionResultWrapper<ItemStack> a(net.minecraft.world.level.World world, EntityHuman user, EnumHand hand) {
        return this.d().a(world, user, hand);
    }

    public ItemStack a(net.minecraft.world.level.World world, EntityLiving user) {
        return this.d().a(this, world, user);
    }

    public NBTTagCompound b(NBTTagCompound nbt) {
        MinecraftKey minecraftkey = BuiltInRegistries.h.b(this.d());
        nbt.a("id", minecraftkey == null ? "minecraft:air" : minecraftkey.toString());
        nbt.a("Count", (byte)this.x);
        if (this.A != null) {
            nbt.a("tag", this.A.h());
        }
        return nbt;
    }

    public int g() {
        return this.d().l();
    }

    public boolean h() {
        return this.g() > 1 && (!this.i() || !this.j());
    }

    public boolean i() {
        if (!this.b() && this.d().n() > 0) {
            NBTTagCompound nbttagcompound = this.v();
            return nbttagcompound == null || !nbttagcompound.q(p);
        }
        return false;
    }

    public boolean j() {
        return this.i() && this.k() > 0;
    }

    public int k() {
        return this.A == null ? 0 : this.A.h(l);
    }

    public void b(int damage) {
        this.w().a(l, Math.max(0, damage));
    }

    public int l() {
        return this.d().n();
    }

    public boolean hurt(int amount, RandomSource random, @Nullable EntityLiving player) {
        int j2;
        if (!this.i()) {
            return false;
        }
        if (amount > 0) {
            j2 = EnchantmentManager.a(Enchantments.w, this);
            int k2 = 0;
            for (int l2 = 0; j2 > 0 && l2 < amount; ++l2) {
                if (!EnchantmentDurability.a(this, j2, random)) continue;
                ++k2;
            }
            int originalDamage = amount;
            amount -= k2;
            if (player instanceof EntityPlayer) {
                EntityPlayer serverPlayer = (EntityPlayer)player;
                PlayerItemDamageEvent event = new PlayerItemDamageEvent((Player)serverPlayer.getBukkitEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(this), amount, originalDamage);
                event.getPlayer().getServer().getPluginManager().callEvent((Event)event);
                if (amount != event.getDamage() || event.isCancelled()) {
                    event.getPlayer().updateInventory();
                }
                if (event.isCancelled()) {
                    return false;
                }
                amount = event.getDamage();
            } else if (player != null) {
                EntityDamageItemEvent event = new EntityDamageItemEvent((Entity)player.getBukkitLivingEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(this), amount);
                if (!event.callEvent()) {
                    return false;
                }
                amount = event.getDamage();
            }
            if (amount <= 0) {
                return false;
            }
        }
        if (player instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)player;
            if (amount != 0) {
                CriterionTriggers.u.a(serverPlayer, this, this.k() + amount);
            }
        }
        j2 = this.k() + amount;
        this.b(j2);
        return j2 >= this.l();
    }

    public <T extends EntityLiving> void a(int amount, T entity, Consumer<T> breakCallback) {
        if (!(entity.dM().B || entity instanceof EntityHuman && ((EntityHuman)entity).fT().d || !this.i() || !this.hurt(amount, entity.eg(), entity))) {
            breakCallback.accept(entity);
            Item item = this.d();
            if (this.x == 1 && entity instanceof EntityHuman) {
                CraftEventFactory.callPlayerItemBreakEvent((EntityHuman)entity, this);
            }
            this.h(1);
            if (entity instanceof EntityHuman) {
                ((EntityHuman)entity).b(StatisticList.d.b(item));
            }
            this.b(0);
        }
    }

    public boolean m() {
        return this.d().e(this);
    }

    public int n() {
        return this.d().f(this);
    }

    public int o() {
        return this.d().g(this);
    }

    public boolean a(Slot slot, ClickAction clickType, EntityHuman player) {
        return this.d().a(this, slot, clickType, player);
    }

    public boolean a(ItemStack stack, Slot slot, ClickAction clickType, EntityHuman player, SlotAccess cursorStackReference) {
        return this.d().a(this, stack, slot, clickType, player, cursorStackReference);
    }

    public void a(EntityLiving target, EntityHuman attacker) {
        Item item = this.d();
        if (item.a(this, target, (EntityLiving)attacker)) {
            attacker.b(StatisticList.c.b(item));
        }
    }

    public void a(net.minecraft.world.level.World world, IBlockData state, BlockPosition pos, EntityHuman miner) {
        Item item = this.d();
        if (item.a(this, world, state, pos, miner)) {
            miner.b(StatisticList.c.b(item));
        }
    }

    public boolean b(IBlockData state) {
        return this.d().a_(state);
    }

    public EnumInteractionResult a(EntityHuman user, EntityLiving entity, EnumHand hand) {
        return this.d().a(this, user, entity, hand);
    }

    public ItemStack p() {
        return this.copy(false);
    }

    public ItemStack copy(boolean originalItem) {
        if (!originalItem && this.b()) {
            return f;
        }
        ItemStack itemstack = new ItemStack(originalItem ? this.z : this.d(), this.x);
        itemstack.e(this.K());
        if (this.A != null) {
            itemstack.A = this.A.h();
        }
        return itemstack;
    }

    public ItemStack c(int count) {
        if (this.b()) {
            return f;
        }
        ItemStack itemstack = this.p();
        itemstack.f(count);
        return itemstack;
    }

    public static boolean a(ItemStack left, ItemStack right) {
        return left == right ? true : (left.L() != right.L() ? false : ItemStack.c(left, right));
    }

    public static boolean b(ItemStack left, ItemStack right) {
        return left.a(right.d());
    }

    public static boolean c(ItemStack stack, ItemStack otherStack) {
        return !stack.a(otherStack.d()) ? false : (stack.b() && otherStack.b() ? true : Objects.equals(stack.A, otherStack.A));
    }

    public String q() {
        return this.d().j(this);
    }

    public String toString() {
        int i2 = this.L();
        return i2 + " " + this.d();
    }

    public void a(net.minecraft.world.level.World world, net.minecraft.world.entity.Entity entity, int slot, boolean selected) {
        if (this.y > 0) {
            --this.y;
        }
        if (this.d() != null) {
            this.d().a(this, world, entity, slot, selected);
        }
    }

    public void a(net.minecraft.world.level.World world, EntityHuman player, int amount) {
        player.a(StatisticList.b.b(this.d()), amount);
        this.d().b(this, world, player);
    }

    public void a(net.minecraft.world.level.World world) {
        this.d().a(this, world);
    }

    public int r() {
        return this.d().b(this);
    }

    public EnumAnimation s() {
        return this.d().c(this);
    }

    public void a(net.minecraft.world.level.World world, EntityLiving user, int remainingUseTicks) {
        this.d().a(this, world, user, remainingUseTicks);
    }

    public boolean t() {
        return this.d().l(this);
    }

    public boolean u() {
        return !this.b() && this.A != null && !this.A.g();
    }

    @Nullable
    public NBTTagCompound v() {
        return this.A;
    }

    @Nullable
    private NBTTagCompound getTagClone() {
        return this.A == null ? null : this.A.h();
    }

    private void setTagClone(@Nullable NBTTagCompound nbtttagcompound) {
        this.c(nbtttagcompound == null ? null : nbtttagcompound.h());
    }

    public NBTTagCompound w() {
        if (this.A == null) {
            this.c(new NBTTagCompound());
        }
        return this.A;
    }

    public NBTTagCompound a(String key) {
        if (this.A != null && this.A.b(key, 10)) {
            return this.A.p(key);
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.a(key, nbttagcompound);
        return nbttagcompound;
    }

    @Nullable
    public NBTTagCompound b(String key) {
        return this.A != null && this.A.b(key, 10) ? this.A.p(key) : null;
    }

    public void c(String key) {
        if (this.A != null && this.A.e(key)) {
            this.A.r(key);
            if (this.A.g()) {
                this.A = null;
            }
        }
    }

    public NBTTagList x() {
        return this.A != null ? this.A.c(h, 10) : new NBTTagList();
    }

    public org.bukkit.inventory.ItemStack asBukkitMirror() {
        return CraftItemStack.asCraftMirror(this);
    }

    public org.bukkit.inventory.ItemStack asBukkitCopy() {
        return CraftItemStack.asCraftMirror(this.p());
    }

    public static ItemStack fromBukkitCopy(org.bukkit.inventory.ItemStack itemstack) {
        return CraftItemStack.asNMSCopy(itemstack);
    }

    public org.bukkit.inventory.ItemStack getBukkitStack() {
        if (this.bukkitStack == null || this.bukkitStack.handle != this) {
            this.bukkitStack = CraftItemStack.asCraftMirror(this);
        }
        return this.bukkitStack;
    }

    public void c(@Nullable NBTTagCompound nbt) {
        this.A = nbt;
        this.processEnchantOrder(this.A);
        if (this.d().o()) {
            this.b(this.k());
        }
        if (nbt != null) {
            this.d().b(nbt);
        }
    }

    public IChatBaseComponent y() {
        NBTTagCompound nbttagcompound = this.b(i);
        if (nbttagcompound != null && nbttagcompound.b(j, 8)) {
            try {
                IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.ChatSerializer.a(nbttagcompound.l(j));
                if (ichatmutablecomponent != null) {
                    return ichatmutablecomponent;
                }
                nbttagcompound.r(j);
            }
            catch (Exception exception) {
                nbttagcompound.r(j);
            }
        }
        return this.d().m(this);
    }

    public ItemStack a(@Nullable IChatBaseComponent name) {
        NBTTagCompound nbttagcompound = this.a(i);
        if (name != null) {
            nbttagcompound.a(j, IChatBaseComponent.ChatSerializer.a(name));
        } else {
            nbttagcompound.r(j);
        }
        return this;
    }

    public void z() {
        NBTTagCompound nbttagcompound = this.b(i);
        if (nbttagcompound != null) {
            nbttagcompound.r(j);
            if (nbttagcompound.g()) {
                this.c(i);
            }
        }
        if (this.A != null && this.A.g()) {
            this.A = null;
        }
    }

    public boolean A() {
        NBTTagCompound nbttagcompound = this.b(i);
        return nbttagcompound != null && nbttagcompound.b(j, 8);
    }

    public List<IChatBaseComponent> a(@Nullable EntityHuman player, TooltipFlag context) {
        int i2;
        Integer integer;
        ArrayList list = Lists.newArrayList();
        IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.i().b(this.y()).a(this.C().e);
        if (this.A()) {
            ichatmutablecomponent.a(EnumChatFormat.u);
        }
        list.add(ichatmutablecomponent);
        if (!context.a() && !this.A() && this.a(Items.rR) && (integer = ItemWorldMap.d(this)) != null) {
            list.add(ItemWorldMap.k(this));
        }
        if (ItemStack.a(i2 = this.P(), HideFlags.f)) {
            this.d().a(this, player == null ? null : player.dM(), list, context);
        }
        if (this.u()) {
            if (ItemStack.a(i2, HideFlags.h) && player != null) {
                ArmorTrim.a(this, player.dM().I_(), list);
            }
            if (ItemStack.a(i2, HideFlags.a)) {
                ItemStack.a(list, this.x());
            }
            if (this.A.b(i, 10)) {
                NBTTagCompound nbttagcompound = this.A.p(i);
                if (ItemStack.a(i2, HideFlags.g) && nbttagcompound.b(m, 99)) {
                    if (context.a()) {
                        list.add(IChatBaseComponent.a("item.color", new Object[]{String.format(Locale.ROOT, "#%06X", nbttagcompound.h(m))}).a(EnumChatFormat.h));
                    } else {
                        list.add(IChatBaseComponent.c("item.dyed").a(EnumChatFormat.h, EnumChatFormat.u));
                    }
                }
                if (nbttagcompound.d(k) == 9) {
                    NBTTagList nbttaglist = nbttagcompound.c(k, 8);
                    for (int j2 = 0; j2 < nbttaglist.size(); ++j2) {
                        String s2 = nbttaglist.j(j2);
                        try {
                            IChatMutableComponent ichatmutablecomponent1 = IChatBaseComponent.ChatSerializer.a(s2);
                            if (ichatmutablecomponent1 == null) continue;
                            list.add(ChatComponentUtils.a(ichatmutablecomponent1, w));
                            continue;
                        }
                        catch (Exception exception) {
                            nbttagcompound.r(k);
                        }
                    }
                }
            }
        }
        if (ItemStack.a(i2, HideFlags.b)) {
            for (EnumItemSlot enumitemslot : EnumItemSlot.VALUES) {
                Multimap<AttributeBase, AttributeModifier> multimap = this.a(enumitemslot);
                if (multimap.isEmpty()) continue;
                list.add(CommonComponents.a);
                list.add(IChatBaseComponent.c("item.modifiers." + enumitemslot.e()).a(EnumChatFormat.h));
                for (Map.Entry entry : multimap.entries()) {
                    AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                    double d0 = attributemodifier.c();
                    boolean flag = false;
                    if (player != null) {
                        if (attributemodifier.a() == Item.m) {
                            d0 += player.c(GenericAttributes.c);
                            d0 += (double)EnchantmentManager.a(this, EnumMonsterType.a);
                            flag = true;
                        } else if (attributemodifier.a() == Item.n) {
                            d0 += player.c(GenericAttributes.e);
                            flag = true;
                        }
                    }
                    double d1 = attributemodifier.b() != AttributeModifier.Operation.b && attributemodifier.b() != AttributeModifier.Operation.c ? (((AttributeBase)entry.getKey()).equals(GenericAttributes.i) ? d0 * 10.0 : d0) : d0 * 100.0;
                    if (flag) {
                        list.add(CommonComponents.a().b(IChatBaseComponent.a("attribute.modifier.equals." + attributemodifier.b().a(), new Object[]{g.format(d1), IChatBaseComponent.c(((AttributeBase)entry.getKey()).c())})).a(EnumChatFormat.c));
                        continue;
                    }
                    if (d0 > 0.0) {
                        list.add(IChatBaseComponent.a("attribute.modifier.plus." + attributemodifier.b().a(), new Object[]{g.format(d1), IChatBaseComponent.c(((AttributeBase)entry.getKey()).c())}).a(EnumChatFormat.j));
                        continue;
                    }
                    if (!(d0 < 0.0)) continue;
                    list.add(IChatBaseComponent.a("attribute.modifier.take." + attributemodifier.b().a(), new Object[]{g.format(d1 *= -1.0), IChatBaseComponent.c(((AttributeBase)entry.getKey()).c())}).a(EnumChatFormat.m));
                }
            }
        }
        if (this.u()) {
            NBTTagList nbttaglist1;
            if (ItemStack.a(i2, HideFlags.c) && this.A.q(p)) {
                list.add(IChatBaseComponent.c("item.unbreakable").a(EnumChatFormat.j));
            }
            if (ItemStack.a(i2, HideFlags.d) && this.A.b(r, 9) && !(nbttaglist1 = this.A.c(r, 8)).isEmpty()) {
                list.add(CommonComponents.a);
                list.add(IChatBaseComponent.c("item.canBreak").a(EnumChatFormat.h));
                for (int k2 = 0; k2 < nbttaglist1.size(); ++k2) {
                    list.addAll(ItemStack.d(nbttaglist1.j(k2)));
                }
            }
            if (ItemStack.a(i2, HideFlags.e) && this.A.b(s, 9) && !(nbttaglist1 = this.A.c(s, 8)).isEmpty()) {
                list.add(CommonComponents.a);
                list.add(IChatBaseComponent.c("item.canPlace").a(EnumChatFormat.h));
                for (int k3 = 0; k3 < nbttaglist1.size(); ++k3) {
                    list.addAll(ItemStack.d(nbttaglist1.j(k3)));
                }
            }
        }
        if (context.a()) {
            if (this.j()) {
                list.add(IChatBaseComponent.a("item.durability", this.l() - this.k(), this.l()));
            }
            list.add(IChatBaseComponent.b(BuiltInRegistries.h.b(this.d()).toString()).a(EnumChatFormat.i));
            if (this.u()) {
                list.add(IChatBaseComponent.a("item.nbt_tags", this.A.e().size()).a(EnumChatFormat.i));
            }
        }
        if (player != null && !this.d().a(player.dM().I())) {
            list.add(u);
        }
        return list;
    }

    private static boolean a(int flags, HideFlags tooltipSection) {
        return (flags & tooltipSection.a()) == 0;
    }

    private int P() {
        return this.u() && this.A.b(t, 99) ? this.A.h(t) : 0;
    }

    public void a(HideFlags tooltipSection) {
        NBTTagCompound nbttagcompound = this.w();
        nbttagcompound.a(t, nbttagcompound.h(t) | tooltipSection.a());
    }

    public static void a(List<IChatBaseComponent> tooltip, NBTTagList enchantments) {
        for (int i2 = 0; i2 < enchantments.size(); ++i2) {
            NBTTagCompound nbttagcompound = enchantments.a(i2);
            BuiltInRegistries.f.b(EnchantmentManager.b(nbttagcompound)).ifPresent(enchantment -> tooltip.add(enchantment.d(EnchantmentManager.a(nbttagcompound))));
        }
    }

    private static Collection<IChatBaseComponent> d(String tag) {
        try {
            return ArgumentBlock.b(BuiltInRegistries.e.p(), tag, true).map(argumentblock_a -> Lists.newArrayList((Object[])new IChatBaseComponent[]{argumentblock_a.a().b().f().a(EnumChatFormat.i)}), argumentblock_b -> argumentblock_b.a().a().map(holder -> ((Block)holder.a()).f().a(EnumChatFormat.i)).collect(Collectors.toList()));
        }
        catch (CommandSyntaxException commandsyntaxexception) {
            return Lists.newArrayList((Object[])new IChatBaseComponent[]{IChatBaseComponent.b("missingno").a(EnumChatFormat.i)});
        }
    }

    public boolean B() {
        return this.d().i(this);
    }

    public EnumItemRarity C() {
        return this.d().n(this);
    }

    public boolean D() {
        return !this.d().d_(this) ? false : !this.E();
    }

    public void a(Enchantment enchantment, int level) {
        this.w();
        if (!this.A.b(h, 9)) {
            this.A.a(h, new NBTTagList());
        }
        NBTTagList nbttaglist = this.A.c(h, 10);
        nbttaglist.add(EnchantmentManager.a(EnchantmentManager.a(enchantment), (int)((byte)level)));
        this.processEnchantOrder(this.A);
    }

    public boolean E() {
        return this.A != null && this.A.b(h, 9) ? !this.A.c(h, 10).isEmpty() : false;
    }

    public void a(String key, NBTBase element) {
        this.w().a(key, element);
    }

    public boolean F() {
        return this.B instanceof EntityItemFrame;
    }

    public void a(@Nullable net.minecraft.world.entity.Entity holder) {
        this.B = holder;
    }

    @Nullable
    public EntityItemFrame G() {
        return this.B instanceof EntityItemFrame ? (EntityItemFrame)this.H() : null;
    }

    @Nullable
    public net.minecraft.world.entity.Entity H() {
        return !this.b() ? this.B : null;
    }

    public int I() {
        return this.u() && this.A.b(q, 3) ? this.A.h(q) : 0;
    }

    public void d(int repairCost) {
        if (repairCost > 0) {
            this.w().a(q, repairCost);
        } else {
            this.c(q);
        }
    }

    public Multimap<AttributeBase, AttributeModifier> a(EnumItemSlot slot) {
        HashMultimap object;
        if (this.u() && this.A.b("AttributeModifiers", 9)) {
            object = HashMultimap.create();
            NBTTagList nbttaglist = this.A.c("AttributeModifiers", 10);
            for (int i2 = 0; i2 < nbttaglist.size(); ++i2) {
                AttributeModifier attributemodifier;
                Optional<AttributeBase> optional;
                NBTTagCompound nbttagcompound = nbttaglist.a(i2);
                if (nbttagcompound.b("Slot", 8) && !nbttagcompound.l("Slot").equals(slot.e()) || (optional = BuiltInRegistries.u.b(MinecraftKey.a(nbttagcompound.l("AttributeName")))).isEmpty() || (attributemodifier = AttributeModifier.a(nbttagcompound)) == null || attributemodifier.a().getLeastSignificantBits() == 0L || attributemodifier.a().getMostSignificantBits() == 0L) continue;
                ((Multimap)object).put((Object)optional.get(), (Object)attributemodifier);
            }
        } else {
            object = this.d().a(slot);
        }
        return object;
    }

    public void a(AttributeBase attribute, AttributeModifier modifier, @Nullable EnumItemSlot slot) {
        this.w();
        if (!this.A.b("AttributeModifiers", 9)) {
            this.A.a("AttributeModifiers", new NBTTagList());
        }
        NBTTagList nbttaglist = this.A.c("AttributeModifiers", 10);
        NBTTagCompound nbttagcompound = modifier.d();
        nbttagcompound.a("AttributeName", BuiltInRegistries.u.b(attribute).toString());
        if (slot != null) {
            nbttagcompound.a("Slot", slot.e());
        }
        nbttaglist.add(nbttagcompound);
    }

    @Deprecated
    public void setItem(Item item) {
        this.bukkitStack = null;
        this.z = item;
    }

    public IChatBaseComponent J() {
        IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.i().b(this.y());
        if (this.A()) {
            ichatmutablecomponent.a(EnumChatFormat.u);
        }
        IChatMutableComponent ichatmutablecomponent1 = ChatComponentUtils.a(ichatmutablecomponent);
        if (!this.b()) {
            ichatmutablecomponent1.a(this.C().e).a(chatmodifier -> chatmodifier.a(new ChatHoverable(ChatHoverable.EnumHoverAction.b, new ChatHoverable.c(this))));
        }
        return ichatmutablecomponent1;
    }

    public boolean a(IRegistry<Block> blockRegistry, ShapeDetectorBlock pos) {
        if (this.D == null) {
            this.D = new AdventureModeCheck(s);
        }
        return this.D.a(this, blockRegistry, pos);
    }

    public boolean b(IRegistry<Block> blockRegistry, ShapeDetectorBlock pos) {
        if (this.C == null) {
            this.C = new AdventureModeCheck(r);
        }
        return this.C.a(this, blockRegistry, pos);
    }

    public int K() {
        return this.y;
    }

    public void e(int bobbingAnimationTime) {
        this.y = bobbingAnimationTime;
    }

    public int L() {
        return this.b() ? 0 : this.x;
    }

    public void f(int count) {
        this.x = count;
    }

    public void g(int amount) {
        this.f(this.L() + amount);
    }

    public void h(int amount) {
        this.g(-amount);
    }

    public void b(net.minecraft.world.level.World world, EntityLiving user, int remainingUseTicks) {
        this.d().a(world, user, this, remainingUseTicks);
    }

    public void a(EntityItem entity) {
        this.d().a(entity);
    }

    public boolean M() {
        return this.d().u();
    }

    public SoundEffect N() {
        return this.d().an_();
    }

    public SoundEffect O() {
        return this.d().ao_();
    }

    public static enum HideFlags {
        a,
        b,
        c,
        d,
        e,
        f,
        g,
        h;

        private final int i = 1 << this.ordinal();

        public int a() {
            return this.i;
        }
    }
}

