/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMapBase;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.MaterialMapColor;
import net.minecraft.world.level.saveddata.maps.WorldMap;

public class ItemWorldMap
extends ItemWorldMapBase {
    public static final int a = 128;
    public static final int b = 128;
    private static final int e = -12173266;
    private static final String f = "map";
    public static final String c = "map_scale_direction";
    public static final String d = "map_to_lock";

    public ItemWorldMap(Item.Info settings) {
        super(settings);
    }

    public static ItemStack a(World world, int x2, int z2, byte scale, boolean showIcons, boolean unlimitedTracking) {
        ItemStack itemstack = new ItemStack(Items.rR);
        ItemWorldMap.a(itemstack, world, x2, z2, scale, showIcons, unlimitedTracking, world.ae());
        return itemstack;
    }

    @Nullable
    public static WorldMap a(@Nullable Integer id, World world) {
        return id == null ? null : world.a(ItemWorldMap.a(id));
    }

    @Nullable
    public static WorldMap b(ItemStack map, World world) {
        Integer integer = ItemWorldMap.d(map);
        return ItemWorldMap.a(integer, world);
    }

    @Nullable
    public static Integer d(ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.v();
        return nbttagcompound != null && nbttagcompound.b(f, 99) ? Integer.valueOf(nbttagcompound.h(f)) : null;
    }

    public static int a(World world, int x2, int z2, int scale, boolean showIcons, boolean unlimitedTracking, ResourceKey<World> dimension) {
        WorldMap worldmap = WorldMap.a(x2, z2, (byte)scale, showIcons, unlimitedTracking, dimension);
        int l2 = world.v();
        world.a(ItemWorldMap.a(l2), worldmap);
        return l2;
    }

    private static void a(ItemStack stack, int id) {
        stack.w().a(f, id);
    }

    private static void a(ItemStack stack, World world, int x2, int z2, int scale, boolean showIcons, boolean unlimitedTracking, ResourceKey<World> dimension) {
        int l2 = ItemWorldMap.a(world, x2, z2, scale, showIcons, unlimitedTracking, dimension);
        ItemWorldMap.a(stack, l2);
    }

    public static String a(int mapId) {
        return "map_" + mapId;
    }

    public void a(World world, Entity entity, WorldMap state) {
        if (world.ae() == state.e && entity instanceof EntityHuman) {
            int i2 = 1 << state.f;
            int j2 = state.c;
            int k2 = state.d;
            int l2 = MathHelper.a(entity.dr() - (double)j2) / i2 + 64;
            int i1 = MathHelper.a(entity.dx() - (double)k2) / i2 + 64;
            int j1 = 128 / i2;
            if (world.E_().h()) {
                j1 /= 2;
            }
            WorldMap.WorldMapHumanTracker worldmap_worldmaphumantracker = state.a((EntityHuman)entity);
            ++worldmap_worldmaphumantracker.b;
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition1 = new BlockPosition.MutableBlockPosition();
            boolean flag = false;
            for (int k1 = l2 - j1 + 1; k1 < l2 + j1; ++k1) {
                if ((k1 & 0xF) != (worldmap_worldmaphumantracker.b & 0xF) && !flag) continue;
                flag = false;
                double d0 = 0.0;
                for (int l1 = i1 - j1 - 1; l1 < i1 + j1; ++l1) {
                    double d2;
                    if (k1 < 0 || l1 < -1 || k1 >= 128 || l1 >= 128) continue;
                    int i22 = MathHelper.h(k1 - l2) + MathHelper.h(l1 - i1);
                    boolean flag1 = i22 > (j1 - 2) * (j1 - 2);
                    int j22 = (j2 / i2 + k1 - 64) * i2;
                    int k22 = (k2 / i2 + l1 - 64) * i2;
                    LinkedHashMultiset multiset = LinkedHashMultiset.create();
                    Chunk chunk = world.getChunkIfLoaded(SectionPosition.a(j22), SectionPosition.a(k22));
                    if (chunk == null || chunk.C()) continue;
                    int l22 = 0;
                    double d1 = 0.0;
                    if (world.E_().h()) {
                        i3 = j22 + k22 * 231871;
                        if (((i3 = i3 * i3 * 31287121 + i3 * 11) >> 20 & 1) == 0) {
                            multiset.add((Object)Blocks.j.o().d(world, BlockPosition.b), 10);
                        } else {
                            multiset.add((Object)Blocks.b.o().d(world, BlockPosition.b), 100);
                        }
                        d1 = 100.0;
                    } else {
                        for (i3 = 0; i3 < i2; ++i3) {
                            for (int j3 = 0; j3 < i2; ++j3) {
                                IBlockData iblockdata;
                                blockposition_mutableblockposition.d(j22 + i3, 0, k22 + j3);
                                int k3 = chunk.a(HeightMap.Type.b, blockposition_mutableblockposition.u(), blockposition_mutableblockposition.w()) + 1;
                                if (k3 > world.J_() + 1) {
                                    do {
                                        blockposition_mutableblockposition.q(--k3);
                                    } while ((iblockdata = chunk.a_(blockposition_mutableblockposition)).d(world, blockposition_mutableblockposition) == MaterialMapColor.a && k3 > world.J_());
                                    if (k3 > world.J_() && !iblockdata.u().c()) {
                                        IBlockData iblockdata1;
                                        int l3 = k3 - 1;
                                        blockposition_mutableblockposition1.g(blockposition_mutableblockposition);
                                        do {
                                            blockposition_mutableblockposition1.q(l3--);
                                            iblockdata1 = chunk.a_(blockposition_mutableblockposition1);
                                            ++l22;
                                        } while (l3 > world.J_() && !iblockdata1.u().c());
                                        iblockdata = this.a(world, iblockdata, blockposition_mutableblockposition);
                                    }
                                } else {
                                    iblockdata = Blocks.F.o();
                                }
                                state.a(world, blockposition_mutableblockposition.u(), blockposition_mutableblockposition.w());
                                d1 += (double)k3 / (double)(i2 * i2);
                                multiset.add((Object)iblockdata.d(world, blockposition_mutableblockposition));
                            }
                        }
                    }
                    MaterialMapColor materialmapcolor = (MaterialMapColor)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)MaterialMapColor.a);
                    MaterialMapColor.a materialmapcolor_a = materialmapcolor == MaterialMapColor.m ? ((d2 = (double)(l22 /= i2 * i2) * 0.1 + (double)(k1 + l1 & 1) * 0.2) < 0.5 ? MaterialMapColor.a.c : (d2 > 0.9 ? MaterialMapColor.a.a : MaterialMapColor.a.b)) : ((d2 = (d1 - d0) * 4.0 / (double)(i2 + 4) + ((double)(k1 + l1 & 1) - 0.5) * 0.4) > 0.6 ? MaterialMapColor.a.c : (d2 < -0.6 ? MaterialMapColor.a.a : MaterialMapColor.a.b));
                    d0 = d1;
                    if (l1 < 0 || i22 >= j1 * j1 || flag1 && (k1 + l1 & 1) == 0) continue;
                    flag |= state.a(k1, l1, materialmapcolor.b(materialmapcolor_a));
                }
            }
        }
    }

    private IBlockData a(World world, IBlockData state, BlockPosition pos) {
        Fluid fluid = state.u();
        return !fluid.c() && !state.d(world, pos, EnumDirection.b) ? fluid.g() : state;
    }

    private static boolean a(boolean[] biomes, int x2, int z2) {
        return biomes[z2 * 128 + x2];
    }

    public static void a(WorldServer world, ItemStack map) {
        WorldMap worldmap = ItemWorldMap.b(map, world);
        if (worldmap != null && world.ae() == worldmap.e) {
            int k1;
            int j1;
            int i2 = 1 << worldmap.f;
            int j2 = worldmap.c;
            int k2 = worldmap.d;
            boolean[] aboolean = new boolean[16384];
            int l2 = j2 / i2 - 64;
            int i1 = k2 / i2 - 64;
            for (j1 = 0; j1 < 128; ++j1) {
                for (k1 = 0; k1 < 128; ++k1) {
                    Holder<BiomeBase> holder = world.a((l2 + k1) * i2, 0, (i1 + j1) * i2);
                    aboolean[j1 * 128 + k1] = holder.a(BiomeTags.ab);
                }
            }
            for (j1 = 1; j1 < 127; ++j1) {
                for (k1 = 1; k1 < 127; ++k1) {
                    int l1 = 0;
                    for (int i22 = -1; i22 < 2; ++i22) {
                        for (int j22 = -1; j22 < 2; ++j22) {
                            if (i22 == 0 && j22 == 0 || !ItemWorldMap.a(aboolean, j1 + i22, k1 + j22)) continue;
                            ++l1;
                        }
                    }
                    MaterialMapColor.a materialmapcolor_a = MaterialMapColor.a.d;
                    MaterialMapColor materialmapcolor = MaterialMapColor.a;
                    if (ItemWorldMap.a(aboolean, j1, k1)) {
                        materialmapcolor = MaterialMapColor.p;
                        if (l1 > 7 && k1 % 2 == 0) {
                            switch ((j1 + (int)(MathHelper.a((float)k1 + 0.0f) * 7.0f)) / 8 % 5) {
                                case 0: 
                                case 4: {
                                    materialmapcolor_a = MaterialMapColor.a.a;
                                    break;
                                }
                                case 1: 
                                case 3: {
                                    materialmapcolor_a = MaterialMapColor.a.b;
                                    break;
                                }
                                case 2: {
                                    materialmapcolor_a = MaterialMapColor.a.c;
                                }
                            }
                        } else if (l1 > 7) {
                            materialmapcolor = MaterialMapColor.a;
                        } else if (l1 > 5) {
                            materialmapcolor_a = MaterialMapColor.a.b;
                        } else if (l1 > 3) {
                            materialmapcolor_a = MaterialMapColor.a.a;
                        } else if (l1 > 1) {
                            materialmapcolor_a = MaterialMapColor.a.a;
                        }
                    } else if (l1 > 0) {
                        materialmapcolor = MaterialMapColor.A;
                        materialmapcolor_a = l1 > 3 ? MaterialMapColor.a.b : MaterialMapColor.a.d;
                    }
                    if (materialmapcolor == MaterialMapColor.a) continue;
                    worldmap.b(j1, k1, materialmapcolor.b(materialmapcolor_a));
                }
            }
        }
    }

    @Override
    public void a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        WorldMap worldmap;
        if (!world.B && (worldmap = ItemWorldMap.b(stack, world)) != null) {
            if (entity instanceof EntityHuman) {
                EntityHuman entityhuman = (EntityHuman)entity;
                worldmap.a(entityhuman, stack);
            }
            if (!worldmap.h && (selected || entity instanceof EntityHuman && ((EntityHuman)entity).eU() == stack)) {
                this.a(world, entity, worldmap);
            }
        }
    }

    @Override
    @Nullable
    public Packet<?> a(ItemStack stack, World world, EntityHuman player) {
        Integer integer = ItemWorldMap.d(stack);
        WorldMap worldmap = ItemWorldMap.a(integer, world);
        return worldmap != null ? worldmap.a((int)integer, player) : null;
    }

    @Override
    public void a(ItemStack stack, World world) {
        NBTTagCompound nbttagcompound = stack.v();
        if (nbttagcompound != null && nbttagcompound.b(c, 99)) {
            ItemWorldMap.a(stack, world, nbttagcompound.h(c));
            nbttagcompound.r(c);
        } else if (nbttagcompound != null && nbttagcompound.b(d, 1) && nbttagcompound.q(d)) {
            ItemWorldMap.a(world, stack);
            nbttagcompound.r(d);
        }
    }

    private static void a(ItemStack map, World world, int amount) {
        WorldMap worldmap = ItemWorldMap.b(map, world);
        if (worldmap != null) {
            int j2 = world.v();
            world.a(ItemWorldMap.a(j2), worldmap.a(amount));
            ItemWorldMap.a(map, j2);
        }
    }

    public static void a(World world, ItemStack stack) {
        WorldMap worldmap = ItemWorldMap.b(stack, world);
        if (worldmap != null) {
            int i2 = world.v();
            String s2 = ItemWorldMap.a(i2);
            WorldMap worldmap1 = worldmap.b();
            world.a(s2, worldmap1);
            ItemWorldMap.a(stack, i2);
        }
    }

    @Override
    public void a(ItemStack stack, @Nullable World world, List<IChatBaseComponent> tooltip, TooltipFlag context) {
        byte b0;
        boolean flag;
        Integer integer = ItemWorldMap.d(stack);
        WorldMap worldmap = world == null ? null : ItemWorldMap.a(integer, world);
        NBTTagCompound nbttagcompound = stack.v();
        if (nbttagcompound != null) {
            flag = nbttagcompound.q(d);
            b0 = nbttagcompound.f(c);
        } else {
            flag = false;
            b0 = 0;
        }
        if (worldmap != null && (worldmap.h || flag)) {
            tooltip.add(IChatBaseComponent.a("filled_map.locked", integer).a(EnumChatFormat.h));
        }
        if (context.a()) {
            if (worldmap != null) {
                if (!flag && b0 == 0) {
                    tooltip.add(ItemWorldMap.c(integer));
                }
                int i2 = Math.min(worldmap.f + b0, 4);
                tooltip.add(IChatBaseComponent.a("filled_map.scale", 1 << i2).a(EnumChatFormat.h));
                tooltip.add(IChatBaseComponent.a("filled_map.level", i2, 4).a(EnumChatFormat.h));
            } else {
                tooltip.add(IChatBaseComponent.c("filled_map.unknown").a(EnumChatFormat.h));
            }
        }
    }

    private static IChatBaseComponent c(int id) {
        return IChatBaseComponent.a("filled_map.id", id).a(EnumChatFormat.h);
    }

    public static IChatBaseComponent k(ItemStack stack) {
        return ItemWorldMap.c(ItemWorldMap.d(stack));
    }

    public static int o(ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.b("display");
        if (nbttagcompound != null && nbttagcompound.b("MapColor", 99)) {
            int i2 = nbttagcompound.h("MapColor");
            return 0xFF000000 | i2 & 0xFFFFFF;
        }
        return -12173266;
    }

    @Override
    public EnumInteractionResult a(ItemActionContext context) {
        IBlockData iblockdata = context.q().a_(context.a());
        if (iblockdata.a(TagsBlock.G)) {
            WorldMap worldmap;
            if (!context.q().B && (worldmap = ItemWorldMap.b(context.n(), context.q())) != null && !worldmap.a(context.q(), context.a())) {
                return EnumInteractionResult.e;
            }
            return EnumInteractionResult.a(context.q().B);
        }
        return super.a(context);
    }
}

