/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataJson;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.IInventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.level.World;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;

public class CraftingManager
extends ResourceDataJson {
    private static final Gson a = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger b = LogUtils.getLogger();
    public Map<Recipes<?>, Object2ObjectLinkedOpenHashMap<MinecraftKey, RecipeHolder<?>>> c = ImmutableMap.of();
    public Map<MinecraftKey, RecipeHolder<?>> d = ImmutableMap.of();
    private boolean e;

    public CraftingManager() {
        super(a, "recipes");
    }

    @Override
    protected void a(Map<MinecraftKey, JsonElement> prepared, IResourceManager manager, GameProfilerFiller profiler) {
        this.e = false;
        HashMap map1 = Maps.newHashMap();
        for (Recipes recipes2 : BuiltInRegistries.s) {
            map1.put(recipes2, new Object2ObjectLinkedOpenHashMap());
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<MinecraftKey, JsonElement> entry : prepared.entrySet()) {
            MinecraftKey minecraftkey = entry.getKey();
            try {
                RecipeHolder<?> recipeholder = CraftingManager.a(minecraftkey, ChatDeserializer.m(entry.getValue(), "top element"));
                map1.computeIfAbsent(recipeholder.b().e(), recipes -> new Object2ObjectLinkedOpenHashMap()).put((Object)minecraftkey, recipeholder);
                builder.put((Object)minecraftkey, recipeholder);
            }
            catch (JsonParseException | IllegalArgumentException jsonparseexception) {
                b.error("Parsing error loading recipe {}", (Object)minecraftkey, (Object)jsonparseexception);
            }
        }
        this.c = (Map)map1.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry1 -> (Object2ObjectLinkedOpenHashMap)entry1.getValue()));
        this.d = Maps.newHashMap((Map)builder.build());
        b.info("Loaded {} recipes", (Object)this.d.size());
    }

    public void addRecipe(RecipeHolder<?> irecipe) {
        AsyncCatcher.catchOp("Recipe Add");
        Object2ObjectLinkedOpenHashMap<MinecraftKey, RecipeHolder<?>> map = this.c.get(irecipe.b().e());
        if (this.d.containsKey(irecipe.a()) || map.containsKey((Object)irecipe.a())) {
            throw new IllegalStateException("Duplicate recipe ignored with ID " + irecipe.a());
        }
        map.putAndMoveToFirst((Object)irecipe.a(), irecipe);
        this.d.put(irecipe.a(), irecipe);
    }

    public boolean a() {
        return this.e;
    }

    public <C extends IInventory, T extends IRecipe<C>> Optional<RecipeHolder<T>> a(Recipes<T> type, C inventory, World world) {
        Optional<RecipeHolder<Object>> recipe = this.c(type).values().stream().filter(recipeholder -> recipeholder.b().a(inventory, world)).findFirst();
        inventory.setCurrentRecipe(recipe.orElse(null));
        return recipe;
    }

    public <C extends IInventory, T extends IRecipe<C>> Optional<Pair<MinecraftKey, RecipeHolder<T>>> a(Recipes<T> type, C inventory, World world, @Nullable MinecraftKey id) {
        RecipeHolder<T> recipeholder;
        Map<MinecraftKey, RecipeHolder<T>> map = this.c(type);
        if (id != null && (recipeholder = map.get(id)) != null && recipeholder.b().a(inventory, world)) {
            inventory.setCurrentRecipe(recipeholder);
            return Optional.of(Pair.of((Object)id, recipeholder));
        }
        inventory.setCurrentRecipe(null);
        return map.entrySet().stream().filter(entry -> ((RecipeHolder)entry.getValue()).b().a(inventory, world)).findFirst().map(entry -> {
            inventory.setCurrentRecipe((RecipeHolder)entry.getValue());
            return Pair.of((Object)((MinecraftKey)entry.getKey()), (Object)((RecipeHolder)entry.getValue()));
        });
    }

    public <C extends IInventory, T extends IRecipe<C>> List<RecipeHolder<T>> a(Recipes<T> type) {
        return List.copyOf(this.c(type).values());
    }

    public <C extends IInventory, T extends IRecipe<C>> List<RecipeHolder<T>> b(Recipes<T> type, C inventory, World world) {
        return this.c(type).values().stream().filter(recipeholder -> recipeholder.b().a(inventory, world)).sorted(Comparator.comparing(recipeholder -> recipeholder.b().a(world.I_()).q())).collect(Collectors.toList());
    }

    private <C extends IInventory, T extends IRecipe<C>> Map<MinecraftKey, RecipeHolder<T>> c(Recipes<T> type) {
        return (Map)this.c.getOrDefault(type, new Object2ObjectLinkedOpenHashMap());
    }

    public <C extends IInventory, T extends IRecipe<C>> NonNullList<ItemStack> c(Recipes<T> type, C inventory, World world) {
        return this.getRemainingItemsFor(type, inventory, world, null);
    }

    public <C extends IInventory, T extends IRecipe<C>> NonNullList<ItemStack> getRemainingItemsFor(Recipes<T> type, C inventory, World world, @Nullable MinecraftKey firstToCheck) {
        Optional<RecipeHolder<RecipeHolder<T>>> optional;
        Optional<RecipeHolder<RecipeHolder<T>>> optional2 = optional = firstToCheck == null ? this.a(type, inventory, world) : this.a(type, inventory, world, firstToCheck).map(Pair::getSecond);
        if (optional.isPresent()) {
            return optional.get().b().a(inventory);
        }
        NonNullList<ItemStack> nonnulllist = NonNullList.a(inventory.b(), ItemStack.f);
        for (int i2 = 0; i2 < nonnulllist.size(); ++i2) {
            nonnulllist.set(i2, inventory.a(i2));
        }
        return nonnulllist;
    }

    public Optional<RecipeHolder<?>> a(MinecraftKey id) {
        return Optional.ofNullable(this.d.get(id));
    }

    public Collection<RecipeHolder<?>> b() {
        return this.c.values().stream().flatMap(map -> map.values().stream()).collect(Collectors.toSet());
    }

    public Stream<MinecraftKey> d() {
        return this.c.values().stream().flatMap(map -> map.keySet().stream());
    }

    protected static RecipeHolder<?> a(MinecraftKey id, JsonObject json) {
        IRecipe irecipe = (IRecipe)SystemUtils.a(IRecipe.h.parse((DynamicOps)JsonOps.INSTANCE, (Object)json), JsonParseException::new);
        return new RecipeHolder<IRecipe>(id, irecipe);
    }

    public void a(Iterable<RecipeHolder<?>> recipes) {
        this.e = false;
        HashMap map = Maps.newHashMap();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        recipes.forEach(recipeholder -> {
            Map map1 = (Map)map.computeIfAbsent(recipeholder.b().e(), recipes_ -> new Object2ObjectLinkedOpenHashMap());
            MinecraftKey minecraftkey = recipeholder.a();
            RecipeHolder recipeholder1 = map1.put(minecraftkey, recipeholder);
            builder.put((Object)minecraftkey, recipeholder);
            if (recipeholder1 != null) {
                throw new IllegalStateException("Duplicate recipe ignored with ID " + minecraftkey);
            }
        });
        this.c = ImmutableMap.copyOf((Map)map);
        this.d = Maps.newHashMap((Map)builder.build());
    }

    public boolean removeRecipe(MinecraftKey mcKey) {
        for (Object2ObjectLinkedOpenHashMap<MinecraftKey, RecipeHolder<?>> recipes : this.c.values()) {
            recipes.remove((Object)mcKey);
        }
        return this.d.remove(mcKey) != null;
    }

    public void clearRecipes() {
        this.c = Maps.newHashMap();
        for (Recipes recipes : BuiltInRegistries.s) {
            this.c.put(recipes, new Object2ObjectLinkedOpenHashMap());
        }
        this.d = Maps.newHashMap();
    }

    public static <C extends IInventory, T extends IRecipe<C>> a<C, T> b(final Recipes<T> type) {
        return new a<C, T>(){
            @Nullable
            private MinecraftKey b;

            @Override
            public Optional<RecipeHolder<T>> a(C inventory, World world) {
                CraftingManager craftingmanager = world.r();
                Optional optional = craftingmanager.a(type, inventory, world, this.b);
                if (optional.isPresent()) {
                    Pair pair = optional.get();
                    this.b = (MinecraftKey)pair.getFirst();
                    return Optional.of((RecipeHolder)pair.getSecond());
                }
                return Optional.empty();
            }
        };
    }

    public static interface a<C extends IInventory, T extends IRecipe<C>> {
        public Optional<RecipeHolder<T>> a(C var1, World var2);
    }
}

