/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IMaterial;

public final class RecipeItemStack
implements Predicate<ItemStack> {
    public static final RecipeItemStack a = new RecipeItemStack(Stream.empty());
    public final Provider[] d;
    @Nullable
    public ItemStack[] e;
    @Nullable
    private IntList f;
    public boolean exact;
    public static final Codec<RecipeItemStack> b = RecipeItemStack.a(true);
    public static final Codec<RecipeItemStack> c = RecipeItemStack.a(false);

    public RecipeItemStack(Stream<? extends Provider> entries) {
        this.d = (Provider[])entries.toArray(Provider[]::new);
    }

    private RecipeItemStack(Provider[] entries) {
        this.d = entries;
    }

    public ItemStack[] a() {
        if (this.e == null) {
            this.e = (ItemStack[])Arrays.stream(this.d).flatMap(recipeitemstack_provider -> recipeitemstack_provider.a().stream()).distinct().toArray(ItemStack[]::new);
        }
        return this.e;
    }

    public boolean a(@Nullable ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        if (this.c()) {
            return itemstack.b();
        }
        for (ItemStack itemstack1 : this.a()) {
            if (!(this.exact ? itemstack1.d() == itemstack.d() && ItemStack.c(itemstack, itemstack1) : itemstack1.a(itemstack.d()))) continue;
            return true;
        }
        return false;
    }

    public IntList b() {
        if (this.f == null) {
            ItemStack[] aitemstack = this.a();
            this.f = new IntArrayList(aitemstack.length);
            ItemStack[] aitemstack1 = aitemstack;
            int i2 = aitemstack.length;
            for (int j2 = 0; j2 < i2; ++j2) {
                ItemStack itemstack = aitemstack1[j2];
                this.f.add(AutoRecipeStackManager.c(itemstack));
            }
            this.f.sort(IntComparators.NATURAL_COMPARATOR);
        }
        return this.f;
    }

    public void a(PacketDataSerializer buf) {
        buf.a(Arrays.asList(this.a()), PacketDataSerializer::a);
    }

    public boolean c() {
        return this.d.length == 0;
    }

    public boolean equals(Object object) {
        if (object instanceof RecipeItemStack) {
            RecipeItemStack recipeitemstack = (RecipeItemStack)object;
            return Arrays.equals(this.d, recipeitemstack.d);
        }
        return false;
    }

    private static RecipeItemStack b(Stream<? extends Provider> entries) {
        RecipeItemStack recipeitemstack = new RecipeItemStack(entries);
        return recipeitemstack.c() ? a : recipeitemstack;
    }

    public static RecipeItemStack d() {
        return a;
    }

    public static RecipeItemStack a(IMaterial ... items) {
        return RecipeItemStack.a(Arrays.stream(items).map(ItemStack::new));
    }

    public static RecipeItemStack a(ItemStack ... stacks) {
        return RecipeItemStack.a(Arrays.stream(stacks));
    }

    public static RecipeItemStack a(Stream<ItemStack> stacks) {
        return RecipeItemStack.b(stacks.filter(itemstack -> !itemstack.b()).map(StackProvider::new));
    }

    public static RecipeItemStack a(TagKey<Item> tag) {
        return RecipeItemStack.b(Stream.of(new b(tag)));
    }

    public static RecipeItemStack b(PacketDataSerializer buf) {
        return RecipeItemStack.b(buf.a(PacketDataSerializer::r).stream().map(StackProvider::new));
    }

    private static Codec<RecipeItemStack> a(boolean allowEmpty) {
        Codec codec = Codec.list(Provider.a).comapFlatMap(list -> !allowEmpty && list.size() < 1 ? DataResult.error(() -> "Item array cannot be empty, at least one item must be defined") : DataResult.success((Object)list.toArray(new Provider[0])), List::of);
        return ExtraCodecs.c(codec, Provider.a).flatComapMap(either -> either.map(RecipeItemStack::new, recipeitemstack_provider -> new RecipeItemStack(new Provider[]{recipeitemstack_provider})), recipeitemstack -> recipeitemstack.d.length == 1 ? DataResult.success(Either.right(recipeitemstack.d[0])) : (recipeitemstack.d.length == 0 && !allowEmpty ? DataResult.error(() -> "Item array cannot be empty, at least one item must be defined") : DataResult.success(Either.left(recipeitemstack.d))));
    }

    public static interface Provider {
        public static final Codec<Provider> a = ExtraCodecs.a(StackProvider.c, net.minecraft.world.item.crafting.RecipeItemStack$b.c).xmap(either -> (Provider)((Object)either.map(recipeitemstack_stackprovider -> recipeitemstack_stackprovider, recipeitemstack_b -> recipeitemstack_b)), recipeitemstack_provider -> {
            if (recipeitemstack_provider instanceof b) {
                b recipeitemstack_b = (b)recipeitemstack_provider;
                return Either.right(recipeitemstack_b);
            }
            if (recipeitemstack_provider instanceof StackProvider) {
                StackProvider recipeitemstack_stackprovider = (StackProvider)recipeitemstack_provider;
                return Either.left(recipeitemstack_stackprovider);
            }
            throw new UnsupportedOperationException("This is neither an item value nor a tag value.");
        });

        public Collection<ItemStack> a();
    }

    private record b(TagKey<Item> b) implements Provider
    {
        static final Codec<b> c = RecordCodecBuilder.create(instance -> instance.group((App)TagKey.a(Registries.F).fieldOf("tag").forGetter(recipeitemstack_b -> recipeitemstack_b.b)).apply((Applicative)instance, b::new));

        @Override
        public boolean equals(Object object) {
            if (object instanceof b) {
                b recipeitemstack_b = (b)object;
                return recipeitemstack_b.b.b().equals(this.b.b());
            }
            return false;
        }

        @Override
        public Collection<ItemStack> a() {
            ArrayList list = Lists.newArrayList();
            for (Holder<Item> holder : BuiltInRegistries.h.c(this.b)) {
                list.add(new ItemStack(holder));
            }
            return list;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "tag", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "tag", "b"}, this);
        }
    }

    public record StackProvider(ItemStack b) implements Provider
    {
        static final Codec<StackProvider> c = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.d.fieldOf("item").forGetter(recipeitemstack_stackprovider -> recipeitemstack_stackprovider.b)).apply((Applicative)instance, StackProvider::new));

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof StackProvider)) {
                return false;
            }
            StackProvider recipeitemstack_stackprovider = (StackProvider)object;
            return recipeitemstack_stackprovider.b.d().equals(this.b.d()) && recipeitemstack_stackprovider.b.L() == this.b.L();
        }

        @Override
        public Collection<ItemStack> a() {
            return Collections.singleton(this.b);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{StackProvider.class, "item", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{StackProvider.class, "item", "b"}, this);
        }
    }
}

