/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.inventory.recipe.RecipeBookExactChoiceRecipe;
import it.unimi.dsi.fastutil.ints.IntList;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.NonNullList;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.RecipeCrafting;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.World;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftShapelessRecipe;
import org.bukkit.inventory.ShapelessRecipe;

public class ShapelessRecipes
extends RecipeBookExactChoiceRecipe<InventoryCrafting>
implements RecipeCrafting {
    final String a;
    final CraftingBookCategory b;
    final ItemStack c;
    final NonNullList<RecipeItemStack> d;

    public ShapelessRecipes(String group, CraftingBookCategory category, ItemStack result, NonNullList<RecipeItemStack> ingredients) {
        this.a = group;
        this.b = category;
        this.c = result;
        this.d = ingredients;
        this.checkExactIngredients();
    }

    public ShapelessRecipe toBukkitRecipe(NamespacedKey id) {
        CraftItemStack result = CraftItemStack.asCraftMirror(this.c);
        CraftShapelessRecipe recipe = new CraftShapelessRecipe(id, result, this);
        recipe.setGroup(this.a);
        recipe.setCategory(CraftRecipe.getCategory(this.d()));
        for (RecipeItemStack list : this.d) {
            recipe.addIngredient(CraftRecipe.toBukkit(list));
        }
        return recipe;
    }

    @Override
    public RecipeSerializer<?> ar_() {
        return RecipeSerializer.b;
    }

    @Override
    public String c() {
        return this.a;
    }

    @Override
    public CraftingBookCategory d() {
        return this.b;
    }

    @Override
    public ItemStack a(IRegistryCustom registryManager) {
        return this.c;
    }

    @Override
    public NonNullList<RecipeItemStack> a() {
        return this.d;
    }

    @Override
    public boolean a(InventoryCrafting inventory, World world) {
        AutoRecipeStackManager autorecipestackmanager = new AutoRecipeStackManager();
        autorecipestackmanager.initialize(this);
        int i2 = 0;
        for (int j2 = 0; j2 < inventory.b(); ++j2) {
            ItemStack itemstack = inventory.a(j2);
            if (itemstack.b()) continue;
            ++i2;
            autorecipestackmanager.a(itemstack, 1);
        }
        return i2 == this.d.size() && autorecipestackmanager.a(this, (IntList)null);
    }

    @Override
    public ItemStack a(InventoryCrafting inventory, IRegistryCustom registryManager) {
        return this.c.p();
    }

    @Override
    public boolean a(int width, int height) {
        return width * height >= this.d.size();
    }

    public static class a
    implements RecipeSerializer<ShapelessRecipes> {
        private static final Codec<ShapelessRecipes> x = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.a(Codec.STRING, "group", "").forGetter(shapelessrecipes -> shapelessrecipes.a), (App)CraftingBookCategory.e.fieldOf("category").orElse((Object)CraftingBookCategory.d).forGetter(shapelessrecipes -> shapelessrecipes.b), (App)ItemStack.c.fieldOf("result").forGetter(shapelessrecipes -> shapelessrecipes.c), (App)RecipeItemStack.c.listOf().fieldOf("ingredients").flatXmap(list -> {
            RecipeItemStack[] arecipeitemstack = (RecipeItemStack[])list.stream().filter(recipeitemstack -> !recipeitemstack.c()).toArray(RecipeItemStack[]::new);
            return arecipeitemstack.length == 0 ? DataResult.error(() -> "No ingredients for shapeless recipe") : (arecipeitemstack.length > 9 ? DataResult.error(() -> "Too many ingredients for shapeless recipe") : DataResult.success(NonNullList.a(RecipeItemStack.a, arecipeitemstack)));
        }, DataResult::success).forGetter(shapelessrecipes -> shapelessrecipes.d)).apply((Applicative)instance, ShapelessRecipes::new));

        @Override
        public Codec<ShapelessRecipes> a() {
            return x;
        }

        public ShapelessRecipes b(PacketDataSerializer buf) {
            String s2 = buf.s();
            CraftingBookCategory craftingbookcategory = buf.b(CraftingBookCategory.class);
            int i2 = buf.n();
            NonNullList<RecipeItemStack> nonnulllist = NonNullList.a(i2, RecipeItemStack.a);
            for (int j2 = 0; j2 < nonnulllist.size(); ++j2) {
                nonnulllist.set(j2, RecipeItemStack.b(buf));
            }
            ItemStack itemstack = buf.r();
            return new ShapelessRecipes(s2, craftingbookcategory, itemstack, nonnulllist);
        }

        @Override
        public void a(PacketDataSerializer buf, ShapelessRecipes recipe) {
            buf.a(recipe.a);
            buf.a(recipe.b);
            buf.c(recipe.d.size());
            for (RecipeItemStack recipeitemstack : recipe.d) {
                recipeitemstack.a(buf);
            }
            buf.a(recipe.c);
        }
    }
}

