/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom2;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemEnchantedBook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentSweeping;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.WeightedRandomEnchant;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;

public class EnchantmentManager {
    private static final String a = "id";
    private static final String b = "lvl";
    private static final float c = 0.15f;

    public static NBTTagCompound a(@Nullable MinecraftKey id, int lvl) {
        NBTTagCompound compoundTag = new NBTTagCompound();
        compoundTag.a(a, String.valueOf(id));
        compoundTag.a(b, (short)lvl);
        return compoundTag;
    }

    public static void a(NBTTagCompound nbt, int lvl) {
        nbt.a(b, (short)lvl);
    }

    public static int a(NBTTagCompound nbt) {
        return MathHelper.a(nbt.h(b), 0, 255);
    }

    @Nullable
    public static MinecraftKey b(NBTTagCompound nbt) {
        return MinecraftKey.a(nbt.l(a));
    }

    @Nullable
    public static MinecraftKey a(Enchantment enchantment) {
        return BuiltInRegistries.f.b(enchantment);
    }

    public static int a(Enchantment enchantment, ItemStack stack) {
        if (stack.b()) {
            return 0;
        }
        MinecraftKey resourceLocation = EnchantmentManager.a(enchantment);
        NBTTagList listTag = stack.x();
        for (int i2 = 0; i2 < listTag.size(); ++i2) {
            NBTTagCompound compoundTag = listTag.a(i2);
            MinecraftKey resourceLocation2 = EnchantmentManager.b(compoundTag);
            if (resourceLocation2 == null || !resourceLocation2.equals(resourceLocation)) continue;
            return EnchantmentManager.a(compoundTag);
        }
        return 0;
    }

    public static Map<Enchantment, Integer> a(ItemStack stack) {
        NBTTagList listTag = stack.a(Items.up) ? ItemEnchantedBook.d(stack) : stack.x();
        return EnchantmentManager.a(listTag);
    }

    public static Map<Enchantment, Integer> a(NBTTagList list) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            NBTTagCompound compoundTag = list.a(i2);
            BuiltInRegistries.f.b(EnchantmentManager.b(compoundTag)).ifPresent(enchantment -> map.put(enchantment, EnchantmentManager.a(compoundTag)));
        }
        return map;
    }

    public static void a(Map<Enchantment, Integer> enchantments, ItemStack stack) {
        NBTTagList listTag = new NBTTagList();
        for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
            Enchantment enchantment = entry.getKey();
            if (enchantment == null) continue;
            int i2 = entry.getValue();
            listTag.add(EnchantmentManager.a(EnchantmentManager.a(enchantment), i2));
            if (!stack.a(Items.up)) continue;
            ItemEnchantedBook.a(stack, new WeightedRandomEnchant(enchantment, i2));
        }
        if (listTag.isEmpty()) {
            stack.c("Enchantments");
        } else if (!stack.a(Items.up)) {
            stack.a("Enchantments", listTag);
        }
    }

    private static void a(a consumer, ItemStack stack) {
        if (stack.b()) {
            return;
        }
        NBTTagList listTag = stack.x();
        for (int i2 = 0; i2 < listTag.size(); ++i2) {
            NBTTagCompound compoundTag = listTag.a(i2);
            BuiltInRegistries.f.b(EnchantmentManager.b(compoundTag)).ifPresent(enchantment -> consumer.accept((Enchantment)enchantment, EnchantmentManager.a(compoundTag)));
        }
    }

    private static void a(a consumer, Iterable<ItemStack> stacks) {
        for (ItemStack itemStack : stacks) {
            EnchantmentManager.a(consumer, itemStack);
        }
    }

    public static int a(Iterable<ItemStack> equipment, DamageSource source) {
        MutableInt mutableInt = new MutableInt();
        EnchantmentManager.a((Enchantment enchantment, int level) -> mutableInt.add(enchantment.a(level, source)), equipment);
        return mutableInt.intValue();
    }

    public static float a(ItemStack stack, EnumMonsterType group) {
        MutableFloat mutableFloat = new MutableFloat();
        EnchantmentManager.a((Enchantment enchantment, int level) -> mutableFloat.add(enchantment.a(level, group)), stack);
        return mutableFloat.floatValue();
    }

    public static float a(EntityLiving entity) {
        int i2 = EnchantmentManager.a(Enchantments.t, entity);
        if (i2 > 0) {
            return EnchantmentSweeping.e(i2);
        }
        return 0.0f;
    }

    public static void a(EntityLiving user, Entity attacker) {
        a enchantmentVisitor = (enchantment, level) -> enchantment.b(user, attacker, level);
        if (user != null) {
            EnchantmentManager.a(enchantmentVisitor, user.bM());
        }
        if (attacker instanceof EntityHuman) {
            EnchantmentManager.a(enchantmentVisitor, user.eT());
        }
    }

    public static void b(EntityLiving user, Entity target) {
        a enchantmentVisitor = (enchantment, level) -> enchantment.a(user, target, level);
        if (user != null) {
            EnchantmentManager.a(enchantmentVisitor, user.bM());
        }
        if (user instanceof EntityHuman) {
            EnchantmentManager.a(enchantmentVisitor, user.eT());
        }
    }

    public static int a(Enchantment enchantment, EntityLiving entity) {
        Collection<ItemStack> iterable = enchantment.a(entity).values();
        if (iterable == null) {
            return 0;
        }
        int i2 = 0;
        for (ItemStack itemStack : iterable) {
            int j2 = EnchantmentManager.a(enchantment, itemStack);
            if (j2 <= i2) continue;
            i2 = j2;
        }
        return i2;
    }

    public static float b(EntityLiving entity) {
        return (float)EnchantmentManager.a(Enchantments.m, entity) * 0.15f;
    }

    public static int c(EntityLiving entity) {
        return EnchantmentManager.a(Enchantments.q, entity);
    }

    public static int d(EntityLiving entity) {
        return EnchantmentManager.a(Enchantments.r, entity);
    }

    public static int e(EntityLiving entity) {
        return EnchantmentManager.a(Enchantments.f, entity);
    }

    public static int f(EntityLiving entity) {
        return EnchantmentManager.a(Enchantments.i, entity);
    }

    public static int g(EntityLiving entity) {
        return EnchantmentManager.a(Enchantments.u, entity);
    }

    public static int b(ItemStack stack) {
        return EnchantmentManager.a(Enchantments.C, stack);
    }

    public static int c(ItemStack stack) {
        return EnchantmentManager.a(Enchantments.D, stack);
    }

    public static int h(EntityLiving entity) {
        return EnchantmentManager.a(Enchantments.s, entity);
    }

    public static boolean i(EntityLiving entity) {
        return EnchantmentManager.a(Enchantments.g, entity) > 0;
    }

    public static boolean j(EntityLiving entity) {
        return EnchantmentManager.a(Enchantments.j, entity) > 0;
    }

    public static boolean k(EntityLiving entity) {
        return EnchantmentManager.a(Enchantments.l, entity) > 0;
    }

    public static boolean d(ItemStack stack) {
        return EnchantmentManager.a(Enchantments.k, stack) > 0;
    }

    public static boolean e(ItemStack stack) {
        return EnchantmentManager.a(Enchantments.M, stack) > 0;
    }

    public static boolean f(ItemStack stack) {
        return EnchantmentManager.a(Enchantments.v, stack) > 0;
    }

    public static int g(ItemStack stack) {
        return EnchantmentManager.a(Enchantments.E, stack);
    }

    public static int h(ItemStack stack) {
        return EnchantmentManager.a(Enchantments.G, stack);
    }

    public static boolean i(ItemStack stack) {
        return EnchantmentManager.a(Enchantments.H, stack) > 0;
    }

    @Nullable
    public static Map.Entry<EnumItemSlot, ItemStack> b(Enchantment enchantment, EntityLiving entity) {
        return EnchantmentManager.a(enchantment, entity, (ItemStack stack) -> true);
    }

    @Nullable
    public static Map.Entry<EnumItemSlot, ItemStack> a(Enchantment enchantment, EntityLiving entity, Predicate<ItemStack> condition) {
        Map<EnumItemSlot, ItemStack> map = enchantment.a(entity);
        if (map.isEmpty()) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<EnumItemSlot, ItemStack> entry : map.entrySet()) {
            ItemStack itemStack = entry.getValue();
            if (itemStack.b() || EnchantmentManager.a(enchantment, itemStack) <= 0 || !condition.test(itemStack)) continue;
            list.add(entry);
        }
        return list.isEmpty() ? null : (Map.Entry)list.get(entity.eg().a(list.size()));
    }

    public static int a(RandomSource random, int slotIndex, int bookshelfCount, ItemStack stack) {
        Item item = stack.d();
        int i2 = item.c();
        if (i2 <= 0) {
            return 0;
        }
        if (bookshelfCount > 15) {
            bookshelfCount = 15;
        }
        int j2 = random.a(8) + 1 + (bookshelfCount >> 1) + random.a(bookshelfCount + 1);
        if (slotIndex == 0) {
            return Math.max(j2 / 3, 1);
        }
        if (slotIndex == 1) {
            return j2 * 2 / 3 + 1;
        }
        return Math.max(j2, bookshelfCount * 2);
    }

    public static ItemStack a(RandomSource random, ItemStack target, int level, boolean treasureAllowed) {
        List<WeightedRandomEnchant> list = EnchantmentManager.b(random, target, level, treasureAllowed);
        boolean bl = target.a(Items.qM);
        if (bl) {
            target = new ItemStack(Items.up);
        }
        for (WeightedRandomEnchant enchantmentInstance : list) {
            if (bl) {
                ItemEnchantedBook.a(target, enchantmentInstance);
                continue;
            }
            target.a(enchantmentInstance.a, enchantmentInstance.b);
        }
        return target;
    }

    public static List<WeightedRandomEnchant> b(RandomSource random, ItemStack stack, int level, boolean treasureAllowed) {
        ArrayList list = Lists.newArrayList();
        Item item = stack.d();
        int i2 = item.c();
        if (i2 <= 0) {
            return list;
        }
        level += 1 + random.a(i2 / 4 + 1) + random.a(i2 / 4 + 1);
        float f2 = (random.i() + random.i() - 1.0f) * 0.15f;
        List<WeightedRandomEnchant> list2 = EnchantmentManager.a(level = MathHelper.a(Math.round((float)level + (float)level * f2), 1, Integer.MAX_VALUE), stack, treasureAllowed);
        if (!list2.isEmpty()) {
            WeightedRandom2.a(random, list2).ifPresent(list::add);
            while (random.a(50) <= level) {
                if (!list.isEmpty()) {
                    EnchantmentManager.a(list2, (WeightedRandomEnchant)SystemUtils.a(list));
                }
                if (list2.isEmpty()) break;
                WeightedRandom2.a(random, list2).ifPresent(list::add);
                level /= 2;
            }
        }
        return list;
    }

    public static void a(List<WeightedRandomEnchant> possibleEntries, WeightedRandomEnchant pickedEntry) {
        Iterator<WeightedRandomEnchant> iterator = possibleEntries.iterator();
        while (iterator.hasNext()) {
            if (pickedEntry.a.b(iterator.next().a)) continue;
            iterator.remove();
        }
    }

    public static boolean a(Collection<Enchantment> existing, Enchantment candidate) {
        for (Enchantment enchantment : existing) {
            if (enchantment.b(candidate)) continue;
            return false;
        }
        return true;
    }

    public static List<WeightedRandomEnchant> a(int power, ItemStack stack, boolean treasureAllowed) {
        ArrayList list = Lists.newArrayList();
        Item item = stack.d();
        boolean bl = stack.a(Items.qM);
        block0: for (Enchantment enchantment : BuiltInRegistries.f) {
            if (enchantment.b() && !treasureAllowed || !enchantment.i() || !enchantment.e.a(item) && !bl) continue;
            for (int i2 = enchantment.a(); i2 > enchantment.e() - 1; --i2) {
                if (power < enchantment.a(i2) || power > enchantment.b(i2)) continue;
                list.add(new WeightedRandomEnchant(enchantment, i2));
                continue block0;
            }
        }
        return list;
    }

    @FunctionalInterface
    static interface a {
        public void accept(Enchantment var1, int var2);
    }
}

