/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPosition;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IBlockLightAccess;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.phys.AxisAlignedBB;

public interface IWorldReader
extends IBlockLightAccess,
ICollisionAccess,
SignalGetter,
BiomeManager.Provider {
    @Nullable
    public IChunkAccess a(int var1, int var2, ChunkStatus var3, boolean var4);

    default public IChunkAccess syncLoadNonFull(int chunkX, int chunkZ, ChunkStatus status) {
        if (status == null || status.b(ChunkStatus.n)) {
            throw new IllegalArgumentException("Status: " + status.toString());
        }
        return this.a(chunkX, chunkZ, status, true);
    }

    @Nullable
    public IChunkAccess getChunkIfLoadedImmediately(int var1, int var2);

    @Nullable
    default public IChunkAccess getChunkIfLoadedImmediately(BlockPosition pos) {
        return this.getChunkIfLoadedImmediately(pos.u() >> 4, pos.w() >> 4);
    }

    @Deprecated
    public boolean b(int var1, int var2);

    public int a(HeightMap.Type var1, int var2, int var3);

    public int C_();

    public BiomeManager G_();

    default public Holder<BiomeBase> t(BlockPosition pos) {
        return this.G_().a(pos);
    }

    default public Stream<IBlockData> c(AxisAlignedBB box) {
        int n2;
        int i2 = MathHelper.a(box.a);
        int j2 = MathHelper.a(box.d);
        int k2 = MathHelper.a(box.b);
        int l2 = MathHelper.a(box.e);
        int m2 = MathHelper.a(box.c);
        return this.a(i2, k2, m2, j2, l2, n2 = MathHelper.a(box.f)) ? this.a(box) : Stream.empty();
    }

    @Override
    default public int a(BlockPosition pos, ColorResolver colorResolver) {
        return colorResolver.getColor(this.t(pos).a(), pos.u(), pos.w());
    }

    @Override
    default public Holder<BiomeBase> getNoiseBiome(int biomeX, int biomeY, int biomeZ) {
        IChunkAccess chunkAccess = this.a(QuartPos.e(biomeX), QuartPos.e(biomeZ), ChunkStatus.f, false);
        return chunkAccess != null ? chunkAccess.getNoiseBiome(biomeX, biomeY, biomeZ) : this.a(biomeX, biomeY, biomeZ);
    }

    public Holder<BiomeBase> a(int var1, int var2, int var3);

    public boolean y_();

    @Deprecated
    public int A_();

    public DimensionManager E_();

    @Override
    default public int J_() {
        return this.E_().n();
    }

    @Override
    default public int K_() {
        return this.E_().o();
    }

    default public BlockPosition a(HeightMap.Type heightmap, BlockPosition pos) {
        return new BlockPosition(pos.u(), this.a(heightmap, pos.u(), pos.w()), pos.w());
    }

    default public boolean u(BlockPosition pos) {
        return this.a_(pos).i();
    }

    default public boolean v(BlockPosition pos) {
        if (pos.v() >= this.A_()) {
            return this.h(pos);
        }
        BlockPosition blockPos = new BlockPosition(pos.u(), this.A_(), pos.w());
        if (!this.h(blockPos)) {
            return false;
        }
        BlockPosition var4 = blockPos.d();
        while (var4.v() > pos.v()) {
            IBlockData blockState = this.a_(var4);
            if (blockState.b(this, var4) > 0 && !blockState.k()) {
                return false;
            }
            var4 = var4.d();
        }
        return true;
    }

    default public float w(BlockPosition pos) {
        return this.x(pos) - 0.5f;
    }

    @Deprecated
    default public float x(BlockPosition pos) {
        float f2 = (float)this.A(pos) / 15.0f;
        float g2 = f2 / (4.0f - 3.0f * f2);
        return MathHelper.i(this.E_().s(), g2, 1.0f);
    }

    default public IChunkAccess y(BlockPosition pos) {
        return this.a(SectionPosition.a(pos.u()), SectionPosition.a(pos.w()));
    }

    default public IChunkAccess a(int chunkX, int chunkZ) {
        return this.a(chunkX, chunkZ, ChunkStatus.n, true);
    }

    default public IChunkAccess a(int chunkX, int chunkZ, ChunkStatus status) {
        return this.a(chunkX, chunkZ, status, true);
    }

    @Override
    @Nullable
    default public IBlockAccess c(int chunkX, int chunkZ) {
        return this.a(chunkX, chunkZ, ChunkStatus.c, false);
    }

    default public boolean z(BlockPosition pos) {
        return this.b_(pos).a(TagsFluid.a);
    }

    default public boolean d(AxisAlignedBB box) {
        int i2 = MathHelper.a(box.a);
        int j2 = MathHelper.c(box.d);
        int k2 = MathHelper.a(box.b);
        int l2 = MathHelper.c(box.e);
        int m2 = MathHelper.a(box.c);
        int n2 = MathHelper.c(box.f);
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (int o2 = i2; o2 < j2; ++o2) {
            for (int p2 = k2; p2 < l2; ++p2) {
                for (int q2 = m2; q2 < n2; ++q2) {
                    IBlockData blockState = this.a_(mutableBlockPos.d(o2, p2, q2));
                    if (blockState.u().c()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    default public int A(BlockPosition pos) {
        return this.c(pos, this.C_());
    }

    default public int c(BlockPosition pos, int ambientDarkness) {
        return pos.u() >= -30000000 && pos.w() >= -30000000 && pos.u() < 30000000 && pos.w() < 30000000 ? this.b(pos, ambientDarkness) : 15;
    }

    @Deprecated
    default public boolean f(int x2, int z2) {
        return this.b(SectionPosition.a(x2), SectionPosition.a(z2));
    }

    @Deprecated
    default public boolean B(BlockPosition pos) {
        return this.f(pos.u(), pos.w());
    }

    @Deprecated
    default public boolean a(BlockPosition min, BlockPosition max) {
        return this.a(min.u(), min.v(), min.w(), max.u(), max.v(), max.w());
    }

    @Deprecated
    default public boolean a(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        return maxY >= this.J_() && minY < this.al() && this.b(minX, minZ, maxX, maxZ);
    }

    @Deprecated
    default public boolean b(int minX, int minZ, int maxX, int maxZ) {
        int i2 = SectionPosition.a(minX);
        int j2 = SectionPosition.a(maxX);
        int k2 = SectionPosition.a(minZ);
        int l2 = SectionPosition.a(maxZ);
        for (int m2 = i2; m2 <= j2; ++m2) {
            for (int n2 = k2; n2 <= l2; ++n2) {
                if (this.b(m2, n2)) continue;
                return false;
            }
        }
        return true;
    }

    public IRegistryCustom I_();

    public FeatureFlagSet I();

    default public <T> HolderLookup<T> a(ResourceKey<? extends IRegistry<? extends T>> registryRef) {
        IRegistry registry = this.I_().d(registryRef);
        return registry.p().a(this.I());
    }
}

