/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityEnderPortal;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBlock;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class BlockEnderPortal
extends BlockTileEntity {
    public static final MapCodec<BlockEnderPortal> a = BlockEnderPortal.b(BlockEnderPortal::new);
    protected static final VoxelShape b = Block.a(0.0, 6.0, 0.0, 16.0, 12.0, 16.0);

    public MapCodec<BlockEnderPortal> a() {
        return a;
    }

    protected BlockEnderPortal(BlockBase.Info settings) {
        super(settings);
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityEnderPortal(pos, state);
    }

    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return b;
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(world, pos)).callEvent()) {
            return;
        }
        if (world instanceof WorldServer && entity.ct() && VoxelShapes.c(VoxelShapes.a(entity.cH().d(-pos.u(), -pos.v(), -pos.w())), state.j(world, pos), OperatorBoolean.i)) {
            ResourceKey<World> resourcekey = world.getTypeKey() == WorldDimension.d ? World.h : World.j;
            WorldServer worldserver = ((WorldServer)world).o().a(resourcekey);
            if (worldserver == null) {
                // empty if block
            }
            EntityPortalEnterEvent event = new EntityPortalEnterEvent((Entity)entity.getBukkitEntity(), new Location((org.bukkit.World)world.getWorld(), (double)pos.u(), (double)pos.v(), (double)pos.w()));
            world.getCraftServer().getPluginManager().callEvent((Event)event);
            if (entity instanceof EntityPlayer) {
                ((EntityPlayer)entity).changeDimension(worldserver, PlayerTeleportEvent.TeleportCause.END_PORTAL);
                return;
            }
            entity.b(worldserver);
        }
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, RandomSource random) {
        double d0 = (double)pos.u() + random.j();
        double d1 = (double)pos.v() + 0.8;
        double d2 = (double)pos.w() + random.j();
        world.a(Particles.ab, d0, d1, d2, 0.0, 0.0, 0.0);
    }

    @Override
    public ItemStack a(IWorldReader world, BlockPosition pos, IBlockData state) {
        return ItemStack.f;
    }

    @Override
    public boolean a(IBlockData state, FluidType fluid) {
        return false;
    }
}

