/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockPlant;
import net.minecraft.world.level.block.BlockStem;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockStemAttached
extends BlockPlant {
    public static final MapCodec<BlockStemAttached> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceKey.a(Registries.f).fieldOf("fruit").forGetter(block -> block.e), (App)ResourceKey.a(Registries.f).fieldOf("stem").forGetter(block -> block.f), (App)ResourceKey.a(Registries.F).fieldOf("seed").forGetter(block -> block.g), BlockStemAttached.u()).apply((Applicative)instance, BlockStemAttached::new));
    public static final BlockStateDirection b = BlockFacingHorizontal.aE;
    protected static final float c = 2.0f;
    private static final Map<EnumDirection, VoxelShape> d = Maps.newEnumMap((Map)ImmutableMap.of((Object)EnumDirection.d, (Object)Block.a(6.0, 0.0, 6.0, 10.0, 10.0, 16.0), (Object)EnumDirection.e, (Object)Block.a(0.0, 0.0, 6.0, 10.0, 10.0, 10.0), (Object)EnumDirection.c, (Object)Block.a(6.0, 0.0, 0.0, 10.0, 10.0, 10.0), (Object)EnumDirection.f, (Object)Block.a(6.0, 0.0, 6.0, 16.0, 10.0, 10.0)));
    private final ResourceKey<Block> e;
    private final ResourceKey<Block> f;
    private final ResourceKey<Item> g;

    @Override
    public MapCodec<BlockStemAttached> a() {
        return a;
    }

    protected BlockStemAttached(ResourceKey<Block> stemBlock, ResourceKey<Block> gourdBlock, ResourceKey<Item> pickBlockItem, BlockBase.Info settings) {
        super(settings);
        this.k((IBlockData)this.E.b().a(b, EnumDirection.c));
        this.f = stemBlock;
        this.e = gourdBlock;
        this.g = pickBlockItem;
    }

    @Override
    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return d.get(state.c(b));
    }

    @Override
    @Override
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        Optional<Block> optional;
        if (!neighborState.a(this.e) && direction == state.c(b) && (optional = world.I_().d(Registries.f).d(this.f)).isPresent()) {
            return (IBlockData)optional.get().o().b(BlockStem.c, 7);
        }
        return super.a(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    @Override
    protected boolean b(IBlockData floor, IBlockAccess world, BlockPosition pos) {
        return floor.a(Blocks.cC);
    }

    @Override
    @Override
    public ItemStack a(IWorldReader world, BlockPosition pos, IBlockData state) {
        return new ItemStack((IMaterial)DataFixUtils.orElse(world.I_().d(Registries.F).d(this.g), (Object)this));
    }

    @Override
    @Override
    public IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.a(b, rotation.a(state.c(b)));
    }

    @Override
    @Override
    public IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(b)));
    }

    @Override
    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{b});
    }
}

