/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyHalf;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_20_R3.CraftWorld;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;

public class BlockTrapdoor
extends BlockFacingHorizontal
implements IBlockWaterlogged {
    public static final MapCodec<BlockTrapdoor> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockSetType.a.fieldOf("block_set_type").forGetter(blocktrapdoor -> blocktrapdoor.m), BlockTrapdoor.u()).apply((Applicative)instance, BlockTrapdoor::new));
    public static final BlockStateBoolean b = BlockProperties.u;
    public static final BlockStateEnum<BlockPropertyHalf> c = BlockProperties.af;
    public static final BlockStateBoolean d = BlockProperties.w;
    public static final BlockStateBoolean e = BlockProperties.C;
    protected static final int f = 3;
    protected static final VoxelShape g = Block.a(0.0, 0.0, 0.0, 3.0, 16.0, 16.0);
    protected static final VoxelShape h = Block.a(13.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape i = Block.a(0.0, 0.0, 0.0, 16.0, 16.0, 3.0);
    protected static final VoxelShape j = Block.a(0.0, 0.0, 13.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape k = Block.a(0.0, 0.0, 0.0, 16.0, 3.0, 16.0);
    protected static final VoxelShape l = Block.a(0.0, 13.0, 0.0, 16.0, 16.0, 16.0);
    private final BlockSetType m;

    public MapCodec<? extends BlockTrapdoor> a() {
        return a;
    }

    protected BlockTrapdoor(BlockSetType type, BlockBase.Info settings) {
        super(settings.a(type.g()));
        this.m = type;
        this.k((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.E.b().a(BlockFacingHorizontal.aE, EnumDirection.c)).a(b, false)).a(c, BlockPropertyHalf.b)).a(d, false)).a(e, false));
    }

    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        if (!state.c(b).booleanValue()) {
            return state.c(c) == BlockPropertyHalf.a ? l : k;
        }
        switch (state.c(BlockFacingHorizontal.aE)) {
            default: {
                return j;
            }
            case d: {
                return i;
            }
            case e: {
                return h;
            }
            case f: 
        }
        return g;
    }

    @Override
    public boolean a(IBlockData state, IBlockAccess world, BlockPosition pos, PathMode type) {
        switch (type) {
            case a: {
                return state.c(b);
            }
            case b: {
                return state.c(e);
            }
            case c: {
                return state.c(b);
            }
        }
        return false;
    }

    @Override
    public EnumInteractionResult a(IBlockData state, World world, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hit) {
        if (!this.m.c()) {
            return EnumInteractionResult.d;
        }
        this.b(state, world, pos, player);
        return EnumInteractionResult.a(world.B);
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, Explosion explosion, BiConsumer<ItemStack, BlockPosition> stackMerger) {
        if (explosion.j() == Explosion.Effect.d && !world.y_() && this.m.d() && !state.c(d).booleanValue()) {
            this.b(state, world, pos, (EntityHuman)null);
        }
        super.a(state, world, pos, explosion, stackMerger);
    }

    private void b(IBlockData state, World world, BlockPosition pos, @Nullable EntityHuman player) {
        IBlockData iblockdata1 = (IBlockData)state.a(b);
        world.a(pos, iblockdata1, 2);
        if (iblockdata1.c(e).booleanValue()) {
            world.a(pos, FluidTypes.c, FluidTypes.c.a((IWorldReader)world));
        }
        this.a(player, world, pos, iblockdata1.c(b));
    }

    protected void a(@Nullable EntityHuman player, World world, BlockPosition pos, boolean open) {
        world.a(player, pos, open ? this.m.k() : this.m.j(), SoundCategory.e, 1.0f, world.F_().i() * 0.1f + 0.9f);
        world.a((Entity)player, open ? GameEvent.h : GameEvent.d, pos);
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, Block sourceBlock, BlockPosition sourcePos, boolean notify) {
        boolean flag1;
        if (!world.B && (flag1 = world.C(pos)) != state.c(d)) {
            CraftWorld bworld = world.getWorld();
            org.bukkit.block.Block bblock = bworld.getBlockAt(pos.u(), pos.v(), pos.w());
            int power = bblock.getBlockPower();
            int oldPower = state.c(b) != false ? 15 : 0;
            if (oldPower == 0 ^ power == 0 || sourceBlock.o().m()) {
                BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent(bblock, oldPower, power);
                world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
                boolean bl = flag1 = eventRedstone.getNewCurrent() > 0;
            }
            if (state.c(b) != flag1) {
                state = (IBlockData)state.a(b, flag1);
                this.a((EntityHuman)null, world, pos, flag1);
            }
            world.a(pos, (IBlockData)state.a(d, flag1), 2);
            if (state.c(e).booleanValue()) {
                world.a(pos, FluidTypes.c, FluidTypes.c.a((IWorldReader)world));
            }
        }
    }

    @Override
    public IBlockData a(BlockActionContext ctx) {
        IBlockData iblockdata = this.o();
        Fluid fluid = ctx.q().b_(ctx.a());
        EnumDirection enumdirection = ctx.k();
        iblockdata = !ctx.c() && enumdirection.o().d() ? (IBlockData)((IBlockData)iblockdata.a(BlockFacingHorizontal.aE, enumdirection)).a(c, ctx.l().d - (double)ctx.a().v() > 0.5 ? BlockPropertyHalf.a : BlockPropertyHalf.b) : (IBlockData)((IBlockData)iblockdata.a(BlockFacingHorizontal.aE, ctx.g().g())).a(c, enumdirection == EnumDirection.b ? BlockPropertyHalf.b : BlockPropertyHalf.a);
        if (ctx.q().C(ctx.a())) {
            iblockdata = (IBlockData)((IBlockData)iblockdata.a(b, true)).a(d, true);
        }
        return (IBlockData)iblockdata.a(e, fluid.a() == FluidTypes.c);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(BlockFacingHorizontal.aE, b, c, d, e);
    }

    @Override
    public Fluid c_(IBlockData state) {
        return state.c(e) != false ? FluidTypes.c.a(false) : super.c_(state);
    }

    @Override
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        if (state.c(e).booleanValue()) {
            world.a(pos, FluidTypes.c, FluidTypes.c.a(world));
        }
        return super.a(state, direction, neighborState, world, pos, neighborPos);
    }

    protected BlockSetType g() {
        return this.m;
    }
}

