/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;

public class DecoratedPotBlock
extends BlockTileEntity
implements IBlockWaterlogged {
    public static final MapCodec<DecoratedPotBlock> a = DecoratedPotBlock.b(DecoratedPotBlock::new);
    public static final MinecraftKey b = new MinecraftKey("sherds");
    private static final VoxelShape d = Block.a(1.0, 0.0, 1.0, 15.0, 16.0, 15.0);
    private static final BlockStateDirection e = BlockProperties.R;
    public static final BlockStateBoolean c = BlockProperties.bw;
    private static final BlockStateBoolean f = BlockProperties.C;

    public MapCodec<DecoratedPotBlock> a() {
        return a;
    }

    protected DecoratedPotBlock(BlockBase.Info settings) {
        super(settings);
        this.k((IBlockData)((IBlockData)((IBlockData)this.E.b().a(e, EnumDirection.c)).a(f, false)).a(c, false));
    }

    @Override
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        if (state.c(f).booleanValue()) {
            world.a(pos, FluidTypes.c, FluidTypes.c.a(world));
        }
        return super.a(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public IBlockData a(BlockActionContext ctx) {
        Fluid fluid = ctx.q().b_(ctx.a());
        return (IBlockData)((IBlockData)((IBlockData)this.o().a(e, ctx.g())).a(f, fluid.a() == FluidTypes.c)).a(c, false);
    }

    @Override
    public EnumInteractionResult a(IBlockData state, World world, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hit) {
        TileEntity tileentity = world.c_(pos);
        if (tileentity instanceof DecoratedPotBlockEntity) {
            DecoratedPotBlockEntity decoratedpotblockentity = (DecoratedPotBlockEntity)tileentity;
            if (world.B) {
                return EnumInteractionResult.b;
            }
            ItemStack itemstack = player.b(hand);
            ItemStack itemstack1 = decoratedpotblockentity.x();
            if (!itemstack.b() && (itemstack1.b() || ItemStack.c(itemstack1, itemstack) && itemstack1.L() < itemstack1.g())) {
                float f2;
                ItemStack itemstack2;
                decoratedpotblockentity.a(DecoratedPotBlockEntity.b.a);
                player.b(StatisticList.c.b(itemstack.d()));
                ItemStack itemStack = itemstack2 = player.f() ? itemstack.c(1) : itemstack.a(1);
                if (decoratedpotblockentity.ai_()) {
                    decoratedpotblockentity.b(itemstack2);
                    f2 = (float)itemstack2.L() / (float)itemstack2.g();
                } else {
                    itemstack1.g(1);
                    f2 = (float)itemstack1.L() / (float)itemstack1.g();
                }
                world.a((EntityHuman)null, pos, SoundEffects.fV, SoundCategory.e, 1.0f, 0.7f + 0.5f * f2);
                if (world instanceof WorldServer) {
                    WorldServer worldserver = (WorldServer)world;
                    worldserver.a(Particles.aU, (double)pos.u() + 0.5, (double)pos.v() + 1.2, (double)pos.w() + 0.5, 7, 0.0, 0.0, 0.0, 0.0);
                }
                decoratedpotblockentity.e();
            } else {
                world.a((EntityHuman)null, pos, SoundEffects.fW, SoundCategory.e, 1.0f, 1.0f);
                decoratedpotblockentity.a(DecoratedPotBlockEntity.b.b);
            }
            world.a((Entity)player, GameEvent.c, pos);
            return EnumInteractionResult.a;
        }
        return EnumInteractionResult.d;
    }

    @Override
    public void a(World world, BlockPosition pos, IBlockData state, @Nullable EntityLiving placer, ItemStack itemStack) {
        if (world.B) {
            world.a(pos, TileEntityTypes.O).ifPresent(decoratedpotblockentity -> decoratedpotblockentity.a(itemStack));
        }
    }

    @Override
    public boolean a(IBlockData state, IBlockAccess world, BlockPosition pos, PathMode type) {
        return false;
    }

    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return d;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(e, f, c);
    }

    @Override
    @Nullable
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new DecoratedPotBlockEntity(pos, state);
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, IBlockData newState, boolean moved) {
        InventoryUtils.a(state, newState, world, pos);
        super.a(state, world, pos, newState, moved);
    }

    @Override
    public List<ItemStack> a(IBlockData state, LootParams.a builder) {
        TileEntity tileentity = builder.b(LootContextParameters.h);
        if (tileentity instanceof DecoratedPotBlockEntity) {
            DecoratedPotBlockEntity decoratedpotblockentity = (DecoratedPotBlockEntity)tileentity;
            builder.a(b, (Consumer<ItemStack> consumer) -> decoratedpotblockentity.m().a().map(Item::am_).forEach(consumer));
        }
        return super.a(state, builder);
    }

    @Override
    public IBlockData a(World world, BlockPosition pos, IBlockData state, EntityHuman player) {
        ItemStack itemstack = player.eT();
        IBlockData iblockdata1 = state;
        if (itemstack.a(TagsItem.aT) && !EnchantmentManager.f(itemstack)) {
            iblockdata1 = (IBlockData)state.a(c, true);
            world.a(pos, iblockdata1, 4);
        }
        return super.a(world, pos, iblockdata1, player);
    }

    @Override
    public Fluid c_(IBlockData state) {
        return state.c(f) != false ? FluidTypes.c.a(false) : super.c_(state);
    }

    @Override
    public SoundEffectType m(IBlockData state) {
        return state.c(c) != false ? SoundEffectType.bc : SoundEffectType.bb;
    }

    @Override
    public void a(ItemStack stack, @Nullable IBlockAccess world, List<IChatBaseComponent> tooltip, TooltipFlag options) {
        super.a(stack, world, tooltip, options);
        DecoratedPotBlockEntity.Decoration decoratedpotblockentity_decoration = DecoratedPotBlockEntity.Decoration.b(ItemBlock.a(stack));
        if (!decoratedpotblockentity_decoration.equals(DecoratedPotBlockEntity.Decoration.a)) {
            tooltip.add(CommonComponents.a);
            Stream.of(decoratedpotblockentity_decoration.e(), decoratedpotblockentity_decoration.c(), decoratedpotblockentity_decoration.d(), decoratedpotblockentity_decoration.b()).forEach(item -> tooltip.add(new ItemStack((IMaterial)item, 1).y().e().a(EnumChatFormat.h)));
        }
    }

    @Override
    public void a(World world, IBlockData state, MovingObjectPositionBlock hit, IProjectile projectile) {
        BlockPosition blockposition = hit.a();
        if (!world.B && projectile.a(world, blockposition) && projectile.b(world)) {
            if (!CraftEventFactory.callEntityChangeBlockEvent(projectile, blockposition, this.c_(state).g())) {
                return;
            }
            world.a(blockposition, (IBlockData)state.a(c, true), 4);
            world.a(blockposition, true, projectile);
        }
    }

    @Override
    public ItemStack a(IWorldReader world, BlockPosition pos, IBlockData state) {
        TileEntity tileentity = world.c_(pos);
        if (tileentity instanceof DecoratedPotBlockEntity) {
            DecoratedPotBlockEntity decoratedpotblockentity = (DecoratedPotBlockEntity)tileentity;
            return decoratedpotblockentity.w();
        }
        return super.a(world, pos, state);
    }

    @Override
    public boolean d_(IBlockData state) {
        return true;
    }

    @Override
    public int a(IBlockData state, World world, BlockPosition pos) {
        return Container.a(world.c_(pos));
    }
}

