/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.monster.EntityRavager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCrops;
import net.minecraft.world.level.block.BlockTallPlant;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.entity.Entity;

public class PitcherCropBlock
extends BlockTallPlant
implements IBlockFragilePlantElement {
    public static final MapCodec<PitcherCropBlock> c = PitcherCropBlock.b(PitcherCropBlock::new);
    public static final BlockStateInteger d = BlockProperties.at;
    public static final int e = 4;
    private static final int f = 3;
    private static final int g = 1;
    private static final VoxelShape h = Block.a(3.0, 0.0, 3.0, 13.0, 15.0, 13.0);
    private static final VoxelShape i = Block.a(3.0, -1.0, 3.0, 13.0, 16.0, 13.0);
    private static final VoxelShape j = Block.a(5.0, -1.0, 5.0, 11.0, 3.0, 11.0);
    private static final VoxelShape k = Block.a(3.0, -1.0, 3.0, 13.0, 5.0, 13.0);
    private static final VoxelShape[] l = new VoxelShape[]{Block.a(3.0, 0.0, 3.0, 13.0, 11.0, 13.0), h};
    private static final VoxelShape[] m = new VoxelShape[]{j, Block.a(3.0, -1.0, 3.0, 13.0, 14.0, 13.0), i, i, i};

    public MapCodec<PitcherCropBlock> a() {
        return c;
    }

    public PitcherCropBlock(BlockBase.Info settings) {
        super(settings);
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext ctx) {
        return this.o();
    }

    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return state.c(BlockTallPlant.b) == BlockPropertyDoubleBlockHalf.a ? l[Math.min(Math.abs(4 - (state.c(d) + 1)), l.length - 1)] : m[state.c(d)];
    }

    @Override
    public VoxelShape b(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        if (state.c(d) == 0) {
            return j;
        }
        return state.c(BlockTallPlant.b) == BlockPropertyDoubleBlockHalf.b ? k : super.b(state, world, pos, context);
    }

    @Override
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        if (PitcherCropBlock.b(state.c(d))) {
            return super.a(state, direction, neighborState, world, pos, neighborPos);
        }
        return state.a(world, pos) ? state : Blocks.a.o();
    }

    @Override
    public boolean a(IBlockData state, IWorldReader world, BlockPosition pos) {
        return (!PitcherCropBlock.h(state) || PitcherCropBlock.b(world, pos)) && super.a(state, world, pos);
    }

    @Override
    protected boolean b(IBlockData floor, IBlockAccess world, BlockPosition pos) {
        return floor.a(Blocks.cC);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{d});
        super.a(builder);
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(world, pos)).callEvent()) {
            return;
        }
        if (entity instanceof EntityRavager && world.Z().b(GameRules.c)) {
            world.a(pos, true, entity);
        }
        super.a(state, world, pos, entity);
    }

    @Override
    public boolean a(IBlockData state, BlockActionContext context) {
        return false;
    }

    @Override
    public void a(World world, BlockPosition pos, IBlockData state, EntityLiving placer, ItemStack itemStack) {
    }

    @Override
    public boolean e_(IBlockData state) {
        return state.c(BlockTallPlant.b) == BlockPropertyDoubleBlockHalf.b && !this.n(state);
    }

    @Override
    public void b(IBlockData state, WorldServer world, BlockPosition pos, RandomSource random) {
        boolean bl;
        float f2 = BlockCrops.a(this, world, pos);
        boolean bl2 = bl = (double)random.i() < (double)world.spigotConfig.pitcherPlantModifier / (100.0 * (Math.floor(25.0f / f2) + 1.0));
        if (bl) {
            this.a(world, state, pos, 1);
        }
    }

    private void a(WorldServer world, IBlockData state, BlockPosition pos, int amount) {
        int i2 = Math.min(state.c(d) + amount, 4);
        if (this.a((IWorldReader)world, pos, state, i2)) {
            IBlockData blockState = (IBlockData)state.a(d, i2);
            if (!CraftEventFactory.handleBlockGrowEvent(world, pos, blockState, 2)) {
                return;
            }
            if (PitcherCropBlock.b(i2)) {
                world.a(pos.c(), (IBlockData)blockState.a(BlockTallPlant.b, BlockPropertyDoubleBlockHalf.a), 3);
            }
        }
    }

    private static boolean a(IWorldReader world, BlockPosition pos) {
        IBlockData blockState = world.a_(pos);
        return blockState.i() || blockState.a(Blocks.kB);
    }

    private static boolean b(IWorldReader world, BlockPosition pos) {
        return BlockCrops.a(world, pos);
    }

    private static boolean h(IBlockData state) {
        return state.a(Blocks.kB) && state.c(BlockTallPlant.b) == BlockPropertyDoubleBlockHalf.b;
    }

    private static boolean b(int age) {
        return age >= 3;
    }

    private boolean a(IWorldReader world, BlockPosition pos, IBlockData state, int age) {
        return !this.n(state) && PitcherCropBlock.b(world, pos) && (!PitcherCropBlock.b(age) || PitcherCropBlock.a(world, pos.c()));
    }

    private boolean n(IBlockData state) {
        return state.c(d) >= 4;
    }

    @Nullable
    private a d(IWorldReader world, BlockPosition pos, IBlockData state) {
        if (PitcherCropBlock.h(state)) {
            return new a(pos, state);
        }
        BlockPosition blockPos = pos.d();
        IBlockData blockState = world.a_(blockPos);
        return PitcherCropBlock.h(blockState) ? new a(blockPos, blockState) : null;
    }

    @Override
    public boolean b(IWorldReader world, BlockPosition pos, IBlockData state) {
        a posAndState = this.d(world, pos, state);
        return posAndState != null && this.a(world, posAndState.a, posAndState.b, posAndState.b.c(d) + 1);
    }

    @Override
    public boolean a(World world, RandomSource random, BlockPosition pos, IBlockData state) {
        return true;
    }

    @Override
    public void a(WorldServer world, RandomSource random, BlockPosition pos, IBlockData state) {
        a posAndState = this.d(world, pos, state);
        if (posAndState != null) {
            this.a(world, posAndState.b, posAndState.a, 1);
        }
    }

    record a(BlockPosition a, IBlockData b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "pos;state", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "pos;state", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "pos;state", "a", "b"}, this, o2);
        }
    }
}

