/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.IWorldInventory;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.AutoRecipeOutput;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.RecipeCooking;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFurnace;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntityContainer;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftItemType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockExpEvent;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.FurnaceExtractEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.event.inventory.FurnaceStartSmeltEvent;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.ItemStack;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.protocol.PcaSyncProtocol;
import top.leavesmc.leaves.util.ArrayConstants;

public abstract class TileEntityFurnace
extends TileEntityContainer
implements IWorldInventory,
RecipeCraftingHolder,
AutoRecipeOutput {
    protected static final int c = 0;
    protected static final int d = 1;
    protected static final int e = 2;
    public static final int f = 0;
    private static final int[] r = ArrayConstants.zeroSingletonIntArray;
    private static final int[] s = new int[]{2, 1};
    private static final int[] t = new int[]{1};
    public static final int g = 1;
    public static final int h = 2;
    public static final int i = 3;
    public static final int j = 4;
    public static final int k = 200;
    public static final int l = 2;
    protected NonNullList<net.minecraft.world.item.ItemStack> m;
    public int u;
    int v;
    public double cookSpeedMultiplier = 1.0;
    public int w;
    public int x;
    protected final IContainerProperties n;
    public final Object2IntOpenHashMap<MinecraftKey> y;
    private final CraftingManager.a<IInventory, ? extends RecipeCooking> z;
    public final Recipes<? extends RecipeCooking> recipeType;
    private static Map<Item, Integer> cachedBurnDurations = null;
    private int maxStack = 64;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();

    protected TileEntityFurnace(TileEntityTypes<?> blockEntityType, BlockPosition pos, IBlockData state, Recipes<? extends RecipeCooking> recipeType) {
        super(blockEntityType, pos, state);
        this.m = NonNullList.a(3, net.minecraft.world.item.ItemStack.f);
        this.n = new IContainerProperties(){

            @Override
            public int a(int index) {
                switch (index) {
                    case 0: {
                        return TileEntityFurnace.this.u;
                    }
                    case 1: {
                        return TileEntityFurnace.this.v;
                    }
                    case 2: {
                        return TileEntityFurnace.this.w;
                    }
                    case 3: {
                        return TileEntityFurnace.this.x;
                    }
                }
                return 0;
            }

            @Override
            public void a(int index, int value) {
                switch (index) {
                    case 0: {
                        TileEntityFurnace.this.u = value;
                        break;
                    }
                    case 1: {
                        TileEntityFurnace.this.v = value;
                        break;
                    }
                    case 2: {
                        TileEntityFurnace.this.w = value;
                        break;
                    }
                    case 3: {
                        TileEntityFurnace.this.x = value;
                    }
                }
            }

            @Override
            public int a() {
                return 4;
            }
        };
        this.y = new Object2IntOpenHashMap();
        this.z = CraftingManager.b(recipeType);
        this.recipeType = recipeType;
    }

    public static Map<Item, Integer> f() {
        if (cachedBurnDurations != null) {
            return cachedBurnDurations;
        }
        LinkedHashMap map = Maps.newLinkedHashMap();
        TileEntityFurnace.a((Map<Item, Integer>)map, Items.qx, 20000);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.iB, 16000);
        TileEntityFurnace.a((Map<Item, Integer>)map, Items.sd, 2400);
        TileEntityFurnace.a((Map<Item, Integer>)map, Items.ot, 1600);
        TileEntityFurnace.a((Map<Item, Integer>)map, Items.ou, 1600);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.r, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.C, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.b, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.w, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.i, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.hU, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.j, 150);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.jC, 150);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.n, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.m, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.k, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.l, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.aY, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.cl, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.cm, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.oa, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.dT, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.cv, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.gV, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.cA, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.gZ, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.E, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Items.or, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Items.qS, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.cO, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.ap, 200);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.aE, 800);
        TileEntityFurnace.a((Map<Item, Integer>)map, Items.oJ, 200);
        TileEntityFurnace.a((Map<Item, Integer>)map, Items.oI, 200);
        TileEntityFurnace.a((Map<Item, Integer>)map, Items.oM, 200);
        TileEntityFurnace.a((Map<Item, Integer>)map, Items.oL, 200);
        TileEntityFurnace.a((Map<Item, Integer>)map, Items.oK, 200);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.h, 200);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.am, 1200);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.a, 100);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.d, 100);
        TileEntityFurnace.a((Map<Item, Integer>)map, Items.pm, 100);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.p, 100);
        TileEntityFurnace.a((Map<Item, Integer>)map, Items.pn, 100);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.g, 67);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.me, 4001);
        TileEntityFurnace.a((Map<Item, Integer>)map, Items.vM, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.mZ, 50);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.bv, 100);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.nS, 50);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.nT, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.nU, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.nX, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.nY, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.ob, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.pc, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.sy, 100);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.sz, 100);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.ac, 300);
        cachedBurnDurations = ImmutableMap.copyOf((Map)map);
        return cachedBurnDurations;
    }

    @Override
    public List<net.minecraft.world.item.ItemStack> getContents() {
        return this.m;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public int ak_() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    public Object2IntOpenHashMap<MinecraftKey> getRecipesUsed() {
        return this.y;
    }

    private static boolean b(Item item) {
        return item.j().a(TagsItem.ag);
    }

    private static void a(Map<Item, Integer> fuelTimes, TagKey<Item> tag, int fuelTime) {
        for (Holder<Item> holder : BuiltInRegistries.h.c(tag)) {
            if (TileEntityFurnace.b(holder.a())) continue;
            fuelTimes.put(holder.a(), fuelTime);
        }
    }

    private static void a(Map<Item, Integer> fuelTimes, IMaterial item, int fuelTime) {
        Item item1 = item.k();
        if (TileEntityFurnace.b(item1)) {
            if (SharedConstants.aW) {
                throw SystemUtils.b(new IllegalStateException("A developer tried to explicitly make fire resistant item " + item1.m(null).getString() + " a furnace fuel. That will not work!"));
            }
        } else {
            fuelTimes.put(item1, fuelTime);
        }
    }

    private boolean g() {
        return this.u > 0;
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.m = NonNullList.a(this.b(), net.minecraft.world.item.ItemStack.f);
        ContainerUtil.b(nbt, this.m);
        this.u = nbt.g("BurnTime");
        this.w = nbt.g("CookTime");
        this.x = nbt.g("CookTimeTotal");
        this.v = this.a(this.m.get(1));
        NBTTagCompound nbttagcompound1 = nbt.p("RecipesUsed");
        for (String s2 : nbttagcompound1.e()) {
            MinecraftKey resourceLocation = MinecraftKey.a(s2);
            if (resourceLocation == null) continue;
            this.y.put((Object)resourceLocation, nbttagcompound1.h(s2));
        }
        if (nbt.e("Paper.CookSpeedMultiplier")) {
            this.cookSpeedMultiplier = nbt.k("Paper.CookSpeedMultiplier");
        }
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("BurnTime", (short)this.u);
        nbt.a("CookTime", (short)this.w);
        nbt.a("CookTimeTotal", (short)this.x);
        nbt.a("Paper.CookSpeedMultiplier", this.cookSpeedMultiplier);
        ContainerUtil.a(nbt, this.m);
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        this.y.forEach((minecraftkey, integer) -> nbttagcompound1.a(minecraftkey.toString(), (int)integer));
        nbt.a("RecipesUsed", nbttagcompound1);
    }

    public static void a(World world, BlockPosition pos, IBlockData state, TileEntityFurnace blockEntity) {
        boolean flag3;
        boolean flag = blockEntity.g();
        boolean flag1 = false;
        if (blockEntity.g()) {
            --blockEntity.u;
        }
        net.minecraft.world.item.ItemStack itemstack = blockEntity.m.get(1);
        boolean flag2 = !blockEntity.m.get(0).b();
        boolean bl = flag3 = !itemstack.b();
        if (!(blockEntity.g() || flag3 && flag2)) {
            if (!blockEntity.g() && blockEntity.w > 0) {
                blockEntity.w = MathHelper.a(blockEntity.w - 2, 0, blockEntity.x);
            }
        } else {
            RecipeHolder recipeholder = flag2 ? (RecipeHolder)blockEntity.z.a(blockEntity, world).orElse(null) : null;
            int i2 = blockEntity.ak_();
            if (!blockEntity.g() && TileEntityFurnace.a(world.I_(), recipeholder, blockEntity.m, i2)) {
                CraftItemStack fuel = CraftItemStack.asCraftMirror(itemstack);
                FurnaceBurnEvent furnaceBurnEvent = new FurnaceBurnEvent((Block)CraftBlock.at(world, pos), (ItemStack)fuel, blockEntity.a(itemstack));
                world.getCraftServer().getPluginManager().callEvent((Event)furnaceBurnEvent);
                if (furnaceBurnEvent.isCancelled()) {
                    return;
                }
                blockEntity.v = blockEntity.u = furnaceBurnEvent.getBurnTime();
                if (blockEntity.g() && furnaceBurnEvent.isBurning()) {
                    flag1 = true;
                    if (flag3 && furnaceBurnEvent.willConsumeFuel()) {
                        Item item = itemstack.d();
                        itemstack.h(1);
                        if (itemstack.b()) {
                            Item item1 = item.s();
                            blockEntity.m.set(1, item1 == null ? net.minecraft.world.item.ItemStack.f : new net.minecraft.world.item.ItemStack(item1));
                        }
                    }
                }
            }
            if (blockEntity.g() && TileEntityFurnace.a(world.I_(), recipeholder, blockEntity.m, i2)) {
                if (recipeholder != null && blockEntity.w == 0) {
                    CraftItemStack source = CraftItemStack.asCraftMirror(blockEntity.m.get(0));
                    CookingRecipe recipe = (CookingRecipe)recipeholder.toBukkitRecipe();
                    FurnaceStartSmeltEvent event = new FurnaceStartSmeltEvent((Block)CraftBlock.at(world, pos), (ItemStack)source, recipe, TileEntityFurnace.getTotalCookTime(world, blockEntity.recipeType, blockEntity, blockEntity.cookSpeedMultiplier));
                    world.getCraftServer().getPluginManager().callEvent((Event)event);
                    blockEntity.x = event.getTotalCookTime();
                }
                ++blockEntity.w;
                if (blockEntity.w >= blockEntity.x) {
                    blockEntity.w = 0;
                    blockEntity.x = TileEntityFurnace.getTotalCookTime(world, blockEntity.recipeType, blockEntity, blockEntity.cookSpeedMultiplier);
                    if (TileEntityFurnace.burn(blockEntity.o, blockEntity.p, world.I_(), recipeholder, blockEntity.m, i2)) {
                        blockEntity.a(recipeholder);
                    }
                    flag1 = true;
                }
            } else {
                blockEntity.w = 0;
            }
        }
        if (flag != blockEntity.g()) {
            flag1 = true;
            state = (IBlockData)state.a(BlockFurnace.b, blockEntity.g());
            world.a(pos, state, 3);
        }
        if (flag1) {
            TileEntityFurnace.a(world, pos, state);
        }
    }

    private static boolean a(IRegistryCustom registryManager, @Nullable RecipeHolder<?> recipe, NonNullList<net.minecraft.world.item.ItemStack> slots, int count) {
        if (!slots.get(0).b() && recipe != null) {
            net.minecraft.world.item.ItemStack itemstack = recipe.b().a(registryManager);
            if (itemstack.b()) {
                return false;
            }
            net.minecraft.world.item.ItemStack itemstack1 = slots.get(2);
            return itemstack1.b() ? true : (!net.minecraft.world.item.ItemStack.b(itemstack1, itemstack) ? false : (itemstack1.L() < count && itemstack1.L() < itemstack1.g() ? true : itemstack1.L() < itemstack.g()));
        }
        return false;
    }

    private static boolean burn(World world, BlockPosition blockposition, IRegistryCustom iregistrycustom, @Nullable RecipeHolder<?> recipeholder, NonNullList<net.minecraft.world.item.ItemStack> nonnulllist, int i2) {
        if (recipeholder != null && TileEntityFurnace.a(iregistrycustom, recipeholder, nonnulllist, i2)) {
            net.minecraft.world.item.ItemStack itemstack = nonnulllist.get(0);
            net.minecraft.world.item.ItemStack itemstack1 = recipeholder.b().a(iregistrycustom);
            net.minecraft.world.item.ItemStack itemstack2 = nonnulllist.get(2);
            CraftItemStack source = CraftItemStack.asCraftMirror(itemstack);
            ItemStack result = CraftItemStack.asBukkitCopy(itemstack1);
            FurnaceSmeltEvent furnaceSmeltEvent = new FurnaceSmeltEvent((Block)CraftBlock.at(world, blockposition), (ItemStack)source, result, (CookingRecipe)recipeholder.toBukkitRecipe());
            world.getCraftServer().getPluginManager().callEvent((Event)furnaceSmeltEvent);
            if (furnaceSmeltEvent.isCancelled()) {
                return false;
            }
            result = furnaceSmeltEvent.getResult();
            itemstack1 = CraftItemStack.asNMSCopy(result);
            if (!itemstack1.b()) {
                if (itemstack2.b()) {
                    nonnulllist.set(2, itemstack1.p());
                } else if (CraftItemStack.asCraftMirror(itemstack2).isSimilar(result)) {
                    itemstack2.g(itemstack1.L());
                } else {
                    return false;
                }
            }
            if (itemstack.a(Blocks.aP.k()) && !nonnulllist.get(1).b() && nonnulllist.get(1).a(Items.qv)) {
                nonnulllist.set(1, new net.minecraft.world.item.ItemStack(Items.qw));
            }
            itemstack.h(1);
            return true;
        }
        return false;
    }

    protected int a(net.minecraft.world.item.ItemStack fuel) {
        if (fuel.b()) {
            return 0;
        }
        Item item = fuel.d();
        return TileEntityFurnace.f().getOrDefault(item, 0);
    }

    public static int getTotalCookTime(@Nullable World world, Recipes<? extends RecipeCooking> recipeType, TileEntityFurnace furnace, double cookSpeedMultiplier) {
        int cookTime = world != null ? furnace.z.a(furnace, world).map(holder -> ((RecipeCooking)holder.b()).d()).orElse(200) : MinecraftServer.getServer().aG().a(recipeType, furnace, world).map(holder -> ((RecipeCooking)holder.b()).d()).orElse(200);
        return (int)Math.ceil((double)cookTime / cookSpeedMultiplier);
    }

    public static boolean b(net.minecraft.world.item.ItemStack stack) {
        return TileEntityFurnace.f().containsKey(stack.d());
    }

    @Override
    public int[] a(EnumDirection side) {
        return side == EnumDirection.a ? s : (side == EnumDirection.b ? r : t);
    }

    @Override
    public boolean a(int slot, net.minecraft.world.item.ItemStack stack, @Nullable EnumDirection dir) {
        return this.b(slot, stack);
    }

    @Override
    public boolean b(int slot, net.minecraft.world.item.ItemStack stack, EnumDirection dir) {
        return dir == EnumDirection.a && slot == 1 ? stack.a(Items.qw) || stack.a(Items.qv) : true;
    }

    @Override
    public int b() {
        return this.m.size();
    }

    @Override
    public boolean ai_() {
        net.minecraft.world.item.ItemStack itemstack;
        Iterator iterator = this.m.iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while ((itemstack = (net.minecraft.world.item.ItemStack)iterator.next()).b());
        return false;
    }

    @Override
    public net.minecraft.world.item.ItemStack a(int slot) {
        return this.m.get(slot);
    }

    @Override
    public net.minecraft.world.item.ItemStack a(int slot, int amount) {
        return ContainerUtil.a(this.m, slot, amount);
    }

    @Override
    public net.minecraft.world.item.ItemStack b(int slot) {
        return ContainerUtil.a(this.m, slot);
    }

    @Override
    public void a(int slot, net.minecraft.world.item.ItemStack stack) {
        net.minecraft.world.item.ItemStack itemstack1 = this.m.get(slot);
        boolean flag = !stack.b() && net.minecraft.world.item.ItemStack.c(itemstack1, stack);
        this.m.set(slot, stack);
        if (stack.L() > this.ak_()) {
            stack.f(this.ak_());
        }
        if (slot == 0 && !flag) {
            this.x = TileEntityFurnace.getTotalCookTime(this.o, this.recipeType, this, this.cookSpeedMultiplier);
            this.w = 0;
            this.e();
        }
    }

    @Override
    public void e() {
        super.e();
        if (LeavesConfig.pcaSyncProtocol) {
            PcaSyncProtocol.syncBlockEntityToClient(this);
        }
    }

    @Override
    public boolean a(EntityHuman player) {
        return IInventory.a(this, player);
    }

    @Override
    public boolean b(int slot, net.minecraft.world.item.ItemStack stack) {
        if (slot == 2) {
            return false;
        }
        if (slot != 1) {
            return true;
        }
        net.minecraft.world.item.ItemStack itemstack1 = this.m.get(1);
        return TileEntityFurnace.b(stack) || stack.a(Items.qv) && !itemstack1.a(Items.qv);
    }

    @Override
    public void a() {
        this.m.clear();
    }

    @Override
    public void a(@Nullable RecipeHolder<?> recipe) {
        if (recipe != null) {
            MinecraftKey minecraftkey = recipe.a();
            this.y.addTo((Object)minecraftkey, 1);
        }
    }

    @Override
    @Nullable
    public RecipeHolder<?> d() {
        return null;
    }

    @Override
    public void a(EntityHuman player, List<net.minecraft.world.item.ItemStack> ingredients) {
    }

    public void awardUsedRecipesAndPopExperience(EntityPlayer entityplayer, net.minecraft.world.item.ItemStack itemstack, int amount) {
        List<RecipeHolder<?>> list = this.getRecipesToAwardAndPopExperience(entityplayer.z(), entityplayer.dk(), this.p, entityplayer, itemstack, amount);
        entityplayer.a((Collection<RecipeHolder<?>>)list);
        for (RecipeHolder<?> recipeholder : list) {
            if (recipeholder == null) continue;
            entityplayer.a(recipeholder, this.m);
        }
        this.y.clear();
    }

    public List<RecipeHolder<?>> a(WorldServer world, Vec3D pos) {
        return this.getRecipesToAwardAndPopExperience(world, pos, this.p, null, null, 0);
    }

    public List<RecipeHolder<?>> getRecipesToAwardAndPopExperience(WorldServer worldserver, Vec3D vec3d, BlockPosition blockposition, EntityPlayer entityplayer, net.minecraft.world.item.ItemStack itemstack, int amount) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.y.object2IntEntrySet()) {
            worldserver.r().a((MinecraftKey)entry.getKey()).ifPresent(recipeholder -> {
                if (!(recipeholder.b() instanceof RecipeCooking)) {
                    return;
                }
                list.add(recipeholder);
                TileEntityFurnace.createExperience(worldserver, vec3d, entry.getIntValue(), ((RecipeCooking)recipeholder.b()).b(), blockposition, entityplayer, itemstack, amount);
            });
        }
        return list;
    }

    private static void createExperience(WorldServer worldserver, Vec3D vec3d, int i2, float f2, BlockPosition blockposition, EntityHuman entityhuman, net.minecraft.world.item.ItemStack itemstack, int amount) {
        int j2 = MathHelper.d((float)i2 * f2);
        float f1 = MathHelper.h((float)i2 * f2);
        if (f1 != 0.0f && Math.random() < (double)f1) {
            ++j2;
        }
        Object event = amount != 0 ? new FurnaceExtractEvent((Player)entityhuman.getBukkitEntity(), (Block)CraftBlock.at(worldserver, blockposition), CraftItemType.minecraftToBukkit(itemstack.d()), amount, j2) : new BlockExpEvent((Block)CraftBlock.at(worldserver, blockposition), j2);
        worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
        j2 = event.getExpToDrop();
        EntityExperienceOrb.award(worldserver, vec3d, j2, ExperienceOrb.SpawnReason.FURNACE, entityhuman);
    }

    @Override
    public void a(AutoRecipeStackManager finder) {
        finder.b(this.m.get(0));
        finder.b(this.m.get(2));
    }
}

