/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.trialspawner.PlayerDetector;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawner;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;

public class TrialSpawnerData {
    public static final String a = "spawn_data";
    private static final String n = "next_mob_spawns_at";
    public static MapCodec<TrialSpawnerData> b = RecordCodecBuilder.mapCodec(instance -> instance.group((App)UUIDUtil.b.optionalFieldOf("registered_players", (Object)Sets.newHashSet()).forGetter(data -> data.c), (App)UUIDUtil.b.optionalFieldOf("current_mobs", (Object)Sets.newHashSet()).forGetter(data -> data.d), (App)Codec.LONG.optionalFieldOf("cooldown_ends_at", (Object)0L).forGetter(data -> data.e), (App)Codec.LONG.optionalFieldOf(n, (Object)0L).forGetter(data -> data.f), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("total_mobs_spawned", (Object)0).forGetter(data -> data.g), (App)MobSpawnerData.b.optionalFieldOf(a).forGetter(data -> data.h), (App)MinecraftKey.a.optionalFieldOf("ejecting_loot_table").forGetter(data -> data.i)).apply((Applicative)instance, TrialSpawnerData::new));
    protected final Set<UUID> c = new HashSet<UUID>();
    protected final Set<UUID> d = new HashSet<UUID>();
    public long e;
    protected long f;
    protected int g;
    protected Optional<MobSpawnerData> h;
    protected Optional<MinecraftKey> i;
    protected SimpleWeightedRandomList<MobSpawnerData> j;
    @Nullable
    protected Entity k;
    protected double l;
    protected double m;

    public TrialSpawnerData() {
        this(Collections.emptySet(), Collections.emptySet(), 0L, 0L, 0, Optional.empty(), Optional.empty());
    }

    public TrialSpawnerData(Set<UUID> players, Set<UUID> spawnedMobsAlive, long cooldownEnd, long nextMobSpawnsAt, int totalSpawnedMobs, Optional<MobSpawnerData> spawnData, Optional<MinecraftKey> rewardLootTable) {
        this.c.addAll(players);
        this.d.addAll(spawnedMobsAlive);
        this.e = cooldownEnd;
        this.f = nextMobSpawnsAt;
        this.g = totalSpawnedMobs;
        this.h = spawnData;
        this.i = rewardLootTable;
    }

    public void a(TrialSpawnerConfig config) {
        SimpleWeightedRandomList<MobSpawnerData> simpleWeightedRandomList = config.i();
        this.j = simpleWeightedRandomList.d() ? SimpleWeightedRandomList.a(this.h.orElseGet(MobSpawnerData::new)) : simpleWeightedRandomList;
    }

    public void a() {
        this.c.clear();
        this.g = 0;
        this.f = 0L;
        this.e = 0L;
        this.d.clear();
    }

    public boolean b() {
        boolean bl = this.h.isPresent() && this.h.get().a().b("id", 8);
        return bl || !this.j.d();
    }

    public boolean a(TrialSpawnerConfig config, int additionalPlayers) {
        return this.g >= config.a(additionalPlayers);
    }

    public boolean c() {
        return this.d.isEmpty();
    }

    public boolean a(WorldServer world, TrialSpawnerConfig config, int additionalPlayers) {
        return world.X() >= this.f && this.d.size() < config.b(additionalPlayers);
    }

    public int a(BlockPosition pos) {
        if (this.c.isEmpty()) {
            SystemUtils.a("Trial Spawner at " + pos + " has no detected players");
        }
        return Math.max(0, this.c.size() - 1);
    }

    public void a(WorldServer world, BlockPosition pos, PlayerDetector entityDetector, int range) {
        List<UUID> list = entityDetector.detect(world, pos, range);
        boolean bl = this.c.addAll(list);
        if (bl) {
            this.f = Math.max(world.X() + 40L, this.f);
            world.c(3013, pos, this.c.size());
        }
    }

    public boolean a(WorldServer world, TrialSpawnerConfig config, float position) {
        long l2 = this.e - (long)config.h();
        return (float)world.X() >= (float)l2 + position;
    }

    public boolean b(WorldServer world, TrialSpawnerConfig config, float position) {
        long l2 = this.e - (long)config.h();
        return (float)(world.X() - l2) % position == 0.0f;
    }

    public boolean a(WorldServer world) {
        return world.X() >= this.e;
    }

    public void a(TrialSpawner logic, RandomSource random, EntityTypes<?> type) {
        this.a(logic, random).a().a("id", BuiltInRegistries.g.b(type).toString());
    }

    protected MobSpawnerData a(TrialSpawner logic, RandomSource random) {
        if (this.h.isPresent()) {
            return this.h.get();
        }
        this.h = Optional.of(this.j.b(random).map(WeightedEntry.b::b).orElseGet(MobSpawnerData::new));
        logic.e();
        return this.h.get();
    }

    @Nullable
    public Entity a(TrialSpawner logic, World world, TrialSpawnerState state) {
        if (logic.a(world) && state.d()) {
            NBTTagCompound compoundTag;
            if (this.k == null && (compoundTag = this.a(logic, world.F_()).a()).b("id", 8)) {
                this.k = EntityTypes.a(compoundTag, world, Function.identity());
            }
            return this.k;
        }
        return null;
    }

    public NBTTagCompound a(TrialSpawnerState state) {
        NBTTagCompound compoundTag = new NBTTagCompound();
        if (state == TrialSpawnerState.c) {
            compoundTag.a(n, this.f);
        }
        this.h.ifPresent(spawnData -> compoundTag.a(a, (NBTBase)MobSpawnerData.b.encodeStart((DynamicOps)DynamicOpsNBT.a, spawnData).result().orElseThrow(() -> new IllegalStateException("Invalid SpawnData"))));
        return compoundTag;
    }

    public double d() {
        return this.l;
    }

    public double e() {
        return this.m;
    }
}

