/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.destroystokyo.paper.exception.ServerInternalException;
import io.papermc.paper.configuration.GlobalConfiguration;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.logging.Level;
import javax.annotation.Nullable;
import net.minecraft.FileUtils;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ExceptionSuppressor;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.storage.ChunkRegionLoader;
import net.minecraft.world.level.chunk.storage.RegionFile;
import org.apache.logging.log4j.LogManager;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.LeavesLogger;
import top.leavesmc.leaves.region.AbstractRegionFile;
import top.leavesmc.leaves.region.AbstractRegionFileFactory;
import top.leavesmc.leaves.region.LinearRegionFile;
import top.leavesmc.leaves.region.RegionFileFormat;

public class RegionFileCache
implements AutoCloseable {
    public static final String a = ".mca";
    private static final int b = 256;
    public final Long2ObjectLinkedOpenHashMap<AbstractRegionFile> c = new Long2ObjectLinkedOpenHashMap();
    private final Path d;
    private final boolean e;
    public final RegionFileFormat format;
    public final int linearCompression;
    public final boolean linearCrashOnBrokenSymlink;
    private final boolean isChunkData;
    static final int MAX_NON_EXISTING_CACHE = 65536;
    private final LongLinkedOpenHashSet nonExistingRegionFiles = new LongLinkedOpenHashSet();

    private synchronized boolean doesRegionFilePossiblyExist(long position) {
        if (this.nonExistingRegionFiles.contains(position)) {
            this.nonExistingRegionFiles.addAndMoveToFirst(position);
            return false;
        }
        return true;
    }

    private synchronized void createRegionFile(long position) {
        this.nonExistingRegionFiles.remove(position);
    }

    private synchronized void markNonExisting(long position) {
        if (this.nonExistingRegionFiles.addAndMoveToFirst(position)) {
            while (this.nonExistingRegionFiles.size() >= 65536) {
                this.nonExistingRegionFiles.removeLastLong();
            }
        }
    }

    public synchronized boolean doesRegionFileNotExistNoIO(ChunkCoordIntPair pos) {
        long key = ChunkCoordIntPair.c(pos.h(), pos.i());
        return !this.doesRegionFilePossiblyExist(key);
    }

    protected RegionFileCache(Path directory, boolean dsync) {
        this(directory, dsync, false);
    }

    RegionFileCache(Path directory, boolean dsync, boolean isChunkData) {
        this.format = LeavesConfig.regionFormatName;
        this.linearCompression = LeavesConfig.linearCompressionLevel;
        this.linearCrashOnBrokenSymlink = LeavesConfig.linearCrashOnBrokenSymlink;
        this.isChunkData = isChunkData;
        this.d = directory;
        this.e = dsync;
    }

    @Nullable
    public static ChunkCoordIntPair getRegionFileCoordinates(Path file) {
        String fileName = file.getFileName().toString();
        if (!(fileName.startsWith("r.") && fileName.endsWith(a) && fileName.endsWith(".linear"))) {
            return null;
        }
        String[] split = fileName.split("\\.");
        if (split.length != 4) {
            return null;
        }
        try {
            int x2 = Integer.parseInt(split[1]);
            int z2 = Integer.parseInt(split[2]);
            return new ChunkCoordIntPair(x2 << 5, z2 << 5);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public synchronized AbstractRegionFile getRegionFileIfLoaded(ChunkCoordIntPair chunkcoordintpair) {
        return (AbstractRegionFile)this.c.getAndMoveToFirst(ChunkCoordIntPair.c(chunkcoordintpair.h(), chunkcoordintpair.i()));
    }

    public synchronized boolean chunkExists(ChunkCoordIntPair pos) throws IOException {
        AbstractRegionFile regionfile = this.getRegionFile(pos, true);
        return regionfile != null ? regionfile.e(pos) : false;
    }

    private void guardAgainstBrokenSymlinks(Path path) throws IOException {
        if (!this.linearCrashOnBrokenSymlink) {
            return;
        }
        if (this.format != RegionFileFormat.LINEAR) {
            return;
        }
        if (!Files.isSymbolicLink(path)) {
            return;
        }
        Path link = Files.readSymbolicLink(path);
        if (!Files.exists(link, new LinkOption[0]) || !Files.isReadable(link)) {
            LeavesLogger.LOGGER.log(Level.SEVERE, "Linear region file {} is a broken symbolic link, crashing to prevent data loss", path);
            MinecraftServer.getServer().a(false);
            throw new IOException("Linear region file " + path + " is a broken symbolic link, crashing to prevent data loss");
        }
    }

    public synchronized AbstractRegionFile getRegionFile(ChunkCoordIntPair chunkcoordintpair, boolean existingOnly) throws IOException {
        return this.getRegionFile(chunkcoordintpair, existingOnly, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized AbstractRegionFile getRegionFile(ChunkCoordIntPair chunkcoordintpair, boolean existingOnly, boolean lock) throws IOException {
        Path path1;
        long i2;
        long regionPos = i2 = ChunkCoordIntPair.c(chunkcoordintpair.h(), chunkcoordintpair.i());
        AbstractRegionFile regionfile = (AbstractRegionFile)this.c.getAndMoveToFirst(i2);
        if (regionfile != null) {
            if (lock) {
                regionfile.getFileLock().lock();
            }
            return regionfile;
        }
        if (existingOnly && !this.doesRegionFilePossiblyExist(regionPos)) {
            return null;
        }
        if (this.c.size() >= GlobalConfiguration.get().misc.regionFileCacheSize) {
            ((AbstractRegionFile)this.c.removeLast()).close();
        }
        Path path = this.d;
        int j2 = chunkcoordintpair.h();
        if (existingOnly) {
            Path anvil = path.resolve("r." + j2 + "." + chunkcoordintpair.i() + a);
            Path linear = path.resolve("r." + j2 + "." + chunkcoordintpair.i() + ".linear");
            this.guardAgainstBrokenSymlinks(linear);
            if (Files.exists(anvil, new LinkOption[0])) {
                path1 = anvil;
            } else {
                if (!Files.exists(linear, new LinkOption[0])) {
                    this.markNonExisting(regionPos);
                    return null;
                }
                path1 = linear;
            }
        } else {
            String extension = switch (this.format) {
                case RegionFileFormat.LINEAR -> "linear";
                default -> "mca";
            };
            path1 = path.resolve("r." + j2 + "." + chunkcoordintpair.i() + "." + extension);
            this.guardAgainstBrokenSymlinks(path1);
            this.createRegionFile(regionPos);
        }
        FileUtils.c(this.d);
        AbstractRegionFile regionfile1 = AbstractRegionFileFactory.getAbstractRegionFile(this.linearCompression, path1, this.d, this.e, this.isChunkData);
        this.c.putAndMoveToFirst(i2, (Object)regionfile1);
        if (lock) {
            regionfile1.getFileLock().lock();
        }
        return regionfile1;
    }

    private static void printOversizedLog(String msg, Path file, int x2, int z2) {
        LogManager.getLogger().fatal(msg + " (" + file.toString().replaceAll(".+[\\\\/]", "") + " - " + x2 + "," + z2 + ") Go clean it up to remove this message. /minecraft:tp " + (x2 << 4) + " 128 " + (z2 << 4) + " - DO NOT REPORT THIS TO PAPER - You may ask for help on Discord, but do not file an issue. These error messages can not be removed.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static NBTTagCompound readOversizedChunk(AbstractRegionFile regionfile, ChunkCoordIntPair chunkCoordinate) throws IOException {
        AbstractRegionFile abstractRegionFile = regionfile;
        synchronized (abstractRegionFile) {
            try (DataInputStream datainputstream = regionfile.a(chunkCoordinate);){
                NBTTagCompound oversizedData = regionfile.getOversizedData(chunkCoordinate.e, chunkCoordinate.f);
                NBTTagCompound chunk = NBTCompressedStreamTools.a(datainputstream);
                if (oversizedData == null) {
                    NBTTagCompound nBTTagCompound2 = chunk;
                    return nBTTagCompound2;
                }
                NBTTagCompound oversizedLevel = oversizedData.p("Level");
                RegionFileCache.mergeChunkList(chunk.p("Level"), oversizedLevel, "Entities", "Entities");
                RegionFileCache.mergeChunkList(chunk.p("Level"), oversizedLevel, "TileEntities", "TileEntities");
                NBTTagCompound nBTTagCompound = chunk;
                return nBTTagCompound;
            }
            catch (Throwable throwable3) {
                throwable3.printStackTrace();
                throw throwable3;
            }
        }
    }

    private static void mergeChunkList(NBTTagCompound level, NBTTagCompound oversizedLevel, String key, String oversizedKey) {
        NBTTagList levelList = level.c(key, 10);
        NBTTagList oversizedList = oversizedLevel.c(oversizedKey, 10);
        if (!oversizedList.isEmpty()) {
            levelList.addAll(oversizedList);
            level.a(key, levelList);
        }
    }

    @Nullable
    public NBTTagCompound a(ChunkCoordIntPair pos) throws IOException {
        AbstractRegionFile regionfile = this.getRegionFile(pos, true, true);
        if (regionfile == null) {
            return null;
        }
        return this.read(pos, regionfile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NBTTagCompound read(ChunkCoordIntPair pos, AbstractRegionFile regionfile) throws IOException {
        try {
            NBTTagCompound nbttagcompound;
            DataInputStream datainputstream = regionfile.a(pos);
            if (regionfile.isOversized(pos.e, pos.f)) {
                RegionFileCache.printOversizedLog("Loading Oversized Chunk!", regionfile.getRegionFile(), pos.e, pos.f);
                NBTTagCompound nBTTagCompound = RegionFileCache.readOversizedChunk(regionfile, pos);
                return nBTTagCompound;
            }
            if (datainputstream != null) {
                ChunkCoordIntPair chunkPos;
                nbttagcompound = NBTCompressedStreamTools.a(datainputstream);
                if (this.isChunkData && !(chunkPos = ChunkRegionLoader.getChunkCoordinate(nbttagcompound)).equals(pos)) {
                    MinecraftServer.l.error("Attempting to read chunk data at " + pos + " but got chunk data for " + chunkPos + " instead! Attempting regionfile recalculation for regionfile " + regionfile.getRegionFile().toAbsolutePath());
                    if (regionfile.recalculateHeader()) {
                        regionfile.getFileLock().lock();
                        NBTTagCompound nBTTagCompound = this.read(pos, regionfile);
                        return nBTTagCompound;
                    }
                    MinecraftServer.l.error("Can't recalculate regionfile header, regenerating chunk " + pos + " for " + regionfile.getRegionFile().toAbsolutePath());
                    NBTTagCompound nBTTagCompound = null;
                    return nBTTagCompound;
                }
            } else {
                NBTTagCompound nbttagcompound2;
                try {
                    nbttagcompound2 = null;
                }
                finally {
                    if (datainputstream != null) {
                        datainputstream.close();
                    }
                }
                NBTTagCompound nBTTagCompound = nbttagcompound2;
                return nBTTagCompound;
            }
            if (datainputstream != null) {
                datainputstream.close();
            }
            NBTTagCompound nBTTagCompound = nbttagcompound;
            return nBTTagCompound;
        }
        finally {
            regionfile.getFileLock().unlock();
        }
    }

    public void a(ChunkCoordIntPair chunkPos, StreamTagVisitor scanner) throws IOException {
        AbstractRegionFile regionfile = this.getRegionFile(chunkPos, true);
        if (regionfile == null) {
            return;
        }
        try (DataInputStream datainputstream = regionfile.a(chunkPos);){
            if (datainputstream != null) {
                NBTCompressedStreamTools.a((DataInput)datainputstream, scanner, NBTReadLimiter.a());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void a(ChunkCoordIntPair pos, @Nullable NBTTagCompound nbt) throws IOException {
        AbstractRegionFile regionfile = this.getRegionFile(pos, nbt == null, true);
        if (nbt == null && regionfile == null) {
            return;
        }
        int attempts = 0;
        Exception lastException = null;
        while (attempts++ < 5) {
            try {
                DataOutputStream dataoutputstream;
                block27: {
                    if (nbt == null) {
                        regionfile.d(pos);
                        return;
                    }
                    if (regionfile instanceof RegionFile && LeavesConfig.regionFormatName == RegionFileFormat.LINEAR && LeavesConfig.autoConvertAnvilToLinear) {
                        Path linearFilePath = Path.of(regionfile.getRegionFile().toString().replaceAll(a, ".linear"), new String[0]);
                        LinearRegionFile linearRegionFile = new LinearRegionFile(linearFilePath, LeavesConfig.linearCompressionLevel);
                        try {
                            DataInputStream regionDataInputStream = regionfile.a(pos);
                            if (regionDataInputStream == null) continue;
                            NBTTagCompound compoundTag = NBTCompressedStreamTools.a(regionDataInputStream);
                            try (DataOutputStream linearDataOutputStream = linearRegionFile.c(pos);){
                                NBTCompressedStreamTools.a(compoundTag, (DataOutput)linearDataOutputStream);
                            }
                            linearRegionFile.a();
                            if (Files.isRegularFile(regionfile.getRegionFile(), new LinkOption[0])) {
                                Files.delete(regionfile.getRegionFile());
                            }
                            dataoutputstream = linearRegionFile.c(pos);
                            break block27;
                        }
                        finally {
                            linearRegionFile.close();
                            continue;
                        }
                    }
                    dataoutputstream = regionfile.c(pos);
                }
                try {
                    NBTCompressedStreamTools.a(nbt, (DataOutput)dataoutputstream);
                    regionfile.setStatus(pos.e, pos.f, ChunkRegionLoader.getStatus(nbt));
                    regionfile.setOversized(pos.e, pos.f, false);
                    dataoutputstream.close();
                    return;
                }
                catch (RegionFileSizeException e2) {
                    attempts = 5;
                    regionfile.d(pos);
                    throw e2;
                }
                catch (Throwable throwable) {
                    if (dataoutputstream == null) throw throwable;
                    throw throwable;
                }
            }
            catch (Exception ex) {
                lastException = ex;
            }
        }
        if (lastException == null) return;
        ServerInternalException.reportInternalException(lastException);
        MinecraftServer.l.error("Failed to save chunk {}", (Object)pos, (Object)lastException);
        return;
        finally {
            regionfile.getFileLock().unlock();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        ExceptionSuppressor<IOException> exceptionsuppressor = new ExceptionSuppressor<IOException>();
        for (AbstractRegionFile regionfile : this.c.values()) {
            try {
                regionfile.close();
            }
            catch (IOException ioexception) {
                exceptionsuppressor.a(ioexception);
            }
        }
        exceptionsuppressor.a();
    }

    public synchronized void a() throws IOException {
        for (AbstractRegionFile regionfile : this.c.values()) {
            regionfile.a();
        }
    }

    public static final class RegionFileSizeException
    extends RuntimeException {
        public RegionFileSizeException(String message) {
            super(message);
        }
    }
}

