/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gameevent;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.PositionSourceType;
import net.minecraft.world.phys.Vec3D;

public class EntityPositionSource
implements PositionSource {
    public static final Codec<EntityPositionSource> a = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.a.fieldOf("source_entity").forGetter(EntityPositionSource::b), (App)Codec.FLOAT.fieldOf("y_offset").orElse((Object)Float.valueOf(0.0f)).forGetter(entityPositionSource -> Float.valueOf(entityPositionSource.d))).apply((Applicative)instance, (uuid, yOffset) -> new EntityPositionSource(Either.right(Either.left(uuid)), yOffset.floatValue())));
    private Either<Entity, Either<UUID, Integer>> c;
    final float d;

    public EntityPositionSource(Entity entity, float yOffset) {
        this(Either.left(entity), yOffset);
    }

    EntityPositionSource(Either<Entity, Either<UUID, Integer>> source, float yOffset) {
        this.c = source;
        this.d = yOffset;
    }

    @Override
    @Override
    public Optional<Vec3D> a(World world) {
        if (this.c.left().isEmpty()) {
            this.b(world);
        }
        return this.c.left().map(entity -> entity.dk().b(0.0, this.d, 0.0));
    }

    private void b(World world) {
        this.c.map(Optional::of, entityId -> Optional.ofNullable(entityId.map(uuid -> {
            Entity entity;
            if (world instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)world;
                entity = serverLevel.a((UUID)uuid);
            } else {
                entity = null;
            }
            return entity;
        }, world::a))).ifPresent(entity -> {
            this.c = Either.left(entity);
        });
    }

    private UUID b() {
        return this.c.map(Entity::cw, entityId -> entityId.map(Function.identity(), entityIdx -> {
            throw new RuntimeException("Unable to get entityId from uuid");
        }));
    }

    int c() {
        return this.c.map(Entity::aj, entityId -> entityId.map(uuid -> {
            throw new IllegalStateException("Unable to get entityId from uuid");
        }, Function.identity()));
    }

    @Override
    @Override
    public PositionSourceType<?> a() {
        return PositionSourceType.b;
    }

    public static class a
    implements PositionSourceType<EntityPositionSource> {
        @Override
        public EntityPositionSource a(PacketDataSerializer friendlyByteBuf) {
            return new EntityPositionSource(Either.right(Either.right(friendlyByteBuf.n())), friendlyByteBuf.readFloat());
        }

        @Override
        @Override
        public void a(PacketDataSerializer buf, EntityPositionSource positionSource) {
            buf.c(positionSource.c());
            buf.a(positionSource.d);
        }

        @Override
        @Override
        public Codec<EntityPositionSource> a() {
            return a;
        }

        @Override
        public /* synthetic */ PositionSource b(PacketDataSerializer buf) {
            return this.a(buf);
        }
    }
}

