/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import java.util.function.Consumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;

public class DripstoneUtils {
    protected static double a(double radius, double scale, double heightScale, double bluntness) {
        if (radius < bluntness) {
            radius = bluntness;
        }
        double d2 = 0.384;
        double e2 = radius / scale * 0.384;
        double f2 = 0.75 * Math.pow(e2, 1.3333333333333333);
        double g2 = Math.pow(e2, 0.6666666666666666);
        double h2 = 0.3333333333333333 * Math.log(e2);
        double i2 = heightScale * (f2 - g2 - h2);
        i2 = Math.max(i2, 0.0);
        return i2 / 0.384 * scale;
    }

    protected static boolean a(GeneratorAccessSeed world, BlockPosition pos, int height) {
        if (DripstoneUtils.b(world, pos)) {
            return false;
        }
        float f2 = 6.0f;
        float g2 = 6.0f / (float)height;
        for (float h2 = 0.0f; h2 < (float)Math.PI * 2; h2 += g2) {
            int j2;
            int i2 = (int)(MathHelper.b(h2) * (float)height);
            if (!DripstoneUtils.b(world, pos.b(i2, 0, j2 = (int)(MathHelper.a(h2) * (float)height)))) continue;
            return false;
        }
        return true;
    }

    protected static boolean a(GeneratorAccess world, BlockPosition pos) {
        return world.a(pos, DripstoneUtils::c);
    }

    protected static boolean b(GeneratorAccess world, BlockPosition pos) {
        return world.a(pos, DripstoneUtils::e);
    }

    protected static void a(EnumDirection direction, int height, boolean merge, Consumer<IBlockData> callback) {
        if (height >= 3) {
            callback.accept(DripstoneUtils.a(direction, DripstoneThickness.e));
            for (int i2 = 0; i2 < height - 3; ++i2) {
                callback.accept(DripstoneUtils.a(direction, DripstoneThickness.d));
            }
        }
        if (height >= 2) {
            callback.accept(DripstoneUtils.a(direction, DripstoneThickness.c));
        }
        if (height >= 1) {
            callback.accept(DripstoneUtils.a(direction, merge ? DripstoneThickness.a : DripstoneThickness.b));
        }
    }

    protected static void a(GeneratorAccess world, BlockPosition pos, EnumDirection direction, int height, boolean merge) {
        if (!DripstoneUtils.b(world.a_(pos.a(direction.g())))) {
            return;
        }
        BlockPosition.MutableBlockPosition mutableBlockPos = pos.j();
        DripstoneUtils.a(direction, height, merge, (IBlockData state) -> {
            if (state.a(Blocks.st)) {
                state = (IBlockData)state.a(PointedDripstoneBlock.d, world.z(mutableBlockPos));
            }
            world.a((BlockPosition)mutableBlockPos, (IBlockData)state, 2);
            mutableBlockPos.c(direction);
        });
    }

    protected static boolean c(GeneratorAccess world, BlockPosition pos) {
        IBlockData blockState = world.a_(pos);
        if (blockState.a(TagsBlock.br)) {
            world.a(pos, Blocks.su.o(), 2);
            return true;
        }
        return false;
    }

    private static IBlockData a(EnumDirection direction, DripstoneThickness thickness) {
        return (IBlockData)((IBlockData)Blocks.st.o().a(PointedDripstoneBlock.b, direction)).a(PointedDripstoneBlock.c, thickness);
    }

    public static boolean a(IBlockData state) {
        return DripstoneUtils.b(state) || state.a(Blocks.H);
    }

    public static boolean b(IBlockData state) {
        return state.a(Blocks.su) || state.a(TagsBlock.br);
    }

    public static boolean c(IBlockData state) {
        return state.i() || state.a(Blocks.G);
    }

    public static boolean d(IBlockData state) {
        return !state.i() && !state.a(Blocks.G);
    }

    public static boolean e(IBlockData state) {
        return state.i() || state.a(Blocks.G) || state.a(Blocks.H);
    }
}

