/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.RootSystemConfiguration;

public class RootSystemFeature
extends WorldGenerator<RootSystemConfiguration> {
    public RootSystemFeature(Codec<RootSystemConfiguration> configCodec) {
        super(configCodec);
    }

    @Override
    @Override
    public boolean a(FeaturePlaceContext<RootSystemConfiguration> context) {
        BlockPosition blockPos;
        GeneratorAccessSeed worldGenLevel = context.b();
        if (!worldGenLevel.a_(blockPos = context.e()).i()) {
            return false;
        }
        RandomSource randomSource = context.d();
        BlockPosition blockPos2 = context.e();
        RootSystemConfiguration rootSystemConfiguration = context.f();
        BlockPosition.MutableBlockPosition mutableBlockPos = blockPos2.j();
        if (RootSystemFeature.a(worldGenLevel, context.c(), rootSystemConfiguration, randomSource, mutableBlockPos, blockPos2)) {
            RootSystemFeature.a(worldGenLevel, rootSystemConfiguration, randomSource, blockPos2, mutableBlockPos);
        }
        return true;
    }

    private static boolean a(GeneratorAccessSeed world, RootSystemConfiguration config, BlockPosition pos) {
        BlockPosition.MutableBlockPosition mutableBlockPos = pos.j();
        for (int i2 = 1; i2 <= config.c; ++i2) {
            mutableBlockPos.c(EnumDirection.b);
            IBlockData blockState = world.a_(mutableBlockPos);
            if (RootSystemFeature.a(blockState, i2, config.n)) continue;
            return false;
        }
        return true;
    }

    private static boolean a(IBlockData state, int height, int allowedVerticalWaterForTree) {
        if (state.i()) {
            return true;
        }
        int i2 = height + 1;
        return i2 <= allowedVerticalWaterForTree && state.u().a(TagsFluid.a);
    }

    private static boolean a(GeneratorAccessSeed world, ChunkGenerator generator, RootSystemConfiguration config, RandomSource random, BlockPosition.MutableBlockPosition mutablePos, BlockPosition pos) {
        for (int i2 = 0; i2 < config.h; ++i2) {
            mutablePos.c(EnumDirection.b);
            if (!config.o.test(world, mutablePos) || !RootSystemFeature.a(world, config, mutablePos)) continue;
            BlockPosition blockPos = mutablePos.d();
            if (world.b_(blockPos).a(TagsFluid.b) || !world.a_(blockPos).e()) {
                return false;
            }
            if (!config.b.a().a(world, generator, random, mutablePos)) continue;
            RootSystemFeature.a(pos, pos.v() + i2, world, config, random);
            return true;
        }
        return false;
    }

    private static void a(BlockPosition pos, int maxY, GeneratorAccessSeed world, RootSystemConfiguration config, RandomSource random) {
        int i2 = pos.u();
        int j2 = pos.w();
        BlockPosition.MutableBlockPosition mutableBlockPos = pos.j();
        for (int k2 = pos.v(); k2 < maxY; ++k2) {
            RootSystemFeature.a(world, config, random, i2, j2, mutableBlockPos.d(i2, k2, j2));
        }
    }

    private static void a(GeneratorAccessSeed world, RootSystemConfiguration config, RandomSource random, int x2, int z2, BlockPosition.MutableBlockPosition mutablePos) {
        int i2 = config.d;
        Predicate<IBlockData> predicate = state -> state.a(rootSystemConfiguration.e);
        for (int j2 = 0; j2 < config.g; ++j2) {
            mutablePos.a(mutablePos, random.a(i2) - random.a(i2), 0, random.a(i2) - random.a(i2));
            if (predicate.test(world.a_(mutablePos))) {
                world.a((BlockPosition)mutablePos, config.f.a(random, mutablePos), 2);
            }
            mutablePos.p(x2);
            mutablePos.r(z2);
        }
    }

    private static void a(GeneratorAccessSeed world, RootSystemConfiguration config, RandomSource random, BlockPosition pos, BlockPosition.MutableBlockPosition mutablePos) {
        int i2 = config.i;
        int j2 = config.j;
        for (int k2 = 0; k2 < config.l; ++k2) {
            IBlockData blockState;
            mutablePos.a(pos, random.a(i2) - random.a(i2), random.a(j2) - random.a(j2), random.a(i2) - random.a(i2));
            if (!world.u(mutablePos) || !(blockState = config.k.a(random, mutablePos)).a(world, (BlockPosition)mutablePos) || !world.a_(mutablePos.c()).d(world, mutablePos, EnumDirection.a)) continue;
            world.a((BlockPosition)mutablePos, blockState, 2);
        }
    }
}

