/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.trunkplacers;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.VirtualLevelReadable;
import net.minecraft.world.level.block.BlockRotatable;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureTreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacers;

public class TrunkPlacerFancy
extends TrunkPlacer {
    public static final Codec<TrunkPlacerFancy> a = RecordCodecBuilder.create(instance -> TrunkPlacerFancy.a(instance).apply((Applicative)instance, TrunkPlacerFancy::new));
    private static final double b = 0.618;
    private static final double h = 1.382;
    private static final double i = 0.381;
    private static final double j = 0.328;

    public TrunkPlacerFancy(int baseHeight, int firstRandomHeight, int secondRandomHeight) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
    }

    @Override
    @Override
    protected TrunkPlacers<?> a() {
        return TrunkPlacers.f;
    }

    @Override
    @Override
    public List<WorldGenFoilagePlacer.a> a(VirtualLevelReadable world, BiConsumer<BlockPosition, IBlockData> replacer, RandomSource random, int height, BlockPosition startPos, WorldGenFeatureTreeConfiguration config) {
        int n2;
        int i2 = 5;
        int j2 = height + 2;
        int k2 = MathHelper.a((double)j2 * 0.618);
        TrunkPlacerFancy.a(world, replacer, random, startPos.d(), config);
        double d2 = 1.0;
        int l2 = Math.min(1, MathHelper.a(1.382 + Math.pow(1.0 * (double)j2 / 13.0, 2.0)));
        int m2 = startPos.v() + k2;
        ArrayList list = Lists.newArrayList();
        list.add(new a(startPos.b(n2), m2));
        for (n2 = j2 - 5; n2 >= 0; --n2) {
            float f2 = TrunkPlacerFancy.b(j2, n2);
            if (f2 < 0.0f) continue;
            for (int o2 = 0; o2 < l2; ++o2) {
                BlockPosition blockPos2;
                double e2 = 1.0;
                double g2 = 1.0 * (double)f2 * ((double)random.i() + 0.328);
                double h2 = (double)(random.i() * 2.0f) * Math.PI;
                double p2 = g2 * Math.sin(h2) + 0.5;
                double q2 = g2 * Math.cos(h2) + 0.5;
                BlockPosition blockPos = startPos.b(MathHelper.a(p2), n2 - 1, MathHelper.a(q2));
                if (!this.a(world, replacer, random, blockPos, blockPos2 = blockPos.b(5), false, config)) continue;
                int r2 = startPos.u() - blockPos.u();
                int s2 = startPos.w() - blockPos.w();
                double t2 = (double)blockPos.v() - Math.sqrt(r2 * r2 + s2 * s2) * 0.381;
                int u2 = t2 > (double)m2 ? m2 : (int)t2;
                BlockPosition blockPos3 = new BlockPosition(startPos.u(), u2, startPos.w());
                if (!this.a(world, replacer, random, blockPos3, blockPos, false, config)) continue;
                list.add(new a(blockPos, blockPos3.v()));
            }
        }
        this.a(world, replacer, random, startPos, startPos.b(k2), true, config);
        this.a(world, replacer, random, j2, startPos, list, config);
        ArrayList list2 = Lists.newArrayList();
        for (a foliageCoords : list) {
            if (!this.a(j2, foliageCoords.a() - startPos.v())) continue;
            list2.add(foliageCoords.a);
        }
        return list2;
    }

    private boolean a(VirtualLevelReadable world, BiConsumer<BlockPosition, IBlockData> replacer, RandomSource random, BlockPosition startPos, BlockPosition branchPos, boolean make, WorldGenFeatureTreeConfiguration config) {
        if (!make && Objects.equals(startPos, branchPos)) {
            return true;
        }
        BlockPosition blockPos = branchPos.b(-startPos.u(), -startPos.v(), -startPos.w());
        int i2 = this.a(blockPos);
        float f2 = (float)blockPos.u() / (float)i2;
        float g2 = (float)blockPos.v() / (float)i2;
        float h2 = (float)blockPos.w() / (float)i2;
        for (int j2 = 0; j2 <= i2; ++j2) {
            BlockPosition blockPos2 = startPos.b(MathHelper.d(0.5f + (float)j2 * f2), MathHelper.d(0.5f + (float)j2 * g2), MathHelper.d(0.5f + (float)j2 * h2));
            if (make) {
                this.a(world, replacer, random, blockPos2, config, (IBlockData state) -> (IBlockData)state.b(BlockRotatable.i, this.a(startPos, blockPos2)));
                continue;
            }
            if (this.b(world, blockPos2)) continue;
            return false;
        }
        return true;
    }

    private int a(BlockPosition offset) {
        int i2 = MathHelper.a(offset.u());
        int j2 = MathHelper.a(offset.v());
        int k2 = MathHelper.a(offset.w());
        return Math.max(i2, Math.max(j2, k2));
    }

    private EnumDirection.EnumAxis a(BlockPosition branchStart, BlockPosition branchEnd) {
        int j2;
        EnumDirection.EnumAxis axis = EnumDirection.EnumAxis.b;
        int i2 = Math.abs(branchEnd.u() - branchStart.u());
        int k2 = Math.max(i2, j2 = Math.abs(branchEnd.w() - branchStart.w()));
        if (k2 > 0) {
            axis = i2 == k2 ? EnumDirection.EnumAxis.a : EnumDirection.EnumAxis.c;
        }
        return axis;
    }

    private boolean a(int treeHeight, int height) {
        return (double)height >= (double)treeHeight * 0.2;
    }

    private void a(VirtualLevelReadable world, BiConsumer<BlockPosition, IBlockData> replacer, RandomSource random, int treeHeight, BlockPosition startPos, List<a> branchPositions, WorldGenFeatureTreeConfiguration config) {
        for (a foliageCoords : branchPositions) {
            int i2 = foliageCoords.a();
            BlockPosition blockPos = new BlockPosition(startPos.u(), i2, startPos.w());
            if (blockPos.equals(foliageCoords.a.a()) || !this.a(treeHeight, i2 - startPos.v())) continue;
            this.a(world, replacer, random, blockPos, foliageCoords.a.a(), true, config);
        }
    }

    private static float b(int treeHeight, int height) {
        if ((float)height < (float)treeHeight * 0.3f) {
            return -1.0f;
        }
        float f2 = (float)treeHeight / 2.0f;
        float g2 = f2 - (float)height;
        float h2 = MathHelper.c(f2 * f2 - g2 * g2);
        if (g2 == 0.0f) {
            h2 = f2;
        } else if (Math.abs(g2) >= f2) {
            return 0.0f;
        }
        return h2 * 0.5f;
    }

    static class a {
        final WorldGenFoilagePlacer.a a;
        private final int b;

        public a(BlockPosition pos, int width) {
            this.a = new WorldGenFoilagePlacer.a(pos, 0, false);
            this.b = width;
        }

        public int a() {
            return this.b;
        }
    }
}

