/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.heightproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.HeightProviderType;
import org.slf4j.Logger;

public class TrapezoidHeight
extends HeightProvider {
    public static final Codec<TrapezoidHeight> a = RecordCodecBuilder.create(instance -> instance.group((App)VerticalAnchor.a.fieldOf("min_inclusive").forGetter(provider -> provider.d), (App)VerticalAnchor.a.fieldOf("max_inclusive").forGetter(provider -> provider.e), (App)Codec.INT.optionalFieldOf("plateau", (Object)0).forGetter(trapezoidHeight -> trapezoidHeight.f)).apply((Applicative)instance, TrapezoidHeight::new));
    private static final Logger b = LogUtils.getLogger();
    private final VerticalAnchor d;
    private final VerticalAnchor e;
    private final int f;

    private TrapezoidHeight(VerticalAnchor minOffset, VerticalAnchor maxOffset, int plateau) {
        this.d = minOffset;
        this.e = maxOffset;
        this.f = plateau;
    }

    public static TrapezoidHeight a(VerticalAnchor minOffset, VerticalAnchor maxOffset, int plateau) {
        return new TrapezoidHeight(minOffset, maxOffset, plateau);
    }

    public static TrapezoidHeight a(VerticalAnchor minOffset, VerticalAnchor maxOffset) {
        return TrapezoidHeight.a(minOffset, maxOffset, 0);
    }

    @Override
    @Override
    public int a(RandomSource random, WorldGenerationContext context) {
        int j2;
        int i2 = this.d.a(context);
        if (i2 > (j2 = this.e.a(context))) {
            b.warn("Empty height range: {}", (Object)this);
            return i2;
        }
        int k2 = j2 - i2;
        if (this.f >= k2) {
            return MathHelper.b(random, i2, j2);
        }
        int l2 = (k2 - this.f) / 2;
        int m2 = k2 - l2;
        return i2 + MathHelper.b(random, 0, m2) + MathHelper.b(random, 0, l2);
    }

    @Override
    @Override
    public HeightProviderType<?> a() {
        return HeightProviderType.e;
    }

    @Override
    public String toString() {
        if (this.f == 0) {
            return "triangle (" + this.d + "-" + this.e + ")";
        }
        return "trapezoid(" + this.f + ") in [" + this.d + "-" + this.e + "]";
    }
}

