/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;

public abstract class WorldGenScatteredPiece
extends StructurePiece {
    protected final int a;
    protected final int b;
    protected final int c;
    protected int d = -1;

    protected WorldGenScatteredPiece(WorldGenFeatureStructurePieceType type, int x2, int y2, int z2, int width, int height, int depth, EnumDirection orientation) {
        super(type, 0, StructurePiece.a(x2, y2, z2, orientation, width, height, depth));
        this.a = width;
        this.b = height;
        this.c = depth;
        this.a(orientation);
    }

    protected WorldGenScatteredPiece(WorldGenFeatureStructurePieceType type, NBTTagCompound nbt) {
        super(type, nbt);
        this.a = nbt.h("Width");
        this.b = nbt.h("Height");
        this.c = nbt.h("Depth");
        this.d = nbt.h("HPos");
    }

    @Override
    @Override
    protected void a(StructurePieceSerializationContext context, NBTTagCompound nbt) {
        nbt.a("Width", this.a);
        nbt.a("Height", this.b);
        nbt.a("Depth", this.c);
        nbt.a("HPos", this.d);
    }

    protected boolean a(GeneratorAccess world, StructureBoundingBox boundingBox, int deltaY) {
        if (this.d >= 0) {
            return true;
        }
        int i2 = 0;
        int j2 = 0;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (int k2 = this.f.j(); k2 <= this.f.m(); ++k2) {
            for (int l2 = this.f.h(); l2 <= this.f.k(); ++l2) {
                mutableBlockPos.d(l2, 64, k2);
                if (!boundingBox.b(mutableBlockPos)) continue;
                i2 += world.a(HeightMap.Type.f, (BlockPosition)mutableBlockPos).v();
                ++j2;
            }
        }
        if (j2 == 0) {
            return false;
        }
        this.d = i2 / j2;
        this.f.a(0, this.d - this.f.i() + deltaY, 0);
        return true;
    }

    protected boolean a(GeneratorAccess world, int yOffset) {
        if (this.d >= 0) {
            return true;
        }
        int i2 = world.al();
        boolean bl = false;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (int j2 = this.f.j(); j2 <= this.f.m(); ++j2) {
            for (int k2 = this.f.h(); k2 <= this.f.k(); ++k2) {
                mutableBlockPos.d(k2, 0, j2);
                i2 = Math.min(i2, world.a(HeightMap.Type.f, (BlockPosition)mutableBlockPos).v());
                bl = true;
            }
        }
        if (!bl) {
            return false;
        }
        this.d = i2;
        this.f.a(0, this.d - this.f.i() + yOffset, 0);
        return true;
    }
}

