/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pools;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.WorldGenFeaturePieces;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SequencedPriorityIterator;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.BlockJigsaw;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.WorldGenFeaturePillagerOutpostPoolPiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructureJigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolEmpty;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolStructure;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;

public class WorldGenFeatureDefinedStructureJigsawPlacement {
    static final Logger a = LogUtils.getLogger();

    public static Optional<Structure.b> a(Structure.a context, Holder<WorldGenFeatureDefinedStructurePoolTemplate> structurePool, Optional<MinecraftKey> id, int size, BlockPosition pos, boolean useExpansionHack, Optional<HeightMap.Type> projectStartToHeightmap, int maxDistanceFromCenter, PoolAliasLookup aliasLookup) {
        int l2;
        BlockPosition blockPos2;
        IRegistryCustom registryAccess = context.a();
        ChunkGenerator chunkGenerator = context.b();
        StructureTemplateManager structureTemplateManager = context.e();
        LevelHeightAccessor levelHeightAccessor = context.i();
        SeededRandom worldgenRandom = context.f();
        IRegistry<WorldGenFeatureDefinedStructurePoolTemplate> registry = registryAccess.d(Registries.aG);
        EnumBlockRotation rotation = EnumBlockRotation.a(worldgenRandom);
        WorldGenFeatureDefinedStructurePoolTemplate structureTemplatePool = structurePool.e().flatMap(resourceKey -> registry.d(aliasLookup.lookup((ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate>)resourceKey))).orElse(structurePool.a());
        WorldGenFeatureDefinedStructurePoolStructure structurePoolElement = structureTemplatePool.a(worldgenRandom);
        if (structurePoolElement == WorldGenFeatureDefinedStructurePoolEmpty.b) {
            return Optional.empty();
        }
        if (id.isPresent()) {
            MinecraftKey resourceLocation = id.get();
            Optional<BlockPosition> optional = WorldGenFeatureDefinedStructureJigsawPlacement.a(structurePoolElement, resourceLocation, pos, rotation, structureTemplateManager, worldgenRandom);
            if (optional.isEmpty()) {
                a.error("No starting jigsaw {} found in start pool {}", (Object)resourceLocation, (Object)structurePool.e().map(key -> key.a().toString()).orElse("<unregistered>"));
                return Optional.empty();
            }
            BlockPosition blockPos = optional.get();
        } else {
            blockPos2 = pos;
        }
        BlockPosition vec3i = blockPos2.b(pos);
        BlockPosition blockPos3 = pos.b(vec3i);
        WorldGenFeaturePillagerOutpostPoolPiece poolElementStructurePiece = new WorldGenFeaturePillagerOutpostPoolPiece(structureTemplateManager, structurePoolElement, blockPos3, structurePoolElement.f(), rotation, structurePoolElement.a(structureTemplateManager, blockPos3, rotation));
        StructureBoundingBox boundingBox = poolElementStructurePiece.f();
        int i2 = (boundingBox.k() + boundingBox.h()) / 2;
        int j2 = (boundingBox.m() + boundingBox.j()) / 2;
        if (projectStartToHeightmap.isPresent()) {
            int k2 = pos.v() + chunkGenerator.b(i2, j2, projectStartToHeightmap.get(), levelHeightAccessor, context.d());
        } else {
            l2 = blockPos3.v();
        }
        int m2 = boundingBox.i() + poolElementStructurePiece.d();
        poolElementStructurePiece.a(0, l2 - m2, 0);
        int n2 = l2 + vec3i.v();
        return Optional.of(new Structure.b(new BlockPosition(i2, n2, j2), collector -> {
            ArrayList list = Lists.newArrayList();
            list.add(poolElementStructurePiece);
            if (size <= 0) {
                return;
            }
            AxisAlignedBB aABB = new AxisAlignedBB(i2 - maxDistanceFromCenter, n2 - maxDistanceFromCenter, j2 - maxDistanceFromCenter, i2 + maxDistanceFromCenter + 1, n2 + maxDistanceFromCenter + 1, j2 + maxDistanceFromCenter + 1);
            VoxelShape voxelShape = VoxelShapes.a(VoxelShapes.a(aABB), VoxelShapes.a(AxisAlignedBB.a(boundingBox)), OperatorBoolean.e);
            WorldGenFeatureDefinedStructureJigsawPlacement.a(context.d(), size, useExpansionHack, chunkGenerator, structureTemplateManager, levelHeightAccessor, worldgenRandom, registry, poolElementStructurePiece, list, voxelShape, aliasLookup);
            list.forEach(collector::a);
        }));
    }

    private static Optional<BlockPosition> a(WorldGenFeatureDefinedStructurePoolStructure pool, MinecraftKey id, BlockPosition pos, EnumBlockRotation rotation, StructureTemplateManager structureManager, SeededRandom random) {
        List<DefinedStructure.BlockInfo> list = pool.a(structureManager, pos, rotation, random);
        Optional<BlockPosition> optional = Optional.empty();
        for (DefinedStructure.BlockInfo structureBlockInfo : list) {
            MinecraftKey resourceLocation = MinecraftKey.a(Objects.requireNonNull(structureBlockInfo.c(), () -> structureBlockInfo + " nbt was null").l("name"));
            if (!id.equals(resourceLocation)) continue;
            optional = Optional.of(structureBlockInfo.a());
            break;
        }
        return optional;
    }

    private static void a(RandomState noiseConfig, int maxSize, boolean modifyBoundingBox, ChunkGenerator chunkGenerator, StructureTemplateManager structureTemplateManager, LevelHeightAccessor heightLimitView, RandomSource random, IRegistry<WorldGenFeatureDefinedStructurePoolTemplate> structurePoolRegistry, WorldGenFeaturePillagerOutpostPoolPiece firstPiece, List<WorldGenFeaturePillagerOutpostPoolPiece> pieces, VoxelShape pieceShape, PoolAliasLookup aliasLookup) {
        b placer = new b(structurePoolRegistry, maxSize, chunkGenerator, structureTemplateManager, pieces, random);
        placer.a(firstPiece, (MutableObject<VoxelShape>)new MutableObject((Object)pieceShape), 0, modifyBoundingBox, heightLimitView, noiseConfig, aliasLookup);
        while (placer.g.hasNext()) {
            a pieceState = (a)placer.g.next();
            placer.a(pieceState.a, pieceState.b, pieceState.c, modifyBoundingBox, heightLimitView, noiseConfig, aliasLookup);
        }
    }

    public static boolean a(WorldServer world, Holder<WorldGenFeatureDefinedStructurePoolTemplate> structurePool, MinecraftKey id, int size, BlockPosition pos, boolean keepJigsaws) {
        ChunkGenerator chunkGenerator = world.l().g();
        StructureTemplateManager structureTemplateManager = world.q();
        StructureManager structureManager = world.a();
        RandomSource randomSource = world.F_();
        Structure.a generationContext = new Structure.a(world.I_(), chunkGenerator, chunkGenerator.c(), world.l().i(), structureTemplateManager, world.C(), new ChunkCoordIntPair(pos), world, biome -> true);
        Optional<Structure.b> optional = WorldGenFeatureDefinedStructureJigsawPlacement.a(generationContext, structurePool, Optional.of(id), size, pos, false, Optional.empty(), 128, PoolAliasLookup.a);
        if (optional.isPresent()) {
            StructurePiecesBuilder structurePiecesBuilder = optional.get().a();
            for (StructurePiece structurePiece : structurePiecesBuilder.a().c()) {
                if (!(structurePiece instanceof WorldGenFeaturePillagerOutpostPoolPiece)) continue;
                WorldGenFeaturePillagerOutpostPoolPiece poolElementStructurePiece = (WorldGenFeaturePillagerOutpostPoolPiece)structurePiece;
                poolElementStructurePiece.a((GeneratorAccessSeed)world, structureManager, chunkGenerator, randomSource, StructureBoundingBox.a(), pos, keepJigsaws);
            }
            return true;
        }
        return false;
    }

    static final class b {
        private final IRegistry<WorldGenFeatureDefinedStructurePoolTemplate> a;
        private final int b;
        private final ChunkGenerator c;
        private final StructureTemplateManager d;
        private final List<? super WorldGenFeaturePillagerOutpostPoolPiece> e;
        private final RandomSource f;
        final SequencedPriorityIterator<a> g = new SequencedPriorityIterator();

        b(IRegistry<WorldGenFeatureDefinedStructurePoolTemplate> registry, int maxSize, ChunkGenerator chunkGenerator, StructureTemplateManager structureTemplateManager, List<? super WorldGenFeaturePillagerOutpostPoolPiece> children, RandomSource random) {
            this.a = registry;
            this.b = maxSize;
            this.c = chunkGenerator;
            this.d = structureTemplateManager;
            this.e = children;
            this.f = random;
        }

        void a(WorldGenFeaturePillagerOutpostPoolPiece piece, MutableObject<VoxelShape> pieceShape, int minY, boolean modifyBoundingBox, LevelHeightAccessor world, RandomState noiseConfig, PoolAliasLookup aliasLookup) {
            WorldGenFeatureDefinedStructurePoolStructure structurePoolElement = piece.b();
            BlockPosition blockPos = piece.c();
            EnumBlockRotation rotation = piece.a();
            WorldGenFeatureDefinedStructurePoolTemplate.Matching projection = structurePoolElement.e();
            boolean bl = projection == WorldGenFeatureDefinedStructurePoolTemplate.Matching.b;
            MutableObject mutableObject = new MutableObject();
            StructureBoundingBox boundingBox = piece.f();
            int i2 = boundingBox.i();
            block0: for (DefinedStructure.BlockInfo structureBlockInfo2 : structurePoolElement.a(this.d, blockPos, rotation, this.f)) {
                WorldGenFeatureDefinedStructurePoolStructure structurePoolElement2;
                MutableObject<VoxelShape> mutableObject3;
                EnumDirection direction = BlockJigsaw.h(structureBlockInfo2.b());
                BlockPosition blockPos2 = structureBlockInfo2.a();
                BlockPosition blockPos3 = blockPos2.a(direction);
                int j2 = blockPos2.v() - i2;
                int k2 = -1;
                ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate> resourceKey = net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructureJigsawPlacement$b.a(structureBlockInfo2, aliasLookup);
                Optional<Holder.c<WorldGenFeatureDefinedStructurePoolTemplate>> optional = this.a.b(resourceKey);
                if (optional.isEmpty()) {
                    a.warn("Empty or non-existent pool: {}", (Object)resourceKey.a());
                    continue;
                }
                Holder holder = optional.get();
                if (((WorldGenFeatureDefinedStructurePoolTemplate)holder.a()).b() == 0 && !holder.a(WorldGenFeaturePieces.a)) {
                    a.warn("Empty or non-existent pool: {}", (Object)resourceKey.a());
                    continue;
                }
                Holder<WorldGenFeatureDefinedStructurePoolTemplate> holder2 = ((WorldGenFeatureDefinedStructurePoolTemplate)holder.a()).a();
                if (holder2.a().b() == 0 && !holder2.a(WorldGenFeaturePieces.a)) {
                    a.warn("Empty or non-existent fallback pool: {}", (Object)holder2.e().map(key -> key.a().toString()).orElse("<unregistered>"));
                    continue;
                }
                boolean bl2 = boundingBox.b(blockPos3);
                if (bl2) {
                    MutableObject mutableObject2 = mutableObject;
                    if (mutableObject.getValue() == null) {
                        mutableObject.setValue((Object)VoxelShapes.a(AxisAlignedBB.a(boundingBox)));
                    }
                } else {
                    mutableObject3 = pieceShape;
                }
                ArrayList list = Lists.newArrayList();
                if (minY != this.b) {
                    list.addAll(((WorldGenFeatureDefinedStructurePoolTemplate)holder.a()).b(this.f));
                }
                list.addAll(holder2.a().b(this.f));
                int l2 = structureBlockInfo2.c() != null ? structureBlockInfo2.c().h("placement_priority") : 0;
                Iterator iterator = list.iterator();
                while (iterator.hasNext() && (structurePoolElement2 = (WorldGenFeatureDefinedStructurePoolStructure)iterator.next()) != WorldGenFeatureDefinedStructurePoolEmpty.b) {
                    for (EnumBlockRotation rotation2 : EnumBlockRotation.b(this.f)) {
                        int n2;
                        List<DefinedStructure.BlockInfo> list2 = structurePoolElement2.a(this.d, BlockPosition.b, rotation2, this.f);
                        StructureBoundingBox boundingBox2 = structurePoolElement2.a(this.d, BlockPosition.b, rotation2);
                        if (!modifyBoundingBox || boundingBox2.e() > 16) {
                            boolean m2 = false;
                        } else {
                            n2 = list2.stream().mapToInt(structureBlockInfo -> {
                                if (!boundingBox2.b(structureBlockInfo.a().a(BlockJigsaw.h(structureBlockInfo.b())))) {
                                    return 0;
                                }
                                ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate> resourceKey = net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructureJigsawPlacement$b.a(structureBlockInfo, aliasLookup);
                                Optional<Holder.c<WorldGenFeatureDefinedStructurePoolTemplate>> optional = this.a.b(resourceKey);
                                Optional<Holder> optional2 = optional.map(entry -> ((WorldGenFeatureDefinedStructurePoolTemplate)entry.a()).a());
                                int i2 = optional.map(entry -> ((WorldGenFeatureDefinedStructurePoolTemplate)entry.a()).a(this.d)).orElse(0);
                                int j2 = optional2.map(entry -> ((WorldGenFeatureDefinedStructurePoolTemplate)entry.a()).a(this.d)).orElse(0);
                                return Math.max(i2, j2);
                            }).max().orElse(0);
                        }
                        for (DefinedStructure.BlockInfo structureBlockInfo22 : list2) {
                            int aa2;
                            int x2;
                            int s2;
                            if (!BlockJigsaw.a(structureBlockInfo2, structureBlockInfo22)) continue;
                            BlockPosition blockPos4 = structureBlockInfo22.a();
                            BlockPosition blockPos5 = blockPos3.b(blockPos4);
                            StructureBoundingBox boundingBox3 = structurePoolElement2.a(this.d, blockPos5, rotation2);
                            int o2 = boundingBox3.i();
                            WorldGenFeatureDefinedStructurePoolTemplate.Matching projection2 = structurePoolElement2.e();
                            boolean bl3 = projection2 == WorldGenFeatureDefinedStructurePoolTemplate.Matching.b;
                            int p2 = blockPos4.v();
                            int q2 = j2 - p2 + BlockJigsaw.h(structureBlockInfo2.b()).k();
                            if (bl && bl3) {
                                int r2 = i2 + q2;
                            } else {
                                if (k2 == -1) {
                                    k2 = this.c.b(blockPos2.u(), blockPos2.w(), HeightMap.Type.a, world, noiseConfig);
                                }
                                s2 = k2 - p2;
                            }
                            int t2 = s2 - o2;
                            StructureBoundingBox boundingBox4 = boundingBox3.b(0, t2, 0);
                            BlockPosition blockPos6 = blockPos5.b(0, t2, 0);
                            if (n2 > 0) {
                                int u2 = Math.max(n2 + 1, boundingBox4.l() - boundingBox4.i());
                                boundingBox4.a(new BlockPosition(boundingBox4.h(), boundingBox4.i() + u2, boundingBox4.j()));
                            }
                            if (VoxelShapes.c((VoxelShape)mutableObject3.getValue(), VoxelShapes.a(AxisAlignedBB.a(boundingBox4).h(0.25)), OperatorBoolean.c)) continue;
                            mutableObject3.setValue((Object)VoxelShapes.b((VoxelShape)mutableObject3.getValue(), VoxelShapes.a(AxisAlignedBB.a(boundingBox4)), OperatorBoolean.e));
                            int v2 = piece.d();
                            if (bl3) {
                                int w2 = v2 - q2;
                            } else {
                                x2 = structurePoolElement2.f();
                            }
                            WorldGenFeaturePillagerOutpostPoolPiece poolElementStructurePiece = new WorldGenFeaturePillagerOutpostPoolPiece(this.d, structurePoolElement2, blockPos6, x2, rotation2, boundingBox4);
                            if (bl) {
                                int y2 = i2 + j2;
                            } else if (bl3) {
                                int z2 = s2 + p2;
                            } else {
                                if (k2 == -1) {
                                    k2 = this.c.b(blockPos2.u(), blockPos2.w(), HeightMap.Type.a, world, noiseConfig);
                                }
                                aa2 = k2 + q2 / 2;
                            }
                            piece.a(new WorldGenFeatureDefinedStructureJigsawJunction(blockPos3.u(), (int)(aa2 - j2 + v2), blockPos3.w(), q2, projection2));
                            poolElementStructurePiece.a(new WorldGenFeatureDefinedStructureJigsawJunction(blockPos2.u(), aa2 - p2 + x2, blockPos2.w(), -q2, projection));
                            this.e.add(poolElementStructurePiece);
                            if (minY + 1 > this.b) continue block0;
                            a pieceState = new a(poolElementStructurePiece, mutableObject3, minY + 1);
                            this.g.a(pieceState, l2);
                            continue block0;
                        }
                    }
                }
            }
        }

        private static ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate> a(DefinedStructure.BlockInfo structureBlockInfo, PoolAliasLookup aliasLookup) {
            NBTTagCompound compoundTag = Objects.requireNonNull(structureBlockInfo.c(), () -> structureBlockInfo + " nbt was null");
            ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate> resourceKey = WorldGenFeaturePieces.a(compoundTag.l("pool"));
            return aliasLookup.lookup(resourceKey);
        }
    }

    record a(WorldGenFeaturePillagerOutpostPoolPiece a, MutableObject<VoxelShape> b, int c) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "piece;free;depth", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "piece;free;depth", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "piece;free;depth", "a", "b", "c"}, this, object);
        }
    }
}

