/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.templatesystem;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureStructureProcessorType;

public class CappedProcessor
extends DefinedStructureProcessor {
    public static final Codec<CappedProcessor> a = RecordCodecBuilder.create(instance -> instance.group((App)DefinedStructureStructureProcessorType.a.fieldOf("delegate").forGetter(processor -> processor.b), (App)IntProvider.e.fieldOf("limit").forGetter(processor -> processor.c)).apply((Applicative)instance, CappedProcessor::new));
    private final DefinedStructureProcessor b;
    private final IntProvider c;

    public CappedProcessor(DefinedStructureProcessor delegate, IntProvider limit) {
        this.b = delegate;
        this.c = limit;
    }

    @Override
    @Override
    protected DefinedStructureStructureProcessorType<?> a() {
        return DefinedStructureStructureProcessorType.o;
    }

    @Override
    @Override
    public final List<DefinedStructure.BlockInfo> a(WorldAccess world, BlockPosition pos, BlockPosition pivot, List<DefinedStructure.BlockInfo> originalBlockInfos, List<DefinedStructure.BlockInfo> currentBlockInfos, DefinedStructureInfo data) {
        if (this.c.b() == 0 || currentBlockInfos.isEmpty()) {
            return currentBlockInfos;
        }
        if (originalBlockInfos.size() != currentBlockInfos.size()) {
            SystemUtils.a("Original block info list not in sync with processed list, skipping processing. Original size: " + originalBlockInfos.size() + ", Processed size: " + currentBlockInfos.size());
            return currentBlockInfos;
        }
        RandomSource randomSource = RandomSource.a(world.E().C()).e().a(pos);
        int i2 = Math.min(this.c.a(randomSource), currentBlockInfos.size());
        if (i2 < 1) {
            return currentBlockInfos;
        }
        IntArrayList intArrayList = SystemUtils.a(IntStream.range(0, currentBlockInfos.size()), randomSource);
        IntIterator intIterator = intArrayList.intIterator();
        int j2 = 0;
        while (intIterator.hasNext() && j2 < i2) {
            DefinedStructure.BlockInfo structureBlockInfo2;
            int k2 = intIterator.nextInt();
            DefinedStructure.BlockInfo structureBlockInfo = originalBlockInfos.get(k2);
            DefinedStructure.BlockInfo structureBlockInfo3 = this.b.a((IWorldReader)world, pos, pivot, structureBlockInfo, structureBlockInfo2 = currentBlockInfos.get(k2), data);
            if (structureBlockInfo3 == null || structureBlockInfo2.equals(structureBlockInfo3)) continue;
            ++j2;
            currentBlockInfos.set(k2, structureBlockInfo3);
        }
        return currentBlockInfos;
    }
}

