/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.function.LongPredicate;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.lighting.LeveledPriorityQueue;

public abstract class LightEngineGraph {
    public static final long e = Long.MAX_VALUE;
    private static final int a = 255;
    protected final int f;
    private final LeveledPriorityQueue b;
    private final Long2ByteMap c;
    private volatile boolean d;

    protected LightEngineGraph(int levelCount, int expectedLevelSize, final int expectedTotalSize) {
        if (levelCount >= 254) {
            throw new IllegalArgumentException("Level count must be < 254.");
        }
        this.f = levelCount;
        this.b = new LeveledPriorityQueue(levelCount, expectedLevelSize);
        this.c = new Long2ByteOpenHashMap(expectedTotalSize, 0.5f){

            protected void rehash(int i2) {
                if (i2 > expectedTotalSize) {
                    super.rehash(i2);
                }
            }
        };
        this.c.defaultReturnValue((byte)-1);
    }

    protected void e(long id) {
        int i2 = this.c.remove(id) & 0xFF;
        if (i2 == 255) {
            return;
        }
        int j2 = this.c(id);
        int k2 = this.a(j2, i2);
        this.b.a(id, k2, this.f);
        this.d = !this.b.b();
    }

    public void a(LongPredicate predicate) {
        LongArrayList longList = new LongArrayList();
        this.c.keySet().forEach(arg_0 -> LightEngineGraph.a(predicate, (LongList)longList, arg_0));
        longList.forEach(this::e);
    }

    private int a(int a2, int b2) {
        return Math.min(Math.min(a2, b2), this.f - 1);
    }

    protected void f(long id) {
        this.a(id, id, this.f - 1, false);
    }

    protected void a(long sourceId, long id, int level, boolean decrease) {
        this.a(sourceId, id, level, this.c(id), this.c.get(id) & 0xFF, decrease);
        this.d = !this.b.b();
    }

    private void a(long sourceId, long id, int level, int currentLevel, int i2, boolean decrease) {
        int k2;
        boolean bl;
        if (this.a(id)) {
            return;
        }
        level = MathHelper.a(level, 0, this.f - 1);
        currentLevel = MathHelper.a(currentLevel, 0, this.f - 1);
        boolean bl2 = bl = i2 == 255;
        if (bl) {
            i2 = currentLevel;
        }
        if (decrease) {
            int j2 = Math.min(i2, level);
        } else {
            k2 = MathHelper.a(this.a(id, sourceId, level), 0, this.f - 1);
        }
        int l2 = this.a(currentLevel, i2);
        if (currentLevel != k2) {
            int m2 = this.a(currentLevel, k2);
            if (l2 != m2 && !bl) {
                this.b.a(id, l2, m2);
            }
            this.b.a(id, m2);
            this.c.put(id, (byte)k2);
        } else if (!bl) {
            this.b.a(id, l2, this.f);
            this.c.remove(id);
        }
    }

    protected final void b(long sourceId, long targetId, int level, boolean decrease) {
        int i2 = this.c.get(targetId) & 0xFF;
        int j2 = MathHelper.a(this.b(sourceId, targetId, level), 0, this.f - 1);
        if (decrease) {
            this.a(sourceId, targetId, j2, this.c(targetId), i2, decrease);
        } else {
            int l2;
            boolean bl;
            boolean bl2 = bl = i2 == 255;
            if (bl) {
                int k2 = MathHelper.a(this.c(targetId), 0, this.f - 1);
            } else {
                l2 = i2;
            }
            if (j2 == l2) {
                this.a(sourceId, targetId, this.f - 1, bl ? l2 : this.c(targetId), i2, decrease);
            }
        }
    }

    protected final boolean b() {
        return this.d;
    }

    protected final int b(int maxSteps) {
        if (this.b.b()) {
            return maxSteps;
        }
        while (!this.b.b() && maxSteps > 0) {
            --maxSteps;
            long l2 = this.b.a();
            int i2 = MathHelper.a(this.c(l2), 0, this.f - 1);
            int j2 = this.c.remove(l2) & 0xFF;
            if (j2 < i2) {
                this.a(l2, j2);
                this.a(l2, j2, true);
                continue;
            }
            if (j2 <= i2) continue;
            this.a(l2, this.f - 1);
            if (j2 != this.f - 1) {
                this.b.a(l2, this.a(this.f - 1, j2));
                this.c.put(l2, (byte)j2);
            }
            this.a(l2, i2, false);
        }
        this.d = !this.b.b();
        return maxSteps;
    }

    public int c() {
        return this.c.size();
    }

    protected boolean a(long id) {
        return id == Long.MAX_VALUE;
    }

    protected abstract int a(long var1, long var3, int var5);

    protected abstract void a(long var1, int var3, boolean var4);

    protected abstract int c(long var1);

    protected abstract void a(long var1, int var3);

    protected abstract int b(long var1, long var3, int var5);

    private static /* synthetic */ void a(LongPredicate longPredicate, LongList longList, long l2) {
        if (longPredicate.test(l2)) {
            longList.add(l2);
        }
    }
}

