/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import ca.spottedleaf.dataconverter.minecraft.MCDataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.FileUtils;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NbtFormatException;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.nbt.visitors.SkipFields;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.util.MemoryReserve;
import net.minecraft.util.SessionLock;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.GeneratorSettings;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.storage.LevelDataAndDimensions;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelVersion;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.level.storage.WorldInfo;
import net.minecraft.world.level.storage.WorldNBTStorage;
import net.minecraft.world.level.validation.ContentValidationException;
import net.minecraft.world.level.validation.DirectoryValidator;
import net.minecraft.world.level.validation.ForbiddenSymlinkInfo;
import net.minecraft.world.level.validation.PathAllowList;
import org.slf4j.Logger;

public class Convertable {
    static final Logger b = LogUtils.getLogger();
    static final DateTimeFormatter c = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('_').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral('-').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral('-').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();
    private static final String d = "Data";
    private static final PathMatcher e = path -> false;
    public static final String a = "allowed_symlinks.txt";
    private static final int f = 0x6400000;
    public final Path g;
    private final Path h;
    final DataFixer i;
    private final DirectoryValidator j;

    public Convertable(Path savesDirectory, Path backupsDirectory, DirectoryValidator symlinkFinder, DataFixer dataFixer) {
        this.i = dataFixer;
        try {
            FileUtils.c(savesDirectory);
        }
        catch (IOException ioexception) {
            throw new UncheckedIOException(ioexception);
        }
        this.g = savesDirectory;
        this.h = backupsDirectory;
        this.j = symlinkFinder;
    }

    public static DirectoryValidator a(Path allowedSymlinksFile) {
        if (Files.exists(allowedSymlinksFile, new LinkOption[0])) {
            try {
                DirectoryValidator directoryvalidator;
                try (BufferedReader bufferedreader = Files.newBufferedReader(allowedSymlinksFile);){
                    directoryvalidator = new DirectoryValidator(PathAllowList.a(bufferedreader));
                }
                return directoryvalidator;
            }
            catch (Exception exception) {
                b.error("Failed to parse {}, disallowing all symbolic links", (Object)a, (Object)exception);
            }
        }
        return new DirectoryValidator(e);
    }

    public static Convertable b(Path path) {
        DirectoryValidator directoryvalidator = Convertable.a(path.resolve(a));
        return new Convertable(path, path.resolve("../backups"), directoryvalidator, DataConverterRegistry.a());
    }

    public static WorldDataConfiguration a(Dynamic<?> dynamic) {
        DataResult dataresult = WorldDataConfiguration.b.parse(dynamic);
        Logger logger = b;
        Objects.requireNonNull(logger);
        return dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).orElse(WorldDataConfiguration.c);
    }

    public static WorldLoader.d a(Dynamic<?> dynamic, ResourcePackRepository dataPackManager, boolean safeMode) {
        return new WorldLoader.d(dataPackManager, Convertable.a(dynamic), safeMode, false);
    }

    public static LevelDataAndDimensions a(Dynamic<?> dynamic, WorldDataConfiguration dataConfiguration, IRegistry<WorldDimension> dimensionsRegistry, IRegistryCustom.Dimension registryManager) {
        Dynamic<?> dynamic1 = Convertable.a(dynamic, registryManager);
        Dynamic dynamic2 = dynamic1.get("WorldGenSettings").orElseEmptyMap();
        DataResult dataresult = GeneratorSettings.a.parse(dynamic2);
        Logger logger = b;
        Objects.requireNonNull(logger);
        GeneratorSettings generatorsettings = (GeneratorSettings)dataresult.getOrThrow(false, SystemUtils.a("WorldGenSettings: ", arg_0 -> ((Logger)logger).error(arg_0)));
        WorldSettings worldsettings = WorldSettings.a(dynamic1, dataConfiguration);
        WorldDimensions.b worlddimensions_b = generatorsettings.b().a(dimensionsRegistry);
        Lifecycle lifecycle = worlddimensions_b.a().add(registryManager.e());
        WorldDataServer worlddataserver = WorldDataServer.a(dynamic1, worldsettings, worlddimensions_b.d(), generatorsettings.a(), lifecycle);
        worlddataserver.pdc = (NBTBase)dynamic1.getElement("BukkitValues", null);
        return new LevelDataAndDimensions(worlddataserver, worlddimensions_b);
    }

    private static <T> Dynamic<T> a(Dynamic<T> dynamic, IRegistryCustom.Dimension registryManager) {
        RegistryOps registryops = RegistryOps.a(dynamic.getOps(), registryManager);
        return new Dynamic(registryops, dynamic.getValue());
    }

    public String a() {
        return "Anvil";
    }

    public a b() throws LevelStorageException {
        if (!Files.isDirectory(this.g, new LinkOption[0])) {
            throw new LevelStorageException(IChatBaseComponent.c("selectWorld.load_folder_access"));
        }
        try {
            a convertable_a;
            try (Stream<Path> stream = Files.list(this.g);){
                List<b> list = stream.filter(path -> Files.isDirectory(path, new LinkOption[0])).map(b::new).filter(convertable_b -> Files.isRegularFile(convertable_b.b(), new LinkOption[0]) || Files.isRegularFile(convertable_b.c(), new LinkOption[0])).toList();
                convertable_a = new a(list);
            }
            return convertable_a;
        }
        catch (IOException ioexception) {
            throw new LevelStorageException(IChatBaseComponent.c("selectWorld.load_folder_access"));
        }
    }

    public CompletableFuture<List<WorldInfo>> a(a levels) {
        ArrayList<CompletableFuture<WorldInfo>> list = new ArrayList<CompletableFuture<WorldInfo>>(levels.a.size());
        for (b convertable_b : levels.a) {
            list.add(CompletableFuture.supplyAsync(() -> {
                boolean flag;
                try {
                    flag = SessionLock.b(convertable_b.f());
                }
                catch (Exception exception) {
                    b.warn("Failed to read {} lock", (Object)convertable_b.f(), (Object)exception);
                    return null;
                }
                try {
                    return this.a(convertable_b, flag);
                }
                catch (OutOfMemoryError outofmemoryerror) {
                    MemoryReserve.b();
                    System.gc();
                    String s2 = "Ran out of memory trying to read summary of world folder \"" + convertable_b.a() + "\"";
                    b.error(LogUtils.FATAL_MARKER, s2);
                    OutOfMemoryError outofmemoryerror1 = new OutOfMemoryError("Ran out of memory reading level data");
                    outofmemoryerror1.initCause(outofmemoryerror);
                    CrashReport crashreport = CrashReport.a(outofmemoryerror1, s2);
                    CrashReportSystemDetails crashreportsystemdetails = crashreport.a("World details");
                    crashreportsystemdetails.a("Folder Name", convertable_b.a());
                    try {
                        long i2 = Files.size(convertable_b.b());
                        crashreportsystemdetails.a("level.dat size", i2);
                    }
                    catch (IOException ioexception) {
                        crashreportsystemdetails.a("level.dat size", ioexception);
                    }
                    throw new ReportedException(crashreport);
                }
            }, SystemUtils.f()));
        }
        return SystemUtils.d(list).thenApply(list1 -> list1.stream().filter(Objects::nonNull).sorted().toList());
    }

    private int f() {
        return 19133;
    }

    static NBTTagCompound c(Path path) throws IOException {
        return NBTCompressedStreamTools.a(path, NBTReadLimiter.a(0x6400000L));
    }

    static Dynamic<?> a(Path path, DataFixer dataFixer) throws IOException {
        int i2;
        NBTTagCompound nbttagcompound = Convertable.c(path);
        NBTTagCompound nbttagcompound1 = nbttagcompound.p(d);
        int version = i2 = GameProfileSerializer.b(nbttagcompound1, -1);
        Dynamic<NBTTagCompound> dynamic = DataFixTypes.a.a(dataFixer, new Dynamic<NBTTagCompound>(DynamicOpsNBT.a, nbttagcompound1), i2);
        Dynamic dynamic1 = dynamic.get("Player").orElseEmptyMap();
        Dynamic dynamic2 = Convertable.dank(dynamic1, version);
        dynamic = dynamic.set("Player", dynamic2);
        Dynamic dynamic3 = dynamic.get("WorldGenSettings").orElseEmptyMap();
        Dynamic dynamic4 = DataFixTypes.r.a(dataFixer, dynamic3, i2);
        dynamic = dynamic.set("WorldGenSettings", dynamic4);
        return dynamic;
    }

    private static <T> Dynamic<T> dank(Dynamic<T> input, int version) {
        return new Dynamic<NBTTagCompound>(input.getOps(), MCDataConverter.convertTag(MCTypeRegistry.PLAYER, (NBTTagCompound)input.getValue(), version, SharedConstants.b().d().c()));
    }

    private WorldInfo a(b save, boolean locked) {
        Path path = save.b();
        if (Files.exists(path, new LinkOption[0])) {
            try {
                List<ForbiddenSymlinkInfo> list;
                if (Files.isSymbolicLink(path) && !(list = this.j.a(path)).isEmpty()) {
                    b.warn("{}", (Object)ContentValidationException.a(path, list));
                    return new WorldInfo.c(save.a(), save.d());
                }
                NBTBase nbtbase = Convertable.e(path);
                if (nbtbase instanceof NBTTagCompound) {
                    NBTTagCompound nbttagcompound = (NBTTagCompound)nbtbase;
                    NBTTagCompound nbttagcompound1 = nbttagcompound.p(d);
                    int i2 = GameProfileSerializer.b(nbttagcompound1, -1);
                    Dynamic<NBTTagCompound> dynamic = DataFixTypes.a.a(this.i, new Dynamic<NBTTagCompound>(DynamicOpsNBT.a, nbttagcompound1), i2);
                    return this.a(dynamic, save, locked);
                }
                b.warn("Invalid root tag in {}", (Object)path);
            }
            catch (Exception exception) {
                b.error("Exception reading {}", (Object)path, (Object)exception);
            }
        }
        return new WorldInfo.b(save.a(), save.d(), Convertable.a(save));
    }

    private static long a(b save) {
        Instant instant = Convertable.d(save.b());
        if (instant == null) {
            instant = Convertable.d(save.c());
        }
        return instant == null ? -1L : instant.toEpochMilli();
    }

    @Nullable
    static Instant d(Path path) {
        try {
            return Files.getLastModifiedTime(path, new LinkOption[0]).toInstant();
        }
        catch (IOException ioexception) {
            return null;
        }
    }

    WorldInfo a(Dynamic<?> dynamic, b save, boolean locked) {
        LevelVersion levelversion = LevelVersion.a(dynamic);
        int i2 = levelversion.a();
        if (i2 != 19132 && i2 != 19133) {
            throw new NbtFormatException("Unknown data version: " + Integer.toHexString(i2));
        }
        boolean flag1 = i2 != this.f();
        Path path = save.d();
        WorldDataConfiguration worlddataconfiguration = Convertable.a(dynamic);
        WorldSettings worldsettings = WorldSettings.a(dynamic, worlddataconfiguration);
        FeatureFlagSet featureflagset = Convertable.b(dynamic);
        boolean flag2 = FeatureFlags.a(featureflagset);
        return new WorldInfo(worldsettings, levelversion, save.a(), flag1, locked, flag2, path);
    }

    private static FeatureFlagSet b(Dynamic<?> levelData) {
        Set<MinecraftKey> set = levelData.get("enabled_features").asStream().flatMap(dynamic1 -> dynamic1.asString().result().map(MinecraftKey::a).stream()).collect(Collectors.toSet());
        return FeatureFlags.e.a(set, minecraftkey -> {});
    }

    @Nullable
    private static NBTBase e(Path path) throws IOException {
        SkipFields skipfields = new SkipFields(new FieldSelector(d, NBTTagCompound.b, "Player"), new FieldSelector(d, NBTTagCompound.b, "WorldGenSettings"));
        NBTCompressedStreamTools.a(path, (StreamTagVisitor)skipfields, NBTReadLimiter.a(0x6400000L));
        return skipfields.d();
    }

    public boolean a(String name) {
        try {
            Path path = this.c(name);
            Files.createDirectory(path, new FileAttribute[0]);
            Files.deleteIfExists(path);
            return true;
        }
        catch (IOException ioexception) {
            return false;
        }
    }

    public boolean b(String name) {
        try {
            return Files.isDirectory(this.c(name), new LinkOption[0]);
        }
        catch (InvalidPathException invalidpathexception) {
            return false;
        }
    }

    public Path c(String name) {
        return this.g.resolve(name);
    }

    public Path c() {
        return this.g;
    }

    public Path d() {
        return this.h;
    }

    public ConversionSession validateAndCreateAccess(String s2, ResourceKey<WorldDimension> dimensionType) throws IOException, ContentValidationException {
        Path path = this.c(s2);
        List<ForbiddenSymlinkInfo> list = this.j.a(path, true);
        if (!list.isEmpty()) {
            throw new ContentValidationException(path, list);
        }
        return new ConversionSession(s2, path, dimensionType);
    }

    public ConversionSession createAccess(String s2, ResourceKey<WorldDimension> dimensionType) throws IOException {
        Path path = this.c(s2);
        return new ConversionSession(s2, path, dimensionType);
    }

    public DirectoryValidator e() {
        return this.j;
    }

    public static Path getStorageFolder(Path path, ResourceKey<WorldDimension> dimensionType) {
        if (dimensionType == WorldDimension.b) {
            return path;
        }
        if (dimensionType == WorldDimension.c) {
            return path.resolve("DIM-1");
        }
        if (dimensionType == WorldDimension.d) {
            return path.resolve("DIM1");
        }
        return path.resolve("dimensions").resolve(dimensionType.a().b()).resolve(dimensionType.a().a());
    }

    public record a(List<b> a) implements Iterable<b>
    {
        private final List<b> a;

        public boolean a() {
            return this.a.isEmpty();
        }

        @Override
        public Iterator<b> iterator() {
            return this.a.iterator();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "levels", "a"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "levels", "a"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "levels", "a"}, this, o2);
        }

        public List<b> b() {
            return this.a;
        }
    }

    public record b(Path a) {
        private final Path a;

        public String a() {
            return this.a.getFileName().toString();
        }

        public Path b() {
            return this.a(SavedFile.e);
        }

        public Path c() {
            return this.a(SavedFile.f);
        }

        public Path a(LocalDateTime dateTime) {
            Path path = this.a;
            String s2 = SavedFile.e.a();
            return path.resolve(s2 + "_corrupted_" + dateTime.format(c));
        }

        public Path b(LocalDateTime dateTime) {
            Path path = this.a;
            String s2 = SavedFile.e.a();
            return path.resolve(s2 + "_raw_" + dateTime.format(c));
        }

        public Path d() {
            return this.a(SavedFile.g);
        }

        public Path e() {
            return this.a(SavedFile.h);
        }

        public Path a(SavedFile savePath) {
            return this.a.resolve(savePath.a());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "path", "a"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "path", "a"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "path", "a"}, this, o2);
        }

        public Path f() {
            return this.a;
        }
    }

    public class ConversionSession
    implements AutoCloseable {
        final SessionLock b;
        public final b c;
        private final String d;
        private final Map<SavedFile, Path> e = Maps.newHashMap();
        public final ResourceKey<WorldDimension> dimensionType;

        ConversionSession(String s2, Path path, ResourceKey<WorldDimension> dimensionType) throws IOException {
            this.dimensionType = dimensionType;
            this.d = s2;
            this.c = new b(path);
            this.b = SessionLock.a(path);
        }

        public void a() {
            try {
                this.close();
            }
            catch (IOException ioexception) {
                b.warn("Failed to unlock access to level {}", (Object)this.d(), (Object)ioexception);
            }
        }

        public Convertable b() {
            return Convertable.this;
        }

        public b c() {
            return this.c;
        }

        public String d() {
            return this.d;
        }

        public Path a(SavedFile savePath) {
            Map<SavedFile, Path> map = this.e;
            b convertable_b = this.c;
            Objects.requireNonNull(this.c);
            return map.computeIfAbsent(savePath, convertable_b::a);
        }

        public Path a(ResourceKey<World> key) {
            return Convertable.getStorageFolder(this.c.f(), this.dimensionType);
        }

        private void m() {
            if (!this.b.a()) {
                throw new IllegalStateException("Lock is no longer valid");
            }
        }

        public WorldNBTStorage e() {
            this.m();
            return new WorldNBTStorage(this, Convertable.this.i);
        }

        public WorldInfo a(Dynamic<?> dynamic) {
            this.m();
            return Convertable.this.a(dynamic, this.c, false);
        }

        public Dynamic<?> f() throws IOException {
            return this.b(false);
        }

        public Dynamic<?> g() throws IOException {
            return this.b(true);
        }

        private Dynamic<?> b(boolean old) throws IOException {
            this.m();
            return Convertable.a(old ? this.c.c() : this.c.b(), Convertable.this.i);
        }

        public void a(IRegistryCustom registryManager, SaveData saveProperties) {
            this.a(registryManager, saveProperties, null);
        }

        public void a(IRegistryCustom registryManager, SaveData saveProperties, @Nullable NBTTagCompound nbt) {
            NBTTagCompound nbttagcompound1 = saveProperties.a(registryManager, nbt);
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            nbttagcompound2.a(Convertable.d, nbttagcompound1);
            this.a(nbttagcompound2);
        }

        private void a(NBTTagCompound nbt) {
            Path path = this.c.f();
            try {
                Path path1 = Files.createTempFile(path, "level", ".dat", new FileAttribute[0]);
                NBTCompressedStreamTools.a(nbt, path1);
                Path path2 = this.c.c();
                Path path3 = this.c.b();
                SystemUtils.a(path3, path1, path2);
            }
            catch (Exception exception) {
                b.error("Failed to save level {}", (Object)path, (Object)exception);
            }
        }

        public Optional<Path> h() {
            return !this.b.a() ? Optional.empty() : Optional.of(this.c.d());
        }

        public void i() throws IOException {
            this.m();
            final Path path = this.c.e();
            b.info("Deleting level {}", (Object)this.d);
            for (int i2 = 1; i2 <= 5; ++i2) {
                b.info("Attempt {}...", (Object)i2);
                try {
                    Files.walkFileTree(this.c.f(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        public FileVisitResult a(Path path1, BasicFileAttributes basicfileattributes) throws IOException {
                            if (!path1.equals(path)) {
                                Convertable.b.debug("Deleting {}", (Object)path1);
                                Files.delete(path1);
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        public FileVisitResult a(Path path1, @Nullable IOException ioexception) throws IOException {
                            if (ioexception != null) {
                                throw ioexception;
                            }
                            if (path1.equals(ConversionSession.this.c.f())) {
                                ConversionSession.this.b.close();
                                Files.deleteIfExists(path);
                            }
                            Files.delete(path1);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                    break;
                }
                catch (IOException ioexception) {
                    if (i2 >= 5) {
                        throw ioexception;
                    }
                    b.warn("Failed to delete {}", (Object)this.c.f(), (Object)ioexception);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }

        public void a(String name) throws IOException {
            this.a((NBTTagCompound nbttagcompound) -> nbttagcompound.a("LevelName", name.trim()));
        }

        public void b(String name) throws IOException {
            this.a((NBTTagCompound nbttagcompound) -> {
                nbttagcompound.a("LevelName", name.trim());
                nbttagcompound.r("Player");
            });
        }

        private void a(Consumer<NBTTagCompound> nbtProcessor) throws IOException {
            this.m();
            NBTTagCompound nbttagcompound = Convertable.c(this.c.b());
            nbtProcessor.accept(nbttagcompound.p(Convertable.d));
            this.a(nbttagcompound);
        }

        public long j() throws IOException {
            this.m();
            String s2 = LocalDateTime.now().format(c);
            String s1 = s2 + "_" + this.d;
            Path path = Convertable.this.d();
            try {
                FileUtils.c(path);
            }
            catch (IOException ioexception) {
                throw new RuntimeException(ioexception);
            }
            Path path1 = path.resolve(FileUtils.a(path, s1, ".zip"));
            try (final ZipOutputStream zipoutputstream = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(path1, new OpenOption[0])));){
                final Path path2 = Paths.get(this.d, new String[0]);
                Files.walkFileTree(this.c.f(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    public FileVisitResult a(Path path3, BasicFileAttributes basicfileattributes) throws IOException {
                        if (path3.endsWith("session.lock")) {
                            return FileVisitResult.CONTINUE;
                        }
                        String s2 = path2.resolve(ConversionSession.this.c.f().relativize(path3)).toString().replace('\\', '/');
                        ZipEntry zipentry = new ZipEntry(s2);
                        zipoutputstream.putNextEntry(zipentry);
                        com.google.common.io.Files.asByteSource((File)path3.toFile()).copyTo((OutputStream)zipoutputstream);
                        zipoutputstream.closeEntry();
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            return Files.size(path1);
        }

        public boolean k() {
            return Files.exists(this.c.b(), new LinkOption[0]) || Files.exists(this.c.c(), new LinkOption[0]);
        }

        @Override
        public void close() throws IOException {
            this.b.close();
        }

        public boolean l() {
            return SystemUtils.a(this.c.b(), this.c.c(), this.c.a(LocalDateTime.now()), true);
        }

        @Nullable
        public Instant a(boolean old) {
            return Convertable.d(old ? this.c.c() : this.c.b());
        }
    }
}

