/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public class IntRange {
    private static final Codec<IntRange> b = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.a(NumberProviders.a, "min").forGetter(operator -> Optional.ofNullable(operator.c)), (App)ExtraCodecs.a(NumberProviders.a, "max").forGetter(operator -> Optional.ofNullable(operator.d))).apply((Applicative)instance, IntRange::new));
    public static final Codec<IntRange> a = Codec.either((Codec)Codec.INT, b).xmap(either -> either.map(IntRange::a, Function.identity()), operator -> {
        OptionalInt optionalInt = operator.b();
        if (optionalInt.isPresent()) {
            return Either.left(optionalInt.getAsInt());
        }
        return Either.right(operator);
    });
    @Nullable
    private final NumberProvider c;
    @Nullable
    private final NumberProvider d;
    private final b e;
    private final a f;

    public Set<LootContextParameter<?>> a() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (this.c != null) {
            builder.addAll(this.c.a());
        }
        if (this.d != null) {
            builder.addAll(this.d.a());
        }
        return builder.build();
    }

    private IntRange(Optional<NumberProvider> min, Optional<NumberProvider> max) {
        this((NumberProvider)min.orElse(null), (NumberProvider)max.orElse(null));
    }

    private IntRange(@Nullable NumberProvider min, @Nullable NumberProvider max) {
        this.c = min;
        this.d = max;
        if (min == null) {
            if (max == null) {
                this.e = (context, value) -> value;
                this.f = (context, value) -> true;
            } else {
                this.e = (context, value) -> Math.min(max.a(context), value);
                this.f = (context, value) -> value <= max.a(context);
            }
        } else if (max == null) {
            this.e = (context, value) -> Math.max(min.a(context), value);
            this.f = (context, value) -> value >= min.a(context);
        } else {
            this.e = (context, value) -> MathHelper.a(value, min.a(context), max.a(context));
            this.f = (context, value) -> value >= min.a(context) && value <= max.a(context);
        }
    }

    public static IntRange a(int value) {
        ConstantValue constantValue = ConstantValue.a(value);
        return new IntRange(Optional.of(constantValue), Optional.of(constantValue));
    }

    public static IntRange a(int min, int max) {
        return new IntRange(Optional.of(ConstantValue.a(min)), Optional.of(ConstantValue.a(max)));
    }

    public static IntRange b(int min) {
        return new IntRange(Optional.of(ConstantValue.a(min)), Optional.empty());
    }

    public static IntRange c(int max) {
        return new IntRange(Optional.empty(), Optional.of(ConstantValue.a(max)));
    }

    public int a(LootTableInfo context, int value) {
        return this.e.apply(context, value);
    }

    public boolean b(LootTableInfo context, int value) {
        return this.f.test(context, value);
    }

    private OptionalInt b() {
        ConstantValue constantValue;
        NumberProvider numberProvider;
        if (Objects.equals(this.c, this.d) && (numberProvider = this.c) instanceof ConstantValue && Math.floor((constantValue = (ConstantValue)numberProvider).c()) == (double)constantValue.c()) {
            return OptionalInt.of((int)constantValue.c());
        }
        return OptionalInt.empty();
    }

    @FunctionalInterface
    static interface b {
        public int apply(LootTableInfo var1, int var2);
    }

    @FunctionalInterface
    static interface a {
        public boolean test(LootTableInfo var1, int var2);
    }
}

