/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.Sets;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootDataResolver;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootTableInfo {
    private final LootParams a;
    private final RandomSource b;
    private final LootDataResolver c;
    private final Set<c<?>> d = Sets.newLinkedHashSet();

    LootTableInfo(LootParams parameters, RandomSource random, LootDataResolver dataLookup) {
        this.a = parameters;
        this.b = random;
        this.c = dataLookup;
    }

    public boolean a(LootContextParameter<?> parameter) {
        return this.a.a(parameter);
    }

    public <T> T b(LootContextParameter<T> parameter) {
        return this.a.b(parameter);
    }

    public void a(MinecraftKey id, Consumer<ItemStack> lootConsumer) {
        this.a.a(id, lootConsumer);
    }

    @Nullable
    public <T> T c(LootContextParameter<T> parameter) {
        return this.a.d(parameter);
    }

    public boolean a(c<?> entry) {
        return this.d.contains(entry);
    }

    public boolean b(c<?> entry) {
        return this.d.add(entry);
    }

    public void c(c<?> entry) {
        this.d.remove(entry);
    }

    public LootDataResolver a() {
        return this.c;
    }

    public RandomSource b() {
        return this.b;
    }

    public float c() {
        return this.a.b();
    }

    public WorldServer d() {
        return this.a.a();
    }

    public static c<LootTable> a(LootTable table) {
        return new c<LootTable>(LootDataType.c, table);
    }

    public static c<LootItemCondition> a(LootItemCondition predicate) {
        return new c<LootItemCondition>(LootDataType.a, predicate);
    }

    public static c<LootItemFunction> a(LootItemFunction itemModifier) {
        return new c<LootItemFunction>(LootDataType.b, itemModifier);
    }

    public record c<T>(LootDataType<T> a, T b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "type;value", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "type;value", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "type;value", "a", "b"}, this, o2);
        }
    }

    public static final class EntityTarget
    extends Enum<EntityTarget>
    implements INamable {
        public static final /* enum */ EntityTarget a = new EntityTarget("this", LootContextParameters.a);
        public static final /* enum */ EntityTarget b = new EntityTarget("killer", LootContextParameters.d);
        public static final /* enum */ EntityTarget c = new EntityTarget("direct_killer", LootContextParameters.e);
        public static final /* enum */ EntityTarget d = new EntityTarget("killer_player", LootContextParameters.b);
        public static final INamable.a<EntityTarget> e;
        private final String f;
        private final LootContextParameter<? extends Entity> g;
        private static final /* synthetic */ EntityTarget[] h;

        public static EntityTarget[] values() {
            return (EntityTarget[])h.clone();
        }

        public static EntityTarget valueOf(String name) {
            return Enum.valueOf(EntityTarget.class, name);
        }

        private EntityTarget(String type, LootContextParameter<? extends Entity> parameter) {
            this.f = type;
            this.g = parameter;
        }

        public LootContextParameter<? extends Entity> a() {
            return this.g;
        }

        public static EntityTarget a(String type) {
            EntityTarget entityTarget = e.a(type);
            if (entityTarget != null) {
                return entityTarget;
            }
            throw new IllegalArgumentException("Invalid entity target " + type);
        }

        @Override
        public String c() {
            return this.f;
        }

        private static /* synthetic */ EntityTarget[] b() {
            return new EntityTarget[]{a, b, c, d};
        }

        static {
            h = EntityTarget.b();
            e = INamable.a(EntityTarget::values);
        }
    }

    public static class Builder {
        private final LootParams a;
        @Nullable
        private RandomSource b;

        public Builder(LootParams parameters) {
            this.a = parameters;
        }

        public Builder withRandom(RandomSource random) {
            this.b = random;
            return this;
        }

        public Builder a(long seed) {
            if (seed != 0L) {
                this.b = RandomSource.a(seed);
            }
            return this;
        }

        public WorldServer a() {
            return this.a.a();
        }

        public LootTableInfo a(Optional<MinecraftKey> randomId) {
            WorldServer serverLevel = this.a();
            MinecraftServer minecraftServer = serverLevel.o();
            RandomSource randomSource = Optional.ofNullable(this.b).or(() -> randomId.map(serverLevel::a)).orElseGet(serverLevel::F_);
            return new LootTableInfo(this.a, randomSource, minecraftServer.aJ());
        }
    }
}

