/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.INamable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProviders;

public class LootItemFunctionCopyNBT
extends LootItemFunctionConditional {
    public static final Codec<LootItemFunctionCopyNBT> a = RecordCodecBuilder.create(instance -> LootItemFunctionCopyNBT.a(instance).and(instance.group((App)NbtProviders.a.fieldOf("source").forGetter(function -> function.b), (App)net.minecraft.world.level.storage.loot.functions.LootItemFunctionCopyNBT$b.a.listOf().fieldOf("ops").forGetter(function -> function.c))).apply((Applicative)instance, LootItemFunctionCopyNBT::new));
    private final NbtProvider b;
    private final List<b> c;

    LootItemFunctionCopyNBT(List<LootItemCondition> conditions, NbtProvider source, List<b> operations) {
        super(conditions);
        this.b = source;
        this.c = List.copyOf(operations);
    }

    @Override
    @Override
    public LootItemFunctionType b() {
        return LootItemFunctions.w;
    }

    @Override
    @Override
    public Set<LootContextParameter<?>> a() {
        return this.b.b();
    }

    @Override
    @Override
    public ItemStack a(ItemStack stack, LootTableInfo context) {
        NBTBase tag = this.b.a(context);
        if (tag != null) {
            this.c.forEach(operation -> operation.a(stack::w, tag));
        }
        return stack;
    }

    public static a a(NbtProvider source) {
        return new a(source);
    }

    public static a a(LootTableInfo.EntityTarget target) {
        return new a(ContextNbtProvider.a(target));
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private final NbtProvider a;
        private final List<b> b = Lists.newArrayList();

        a(NbtProvider source) {
            this.a = source;
        }

        public a a(String source, String target, Action operator) {
            try {
                this.b.add(new b(d.a(source), d.a(target), operator));
            }
            catch (CommandSyntaxException commandSyntaxException) {
                throw new IllegalArgumentException(commandSyntaxException);
            }
            return this;
        }

        public a a(String source, String target) {
            return this.a(source, target, Action.a);
        }

        @Override
        protected a a() {
            return this;
        }

        @Override
        @Override
        public LootItemFunction b() {
            return new LootItemFunctionCopyNBT(this.g(), this.a, this.b);
        }

        @Override
        protected /* synthetic */ LootItemFunctionConditional.a c() {
            return this.a();
        }
    }

    static final class b
    extends Record {
        private final d b;
        private final d c;
        private final Action d;
        public static final Codec<b> a = RecordCodecBuilder.create(instance -> instance.group((App)net.minecraft.world.level.storage.loot.functions.LootItemFunctionCopyNBT$d.a.fieldOf("source").forGetter(b::a), (App)net.minecraft.world.level.storage.loot.functions.LootItemFunctionCopyNBT$d.a.fieldOf("target").forGetter(b::b), (App)Action.d.fieldOf("op").forGetter(b::c)).apply((Applicative)instance, b::new));

        b(d path, d path2, Action operator) {
            this.b = path;
            this.c = path2;
            this.d = operator;
        }

        public void a(Supplier<NBTBase> itemNbtGetter, NBTBase sourceEntityNbt) {
            try {
                List<NBTBase> list = this.b.b().a(sourceEntityNbt);
                if (!list.isEmpty()) {
                    this.d.a(itemNbtGetter.get(), this.c.b(), list);
                }
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "sourcePath;targetPath;op", "b", "c", "d"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "sourcePath;targetPath;op", "b", "c", "d"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "sourcePath;targetPath;op", "b", "c", "d"}, this, object);
        }

        public d a() {
            return this.b;
        }

        public d b() {
            return this.c;
        }

        public Action c() {
            return this.d;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class Action
    extends Enum<Action>
    implements INamable {
        public static final /* enum */ Action a = new Action("replace"){

            @Override
            @Override
            public void a(NBTBase itemNbt, ArgumentNBTKey.g targetPath, List<NBTBase> sourceNbts) throws CommandSyntaxException {
                targetPath.a(itemNbt, (NBTBase)Iterables.getLast(sourceNbts));
            }
        };
        public static final /* enum */ Action b = new Action("append"){

            @Override
            @Override
            public void a(NBTBase itemNbt, ArgumentNBTKey.g targetPath, List<NBTBase> sourceNbts) throws CommandSyntaxException {
                List<NBTBase> list = targetPath.a(itemNbt, NBTTagList::new);
                list.forEach(foundNbt -> {
                    if (foundNbt instanceof NBTTagList) {
                        sourceNbts.forEach(sourceNbt -> ((NBTTagList)foundNbt).add(sourceNbt.d()));
                    }
                });
            }
        };
        public static final /* enum */ Action c = new Action("merge"){

            @Override
            @Override
            public void a(NBTBase itemNbt, ArgumentNBTKey.g targetPath, List<NBTBase> sourceNbts) throws CommandSyntaxException {
                List<NBTBase> list = targetPath.a(itemNbt, NBTTagCompound::new);
                list.forEach(foundNbt -> {
                    if (foundNbt instanceof NBTTagCompound) {
                        sourceNbts.forEach(sourceNbt -> {
                            if (sourceNbt instanceof NBTTagCompound) {
                                ((NBTTagCompound)foundNbt).a((NBTTagCompound)sourceNbt);
                            }
                        });
                    }
                });
            }
        };
        public static final Codec<Action> d;
        private final String e;
        private static final /* synthetic */ Action[] f;

        public static Action[] values() {
            return (Action[])f.clone();
        }

        public static Action valueOf(String string) {
            return Enum.valueOf(Action.class, string);
        }

        public abstract void a(NBTBase var1, ArgumentNBTKey.g var2, List<NBTBase> var3) throws CommandSyntaxException;

        Action(String name) {
            this.e = name;
        }

        @Override
        @Override
        public String c() {
            return this.e;
        }

        private static /* synthetic */ Action[] a() {
            return new Action[]{a, b, c};
        }

        static {
            f = Action.a();
            d = INamable.a(Action::values);
        }
    }

    static final class d
    extends Record {
        private final String b;
        private final ArgumentNBTKey.g c;
        public static final Codec<d> a = Codec.STRING.comapFlatMap(path -> {
            try {
                return DataResult.success((Object)d.a(path));
            }
            catch (CommandSyntaxException commandSyntaxException) {
                return DataResult.error(() -> "Failed to parse path " + path + ": " + commandSyntaxException.getMessage());
            }
        }, d::a);

        private d(String string, ArgumentNBTKey.g nbtPath) {
            this.b = string;
            this.c = nbtPath;
        }

        public static d a(String path) throws CommandSyntaxException {
            ArgumentNBTKey.g nbtPath = new ArgumentNBTKey().a(new StringReader(path));
            return new d(path, nbtPath);
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "string;path", "b", "c"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "string;path", "b", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "string;path", "b", "c"}, this, object);
        }

        public String a() {
            return this.b;
        }

        public ArgumentNBTKey.g b() {
            return this.c;
        }
    }
}

