/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public class LootItemFunctionSetAttribute
extends LootItemFunctionConditional {
    public static final Codec<LootItemFunctionSetAttribute> a = RecordCodecBuilder.create(instance -> LootItemFunctionSetAttribute.a(instance).and((App)ExtraCodecs.a(net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetAttribute$b.a.listOf()).fieldOf("modifiers").forGetter(function -> function.b)).apply((Applicative)instance, LootItemFunctionSetAttribute::new));
    private final List<b> b;

    LootItemFunctionSetAttribute(List<LootItemCondition> conditions, List<b> attributes) {
        super(conditions);
        this.b = List.copyOf(attributes);
    }

    @Override
    @Override
    public LootItemFunctionType b() {
        return LootItemFunctions.k;
    }

    @Override
    @Override
    public Set<LootContextParameter<?>> a() {
        return (Set)this.b.stream().flatMap(attribute -> attribute.e.a().stream()).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    @Override
    public ItemStack a(ItemStack stack, LootTableInfo context) {
        RandomSource randomSource = context.b();
        for (b modifier : this.b) {
            UUID uUID = modifier.g.orElseGet(UUID::randomUUID);
            EnumItemSlot equipmentSlot = SystemUtils.a(modifier.f, randomSource);
            stack.a(modifier.c.a(), new AttributeModifier(uUID, modifier.b, modifier.e.b(context), modifier.d), equipmentSlot);
        }
        return stack;
    }

    public static c a(String name, Holder<AttributeBase> attribute, AttributeModifier.Operation operation, NumberProvider amountRange) {
        return new c(name, attribute, operation, amountRange);
    }

    public static a c() {
        return new a();
    }

    static final class b
    extends Record {
        private final String b;
        private final Holder<AttributeBase> c;
        private final AttributeModifier.Operation d;
        private final NumberProvider e;
        private final List<EnumItemSlot> f;
        private final Optional<UUID> g;
        private static final Codec<List<EnumItemSlot>> h = ExtraCodecs.a(Codec.either(EnumItemSlot.g, (Codec)EnumItemSlot.g.listOf()).xmap(either -> either.map(List::of, Function.identity()), list -> list.size() == 1 ? Either.left((EnumItemSlot)list.get(0)) : Either.right(list)));
        public static final Codec<b> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(b::a), (App)BuiltInRegistries.u.r().fieldOf("attribute").forGetter(b::b), (App)AttributeModifier.Operation.d.fieldOf("operation").forGetter(b::c), (App)NumberProviders.a.fieldOf("amount").forGetter(b::d), (App)h.fieldOf("slot").forGetter(b::e), (App)ExtraCodecs.a(UUIDUtil.c, "id").forGetter(b::f)).apply((Applicative)instance, b::new));

        b(String name, Holder<AttributeBase> holder, AttributeModifier.Operation operation, NumberProvider amount, List<EnumItemSlot> list, Optional<UUID> optional) {
            this.b = name;
            this.c = holder;
            this.d = operation;
            this.e = amount;
            this.f = list;
            this.g = optional;
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "name;attribute;operation;amount;slots;id", "b", "c", "d", "e", "f", "g"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "name;attribute;operation;amount;slots;id", "b", "c", "d", "e", "f", "g"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "name;attribute;operation;amount;slots;id", "b", "c", "d", "e", "f", "g"}, this, object);
        }

        public String a() {
            return this.b;
        }

        public Holder<AttributeBase> b() {
            return this.c;
        }

        public AttributeModifier.Operation c() {
            return this.d;
        }

        public NumberProvider d() {
            return this.e;
        }

        public List<EnumItemSlot> e() {
            return this.f;
        }

        public Optional<UUID> f() {
            return this.g;
        }
    }

    public static class c {
        private final String a;
        private final Holder<AttributeBase> b;
        private final AttributeModifier.Operation c;
        private final NumberProvider d;
        private Optional<UUID> e = Optional.empty();
        private final Set<EnumItemSlot> f = EnumSet.noneOf(EnumItemSlot.class);

        public c(String name, Holder<AttributeBase> attribute, AttributeModifier.Operation operation, NumberProvider amount) {
            this.a = name;
            this.b = attribute;
            this.c = operation;
            this.d = amount;
        }

        public c a(EnumItemSlot slot) {
            this.f.add(slot);
            return this;
        }

        public c a(UUID uuid) {
            this.e = Optional.of(uuid);
            return this;
        }

        public b a() {
            return new b(this.a, this.b, this.c, this.d, List.copyOf(this.f), this.e);
        }
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private final List<b> a = Lists.newArrayList();

        @Override
        protected a a() {
            return this;
        }

        public a a(c attribute) {
            this.a.add(attribute.a());
            return this;
        }

        @Override
        @Override
        public LootItemFunction b() {
            return new LootItemFunctionSetAttribute(this.g(), this.a);
        }

        @Override
        protected /* synthetic */ LootItemFunctionConditional.a c() {
            return this.a();
        }
    }
}

