/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R3;

import com.google.common.base.Preconditions;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.decoration.PaintingVariant;
import org.bukkit.Art;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_20_R3.CraftRegistry;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftNamespacedKey;

public class CraftArt {
    public static Art minecraftToBukkit(PaintingVariant minecraft) {
        Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
        IRegistry registry = CraftRegistry.getMinecraftRegistry(Registries.R);
        Art bukkit = (Art)Registry.ART.get(CraftNamespacedKey.fromMinecraft(registry.c(minecraft).orElseThrow().a()));
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return bukkit;
    }

    public static Art minecraftHolderToBukkit(Holder<PaintingVariant> minecraft) {
        return CraftArt.minecraftToBukkit(minecraft.a());
    }

    public static PaintingVariant bukkitToMinecraft(Art bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return (PaintingVariant)CraftRegistry.getMinecraftRegistry(Registries.R).b(CraftNamespacedKey.toMinecraft(bukkit.getKey())).orElseThrow();
    }

    public static Holder<PaintingVariant> bukkitToMinecraftHolder(Art bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        IRegistry registry = CraftRegistry.getMinecraftRegistry(Registries.R);
        Holder<PaintingVariant> holder = registry.d(CraftArt.bukkitToMinecraft(bukkit));
        if (holder instanceof Holder.c) {
            Holder.c holder2 = (Holder.c)holder;
            return holder2;
        }
        throw new IllegalArgumentException("No Reference holder found for " + bukkit + ", this can happen if a plugin creates its own painting variant with out properly registering it.");
    }
}

