/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R3.block.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.world.level.block.SculkVeinBlock;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.block.data.type.SculkVein;
import org.bukkit.craftbukkit.v1_20_R3.block.data.CraftBlockData;

public final class CraftSculkVein
extends CraftBlockData
implements SculkVein,
MultipleFacing,
Waterlogged {
    private static final BlockStateBoolean[] FACES = new BlockStateBoolean[]{CraftSculkVein.getBoolean(SculkVeinBlock.class, "north", true), CraftSculkVein.getBoolean(SculkVeinBlock.class, "east", true), CraftSculkVein.getBoolean(SculkVeinBlock.class, "south", true), CraftSculkVein.getBoolean(SculkVeinBlock.class, "west", true), CraftSculkVein.getBoolean(SculkVeinBlock.class, "up", true), CraftSculkVein.getBoolean(SculkVeinBlock.class, "down", true)};
    private static final BlockStateBoolean WATERLOGGED = CraftSculkVein.getBoolean(SculkVeinBlock.class, "waterlogged");

    public CraftSculkVein() {
    }

    public CraftSculkVein(IBlockData state) {
        super(state);
    }

    public boolean hasFace(BlockFace face) {
        BlockStateBoolean state = FACES[face.ordinal()];
        if (state == null) {
            throw new IllegalArgumentException("Non-allowed face " + face + ". Check MultipleFacing.getAllowedFaces.");
        }
        return this.get(state);
    }

    public void setFace(BlockFace face, boolean has) {
        BlockStateBoolean state = FACES[face.ordinal()];
        if (state == null) {
            throw new IllegalArgumentException("Non-allowed face " + face + ". Check MultipleFacing.getAllowedFaces.");
        }
        this.set(state, has);
    }

    public Set<BlockFace> getFaces() {
        ImmutableSet.Builder faces = ImmutableSet.builder();
        for (int i2 = 0; i2 < FACES.length; ++i2) {
            if (FACES[i2] == null || !this.get(FACES[i2]).booleanValue()) continue;
            faces.add((Object)BlockFace.values()[i2]);
        }
        return faces.build();
    }

    public Set<BlockFace> getAllowedFaces() {
        ImmutableSet.Builder faces = ImmutableSet.builder();
        for (int i2 = 0; i2 < FACES.length; ++i2) {
            if (FACES[i2] == null) continue;
            faces.add((Object)BlockFace.values()[i2]);
        }
        return faces.build();
    }

    public boolean isWaterlogged() {
        return this.get(WATERLOGGED);
    }

    public void setWaterlogged(boolean waterlogged) {
        this.set(WATERLOGGED, waterlogged);
    }
}

