/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R3.damage;

import com.google.common.base.Preconditions;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.damagesource.DamageScaling;
import net.minecraft.world.damagesource.DamageType;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_20_R3.CraftRegistry;
import org.bukkit.craftbukkit.v1_20_R3.damage.CraftDamageEffect;
import org.bukkit.craftbukkit.v1_20_R3.util.Handleable;
import org.bukkit.damage.DamageEffect;
import org.bukkit.damage.DeathMessageType;

public class CraftDamageType
implements org.bukkit.damage.DamageType,
Handleable<DamageType> {
    private final NamespacedKey key;
    private final DamageType damageType;

    public CraftDamageType(NamespacedKey key, DamageType damageType) {
        this.key = key;
        this.damageType = damageType;
    }

    @Override
    public DamageType getHandle() {
        return this.damageType;
    }

    public String getTranslationKey() {
        return this.getHandle().a();
    }

    public org.bukkit.damage.DamageScaling getDamageScaling() {
        return CraftDamageType.damageScalingToBukkit(this.getHandle().b());
    }

    public DamageEffect getDamageEffect() {
        return CraftDamageEffect.toBukkit(this.getHandle().d());
    }

    public DeathMessageType getDeathMessageType() {
        return CraftDamageType.deathMessageTypeToBukkit(this.getHandle().e());
    }

    public float getExhaustion() {
        return this.getHandle().c();
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    public String toString() {
        return "CraftDamageType{key=" + this.getKey() + ",damageScaling=" + this.getDamageScaling() + ",damageEffect=" + this.getDamageEffect() + ",deathMessageType=" + this.getDeathMessageType() + ",exhaustion=" + this.getExhaustion() + "}";
    }

    public static DeathMessageType deathMessageTypeToBukkit(net.minecraft.world.damagesource.DeathMessageType deathMessageType) {
        return switch (deathMessageType) {
            case net.minecraft.world.damagesource.DeathMessageType.a -> DeathMessageType.DEFAULT;
            case net.minecraft.world.damagesource.DeathMessageType.b -> DeathMessageType.FALL_VARIANTS;
            case net.minecraft.world.damagesource.DeathMessageType.c -> DeathMessageType.INTENTIONAL_GAME_DESIGN;
            default -> throw new IllegalArgumentException("NMS DeathMessageType." + deathMessageType + " cannot be converted to a Bukkit DeathMessageType.");
        };
    }

    public static net.minecraft.world.damagesource.DeathMessageType deathMessageTypeToNMS(DeathMessageType deathMessageType) {
        return switch (deathMessageType) {
            case DeathMessageType.DEFAULT -> net.minecraft.world.damagesource.DeathMessageType.a;
            case DeathMessageType.FALL_VARIANTS -> net.minecraft.world.damagesource.DeathMessageType.b;
            case DeathMessageType.INTENTIONAL_GAME_DESIGN -> net.minecraft.world.damagesource.DeathMessageType.c;
            default -> throw new IllegalArgumentException("Bukkit DeathMessageType." + deathMessageType + " cannot be converted to a NMS DeathMessageType.");
        };
    }

    public static org.bukkit.damage.DamageScaling damageScalingToBukkit(DamageScaling damageScaling) {
        return switch (damageScaling) {
            case DamageScaling.c -> org.bukkit.damage.DamageScaling.ALWAYS;
            case DamageScaling.b -> org.bukkit.damage.DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER;
            case DamageScaling.a -> org.bukkit.damage.DamageScaling.NEVER;
            default -> throw new IllegalArgumentException("NMS DamageScaling." + damageScaling + " cannot be converted to a Bukkit DamageScaling");
        };
    }

    public static DamageScaling damageScalingToNMS(org.bukkit.damage.DamageScaling damageScaling) {
        return switch (damageScaling) {
            case org.bukkit.damage.DamageScaling.ALWAYS -> DamageScaling.c;
            case org.bukkit.damage.DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER -> DamageScaling.b;
            case org.bukkit.damage.DamageScaling.NEVER -> DamageScaling.a;
            default -> throw new IllegalArgumentException("Bukkit DamageScaling." + damageScaling + " cannot be converted to a NMS DamageScaling");
        };
    }

    public static org.bukkit.damage.DamageType minecraftHolderToBukkit(Holder<DamageType> minecraftHolder) {
        return CraftDamageType.minecraftToBukkit(minecraftHolder.a());
    }

    public static Holder<DamageType> bukkitToMinecraftHolder(org.bukkit.damage.DamageType bukkitDamageType) {
        Preconditions.checkArgument((bukkitDamageType != null ? 1 : 0) != 0);
        IRegistry registry = CraftRegistry.getMinecraftRegistry(Registries.r);
        Holder<DamageType> holder = registry.d(CraftDamageType.bukkitToMinecraft(bukkitDamageType));
        if (holder instanceof Holder.c) {
            Holder.c holder2 = (Holder.c)holder;
            return holder2;
        }
        throw new IllegalArgumentException("No Reference holder found for " + bukkitDamageType + ", this can happen if a plugin creates its own damage type with out properly registering it.");
    }

    public static DamageType bukkitToMinecraft(org.bukkit.damage.DamageType bukkitDamageType) {
        return (DamageType)CraftRegistry.bukkitToMinecraft(bukkitDamageType);
    }

    public static org.bukkit.damage.DamageType minecraftToBukkit(DamageType minecraftDamageType) {
        return (org.bukkit.damage.DamageType)CraftRegistry.minecraftToBukkit(minecraftDamageType, Registries.r, Registry.DAMAGE_TYPE);
    }
}

