/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R3.entity;

import com.google.common.base.Preconditions;
import net.kyori.adventure.util.TriState;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.animal.EntityBee;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R3.CraftServer;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftAnimals;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftLocation;
import org.bukkit.entity.Bee;

public class CraftBee
extends CraftAnimals
implements Bee {
    public CraftBee(CraftServer server, EntityBee entity) {
        super(server, entity);
    }

    @Override
    public EntityBee getHandle() {
        return (EntityBee)this.entity;
    }

    @Override
    public String toString() {
        return "CraftBee";
    }

    public Location getHive() {
        BlockPosition hive = this.getHandle().gm();
        return hive == null ? null : CraftLocation.toBukkit(hive, this.getWorld());
    }

    public void setHive(Location location) {
        Preconditions.checkArgument((location == null || this.getWorld().equals(location.getWorld()) ? 1 : 0) != 0, (Object)"Hive must be in same world");
        this.getHandle().cH = location == null ? null : CraftLocation.toBlockPosition(location);
    }

    public Location getFlower() {
        BlockPosition flower = this.getHandle().u();
        return flower == null ? null : CraftLocation.toBukkit(flower, this.getWorld());
    }

    public void setFlower(Location location) {
        Preconditions.checkArgument((location == null || this.getWorld().equals(location.getWorld()) ? 1 : 0) != 0, (Object)"Flower must be in same world");
        this.getHandle().i(location == null ? null : CraftLocation.toBlockPosition(location));
    }

    public boolean hasNectar() {
        return this.getHandle().go();
    }

    public void setHasNectar(boolean nectar) {
        this.getHandle().w(nectar);
    }

    public boolean hasStung() {
        return this.getHandle().gp();
    }

    public void setHasStung(boolean stung) {
        this.getHandle().x(stung);
    }

    public int getAnger() {
        return this.getHandle().a();
    }

    public void setAnger(int anger) {
        this.getHandle().a(anger);
    }

    public int getCannotEnterHiveTicks() {
        return this.getHandle().cA;
    }

    public void setCannotEnterHiveTicks(int ticks) {
        this.getHandle().t(ticks);
    }

    public void setRollingOverride(TriState rolling) {
        this.getHandle().rollingOverride = rolling;
        this.getHandle().y(this.getHandle().gB());
    }

    public boolean isRolling() {
        return this.getRollingOverride().toBooleanOrElse(this.getHandle().gB());
    }

    public TriState getRollingOverride() {
        return this.getHandle().rollingOverride;
    }

    public void setCropsGrownSincePollination(int crops) {
        this.getHandle().cB = crops;
    }

    public int getCropsGrownSincePollination() {
        return this.getHandle().cB;
    }

    public void setTicksSincePollination(int ticks) {
        this.getHandle().cz = ticks;
    }

    public int getTicksSincePollination() {
        return this.getHandle().cz;
    }
}

