/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R3.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.projectile.EntityEnderSignal;
import net.minecraft.world.item.Items;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R3.CraftServer;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftLocation;
import org.bukkit.entity.EnderSignal;
import org.bukkit.inventory.ItemStack;

public class CraftEnderSignal
extends CraftEntity
implements EnderSignal {
    public CraftEnderSignal(CraftServer server, EntityEnderSignal entity) {
        super(server, entity);
    }

    @Override
    public EntityEnderSignal getHandle() {
        return (EntityEnderSignal)this.entity;
    }

    @Override
    public String toString() {
        return "CraftEnderSignal";
    }

    public Location getTargetLocation() {
        return new Location(this.getWorld(), this.getHandle().c, this.getHandle().d, this.getHandle().e, this.getHandle().dC(), this.getHandle().dE());
    }

    public void setTargetLocation(Location location) {
        this.setTargetLocation(location, true);
    }

    public void setTargetLocation(Location location, boolean update) {
        Preconditions.checkArgument((boolean)this.getWorld().equals(location.getWorld()), (Object)"Cannot target EnderSignal across worlds");
        this.getHandle().signalTo(CraftLocation.toBlockPosition(location), update);
    }

    public boolean getDropItem() {
        return this.getHandle().g;
    }

    public void setDropItem(boolean shouldDropItem) {
        this.getHandle().g = shouldDropItem;
    }

    public ItemStack getItem() {
        return CraftItemStack.asBukkitCopy(this.getHandle().q());
    }

    public void setItem(ItemStack item) {
        this.getHandle().a(item != null ? CraftItemStack.asNMSCopy(item) : Items.sp.am_());
    }

    public int getDespawnTimer() {
        return this.getHandle().f;
    }

    public void setDespawnTimer(int time) {
        this.getHandle().f = time;
    }
}

