/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R3.entity;

import com.destroystokyo.paper.block.TargetBlockInfo;
import com.destroystokyo.paper.entity.TargetEntityInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.kyori.adventure.util.TriState;
import net.minecraft.network.protocol.game.ClientboundHurtAnimationPacket;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.EnumHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityDragonFireball;
import net.minecraft.world.entity.projectile.EntityEgg;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.entity.projectile.EntityFireball;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.entity.projectile.EntityLargeFireball;
import net.minecraft.world.entity.projectile.EntityLlamaSpit;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.entity.projectile.EntityProjectile;
import net.minecraft.world.entity.projectile.EntityShulkerBullet;
import net.minecraft.world.entity.projectile.EntitySmallFireball;
import net.minecraft.world.entity.projectile.EntitySnowball;
import net.minecraft.world.entity.projectile.EntitySpectralArrow;
import net.minecraft.world.entity.projectile.EntityThrownExpBottle;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.entity.projectile.EntityTippedArrow;
import net.minecraft.world.entity.projectile.EntityWitherSkull;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_20_R3.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_20_R3.CraftServer;
import org.bukkit.craftbukkit.v1_20_R3.CraftSound;
import org.bukkit.craftbukkit.v1_20_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R3.damage.CraftDamageSource;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftItem;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R3.entity.memory.CraftMemoryKey;
import org.bukkit.craftbukkit.v1_20_R3.entity.memory.CraftMemoryMapper;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftEntityEquipment;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R3.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_20_R3.potion.CraftPotionUtil;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftVector;
import org.bukkit.damage.DamageSource;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.DragonFireball;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityCategory;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Firework;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LingeringPotion;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.LlamaSpit;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.Trident;
import org.bukkit.entity.WindCharge;
import org.bukkit.entity.WitherSkull;
import org.bukkit.entity.memory.MemoryKey;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.spigotmc.AsyncCatcher;

public class CraftLivingEntity
extends CraftEntity
implements LivingEntity {
    private CraftEntityEquipment equipment;

    public CraftLivingEntity(CraftServer server, EntityLiving entity) {
        super(server, entity);
        if (entity instanceof EntityInsentient || entity instanceof EntityArmorStand) {
            this.equipment = new CraftEntityEquipment(this);
        }
    }

    public double getHealth() {
        return Math.min((double)Math.max(0.0f, this.getHandle().ev()), this.getMaxHealth());
    }

    public void setHealth(double health) {
        Preconditions.checkArgument(((health = (double)((float)health)) >= 0.0 && health <= this.getMaxHealth() ? 1 : 0) != 0, (String)"Health value (%s) must be between 0 and %s. (attribute base value: %s%s)", (Object)health, (Object)this.getMaxHealth(), (Object)this.getHandle().a(GenericAttributes.l).b(), (Object)(this instanceof CraftPlayer ? ", player: " + this.getName() : ""));
        if (this.getHandle().generation && health == 0.0) {
            this.getHandle().discard(null);
            return;
        }
        this.getHandle().c((float)health);
        if (health == 0.0) {
            this.getHandle().a(this.getHandle().dN().n());
        }
    }

    public double getAbsorptionAmount() {
        return this.getHandle().fk();
    }

    public void setAbsorptionAmount(double amount) {
        Preconditions.checkArgument((amount >= 0.0 && Double.isFinite(amount) ? 1 : 0) != 0, (Object)"amount < 0 or non-finite");
        this.getHandle().y((float)amount);
    }

    public double getMaxHealth() {
        return this.getHandle().eM();
    }

    public void setMaxHealth(double amount) {
        Preconditions.checkArgument((amount > 0.0 ? 1 : 0) != 0, (String)"Max health amount (%s) must be greater than 0", (Object)amount);
        this.getHandle().a(GenericAttributes.l).a(amount);
        if (this.getHealth() > amount) {
            this.setHealth(amount);
        }
    }

    public void resetMaxHealth() {
        this.setMaxHealth(this.getHandle().a(GenericAttributes.l).a().a());
    }

    public double getEyeHeight() {
        return this.getHandle().cI();
    }

    public double getEyeHeight(boolean ignorePose) {
        return this.getEyeHeight();
    }

    private List<Block> getLineOfSight(Set<Material> transparent, int maxDistance, int maxLength) {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot get line of sight during world generation");
        if (transparent == null) {
            transparent = Sets.newHashSet((Object[])new Material[]{Material.AIR, Material.CAVE_AIR, Material.VOID_AIR});
        }
        if (maxDistance > 120) {
            maxDistance = 120;
        }
        ArrayList<Block> blocks = new ArrayList<Block>();
        BlockIterator itr = new BlockIterator((LivingEntity)this, maxDistance);
        while (itr.hasNext()) {
            Material material;
            Block block = (Block)itr.next();
            blocks.add(block);
            if (maxLength != 0 && blocks.size() > maxLength) {
                blocks.remove(0);
            }
            if (transparent.contains(material = block.getType())) continue;
            break;
        }
        return blocks;
    }

    public List<Block> getLineOfSight(Set<Material> transparent, int maxDistance) {
        return this.getLineOfSight(transparent, maxDistance, 0);
    }

    public Block getTargetBlock(Set<Material> transparent, int maxDistance) {
        List<Block> blocks = this.getLineOfSight(transparent, maxDistance, 1);
        return blocks.get(0);
    }

    public Block getTargetBlock(int maxDistance, TargetBlockInfo.FluidMode fluidMode) {
        return this.getTargetBlockExact(maxDistance, fluidMode.bukkit);
    }

    public BlockFace getTargetBlockFace(int maxDistance, TargetBlockInfo.FluidMode fluidMode) {
        return this.getTargetBlockFace(maxDistance, fluidMode.bukkit);
    }

    public BlockFace getTargetBlockFace(int maxDistance, FluidCollisionMode fluidMode) {
        RayTraceResult result = this.rayTraceBlocks(maxDistance, fluidMode);
        return result != null ? result.getHitBlockFace() : null;
    }

    public TargetBlockInfo getTargetBlockInfo(int maxDistance, TargetBlockInfo.FluidMode fluidMode) {
        RayTraceResult result = this.rayTraceBlocks(maxDistance, fluidMode.bukkit);
        if (result != null && result.getHitBlock() != null && result.getHitBlockFace() != null) {
            return new TargetBlockInfo(result.getHitBlock(), result.getHitBlockFace());
        }
        return null;
    }

    public Entity getTargetEntity(int maxDistance, boolean ignoreBlocks) {
        MovingObjectPositionEntity rayTrace = this.rayTraceEntity(maxDistance, ignoreBlocks);
        return rayTrace == null ? null : rayTrace.a().getBukkitEntity();
    }

    public TargetEntityInfo getTargetEntityInfo(int maxDistance, boolean ignoreBlocks) {
        MovingObjectPositionEntity rayTrace = this.rayTraceEntity(maxDistance, ignoreBlocks);
        return rayTrace == null ? null : new TargetEntityInfo((Entity)rayTrace.a().getBukkitEntity(), new Vector(rayTrace.e().c, rayTrace.e().d, rayTrace.e().e));
    }

    public RayTraceResult rayTraceEntities(int maxDistance, boolean ignoreBlocks) {
        MovingObjectPositionEntity rayTrace = this.rayTraceEntity(maxDistance, ignoreBlocks);
        return rayTrace == null ? null : new RayTraceResult(CraftVector.toBukkit(rayTrace.e()), (Entity)rayTrace.a().getBukkitEntity());
    }

    public MovingObjectPositionEntity rayTraceEntity(int maxDistance, boolean ignoreBlocks) {
        Vec3D eye;
        MovingObjectPosition rayTraceBlocks;
        MovingObjectPositionEntity rayTrace = this.getHandle().getTargetEntity(maxDistance);
        if (rayTrace == null) {
            return null;
        }
        if (!ignoreBlocks && (rayTraceBlocks = this.getHandle().getRayTrace(maxDistance, RayTrace.FluidCollisionOption.a)) != null && (eye = this.getHandle().j(1.0f)).g(rayTraceBlocks.e()) <= eye.g(rayTrace.e())) {
            return null;
        }
        return rayTrace;
    }

    public List<Block> getLastTwoTargetBlocks(Set<Material> transparent, int maxDistance) {
        return this.getLineOfSight(transparent, maxDistance, 2);
    }

    public Block getTargetBlockExact(int maxDistance) {
        return this.getTargetBlockExact(maxDistance, FluidCollisionMode.NEVER);
    }

    public Block getTargetBlockExact(int maxDistance, FluidCollisionMode fluidCollisionMode) {
        RayTraceResult hitResult = this.rayTraceBlocks(maxDistance, fluidCollisionMode);
        return hitResult != null ? hitResult.getHitBlock() : null;
    }

    public RayTraceResult rayTraceBlocks(double maxDistance) {
        return this.rayTraceBlocks(maxDistance, FluidCollisionMode.NEVER);
    }

    public RayTraceResult rayTraceBlocks(double maxDistance, FluidCollisionMode fluidCollisionMode) {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot ray tray blocks during world generation");
        Location eyeLocation = this.getEyeLocation();
        Vector direction = eyeLocation.getDirection();
        return this.getWorld().rayTraceBlocks(eyeLocation, direction, maxDistance, fluidCollisionMode, false);
    }

    public int getRemainingAir() {
        return this.getHandle().ci();
    }

    public void setRemainingAir(int ticks) {
        this.getHandle().j(ticks);
    }

    public int getMaximumAir() {
        return this.getHandle().maxAirTicks;
    }

    public void setMaximumAir(int ticks) {
        this.getHandle().maxAirTicks = ticks;
    }

    public ItemStack getItemInUse() {
        net.minecraft.world.item.ItemStack item = this.getHandle().fp();
        return item.b() ? null : CraftItemStack.asCraftMirror(item);
    }

    public int getItemInUseTicks() {
        return this.getHandle().fq();
    }

    public void setItemInUseTicks(int ticks) {
        this.getHandle().bw = ticks;
    }

    public int getArrowCooldown() {
        return this.getHandle().aI;
    }

    public void setArrowCooldown(int ticks) {
        this.getHandle().aI = ticks;
    }

    public int getArrowsInBody() {
        return this.getHandle().eO();
    }

    public void setArrowsInBody(int count, boolean fireEvent) {
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0, (Object)"New arrow amount must be >= 0");
        if (!fireEvent) {
            this.getHandle().an().b(EntityLiving.bK, count);
        } else {
            this.getHandle().p(count);
        }
    }

    public int getBeeStingerCooldown() {
        return this.getHandle().aJ;
    }

    public void setNextArrowRemoval(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"New amount of ticks before next arrow removal must be >= 0");
        this.getHandle().aI = ticks;
    }

    public int getNextArrowRemoval() {
        return this.getHandle().aI;
    }

    public void setBeeStingerCooldown(int ticks) {
        this.getHandle().aJ = ticks;
    }

    public int getBeeStingersInBody() {
        return this.getHandle().eP();
    }

    public void setBeeStingersInBody(int count) {
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0, (Object)"New bee stinger amount must be >= 0");
        this.getHandle().q(count);
    }

    public void setNextBeeStingerRemoval(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"New amount of ticks before next bee stinger removal must be >= 0");
        this.getHandle().aJ = ticks;
    }

    public int getNextBeeStingerRemoval() {
        return this.getHandle().aJ;
    }

    public void damage(double amount) {
        this.damage(amount, this.getHandle().dN().n());
    }

    public void damage(double amount, Entity source) {
        net.minecraft.world.damagesource.DamageSource reason = this.getHandle().dN().n();
        if (source instanceof HumanEntity) {
            reason = this.getHandle().dN().a(((CraftHumanEntity)source).getHandle());
        } else if (source instanceof LivingEntity) {
            reason = this.getHandle().dN().b(((CraftLivingEntity)source).getHandle());
        }
        this.damage(amount, reason);
    }

    public void damage(double amount, DamageSource damageSource) {
        Preconditions.checkArgument((damageSource != null ? 1 : 0) != 0, (Object)"damageSource cannot be null");
        this.damage(amount, ((CraftDamageSource)damageSource).getHandle());
    }

    private void damage(double amount, net.minecraft.world.damagesource.DamageSource damageSource) {
        Preconditions.checkArgument((damageSource != null ? 1 : 0) != 0, (Object)"damageSource cannot be null");
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot damage entity during world generation");
        this.entity.a(damageSource, (float)amount);
    }

    public Location getEyeLocation() {
        Location loc = this.getLocation();
        loc.setY(loc.getY() + this.getEyeHeight());
        return loc;
    }

    public int getMaximumNoDamageTicks() {
        return this.getHandle().aR;
    }

    public void setMaximumNoDamageTicks(int ticks) {
        this.getHandle().aR = ticks;
    }

    public double getLastDamage() {
        return this.getHandle().bi;
    }

    public void setLastDamage(double damage) {
        this.getHandle().bi = (float)damage;
    }

    public int getNoDamageTicks() {
        return this.getHandle().al;
    }

    public void setNoDamageTicks(int ticks) {
        this.getHandle().al = ticks;
    }

    public int getNoActionTicks() {
        return this.getHandle().el();
    }

    public void setNoActionTicks(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks must be >= 0");
        this.getHandle().o(ticks);
    }

    @Override
    public EntityLiving getHandle() {
        return (EntityLiving)this.entity;
    }

    public void setHandle(EntityLiving entity) {
        super.setHandle(entity);
    }

    @Override
    public String toString() {
        return "CraftLivingEntity{id=" + this.getEntityId() + "}";
    }

    public Player getKiller() {
        return this.getHandle().aY == null ? null : (Player)this.getHandle().aY.getBukkitEntity();
    }

    public void setKiller(Player killer) {
        EntityPlayer entityPlayer = killer == null ? null : ((CraftPlayer)killer).getHandle();
        this.getHandle().aY = entityPlayer;
        this.getHandle().bU = entityPlayer;
        this.getHandle().aZ = entityPlayer == null ? 0 : 100;
    }

    public boolean addPotionEffect(PotionEffect effect) {
        return this.addPotionEffect(effect, false);
    }

    public boolean addPotionEffect(PotionEffect effect, boolean force) {
        AsyncCatcher.catchOp("effect add");
        this.getHandle().addEffect(CraftPotionUtil.fromBukkit(effect), EntityPotionEffectEvent.Cause.PLUGIN);
        return true;
    }

    public boolean addPotionEffects(Collection<PotionEffect> effects) {
        boolean success = true;
        for (PotionEffect effect : effects) {
            success &= this.addPotionEffect(effect);
        }
        return success;
    }

    public boolean hasPotionEffect(PotionEffectType type) {
        return this.getHandle().a(CraftPotionEffectType.bukkitToMinecraft(type));
    }

    public PotionEffect getPotionEffect(PotionEffectType type) {
        MobEffect handle = this.getHandle().b(CraftPotionEffectType.bukkitToMinecraft(type));
        return handle == null ? null : CraftPotionUtil.toBukkit(handle);
    }

    public void removePotionEffect(PotionEffectType type) {
        this.getHandle().removeEffect(CraftPotionEffectType.bukkitToMinecraft(type), EntityPotionEffectEvent.Cause.PLUGIN);
    }

    public Collection<PotionEffect> getActivePotionEffects() {
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        for (MobEffect handle : this.getHandle().bP.values()) {
            effects.add(CraftPotionUtil.toBukkit(handle));
        }
        return effects;
    }

    public boolean clearActivePotionEffects() {
        return this.getHandle().removeAllEffects(EntityPotionEffectEvent.Cause.PLUGIN);
    }

    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile) {
        return this.launchProjectile(projectile, null);
    }

    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile, Vector velocity) {
        return this.launchProjectile(projectile, velocity, null);
    }

    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile, Vector velocity, Consumer<? super T> function) {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot launch projectile during world generation");
        WorldServer world = ((CraftWorld)this.getWorld()).getHandle();
        IProjectile launch = null;
        if (Snowball.class.isAssignableFrom(projectile)) {
            launch = new EntitySnowball(world, this.getHandle());
            ((EntityProjectile)launch).a(this.getHandle(), this.getHandle().dE(), this.getHandle().dC(), 0.0f, 1.5f, 1.0f);
        } else if (Egg.class.isAssignableFrom(projectile)) {
            launch = new EntityEgg(world, this.getHandle());
            ((EntityProjectile)launch).a(this.getHandle(), this.getHandle().dE(), this.getHandle().dC(), 0.0f, 1.5f, 1.0f);
        } else if (EnderPearl.class.isAssignableFrom(projectile)) {
            launch = new EntityEnderPearl(world, this.getHandle());
            ((EntityProjectile)launch).a(this.getHandle(), this.getHandle().dE(), this.getHandle().dC(), 0.0f, 1.5f, 1.0f);
        } else if (AbstractArrow.class.isAssignableFrom(projectile)) {
            if (TippedArrow.class.isAssignableFrom(projectile)) {
                launch = new EntityTippedArrow(world, this.getHandle(), new net.minecraft.world.item.ItemStack(Items.os));
                ((Arrow)launch.getBukkitEntity()).setBasePotionType(PotionType.WATER);
            } else {
                launch = SpectralArrow.class.isAssignableFrom(projectile) ? new EntitySpectralArrow(world, this.getHandle(), new net.minecraft.world.item.ItemStack(Items.vi)) : (Trident.class.isAssignableFrom(projectile) ? new EntityThrownTrident(world, this.getHandle(), new net.minecraft.world.item.ItemStack(Items.vI)) : new EntityTippedArrow(world, this.getHandle(), new net.minecraft.world.item.ItemStack(Items.os)));
            }
            ((EntityArrow)launch).a(this.getHandle(), this.getHandle().dE(), this.getHandle().dC(), 0.0f, 3.0f, 1.0f);
        } else if (ThrownPotion.class.isAssignableFrom(projectile)) {
            if (LingeringPotion.class.isAssignableFrom(projectile)) {
                launch = new EntityPotion(world, this.getHandle());
                ((EntityPotion)launch).a(CraftItemStack.asNMSCopy(new ItemStack(Material.LINGERING_POTION, 1)));
            } else {
                launch = new EntityPotion(world, this.getHandle());
                ((EntityPotion)launch).a(CraftItemStack.asNMSCopy(new ItemStack(Material.SPLASH_POTION, 1)));
            }
            ((EntityProjectile)launch).a(this.getHandle(), this.getHandle().dE(), this.getHandle().dC(), -20.0f, 0.5f, 1.0f);
        } else if (ThrownExpBottle.class.isAssignableFrom(projectile)) {
            launch = new EntityThrownExpBottle(world, this.getHandle());
            ((EntityProjectile)launch).a(this.getHandle(), this.getHandle().dE(), this.getHandle().dC(), -20.0f, 0.7f, 1.0f);
        } else if (FishHook.class.isAssignableFrom(projectile) && this.getHandle() instanceof EntityHuman) {
            launch = new EntityFishingHook((EntityHuman)this.getHandle(), (World)world, 0, 0);
        } else if (Fireball.class.isAssignableFrom(projectile)) {
            Location location = this.getEyeLocation();
            Vector direction = location.getDirection().multiply(10);
            if (SmallFireball.class.isAssignableFrom(projectile)) {
                launch = new EntitySmallFireball(world, this.getHandle(), direction.getX(), direction.getY(), direction.getZ());
            } else if (WitherSkull.class.isAssignableFrom(projectile)) {
                launch = new EntityWitherSkull(world, this.getHandle(), direction.getX(), direction.getY(), direction.getZ());
            } else if (DragonFireball.class.isAssignableFrom(projectile)) {
                launch = new EntityDragonFireball(world, this.getHandle(), direction.getX(), direction.getY(), direction.getZ());
            } else if (WindCharge.class.isAssignableFrom(projectile)) {
                launch = EntityTypes.bk.a(world);
                ((net.minecraft.world.entity.projectile.WindCharge)launch).b((net.minecraft.world.entity.Entity)this.getHandle());
                ((net.minecraft.world.entity.projectile.WindCharge)launch).setDirection(direction.getX(), direction.getY(), direction.getZ());
            } else {
                launch = new EntityLargeFireball(world, this.getHandle(), direction.getX(), direction.getY(), direction.getZ(), 1);
            }
            ((EntityFireball)launch).projectileSource = this;
            launch.b(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        } else if (LlamaSpit.class.isAssignableFrom(projectile)) {
            Location location = this.getEyeLocation();
            Vector direction = location.getDirection();
            launch = EntityTypes.al.a(world);
            ((EntityLlamaSpit)launch).b((net.minecraft.world.entity.Entity)this.getHandle());
            ((EntityLlamaSpit)launch).c(direction.getX(), direction.getY(), direction.getZ(), 1.5f, 10.0f);
            launch.b(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        } else if (ShulkerBullet.class.isAssignableFrom(projectile)) {
            Location location = this.getEyeLocation();
            launch = new EntityShulkerBullet(world, this.getHandle(), null, null);
            launch.b(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        } else if (Firework.class.isAssignableFrom(projectile)) {
            Location location = this.getEyeLocation();
            launch = new EntityFireworks(world, net.minecraft.world.item.ItemStack.f, this.getHandle());
            launch.b(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        }
        Preconditions.checkArgument((launch != null ? 1 : 0) != 0, (String)"Projectile (%s) not supported", (Object)projectile.getName());
        if (velocity != null) {
            ((Projectile)launch.getBukkitEntity()).setVelocity(velocity);
        }
        if (function != null) {
            function.accept((Projectile)launch.getBukkitEntity());
        }
        world.b(launch);
        return (T)((Projectile)launch.getBukkitEntity());
    }

    public boolean hasLineOfSight(Entity other) {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot check line of sight during world generation");
        return this.getHandle().E(((CraftEntity)other).getHandle());
    }

    public boolean hasLineOfSight(Location loc) {
        if (this.getHandle().dM() != ((CraftWorld)loc.getWorld()).getHandle()) {
            return false;
        }
        Vec3D start = new Vec3D(this.getHandle().dr(), this.getHandle().dv(), this.getHandle().dx());
        Vec3D end = new Vec3D(loc.getX(), loc.getY(), loc.getZ());
        if (end.g(start) > 16384.0) {
            return false;
        }
        return this.getHandle().dM().clipDirect(start, end, VoxelShapeCollision.a(this.getHandle())) == MovingObjectPosition.EnumMovingObjectType.a;
    }

    public boolean getRemoveWhenFarAway() {
        return this.getHandle() instanceof EntityInsentient && !((EntityInsentient)this.getHandle()).fL();
    }

    public void setRemoveWhenFarAway(boolean remove) {
        if (this.getHandle() instanceof EntityInsentient) {
            ((EntityInsentient)this.getHandle()).setPersistenceRequired(!remove);
        }
    }

    public EntityEquipment getEquipment() {
        return this.equipment;
    }

    public void setCanPickupItems(boolean pickup) {
        if (this.getHandle() instanceof EntityInsentient) {
            ((EntityInsentient)this.getHandle()).s(pickup);
        } else {
            this.getHandle().bukkitPickUpLoot = pickup;
        }
    }

    public boolean getCanPickupItems() {
        if (this.getHandle() instanceof EntityInsentient) {
            return ((EntityInsentient)this.getHandle()).fK();
        }
        return this.getHandle().bukkitPickUpLoot;
    }

    @Override
    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        if (this.getHealth() == 0.0) {
            return false;
        }
        return super.teleport(location, cause);
    }

    public boolean isLeashed() {
        if (!(this.getHandle() instanceof EntityInsentient)) {
            return false;
        }
        return ((EntityInsentient)this.getHandle()).fT() != null;
    }

    public Entity getLeashHolder() throws IllegalStateException {
        Preconditions.checkState((boolean)this.isLeashed(), (Object)"Entity not leashed");
        return ((EntityInsentient)this.getHandle()).fT().getBukkitEntity();
    }

    private boolean unleash() {
        if (!this.isLeashed()) {
            return false;
        }
        ((EntityInsentient)this.getHandle()).a(true, false);
        return true;
    }

    public boolean setLeashHolder(Entity holder) {
        if (this.getHandle().generation || this.getHandle() instanceof EntityWither || !(this.getHandle() instanceof EntityInsentient)) {
            return false;
        }
        if (holder == null) {
            return this.unleash();
        }
        if (holder.isDead()) {
            return false;
        }
        this.unleash();
        ((EntityInsentient)this.getHandle()).b(((CraftEntity)holder).getHandle(), true);
        return true;
    }

    public boolean isGliding() {
        return this.getHandle().i(7);
    }

    public void setGliding(boolean gliding) {
        this.getHandle().b(7, gliding);
    }

    public boolean isSwimming() {
        return this.getHandle().bZ();
    }

    public void setSwimming(boolean swimming) {
        this.getHandle().h(swimming);
    }

    public boolean isRiptiding() {
        return this.getHandle().fj();
    }

    public boolean isSleeping() {
        return this.getHandle().fD();
    }

    public boolean isClimbing() {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot check if climbing during world generation");
        return this.getHandle().e_();
    }

    public AttributeInstance getAttribute(Attribute attribute) {
        return this.getHandle().craftAttributes.getAttribute(attribute);
    }

    public void registerAttribute(Attribute attribute) {
        this.getHandle().craftAttributes.registerAttribute(attribute);
    }

    public void setAI(boolean ai) {
        if (this.getHandle() instanceof EntityInsentient) {
            ((EntityInsentient)this.getHandle()).t(!ai);
        }
    }

    public boolean hasAI() {
        return this.getHandle() instanceof EntityInsentient ? !((EntityInsentient)this.getHandle()).fU() : false;
    }

    public void attack(Entity target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"target == null");
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot attack during world generation");
        if (this.getHandle() instanceof EntityHuman) {
            ((EntityHuman)this.getHandle()).d(((CraftEntity)target).getHandle());
        } else {
            this.getHandle().C(((CraftEntity)target).getHandle());
        }
    }

    public void swingMainHand() {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot swing hand during world generation");
        this.getHandle().a(EnumHand.a, true);
    }

    public void swingOffHand() {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot swing hand during world generation");
        this.getHandle().a(EnumHand.b, true);
    }

    public void playHurtAnimation(float yaw) {
        World world = this.getHandle().dM();
        if (world instanceof WorldServer) {
            WorldServer world2 = (WorldServer)world;
            float actualYaw = yaw + 90.0f;
            ClientboundHurtAnimationPacket packet = new ClientboundHurtAnimationPacket(this.getEntityId(), actualYaw);
            world2.l().a(this.getHandle(), packet);
        }
    }

    public void setCollidable(boolean collidable) {
        this.getHandle().collides = collidable;
    }

    public boolean isCollidable() {
        return this.getHandle().collides;
    }

    public Set<UUID> getCollidableExemptions() {
        return this.getHandle().collidableExemptions;
    }

    public <T> T getMemory(MemoryKey<T> memoryKey) {
        return this.getHandle().dO().c(CraftMemoryKey.bukkitToMinecraft(memoryKey)).map(CraftMemoryMapper::fromNms).orElse(null);
    }

    public <T> void setMemory(MemoryKey<T> memoryKey, T t2) {
        this.getHandle().dO().a(CraftMemoryKey.bukkitToMinecraft(memoryKey), CraftMemoryMapper.toNms(t2));
    }

    public Sound getHurtSound() {
        SoundEffect sound = this.getHandle().getHurtSound0(this.getHandle().dN().n());
        return sound != null ? CraftSound.minecraftToBukkit(sound) : null;
    }

    public Sound getDeathSound() {
        SoundEffect sound = this.getHandle().getDeathSound0();
        return sound != null ? CraftSound.minecraftToBukkit(sound) : null;
    }

    public Sound getFallDamageSound(int fallHeight) {
        return CraftSound.minecraftToBukkit(this.getHandle().getFallDamageSound0(fallHeight));
    }

    public Sound getFallDamageSoundSmall() {
        return CraftSound.minecraftToBukkit(this.getHandle().eG().a());
    }

    public Sound getFallDamageSoundBig() {
        return CraftSound.minecraftToBukkit(this.getHandle().eG().b());
    }

    public Sound getDrinkingSound(ItemStack itemStack) {
        Preconditions.checkArgument((itemStack != null ? 1 : 0) != 0, (Object)"itemStack must not be null");
        return CraftSound.minecraftToBukkit(this.getHandle().getDrinkingSound0(CraftItemStack.asNMSCopy(itemStack)));
    }

    public Sound getEatingSound(ItemStack itemStack) {
        Preconditions.checkArgument((itemStack != null ? 1 : 0) != 0, (Object)"itemStack must not be null");
        return CraftSound.minecraftToBukkit(this.getHandle().getEatingSound0(CraftItemStack.asNMSCopy(itemStack)));
    }

    public boolean canBreatheUnderwater() {
        return this.getHandle().dR();
    }

    public EntityCategory getCategory() {
        EnumMonsterType type = this.getHandle().eS();
        if (type == EnumMonsterType.a) {
            return EntityCategory.NONE;
        }
        if (type == EnumMonsterType.b) {
            return EntityCategory.UNDEAD;
        }
        if (type == EnumMonsterType.c) {
            return EntityCategory.ARTHROPOD;
        }
        if (type == EnumMonsterType.d) {
            return EntityCategory.ILLAGER;
        }
        if (type == EnumMonsterType.e) {
            return EntityCategory.WATER;
        }
        throw new UnsupportedOperationException("Unsupported monster type: " + type + ". This is a bug, report this to Spigot.");
    }

    @Override
    public boolean isInvisible() {
        return super.isInvisible();
    }

    @Override
    public void setInvisible(boolean invisible) {
        super.setInvisible(invisible);
    }

    public float getSidewaysMovement() {
        return this.getHandle().bk;
    }

    public float getForwardsMovement() {
        return this.getHandle().bm;
    }

    public float getUpwardsMovement() {
        return this.getHandle().bl;
    }

    public int getArrowsStuck() {
        return this.getHandle().eO();
    }

    public void setArrowsStuck(int arrows) {
        this.getHandle().p(arrows);
    }

    public int getShieldBlockingDelay() {
        return this.getHandle().getShieldBlockingDelay();
    }

    public void setShieldBlockingDelay(int delay) {
        this.getHandle().setShieldBlockingDelay(delay);
    }

    public void startUsingItem(EquipmentSlot hand) {
        Preconditions.checkArgument((hand != null ? 1 : 0) != 0, (Object)"hand must not be null");
        switch (hand) {
            case HAND: {
                this.getHandle().c(EnumHand.a);
                break;
            }
            case OFF_HAND: {
                this.getHandle().c(EnumHand.b);
                break;
            }
            default: {
                throw new IllegalArgumentException("hand may only be HAND or OFF_HAND");
            }
        }
    }

    public void completeUsingActiveItem() {
        this.getHandle().x();
    }

    public ItemStack getActiveItem() {
        return this.getHandle().fp().asBukkitMirror();
    }

    public void clearActiveItem() {
        this.getHandle().ft();
    }

    public int getActiveItemRemainingTime() {
        return this.getHandle().fq();
    }

    public void setActiveItemRemainingTime(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks must be >= 0");
        Preconditions.checkArgument((ticks <= this.getHandle().fp().r() ? 1 : 0) != 0, (Object)"ticks must be <= item use duration");
        this.getHandle().bw = ticks;
    }

    public int getActiveItemUsedTime() {
        return this.getHandle().fr();
    }

    public boolean hasActiveItem() {
        return this.getHandle().fn();
    }

    public EquipmentSlot getActiveItemHand() {
        return CraftEquipmentSlot.getHand(this.getHandle().fo());
    }

    public boolean isJumping() {
        return this.getHandle().bj;
    }

    public void setJumping(boolean jumping) {
        this.getHandle().r(jumping);
        if (jumping && this.getHandle() instanceof EntityInsentient) {
            ((EntityInsentient)this.getHandle()).M().a();
        }
    }

    public void playPickupItemAnimation(Item item, int quantity) {
        this.getHandle().a((net.minecraft.world.entity.Entity)((CraftItem)item).getHandle(), quantity);
    }

    public float getHurtDirection() {
        return this.getHandle().eE();
    }

    public void setHurtDirection(float hurtDirection) {
        throw new UnsupportedOperationException("Cannot set the hurt direction on a non player");
    }

    public static EnumMonsterType fromBukkitEntityCategory(EntityCategory entityCategory) {
        switch (entityCategory) {
            case NONE: {
                return EnumMonsterType.a;
            }
            case UNDEAD: {
                return EnumMonsterType.b;
            }
            case ARTHROPOD: {
                return EnumMonsterType.c;
            }
            case ILLAGER: {
                return EnumMonsterType.d;
            }
            case WATER: {
                return EnumMonsterType.e;
            }
        }
        throw new IllegalArgumentException(entityCategory + " is an unrecognized entity category");
    }

    public void knockback(double strength, double directionX, double directionZ) {
        Preconditions.checkArgument((strength > 0.0 ? 1 : 0) != 0, (Object)"Knockback strength must be > 0");
        this.getHandle().q(strength, directionX, directionZ);
    }

    public void broadcastSlotBreak(EquipmentSlot slot) {
        this.getHandle().d(CraftEquipmentSlot.getNMS(slot));
    }

    public void broadcastSlotBreak(EquipmentSlot slot, Collection<Player> players) {
        if (players.isEmpty()) {
            return;
        }
        PacketPlayOutEntityStatus packet = new PacketPlayOutEntityStatus(this.getHandle(), EntityLiving.g(CraftEquipmentSlot.getNMS(slot)));
        players.forEach(player -> ((CraftPlayer)player).getHandle().c.b(packet));
    }

    public ItemStack damageItemStack(ItemStack stack, int amount) {
        net.minecraft.world.item.ItemStack nmsStack;
        if (stack instanceof CraftItemStack) {
            CraftItemStack craftItemStack = (CraftItemStack)stack;
            if (craftItemStack.handle == null || craftItemStack.handle.b()) {
                return stack;
            }
            nmsStack = craftItemStack.handle;
        } else {
            nmsStack = CraftItemStack.asNMSCopy(stack);
            stack = CraftItemStack.asCraftMirror(nmsStack);
        }
        this.damageItemStack0(nmsStack, amount, null);
        return stack;
    }

    public void damageItemStack(EquipmentSlot slot, int amount) {
        EnumItemSlot nmsSlot = CraftEquipmentSlot.getNMS(slot);
        this.damageItemStack0(this.getHandle().c(nmsSlot), amount, nmsSlot);
    }

    private void damageItemStack0(net.minecraft.world.item.ItemStack nmsStack, int amount, EnumItemSlot slot) {
        nmsStack.a(amount, this.getHandle(), livingEntity -> {
            if (slot != null) {
                livingEntity.d(slot);
            }
        });
    }

    @NotNull
    public TriState getFrictionState() {
        return this.getHandle().frictionState;
    }

    public void setFrictionState(@NotNull TriState state) {
        Objects.requireNonNull(state, "state may not be null");
        this.getHandle().frictionState = state;
    }

    public float getBodyYaw() {
        return this.getHandle().dD();
    }

    public void setBodyYaw(float bodyYaw) {
        this.getHandle().o(bodyYaw);
    }
}

