/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R3.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.papermc.paper.entity.PaperShearable;
import io.papermc.paper.potion.SuspiciousEffectEntry;
import io.papermc.paper.util.MCUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.animal.EntityMushroomCow;
import net.minecraft.world.level.block.SuspiciousEffectHolder;
import org.bukkit.craftbukkit.v1_20_R3.CraftServer;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftCow;
import org.bukkit.craftbukkit.v1_20_R3.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_20_R3.potion.CraftPotionUtil;
import org.bukkit.entity.MushroomCow;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class CraftMushroomCow
extends CraftCow
implements MushroomCow,
PaperShearable {
    public CraftMushroomCow(CraftServer server, EntityMushroomCow entity) {
        super(server, entity);
    }

    public boolean hasEffectsForNextStew() {
        return this.getHandle().bX != null && !this.getHandle().bX.isEmpty();
    }

    public List<PotionEffect> getEffectsForNextStew() {
        if (this.hasEffectsForNextStew()) {
            return this.getHandle().bX.stream().map(recordSuspiciousEffect -> CraftPotionUtil.toBukkit(recordSuspiciousEffect.a())).toList();
        }
        return ImmutableList.of();
    }

    public boolean addEffectToNextStew(PotionEffect potionEffect, boolean overwrite) {
        Preconditions.checkArgument((potionEffect != null ? 1 : 0) != 0, (Object)"PotionEffect cannot be null");
        return this.addEffectToNextStew(SuspiciousEffectEntry.create((PotionEffectType)potionEffect.getType(), (int)potionEffect.getDuration()), overwrite);
    }

    public boolean addEffectToNextStew(SuspiciousEffectEntry suspiciousEffectEntry, boolean overwrite) {
        Preconditions.checkArgument((suspiciousEffectEntry != null ? 1 : 0) != 0, (Object)"SuspiciousEffectEntry cannot be null");
        MobEffectList minecraftPotionEffect = CraftPotionEffectType.bukkitToMinecraft(suspiciousEffectEntry.effect());
        if (!overwrite && this.hasEffectForNextStew(suspiciousEffectEntry.effect())) {
            return false;
        }
        SuspiciousEffectHolder.a recordSuspiciousEffect = new SuspiciousEffectHolder.a(minecraftPotionEffect, suspiciousEffectEntry.duration());
        this.removeEffectFromNextStew(suspiciousEffectEntry.effect());
        this.getHandle().bX = this.getHandle().bX == null ? List.of(recordSuspiciousEffect) : MCUtil.copyListAndAdd(this.getHandle().bX, recordSuspiciousEffect);
        return true;
    }

    public boolean removeEffectFromNextStew(PotionEffectType potionEffectType) {
        Preconditions.checkArgument((potionEffectType != null ? 1 : 0) != 0, (Object)"potionEffectType cannot be null");
        if (!this.hasEffectsForNextStew()) {
            return false;
        }
        MobEffectList minecraftPotionEffectType = CraftPotionEffectType.bukkitToMinecraft(potionEffectType);
        if (this.getHandle().bX == null) {
            return false;
        }
        int oldSize = this.getHandle().bX.size();
        this.getHandle().bX = MCUtil.copyListAndRemoveIf(this.getHandle().bX, s2 -> Objects.equals(s2.b(), minecraftPotionEffectType));
        int newSize = this.getHandle().bX.size();
        if (newSize == 0) {
            this.getHandle().bX = null;
        }
        return oldSize != newSize;
    }

    public boolean hasEffectForNextStew(PotionEffectType potionEffectType) {
        Preconditions.checkArgument((potionEffectType != null ? 1 : 0) != 0, (Object)"potionEffectType cannot be null");
        if (!this.hasEffectsForNextStew()) {
            return false;
        }
        MobEffectList minecraftPotionEffectType = CraftPotionEffectType.bukkitToMinecraft(potionEffectType);
        return this.getHandle().bX.stream().anyMatch(recordSuspiciousEffect -> recordSuspiciousEffect.b().equals(minecraftPotionEffectType));
    }

    public void clearEffectsForNextStew() {
        this.getHandle().bX = null;
    }

    @Override
    public EntityMushroomCow getHandle() {
        return (EntityMushroomCow)this.entity;
    }

    public MushroomCow.Variant getVariant() {
        return MushroomCow.Variant.values()[this.getHandle().w().ordinal()];
    }

    public void setVariant(MushroomCow.Variant variant) {
        Preconditions.checkArgument((variant != null ? 1 : 0) != 0, (Object)"Variant cannot be null");
        this.getHandle().a(EntityMushroomCow.Type.values()[variant.ordinal()]);
    }

    public List<SuspiciousEffectEntry> getStewEffects() {
        if (this.getHandle().bX == null) {
            return List.of();
        }
        ArrayList<SuspiciousEffectEntry> nmsPairs = new ArrayList<SuspiciousEffectEntry>(this.getHandle().bX.size());
        for (SuspiciousEffectHolder.a effect : this.getHandle().bX) {
            nmsPairs.add(SuspiciousEffectEntry.create((PotionEffectType)CraftPotionEffectType.minecraftToBukkit(effect.b()), (int)effect.c()));
        }
        return Collections.unmodifiableList(nmsPairs);
    }

    public void setStewEffects(List<SuspiciousEffectEntry> effects) {
        if (effects.isEmpty()) {
            this.getHandle().bX = null;
            return;
        }
        ArrayList<SuspiciousEffectHolder.a> nmsPairs = new ArrayList<SuspiciousEffectHolder.a>(effects.size());
        for (SuspiciousEffectEntry effect : effects) {
            nmsPairs.add(new SuspiciousEffectHolder.a(CraftPotionEffectType.bukkitToMinecraft(effect.effect()), effect.duration()));
        }
        this.getHandle().bX = nmsPairs;
    }

    @Override
    public String toString() {
        return "CraftMushroomCow";
    }
}

