/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R3.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.animal.EntityPanda;
import org.bukkit.craftbukkit.v1_20_R3.CraftServer;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftAnimals;
import org.bukkit.entity.Panda;

public class CraftPanda
extends CraftAnimals
implements Panda {
    public CraftPanda(CraftServer server, EntityPanda entity) {
        super(server, entity);
    }

    @Override
    public EntityPanda getHandle() {
        return (EntityPanda)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftPanda";
    }

    public Panda.Gene getMainGene() {
        return CraftPanda.fromNms(this.getHandle().gm());
    }

    public void setMainGene(Panda.Gene gene) {
        this.getHandle().a(CraftPanda.toNms(gene));
    }

    public Panda.Gene getHiddenGene() {
        return CraftPanda.fromNms(this.getHandle().gn());
    }

    public void setHiddenGene(Panda.Gene gene) {
        this.getHandle().b(CraftPanda.toNms(gene));
    }

    public void setSneezeTicks(int ticks) {
        this.getHandle().u(ticks);
    }

    public int getSneezeTicks() {
        return this.getHandle().gl();
    }

    public void setEatingTicks(int ticks) {
        this.getHandle().v(ticks);
    }

    public int getEatingTicks() {
        return this.getHandle().gz();
    }

    public void setUnhappyTicks(int ticks) {
        this.getHandle().t(ticks);
    }

    public Panda.Gene getCombinedGene() {
        return CraftPanda.fromNms(this.getHandle().gq());
    }

    public boolean isRolling() {
        return this.getHandle().go();
    }

    public void setRolling(boolean flag) {
        this.getHandle().A(flag);
    }

    public boolean isSneezing() {
        return this.getHandle().w();
    }

    public void setSneezing(boolean flag) {
        this.getHandle().z(flag);
    }

    public boolean isSitting() {
        return this.getHandle().A();
    }

    public void setSitting(boolean flag) {
        this.getHandle().w(flag);
    }

    public boolean isOnBack() {
        return this.getHandle().ge();
    }

    public void setOnBack(boolean flag) {
        this.getHandle().x(flag);
    }

    public boolean isEating() {
        return this.getHandle().gk();
    }

    public void setEating(boolean flag) {
        this.getHandle().y(flag);
    }

    public boolean isScared() {
        return this.getHandle().gw();
    }

    public int getUnhappyTicks() {
        return this.getHandle().u();
    }

    public static Panda.Gene fromNms(EntityPanda.Gene gene) {
        Preconditions.checkArgument((gene != null ? 1 : 0) != 0, (Object)"Gene may not be null");
        return Panda.Gene.values()[gene.ordinal()];
    }

    public static EntityPanda.Gene toNms(Panda.Gene gene) {
        Preconditions.checkArgument((gene != null ? 1 : 0) != 0, (Object)"Gene may not be null");
        return EntityPanda.Gene.values()[gene.ordinal()];
    }
}

