/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R3.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.projectile.EntityTippedArrow;
import org.bukkit.Color;
import org.bukkit.craftbukkit.v1_20_R3.CraftServer;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftArrow;
import org.bukkit.craftbukkit.v1_20_R3.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_20_R3.potion.CraftPotionType;
import org.bukkit.craftbukkit.v1_20_R3.potion.CraftPotionUtil;
import org.bukkit.entity.Arrow;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;

public class CraftTippedArrow
extends CraftArrow
implements Arrow {
    public CraftTippedArrow(CraftServer server, EntityTippedArrow entity) {
        super(server, entity);
    }

    @Override
    public EntityTippedArrow getHandle() {
        return (EntityTippedArrow)this.entity;
    }

    @Override
    public String toString() {
        return "CraftTippedArrow";
    }

    public boolean addCustomEffect(PotionEffect effect, boolean override) {
        MobEffectList minecraft = CraftPotionEffectType.bukkitToMinecraft(effect.getType());
        MobEffect existing = null;
        for (MobEffect mobEffect : this.getHandle().l) {
            if (mobEffect.c() != minecraft) continue;
            existing = mobEffect;
        }
        if (existing != null) {
            if (!override) {
                return false;
            }
            this.getHandle().l.remove(existing);
        }
        this.getHandle().a(CraftPotionUtil.fromBukkit(effect));
        this.getHandle().M();
        return true;
    }

    public void clearCustomEffects() {
        this.getHandle().l.clear();
        this.getHandle().M();
    }

    public List<PotionEffect> getCustomEffects() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (MobEffect effect : this.getHandle().l) {
            builder.add((Object)CraftPotionUtil.toBukkit(effect));
        }
        return builder.build();
    }

    public boolean hasCustomEffect(PotionEffectType type) {
        for (MobEffect effect : this.getHandle().l) {
            if (!CraftPotionUtil.equals(effect.c(), type)) continue;
            return true;
        }
        return false;
    }

    public boolean hasCustomEffects() {
        return !this.getHandle().l.isEmpty();
    }

    public boolean removeCustomEffect(PotionEffectType effect) {
        MobEffectList minecraft = CraftPotionEffectType.bukkitToMinecraft(effect);
        MobEffect existing = null;
        for (MobEffect mobEffect : this.getHandle().l) {
            if (mobEffect.c() != minecraft) continue;
            existing = mobEffect;
        }
        if (existing == null) {
            return false;
        }
        this.getHandle().l.remove(existing);
        this.getHandle().M();
        return true;
    }

    public void setBasePotionData(PotionData data) {
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"PotionData cannot be null");
        this.getHandle().k = CraftPotionType.bukkitToMinecraft(CraftPotionUtil.fromBukkit(data));
    }

    public PotionData getBasePotionData() {
        return CraftPotionUtil.toBukkit(CraftPotionType.minecraftToBukkit(this.getHandle().k));
    }

    public void setBasePotionType(@NotNull PotionType potionType) {
        Preconditions.checkArgument((potionType != null ? 1 : 0) != 0, (Object)"PotionType cannot be null use PotionType.UNCRAFTABLE to represent no effect instead.");
        this.getHandle().k = CraftPotionType.bukkitToMinecraft(potionType);
    }

    @NotNull
    public PotionType getBasePotionType() {
        return CraftPotionType.minecraftToBukkit(this.getHandle().k);
    }

    public void setColor(Color color) {
        int colorRGB = color == null ? -1 : color.asRGB();
        this.getHandle().d(colorRGB);
    }

    public Color getColor() {
        if (this.getHandle().I() <= -1) {
            return null;
        }
        return Color.fromRGB((int)this.getHandle().I());
    }
}

