/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R3.entity;

import com.google.common.base.Preconditions;
import java.util.UUID;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.monster.EntityZombieVillager;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_20_R3.CraftServer;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftVillager;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftZombie;
import org.bukkit.entity.Villager;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class CraftVillagerZombie
extends CraftZombie
implements ZombieVillager {
    public CraftVillagerZombie(CraftServer server, EntityZombieVillager entity) {
        super(server, entity);
    }

    @Override
    public EntityZombieVillager getHandle() {
        return (EntityZombieVillager)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftVillagerZombie";
    }

    @Override
    public Villager.Profession getVillagerProfession() {
        return CraftVillager.CraftProfession.minecraftToBukkit(this.getHandle().gp().b());
    }

    @Override
    public void setVillagerProfession(Villager.Profession profession) {
        Preconditions.checkArgument((profession != null ? 1 : 0) != 0, (Object)"Villager.Profession cannot be null");
        this.getHandle().a(this.getHandle().gp().a(CraftVillager.CraftProfession.bukkitToMinecraft(profession)));
    }

    public Villager.Type getVillagerType() {
        return CraftVillager.CraftType.minecraftToBukkit(this.getHandle().gp().a());
    }

    public void setVillagerType(Villager.Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Villager.Type cannot be null");
        this.getHandle().a(this.getHandle().gp().a(CraftVillager.CraftType.bukkitToMinecraft(type)));
    }

    @Override
    public boolean isConverting() {
        return this.getHandle().go();
    }

    @Override
    public int getConversionTime() {
        Preconditions.checkState((boolean)this.isConverting(), (Object)"Entity not converting");
        return this.getHandle().cb;
    }

    @Override
    public void setConversionTime(int time) {
        this.setConversionTime(time, true);
    }

    public void setConversionTime(int time, boolean broadcastEntityEvent) {
        if (time < 0) {
            this.getHandle().cb = -1;
            this.getHandle().an().b(EntityZombieVillager.c, false);
            this.getHandle().cc = null;
            this.getHandle().removeEffect(MobEffects.e, EntityPotionEffectEvent.Cause.CONVERSION);
        } else {
            this.getHandle().startConverting(null, time, broadcastEntityEvent);
        }
    }

    public OfflinePlayer getConversionPlayer() {
        return this.getHandle().cc == null ? null : Bukkit.getOfflinePlayer((UUID)this.getHandle().cc);
    }

    public void setConversionPlayer(OfflinePlayer conversionPlayer) {
        if (!this.isConverting()) {
            return;
        }
        this.getHandle().cc = conversionPlayer == null ? null : conversionPlayer.getUniqueId();
    }
}

